/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.visao.panel;

import br.gov.rs.tce.mci.beans.remessa.Remessa;
import br.gov.rs.tce.mci.beans.remessa.RemessaInfo;
import br.gov.rs.tce.mci.modelo.servico.acessodados.RemessasMCIViewRowImpl;
import br.gov.rs.tce.mci.modelo.servico.common.ServicoMCI;
import br.gov.rs.tce.mci.util.DatacontrolHelper;
import br.gov.rs.tce.mci.visao.MciModelo;
import br.gov.rs.tce.mci.visao.MciWizardControle;
import br.gov.rs.tce.mci.visao.MciWizardHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.sql.Date;
import java.text.SimpleDateFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.adf.model.BindingContext;
import oracle.jbo.Row;
import oracle.jbo.ViewObject;
import oracle.jbo.uicli.controls.JULabel;
import oracle.jbo.uicli.controls.JUPanel;
import oracle.jbo.uicli.controls.JUTestFrame;
import oracle.jbo.uicli.jui.JUPanelBinding;
import oracle.jdeveloper.layout.XYConstraints;
import oracle.jdeveloper.layout.XYLayout;

public class TelaUC044
extends JPanel
implements JUPanel,
MciModelo {
    private JUPanelBinding panelBinding = new JUPanelBinding("TelaUC044UIModel");
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel pnlSul = new JPanel();
    private JPanel pnlNort = new JPanel();
    private XYLayout xYLayout1 = new XYLayout();
    private JTextField lblPerInfDesc = new JTextField();
    private JLabel lblPerInfo = new JLabel();
    private JULabel lblCodigo = new JULabel();
    private JTextField tfCodigo = new JTextField();
    private JULabel lblNome = new JULabel();
    private JTextField tfNome = new JTextField();
    private JULabel lblDataHora = new JULabel();
    private JTextField tfDataHora = new JTextField();
    private JULabel lblCdBarras = new JULabel();
    private JTextField tfCdBarras = new JTextField();
    private JLabel jLabel1 = new JLabel();
    private JTextField txtArquivo = new JTextField();
    private JButton btProcurar = new JButton();
    private String path = null;
    private RemessaInfo remInfoTmp = null;
    private boolean flagAvancar = false;

    public void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.setSize(new Dimension(620, 320));
        this.setPreferredSize(new Dimension(620, 320));
        this.setMinimumSize(new Dimension(620, 320));
        this.setMaximumSize(new Dimension(620, 320));
        this.add((Component)this.pnlNort, "North");
        this.add((Component)this.pnlSul, "South");
        this.pnlNort.setLayout((LayoutManager)this.xYLayout1);
        this.pnlNort.add((Component)this.jLabel1, new XYConstraints(50, 15, 520, 40));
        this.pnlNort.add((Component)this.btProcurar, new XYConstraints(455, 70, 115, 25));
        this.pnlNort.add((Component)this.txtArquivo, new XYConstraints(50, 70, 390, 25));
        this.jLabel1.setText("<html>Para fazer o envio, \u00e9 necess\u00e1rio informar o arquivo de remessa contendo os dados da Entidade</html>");
        this.jLabel1.setAlignmentY(2.0f);
        this.btProcurar.setText("Procurar");
        this.btProcurar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TelaUC044.this.btnProcurar_actionPerformed(e);
            }
        });
        this.pnlSul.setLayout((LayoutManager)this.xYLayout1);
        this.pnlSul.setBorder(BorderFactory.createTitledBorder("Dados da Entidade"));
        this.pnlSul.add((Component)this.lblNome, new XYConstraints(10, 5, 35, 20));
        this.pnlSul.add((Component)this.lblCodigo, new XYConstraints(10, 35, 70, 20));
        this.pnlSul.add((Component)this.lblCdBarras, new XYConstraints(10, 65, 125, 15));
        this.pnlSul.add((Component)this.lblPerInfo, new XYConstraints(10, 95, 60, 15));
        this.pnlSul.add((Component)this.lblDataHora, new XYConstraints(10, 125, 125, 15));
        this.pnlSul.add((Component)this.tfNome, new XYConstraints(50, 5, 270, 20));
        this.pnlSul.add((Component)this.tfCodigo, new XYConstraints(85, 35, 115, 20));
        this.pnlSul.add((Component)this.tfCdBarras, new XYConstraints(110, 65, 150, 14));
        this.pnlSul.add((Component)this.lblPerInfDesc, new XYConstraints(75, 95, 130, 14));
        this.pnlSul.add((Component)this.tfDataHora, new XYConstraints(125, 125, 150, 14));
        this.lblPerInfDesc.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.lblPerInfDesc.setEditable(false);
        this.lblPerInfDesc.setBackground(SystemColor.control);
        this.lblPerInfDesc.setForeground(Color.gray);
        this.lblPerInfo.setText("Exerc\u00edcio:");
        this.tfCodigo.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.tfCodigo.setEditable(false);
        this.tfCodigo.setBackground(SystemColor.control);
        this.tfCodigo.setForeground(Color.gray);
        this.tfNome.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.tfNome.setEnabled(false);
        this.tfNome.setBackground(SystemColor.control);
        this.tfDataHora.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.tfDataHora.setEnabled(false);
        this.tfDataHora.setBackground(SystemColor.control);
        this.tfDataHora.setForeground(Color.gray);
        this.tfCdBarras.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.tfCdBarras.setEnabled(false);
        this.tfCdBarras.setBackground(SystemColor.control);
        this.tfCdBarras.setForeground(Color.gray);
        this.txtArquivo.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                TelaUC044.this.setAvancar(false);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TelaUC044.this.setAvancar(false);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                TelaUC044.this.setAvancar(false);
            }
        });
        this.lblCodigo.setText("N\u00ba do \u00d3rg\u00e3o:");
        this.lblNome.setText("Nome:");
        this.lblCdBarras.setText("Codigo de Barras:");
        this.lblDataHora.setText("Data e Hora Gera\u00e7\u00e3o:");
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exemp) {
            exemp.printStackTrace();
        }
        TelaUC044 panel = new TelaUC044();
        panel.setBindingContext(JUTestFrame.startTestFrame((String)"DataBindings.cpx", (String)"null", (JPanel)panel, (JUPanelBinding)panel.getPanelBinding(), (Dimension)new Dimension(400, 300)));
        panel.revalidate();
    }

    private void btnProcurar_actionPerformed(ActionEvent e) {
        this.selecionaArquivo();
    }

    private void selecionaArquivo() {
        if (this.path == null) {
            this.path = "C:/";
        }
        JFileChooser fc = new JFileChooser(new File(this.path));
        fc.setFileSelectionMode(0);
        FileFilter ff = new FileFilter(){

            @Override
            public boolean accept(File file) {
                boolean ok = false;
                if (file != null) {
                    boolean bl = ok = file.getName().endsWith(".dat") || file.getName().indexOf(".p0") > 0;
                }
                if (!ok) {
                    ok = file.isDirectory();
                }
                return ok;
            }

            @Override
            public String getDescription() {
                return "Troca de informa\u00e7\u00f5es (*.dat;*.p0*)";
            }
        };
        fc.setFileFilter(ff);
        if (fc.showOpenDialog(this) == 0 && fc.getSelectedFile() != null && fc.getSelectedFile().exists()) {
            this.path = fc.getSelectedFile().getAbsolutePath();
            this.txtArquivo.setText(this.path);
        }
    }

    public JUPanelBinding getPanelBinding() {
        return this.panelBinding;
    }

    @Override
    public void setBindingContext(BindingContext bindCtx) {
        if (this.panelBinding.getPanel() == null) {
            this.panelBinding = this.panelBinding.setup(bindCtx, (Object)this);
            this.panelBinding.refreshControl();
            try {
                this.jbInit();
                this.panelBinding.refreshControl();
            }
            catch (Exception ex) {
                this.panelBinding.reportException((Throwable)ex);
            }
        }
    }

    @Override
    public void preparaTela() {
        MciWizardControle control = MciWizardHelper.getInstance().getForm().getPagina().getMciWizardControle();
        control.setaNomeAvancar("Carregar");
        this.escondePnlSul();
        this.flagAvancar = false;
    }

    public void setAvancar(boolean valor) {
        this.flagAvancar = valor;
        MciWizardControle control = MciWizardHelper.getInstance().getForm().getPagina().getMciWizardControle();
        if (valor) {
            control.setaNomeAvancar("Avan\u00e7ar >");
            this.setDadosEntidadeRemessa();
            this.mostraPnlSul();
        } else {
            control.setaNomeAvancar("Carregar");
            this.escondePnlSul();
        }
    }

    public boolean getAvancar() {
        return this.flagAvancar;
    }

    public void mostraPnlSul() {
        this.pnlSul.setVisible(true);
    }

    public void escondePnlSul() {
        this.pnlSul.setVisible(false);
    }

    private void setDadosEntidadeRemessa() {
        BindingContext binding = this.panelBinding.getBindingContext();
        ServicoMCI ser = DatacontrolHelper.getServicoMCIAppModule(binding);
        ViewObject vo = ser.findViewObject("RemessasMCIView");
        vo.executeQuery();
        RemessasMCIViewRowImpl remessaRow = (RemessasMCIViewRowImpl)vo.first();
        Remessa remessa = DatacontrolHelper.getRemessaDataControl(binding);
        int periodoInf = remessa.getPeriodoInformacoes();
        String tpEntrega = remessaRow.getTpentrega();
        switch (periodoInf) {
            case 1: {
                this.lblPerInfDesc.setText("Primeiro Quadrimestre");
                break;
            }
            case 2: {
                this.lblPerInfDesc.setText("Segundo Quadrimestre");
                break;
            }
            case 3: {
                this.lblPerInfDesc.setText("Terceiro Quadrimestre");
                break;
            }
            case 4: {
                this.lblPerInfDesc.setText("Primeiro Semestre");
                break;
            }
            case 5: {
                this.lblPerInfDesc.setText("Segundo Semestre");
            }
        }
        if (tpEntrega != null) {
            // empty if block
        }
        ViewObject viewRemessa = ser.findViewObject("RemessasMCIView");
        viewRemessa.executeQuery();
        Row row = viewRemessa.first();
        String format = "dd/MM/yyyy HH:mm:ss";
        SimpleDateFormat df = new SimpleDateFormat(format);
        java.util.Date dtGravacao = new java.util.Date(((Date)row.getAttribute("DtGravacao")).getTime());
        String dateStr = df.format(dtGravacao).toString();
        System.out.println("TelaUC044: barras: " + row.getAttribute("CodBarras") + "; nome: " + row.getAttribute("NomeEntidade"));
        System.out.println("TelaUC044: " + remessaRow.getCdEntidade() + "; " + dateStr + "; DtGravacao.class: " + row.getAttribute("DtGravacao").getClass() + "; ");
        this.tfNome.setText((String)row.getAttribute("NomeEntidade"));
        this.tfCodigo.setText(String.valueOf(remessaRow.getCdEntidade()));
        this.lblPerInfDesc.setText(String.valueOf(remessaRow.getAnoExercicio()));
        this.tfCdBarras.setText((String)row.getAttribute("CodBarras"));
        this.tfDataHora.setText(df.format(this.remInfoTmp.getDataGeracao()));
    }

    @Override
    public final void finalizaTela() {
        MciWizardControle control = MciWizardHelper.getInstance().getForm().getPagina().getMciWizardControle();
        control.setaNomeAvancar("Avan\u00e7ar >");
    }

    public String getArquivo() {
        return this.txtArquivo.getText();
    }

    public void setArquivo(String texto) {
        this.txtArquivo.setText(texto);
    }

    @Override
    public boolean validaTela() {
        File f = new File(this.txtArquivo.getText());
        System.out.println("UC044: validaTela(): " + f.getAbsolutePath());
        if (!f.exists()) {
            this.exibeMensagemWarning("Selecione o arquivo de envio");
            return false;
        }
        if (!f.getName().toLowerCase().startsWith("remessa")) {
            this.exibeMensagemWarning("Arquivo inv\u00e1lido. Arquivo deve ser do tipo 'remessa.dat' ou 'remessa.p0*'");
            return false;
        }
        return true;
    }

    public void setRemInfoTmp(RemessaInfo remInfoTmp) {
        this.remInfoTmp = remInfoTmp;
    }

    public void exibeMensagemWarning(String mensagem) {
        JOptionPane.showMessageDialog(this, mensagem, "Aten\u00e7\u00e3o", 2);
    }

    class MyJTextField
    extends JTextField {
        public MyJTextField() {
            this.setEditable(false);
            FocusAdapter list = new FocusAdapter(){
                public int conta;

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                }
            };
            this.addFocusListener(list);
        }
    }

    class MyTableCellRenderer
    extends DefaultTableCellRenderer {
        private Color unselectedForeground;
        private Color unselectedBackground;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                super.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
                super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground());
            }
            this.setFont(table.getFont());
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
                if (table.isCellEditable(row, column)) {
                    super.setForeground(Color.WHITE);
                    super.setBackground(UIManager.getColor("Table.selectionBackground"));
                }
            } else {
                this.setBorder(noFocusBorder);
            }
            this.setValue(value);
            if (value != null) {
                this.setHorizontalAlignment(2);
            }
            return this;
        }
    }
}

