/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.visao.panel;

import br.gov.rs.tce.mci.beans.remessa.Remessa;
import br.gov.rs.tce.mci.modelo.servico.common.ServicoMCI;
import br.gov.rs.tce.mci.util.DatacontrolHelper;
import br.gov.rs.tce.mci.visao.MciModelo;
import br.gov.rs.tce.mci.visao.MciWizardControle;
import br.gov.rs.tce.mci.visao.MciWizardForm;
import br.gov.rs.tce.mci.visao.MciWizardHelper;
import br.gov.rs.tce.mci.visao.util.DocumentSizeFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputMethodEvent;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.text.AbstractDocument;
import oracle.adf.model.BindingContext;
import oracle.adf.model.binding.DCDataControl;
import oracle.jbo.uicli.binding.JUFormBinding;
import oracle.jbo.uicli.binding.JUUtil;
import oracle.jbo.uicli.controls.JUPanel;
import oracle.jbo.uicli.controls.JUTestFrame;
import oracle.jbo.uicli.jui.JUPanelBinding;

public class TelaUC026
extends JPanel
implements JUPanel,
MciModelo {
    private JUPanelBinding panelBinding = new JUPanelBinding("TelaUC026UIModel");
    private static final String UC026_01 = "O tamanho do C\u00f3digo de Barras \u00e9 inv\u00e1lido!";
    private static final String UC026_02 = "O per\u00edodo das informa\u00e7\u00f5es \u00e9 inv\u00e1lido";
    private static final String UC026_03 = "O ano de exerc\u00edcio \u00e9 inv\u00e1lido";
    private static final String UC026_04 = "O tipo do Relat\u00f3rio \u00e9 inv\u00e1lido";
    private static final String UC026_05 = "O grupo de entrega do relat\u00f3rio \u00e9 inv\u00e1lido";
    private static final String UC026_06 = "O CRC do d\u00edgito de controle \u00e9 inv\u00e1lido";
    private static final String UC026_07 = "O C\u00f3digo de Barras precisa ser um n\u00famero";
    static final int RELATORIO_MODELO_9 = 2;
    static final int RELATORIO_MODELO_14 = 3;
    public static final int RVE_MDL9 = 1;
    public static final int RVE_MDL14 = 2;
    public static final int RVE = 3;
    public static final int RVE_MDL9_CONSOLIDADA = 5;
    public static final int RVE_MDL9_DC = 11;
    public static final int RVE_MDL9_CONSOLIDADA_DC = 12;
    public static final int RVE_MDL14_DC = 13;
    private JLabel jlPergunta2 = new JLabel();
    private JFormattedTextField jtfCodBarras = new JFormattedTextField();
    private JLabel jlPeriodo = new JLabel();
    private JLabel jlAno = new JLabel();
    private JLabel jlTipoRelatorio = new JLabel();
    private JLabel jlGrupoEntrega = new JLabel();
    private JLabel jlDigitos = new JLabel();
    private JLabel jlMensagem = new JLabel();
    private JButton jbValidar = new JButton();
    private boolean validacaoOk = false;

    public void jbInit() throws Exception {
        this.setLayout(null);
        this.setSize(new Dimension(620, 320));
        this.setPreferredSize(new Dimension(620, 320));
        this.setMaximumSize(new Dimension(620, 320));
        this.setMinimumSize(new Dimension(620, 320));
        this.jlPergunta2.setBounds(new Rectangle(20, 35, 565, 30));
        this.jlPergunta2.setFont(new Font("Tahoma", 1, 11));
        this.jtfCodBarras.setText("");
        this.jtfCodBarras.setBounds(new Rectangle(20, 80, 385, 35));
        this.jtfCodBarras.setFont(new Font("SansSerif", 0, 35));
        this.jlPeriodo.setText("jLabel1");
        this.jlPeriodo.setBounds(new Rectangle(30, 162, 280, 14));
        this.jlAno.setText("jLabel2");
        this.jlAno.setBounds(new Rectangle(30, 189, 280, 14));
        this.jlTipoRelatorio.setText("jLabel3");
        this.jlTipoRelatorio.setBounds(new Rectangle(30, 216, 280, 14));
        this.jlGrupoEntrega.setText("jLabel4");
        this.jlGrupoEntrega.setBounds(new Rectangle(30, 243, 280, 14));
        this.jlDigitos.setText("jLabel5");
        this.jlDigitos.setBounds(new Rectangle(30, 270, 280, 14));
        this.jlMensagem.setText("jlMensagem");
        this.jlMensagem.setBounds(new Rectangle(30, 135, 480, 14));
        this.jlMensagem.setFont(new Font("Tahoma", 1, 11));
        this.jbValidar.setText("Validar");
        this.jbValidar.setBounds(new Rectangle(415, 80, 85, 35));
        this.jbValidar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TelaUC026.this.jbValidar_actionPerformed(e);
            }
        });
        this.add((Component)this.jbValidar, null);
        this.add((Component)this.jlMensagem, null);
        this.add((Component)this.jlDigitos, null);
        this.add((Component)this.jlGrupoEntrega, null);
        this.add((Component)this.jlTipoRelatorio, null);
        this.add((Component)this.jlAno, null);
        this.add((Component)this.jlPeriodo, null);
        this.add((Component)this.jtfCodBarras, null);
        this.add((Component)this.jlPergunta2, null);
        this.preparaTamanhoCampos();
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exemp) {
            exemp.printStackTrace();
        }
        TelaUC026 panel = new TelaUC026();
        panel.setBindingContext(JUTestFrame.startTestFrame((String)"DataBindings.cpx", (String)"null", (JPanel)panel, (JUPanelBinding)panel.getPanelBinding(), (Dimension)new Dimension(400, 300)));
        panel.revalidate();
    }

    public JUPanelBinding getPanelBinding() {
        return this.panelBinding;
    }

    private void unRegisterProjectGlobalVariables(BindingContext bindCtx) {
        JUUtil.unRegisterNavigationBarInterface((JUFormBinding)this.panelBinding, (BindingContext)bindCtx);
    }

    private void registerProjectGlobalVariables(BindingContext bindCtx) {
        JUUtil.registerNavigationBarInterface((JUFormBinding)this.panelBinding, (BindingContext)bindCtx);
    }

    @Override
    public void setBindingContext(BindingContext bindCtx) {
        if (this.panelBinding.getPanel() == null) {
            this.panelBinding = this.panelBinding.setup(bindCtx, (Object)this);
            this.registerProjectGlobalVariables(bindCtx);
            this.panelBinding.refreshControl();
            try {
                this.jbInit();
                this.panelBinding.refreshControl();
            }
            catch (Exception ex) {
                this.panelBinding.reportException((Throwable)ex);
            }
        }
    }

    private void preparaTamanhoCampos() {
        int MAX_CHARACTERS_CODBARRAS = 17;
        ((AbstractDocument)this.jtfCodBarras.getDocument()).setDocumentFilter(new DocumentSizeFilter(MAX_CHARACTERS_CODBARRAS));
    }

    @Override
    public void preparaTela() {
        MciWizardControle control = MciWizardHelper.getInstance().getForm().getPagina().getMciWizardControle();
        control.exibeBotaoObservacoes(false);
        Remessa remessa = DatacontrolHelper.getRemessaDataControl(this.panelBinding.getBindingContext());
        BindingContext binding = this.panelBinding.getBindingContext();
        DCDataControl dc = binding.findDataControl("ServicoMCIDataControl");
        ServicoMCI ser = (ServicoMCI)dc.getDataProvider();
        this.jlPergunta2.setText("<html>Informe o C\u00f3digo de Barras do Modelo " + this.retNumModelo() + " - Relat\u00f3rio de Gest\u00e3o Fiscal:");
        this.ocultaControles();
        this.setValidacaoOk(false);
        if (ser.buscaCodBarras(remessa.getTipoSetor()) != null) {
            this.jtfCodBarras.setText(ser.buscaCodBarras(remessa.getTipoSetor()));
        }
    }

    public void exibeMensagemWarning(String mensagem) {
        MciWizardForm form = MciWizardHelper.getInstance().getForm();
        JOptionPane.showMessageDialog(form, mensagem, "Aten\u00e7\u00e3o", 2);
    }

    @Override
    public final void finalizaTela() {
        MciWizardControle control = MciWizardHelper.getInstance().getForm().getPagina().getMciWizardControle();
        control.exibeBotaoObservacoes(true);
    }

    @Override
    public boolean validaTela() {
        return true;
    }

    public String retNumModelo() {
        Remessa remessa = DatacontrolHelper.getRemessaDataControl(this.panelBinding.getBindingContext());
        if (remessa.getTipoSetor().equalsIgnoreCase("P")) {
            return "9";
        }
        return "14";
    }

    public void setPeriodo(String periodo) {
        this.jlPeriodo.setVisible(true);
        this.jlPeriodo.setText("Per\u00edodo das Informa\u00e7\u00f5es: " + periodo + " \u00ba bimestre");
    }

    public void setAno(int ano) {
        this.jlAno.setVisible(true);
        this.jlAno.setText("Ano do Exerc\u00edcio: " + (2000 + ano));
    }

    public void setTipoEntrega(int tpRelatorio) {
        this.jlTipoRelatorio.setVisible(true);
        switch (tpRelatorio) {
            case 1: {
                this.jlTipoRelatorio.setText("Tipo do Relat\u00f3rio: RVE");
                break;
            }
            case 2: {
                this.jlTipoRelatorio.setText("Tipo do Relat\u00f3rio: Modelo 9");
                break;
            }
            case 3: {
                this.jlTipoRelatorio.setText("Tipo do Relat\u00f3rio: Modelo 14");
                break;
            }
            default: {
                throw new RuntimeException("tipo relat\u00f3rio desconhecido: " + tpRelatorio);
            }
        }
    }

    public void setGrupoEntrega(int grupoEntrega) {
        this.jlGrupoEntrega.setVisible(true);
        switch (grupoEntrega) {
            case 1: {
                this.jlGrupoEntrega.setText("Grupo de Entrega: RVE + Modelo 9");
                break;
            }
            case 2: {
                this.jlGrupoEntrega.setText("Grupo de Entrega: RVE + Modelo 14");
                break;
            }
            case 3: {
                this.jlGrupoEntrega.setText("Grupo de Entrega: RVE");
                break;
            }
            case 5: {
                this.jlGrupoEntrega.setText("Grupo de Entrega: RVE + Modelo 9 - Consolida\u00e7\u00e3o");
                break;
            }
            case 11: {
                this.jlGrupoEntrega.setText("Grupo de Entrega: RVE + Modelo 9 + DC");
                break;
            }
            case 12: {
                this.jlGrupoEntrega.setText("Grupo de Entrega: RVE + Modelo 9 - Consolida\u00e7\u00e3o + DC");
                break;
            }
            case 13: {
                this.jlGrupoEntrega.setText("Grupo de Entrega: RVE + Modelo 14 + DC");
                break;
            }
            default: {
                throw new RuntimeException("grupo-entrega desconhecido: " + grupoEntrega);
            }
        }
    }

    public void setDigControles(String digControle) {
        this.jlDigitos.setVisible(true);
        this.jlDigitos.setText("D\u00edgitos de Controle: " + digControle);
    }

    public void ocultaControlesSemMensagem() {
        this.jlPeriodo.setText("");
        this.jlAno.setText("");
        this.jlTipoRelatorio.setText("");
        this.jlGrupoEntrega.setText("");
        this.jlDigitos.setText("");
        this.jlPeriodo.setVisible(false);
        this.jlAno.setVisible(false);
        this.jlTipoRelatorio.setVisible(false);
        this.jlGrupoEntrega.setVisible(false);
        this.jlDigitos.setVisible(false);
    }

    public void ocultaControles() {
        this.jlPeriodo.setText("");
        this.jlAno.setText("");
        this.jlTipoRelatorio.setText("");
        this.jlGrupoEntrega.setText("");
        this.jlDigitos.setText("");
        this.jlMensagem.setText("");
        this.jlPeriodo.setVisible(false);
        this.jlAno.setVisible(false);
        this.jlTipoRelatorio.setVisible(false);
        this.jlGrupoEntrega.setVisible(false);
        this.jlDigitos.setVisible(false);
    }

    private void jbValidar_actionPerformed(ActionEvent e) {
        MciWizardControle control = MciWizardHelper.getInstance().getForm().getPagina().getMciWizardControle();
        control.exibeBotaoObservacoes(false);
        Remessa remessa = DatacontrolHelper.getRemessaDataControl(this.panelBinding.getBindingContext());
        BindingContext binding = this.panelBinding.getBindingContext();
        DCDataControl dc = binding.findDataControl("ServicoMCIDataControl");
        ServicoMCI ser = (ServicoMCI)dc.getDataProvider();
        if (this.validaCodigoBarras(this.jtfCodBarras.getText())) {
            this.jlMensagem.setForeground(Color.BLACK);
            this.jlMensagem.setText("Confira os dados do RGF antes de avan\u00e7ar:");
            this.setValidacaoOk(true);
            ser.insereCodBarras(this.jtfCodBarras.getText(), remessa.getTipoSetor());
        } else {
            this.setValidacaoOk(false);
            this.jlMensagem.setForeground(Color.RED);
            this.ocultaControlesSemMensagem();
        }
    }

    public String getCodBarras() {
        return this.jtfCodBarras.getText();
    }

    public boolean validaCodigoBarras(String cdBarras) {
        long digito;
        int ano;
        int periodo;
        int tipo = -1;
        int grupo = -1;
        String strDigito = "0";
        int tamanho = cdBarras.trim().length();
        if (tamanho != 15 && tamanho != 17) {
            this.jlMensagem.setVisible(true);
            this.jlMensagem.setText(UC026_01);
            return false;
        }
        try {
            long l = Long.parseLong(cdBarras);
        }
        catch (Exception ex) {
            this.jlMensagem.setText(UC026_07);
            return false;
        }
        try {
            periodo = Integer.parseInt(cdBarras.substring(0, 1));
        }
        catch (Exception ex) {
            this.jlMensagem.setText(UC026_02);
            return false;
        }
        try {
            ano = Integer.parseInt(cdBarras.substring(1, 3));
        }
        catch (Exception ex) {
            this.jlMensagem.setText(UC026_03);
            return false;
        }
        try {
            if (tamanho == 15) {
                tipo = Integer.parseInt(cdBarras.substring(3, 4));
            } else if (tamanho == 17) {
                tipo = Integer.parseInt(cdBarras.substring(3, 5));
            }
        }
        catch (Exception ex) {
            this.jlMensagem.setText(UC026_04);
            return false;
        }
        try {
            if (tamanho == 15) {
                grupo = Integer.parseInt(cdBarras.substring(4, 5));
            } else if (tamanho == 17) {
                grupo = Integer.parseInt(cdBarras.substring(5, 7));
            }
        }
        catch (Exception ex) {
            this.jlMensagem.setText(UC026_05);
            return false;
        }
        try {
            if (tamanho == 15) {
                strDigito = cdBarras.substring(5, 15);
            } else if (tamanho == 17) {
                strDigito = cdBarras.substring(7, 17);
            }
            digito = Long.parseLong(strDigito);
        }
        catch (Exception ex) {
            this.jlMensagem.setText(UC026_06);
            return false;
        }
        try {
            return this.validaConteudo(periodo, ano, tipo, grupo, digito, strDigito);
        }
        catch (Exception ex) {
            this.jlMensagem.setText("Erro ao validar c\u00f3digo de barras: " + ex.getMessage());
            return false;
        }
    }

    public boolean validaConteudo(int periodo, int ano, int tipo, int grupo, long digito, String strDigito) {
        Remessa remessa = DatacontrolHelper.getRemessaDataControl(this.panelBinding.getBindingContext());
        if (remessa.getPeriodoInformacoes() == 1 && periodo != 2 || remessa.getPeriodoInformacoes() == 2 && periodo != 4 || remessa.getPeriodoInformacoes() == 3 && periodo != 6 || remessa.getPeriodoInformacoes() == 4 && periodo != 3 || remessa.getPeriodoInformacoes() == 5 && periodo != 6) {
            this.jlMensagem.setText(UC026_02);
            return false;
        }
        if (ano + 2000 != remessa.getAnoExercicio()) {
            this.jlMensagem.setText(UC026_03);
            return false;
        }
        if (remessa.getTipoSetor().equalsIgnoreCase("P") && tipo != 2 || remessa.getTipoSetor().equalsIgnoreCase("C") && tipo != 3) {
            this.jlMensagem.setText(UC026_04);
            return false;
        }
        if (tipo == 2 && grupo != 1 && grupo != 5 && grupo != 11 && grupo != 12 || tipo == 3 && grupo != 2 && grupo != 13) {
            System.out.println("erro grupo de entrega: tipo = " + tipo + " ; grupo = " + grupo);
            this.jlMensagem.setText(UC026_05);
            return false;
        }
        if (digito < 0L) {
            this.jlMensagem.setText(UC026_05);
            return false;
        }
        this.setPeriodo(Integer.toString(periodo));
        this.setAno(ano);
        this.setTipoEntrega(tipo);
        this.setGrupoEntrega(grupo);
        this.setDigControles(strDigito);
        return true;
    }

    public boolean isValidacaoOk() {
        return this.validacaoOk;
    }

    public void setValidacaoOk(boolean validacaoOk) {
        this.validacaoOk = validacaoOk;
    }

    private void jtfCodBarras_inputMethodTextChanged(InputMethodEvent e) {
        this.setValidacaoOk(false);
    }
}

