/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.visao.panel;

import br.gov.rs.tce.mci.beans.remessa.Remessa;
import br.gov.rs.tce.mci.modelo.decisao.ConstantesTelas;
import br.gov.rs.tce.mci.modelo.servico.acessodados.RemessasMCIViewRowImpl;
import br.gov.rs.tce.mci.modelo.servico.common.ServicoMCI;
import br.gov.rs.tce.mci.util.DatacontrolHelper;
import br.gov.rs.tce.mci.visao.MciErrorDialog;
import br.gov.rs.tce.mci.visao.MciModelo;
import br.gov.rs.tce.mci.visao.MciWizardControle;
import br.gov.rs.tce.mci.visao.MciWizardForm;
import br.gov.rs.tce.mci.visao.MciWizardHelper;
import br.gov.rs.tce.mci.visao.swing.MciFoneField;
import br.gov.rs.tce.mci.visao.swing.MciTextFieldBinding;
import br.gov.rs.tce.mci.visao.util.DocumentSizeFilter;
import br.gov.rs.tce.siapc.exception.ResponsaveisFault;
import br.gov.rs.tce.siapc.exception.ResponsavelNaoEncontradoFault;
import br.gov.rs.tce.ws.responsaveis.client.ResponsaveisWSClient;
import https.wsresponsaveis_tce_rs_gov.EntidadeWSPojo;
import https.wsresponsaveis_tce_rs_gov.ResponsavelAtualWSPojo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.NoRouteToHostException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;
import oracle.adf.model.BindingContext;
import oracle.adf.model.binding.DCDataControl;
import oracle.jbo.Row;
import oracle.jbo.ViewObject;
import oracle.jbo.server.ViewRowImpl;
import oracle.jbo.uicli.binding.JUFormBinding;
import oracle.jbo.uicli.binding.JUUtil;
import oracle.jbo.uicli.controls.JULabel;
import oracle.jbo.uicli.controls.JUPanel;
import oracle.jbo.uicli.controls.JUTestFrame;
import oracle.jbo.uicli.jui.JUPanelBinding;
import oracle.jdeveloper.layout.XYConstraints;
import oracle.jdeveloper.layout.XYLayout;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TelaUC004
extends JPanel
implements JUPanel,
MciModelo {
    private static final long serialVersionUID = 1L;
    private static Log log = LogFactory.getLog(TelaUC004.class);
    private JUPanelBinding panelBinding = new JUPanelBinding("TelaUC004UIModel");
    private static final String UC004_12 = "\u00c9 preciso preencher o telefone do respons\u00e1vel";
    private final BorderLayout borderLayout1 = new BorderLayout();
    private final JPanel jpFundo = new JPanel();
    private final BorderLayout borderLayout2 = new BorderLayout();
    private final JPanel jpCabecalho = new JPanel();
    private final XYLayout xYLayout1 = new XYLayout();
    private final JPanel jpMeio = new JPanel();
    private final JULabel lblOrgao = new JULabel();
    private final JULabel lblCNPJ = new JULabel();
    private final JLabel jlAno = new JLabel();
    private final JLabel jlPeriodo = new JLabel();
    private final JLabel jlRepresentante = new JLabel();
    private final JPanel jpPerguntas = new JPanel();
    private final GridBagLayout gridBagLayout2 = new GridBagLayout();
    private final JLabel jlEncerramento = new JLabel();
    private final JLabel jlRPPS = new JLabel();
    private final JLabel jlOrganizacao = new JLabel();
    private final JRadioButton jrbRPPSSim = new JRadioButton();
    private final JRadioButton jrbRPPSNao = new JRadioButton();
    private final JRadioButton jrbRPPSNone = new JRadioButton();
    private final JRadioButton jrbOrganizacaoFundo = new JRadioButton();
    private final JRadioButton jrbOrganizacaoAutFund = new JRadioButton();
    private final JRadioButton jrbOrganizacaoNone = new JRadioButton();
    private final JRadioButton jrbEncerramentoSim = new JRadioButton();
    private final JRadioButton jrbEncerramentoNao = new JRadioButton();
    private final JRadioButton jrbEncerramentoNone = new JRadioButton();
    private final ButtonGroup bgEncerramento = new ButtonGroup();
    private final ButtonGroup bgRPPS = new ButtonGroup();
    private final ButtonGroup bgOrganizacao = new ButtonGroup();
    private final JTextField jtfCNPJ = new JTextField();
    private final JTextField jtfRepresentante = new JTextField();
    private final JComboBox jcbPeriodo = new JComboBox();
    private final JComboBox jcbEntidades = new JComboBox();
    public boolean bindingConcluido = false;
    public Integer cdEntidadeAnterior = new Integer(0);
    public Integer cdEntidadeAtual = new Integer(0);
    private final JSpinner jsAno = new JSpinner();
    public String cnpjEncontrado = "";
    private int anoAnterior = 0;
    private int periodoAnterior = 0;
    private String nomeEntidade = "";
    private final JLabel jlNomeResponsavel = new JLabel();
    private final JLabel jlTelefoneResponsavel = new JLabel();
    private final JLabel jlEmailResponsavel = new JLabel();
    private final JTextField jtfNomeResponsavel = new JTextField();
    private final MciFoneField jtfTelefoneResponsavel = new MciFoneField("(**)#######*", "\u00c9 preciso preencher o telefone do respons\u00e1vel");
    private final JTextField jtfEmailResponsavel = new JTextField();
    private Integer cbLastCod;
    private final JButton btnConsultar = new JButton();
    private RemessasMCIViewRowImpl viewRowImplEntidade;
    private static Boolean consultaEntidadesAtivada = false;
    public static final String MSG_ERRO_CONEXAO = "N\u00e3o foi poss\u00edvel estabelecer conex\u00e3o com o TCE. Favor verifique sua conex\u00e3o com a internet ou entre em contato com o TCE.";
    public static final String NOME_REPRESENTANTE = "NomeRepresentante";
    private final XYLayout xYLayout2 = new XYLayout();
    public static Boolean reconsultarResponsaveis = false;

    public static void setReconsultarResponsaveis(Boolean reconsultarResponsaveis) {
        TelaUC004.reconsultarResponsaveis = reconsultarResponsaveis;
    }

    public static Boolean getReconsultarResponsaveis() {
        return reconsultarResponsaveis;
    }

    public void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.setSize(new Dimension(620, 320));
        this.setPreferredSize(new Dimension(620, 320));
        this.setMaximumSize(new Dimension(620, 320));
        this.setMinimumSize(new Dimension(620, 320));
        this.jpFundo.setLayout(this.borderLayout2);
        this.jpCabecalho.setLayout((LayoutManager)this.xYLayout1);
        this.jpCabecalho.setPreferredSize(new Dimension(254, 80));
        this.jpCabecalho.setBorder(BorderFactory.createEtchedBorder(1));
        this.jpMeio.setBorder(BorderFactory.createEtchedBorder(1));
        this.jpMeio.setLayout((LayoutManager)this.xYLayout2);
        this.lblOrgao.setText("\u00d3rg\u00e3o:");
        this.lblCNPJ.setText("CNPJ:");
        this.jlAno.setText("Ano do Exerc\u00edcio:");
        this.jlAno.setHorizontalAlignment(0);
        this.jlAno.setHorizontalTextPosition(0);
        this.jlPeriodo.setText("Per\u00edodo das Informa\u00e7\u00f5es:");
        this.jlPeriodo.setHorizontalAlignment(0);
        this.jlPeriodo.setHorizontalTextPosition(0);
        this.jlRepresentante.setText("Respons\u00e1vel:");
        this.jlRepresentante.setHorizontalAlignment(0);
        this.jlRepresentante.setHorizontalTextPosition(0);
        this.jlRepresentante.setToolTipText("Nome do Representante");
        this.jpPerguntas.setLayout(this.gridBagLayout2);
        this.jpPerguntas.setBorder(BorderFactory.createEtchedBorder(1));
        this.jlEncerramento.setText("O per\u00edodo acima refere-se a encerramento de mandato?");
        this.jlRPPS.setText("Possui RPPS?");
        this.jlOrganizacao.setText("Forma de Organiza\u00e7\u00e3o?");
        this.jrbRPPSSim.setText("Sim");
        this.jrbRPPSNao.setText("N\u00e3o");
        this.jrbOrganizacaoFundo.setText("Fundo");
        this.jrbOrganizacaoAutFund.setText("Autarquia/Funda\u00e7\u00e3o");
        this.jrbEncerramentoSim.setText("Sim");
        this.jrbEncerramentoNao.setText("N\u00e3o");
        this.jrbEncerramentoNone.setVisible(false);
        this.jrbOrganizacaoNone.setVisible(false);
        this.jrbRPPSNone.setVisible(false);
        this.jpCabecalho.add((Component)this.jcbEntidades, new XYConstraints(70, 15, 515, 20));
        this.jpCabecalho.add((Component)this.jtfCNPJ, new XYConstraints(70, 45, 225, 20));
        this.jpCabecalho.add((Component)this.lblCNPJ, new XYConstraints(30, 45, -1, -1));
        this.jpCabecalho.add((Component)this.lblOrgao, new XYConstraints(25, 15, -1, -1));
        this.jpCabecalho.add((Component)this.btnConsultar, new XYConstraints(310, 45, 120, 20));
        this.jpFundo.add((Component)this.jpCabecalho, "North");
        this.jpFundo.add((Component)this.jpMeio, "Center");
        this.jpMeio.add((Component)this.jlAno, new XYConstraints(130, 10, 120, 20));
        this.jpMeio.add((Component)this.jlPeriodo, new XYConstraints(85, 45, 160, 15));
        this.jpMeio.add((Component)this.jlRepresentante, new XYConstraints(110, 73, 180, 15));
        this.jpMeio.add((Component)this.jtfRepresentante, new XYConstraints(240, 70, 320, 20));
        this.jpMeio.add((Component)this.jcbPeriodo, new XYConstraints(240, 40, 220, 20));
        this.jpMeio.add((Component)this.jsAno, new XYConstraints(240, 10, 70, 20));
        this.jpPerguntas.add((Component)this.jlEncerramento, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(6, 0, 6, 66), 8, 1));
        this.jpPerguntas.add((Component)this.jlRPPS, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(6, 0, 6, 30), 0, 0));
        this.jpPerguntas.add((Component)this.jlOrganizacao, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(6, 0, 6, 15), 0, 0));
        this.jpPerguntas.add((Component)this.jrbRPPSSim, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jpPerguntas.add((Component)this.jrbRPPSNao, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 87, 0, 0), 0, 0));
        this.jpPerguntas.add((Component)this.jrbOrganizacaoFundo, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jpPerguntas.add((Component)this.jrbOrganizacaoAutFund, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 87, 0, 1), 0, 0));
        this.jpPerguntas.add((Component)this.jrbEncerramentoSim, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jpPerguntas.add((Component)this.jrbEncerramentoNao, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 87, 0, 0), 0, 0));
        this.jpPerguntas.add((Component)this.jlNomeResponsavel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 0, 6, 0), 0, 0));
        this.jpPerguntas.add((Component)this.jlTelefoneResponsavel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 0, 6, 30), 0, 0));
        this.jpPerguntas.add((Component)this.jlEmailResponsavel, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jpPerguntas.add((Component)this.jtfNomeResponsavel, new GridBagConstraints(1, 3, 3, 1, 0.0, 0.0, 17, 2, new Insets(0, 15, 0, 25), 0, 0));
        this.jpPerguntas.add((Component)this.jtfTelefoneResponsavel, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 15, 0, 3), 0, 0));
        this.jpPerguntas.add((Component)this.jtfEmailResponsavel, new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 15, 0, 25), 0, 0));
        this.bgEncerramento.add(this.jrbEncerramentoSim);
        this.bgEncerramento.add(this.jrbEncerramentoNao);
        this.bgEncerramento.add(this.jrbEncerramentoNone);
        this.bgRPPS.add(this.jrbRPPSSim);
        this.bgRPPS.add(this.jrbRPPSNao);
        this.bgRPPS.add(this.jrbRPPSNone);
        this.bgOrganizacao.add(this.jrbOrganizacaoFundo);
        this.bgOrganizacao.add(this.jrbOrganizacaoAutFund);
        this.bgOrganizacao.add(this.jrbOrganizacaoNone);
        this.jpFundo.add((Component)this.jpPerguntas, "South");
        this.add((Component)this.jpFundo, "Center");
        this.jcbEntidades.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                TelaUC004.this.validaCNPJEntidade(e);
            }
        });
        this.jcbEntidades.setEditable(false);
        this.jsAno.setOpaque(false);
        this.jsAno.setBackground(Color.white);
        SpinnerNumberModel spinnerNumber = new SpinnerNumberModel(ConstantesTelas.ANO_PADRAO_REMESSA, 2000, ConstantesTelas.ANO_MAXIMO_REMESSA, 1);
        this.jrbOrganizacaoFundo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TelaUC004.this.jrbOrganizacaoFundo_itemStateChanged(e);
            }
        });
        this.jtfEmailResponsavel.setPreferredSize(new Dimension(130, 19));
        this.jtfTelefoneResponsavel.setPreferredSize(new Dimension(130, 19));
        this.jlEmailResponsavel.setText("e-mail:");
        this.jlTelefoneResponsavel.setText("Telefone:");
        this.jlNomeResponsavel.setText("Nome do Respons\u00e1vel:");
        this.jlAno.setToolTipText("Ano do Exerc\u00edcio");
        this.btnConsultar.setText("Atualizar Dados");
        this.jcbEntidades.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                TelaUC004.this.jcbEntidades_focusLost(e);
            }
        });
        this.jrbRPPSSim.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TelaUC004.this.jrbRPPSSim_itemStateChanged(e);
            }
        });
        this.jcbPeriodo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TelaUC004.this.jcbPeriodo_itemStateChanged(e);
            }
        });
        this.jsAno.setModel(spinnerNumber);
        this.jsAno.setEditor(new JSpinner.NumberEditor(this.jsAno, "#"));
        ((JSpinner.DefaultEditor)this.jsAno.getEditor()).getTextField().setEditable(false);
        ((JSpinner.DefaultEditor)this.jsAno.getEditor()).getTextField().setBackground(Color.white);
        this.jcbPeriodo.setEditable(false);
        this.jtfCNPJ.setEditable(false);
        this.jcbEntidades.setModel((ComboBoxModel)this.panelBinding.bindUIControl("TipoSetorGov", (Object)this.jcbEntidades));
        this.jtfCNPJ.setDocument((Document)this.panelBinding.bindUIControl("Cnpj", (Object)this.jtfCNPJ));
        this.jtfRepresentante.setEditable(false);
        this.jcbPeriodo.setModel((ComboBoxModel)this.panelBinding.bindUIControl("DsPeriodo", (Object)this.jcbPeriodo));
        this.jtfRepresentante.setDocument((Document)this.panelBinding.bindUIControl(NOME_REPRESENTANTE, (Object)this.jtfRepresentante));
        this.preparaTamanhoCampos();
        this.jtfNomeResponsavel.setDocument((Document)this.panelBinding.bindUIControl("NomeResponsavel", (Object)this.jtfNomeResponsavel));
        this.jtfEmailResponsavel.setDocument((Document)this.panelBinding.bindUIControl("EmailResponsavel", (Object)this.jtfEmailResponsavel));
        this.jtfTelefoneResponsavel.setDocument(MciTextFieldBinding.createAttributeBinding((JUFormBinding)this.panelBinding, this.jtfTelefoneResponsavel, "Cadcontinterno", null, "RemessasMCIViewIterator", "TelefoneResponsavel"));
        this.btnConsultar.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                MciWizardForm form = MciWizardHelper.getInstance().getForm();
                try {
                    form.defineCursor(3);
                    TelaUC004.this.limparCampos();
                    reconsultarResponsaveis = true;
                    TelaUC004.this.consultaWebService((ViewRowImpl)TelaUC004.this.jcbEntidades.getSelectedItem());
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                finally {
                    form.defineCursor(0);
                }
            }
        });
        this.jcbEntidades.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (TelaUC004.this.jcbEntidades.getSelectedItem() == null || (Integer)((ViewRowImpl)TelaUC004.this.jcbEntidades.getSelectedItem()).getAttribute(0) == 1) {
                    TelaUC004.this.btnConsultar.setEnabled(false);
                } else {
                    TelaUC004.this.btnConsultar.setEnabled(true);
                }
                if (TelaUC004.this.btnConsultar.isEnabled() && e.getStateChange() == 1 && TelaUC004.this.jcbEntidades.getSelectedItem() != null) {
                    Integer cdEntidade = (Integer)((ViewRowImpl)TelaUC004.this.jcbEntidades.getSelectedItem()).getAttribute(0);
                    TelaUC004.this.viewRowImplEntidade = (RemessasMCIViewRowImpl)TelaUC004.this.panelBinding.getControlBinding((Object)TelaUC004.this.jtfNomeResponsavel).getCurrentRow();
                    if (TelaUC004.this.viewRowImplEntidade != null) {
                        if (TelaUC004.this.viewRowImplEntidade.getCdEntidade() == null) {
                            TelaUC004.this.cbLastCod = 0;
                        } else {
                            TelaUC004.this.cbLastCod = (int)TelaUC004.this.viewRowImplEntidade.getCdEntidade();
                        }
                    }
                    if (consultaEntidadesAtivada.booleanValue() && !cdEntidade.equals(TelaUC004.this.cbLastCod)) {
                        TelaUC004.this.cbLastCod = cdEntidade;
                        TelaUC004.this.limparCampos();
                        reconsultarResponsaveis = true;
                        TelaUC004.this.consultaWebService((ViewRowImpl)TelaUC004.this.jcbEntidades.getSelectedItem());
                    }
                }
            }
        });
        this.jcbEntidades.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
            }

            @Override
            public void focusGained(FocusEvent e) {
                consultaEntidadesAtivada = true;
            }
        });
    }

    private void consultaWebService(ViewRowImpl selectedItem) {
        try {
            ResponsaveisWSClient.initalize();
            Integer cdEntidade = (Integer)selectedItem.getAttribute(0);
            if (cdEntidade > 1) {
                log.info((Object)"-------------------> CONSULTOU!");
                final EntidadeWSPojo entidade = ResponsaveisWSClient.buscarDadosEntidade(cdEntidade.longValue());
                ResponsavelAtualWSPojo responsavelAtual = entidade.getResponsavel();
                if (responsavelAtual == null) {
                    throw new ResponsavelNaoEncontradoFault();
                }
                log.info((Object)("info: " + responsavelAtual.getCpf() + " / " + responsavelAtual.getNome() + " / " + responsavelAtual.getCargo() + " [cdEntidade=" + cdEntidade + "]"));
                this.viewRowImplEntidade.setCdEntidade(cdEntidade);
                this.viewRowImplEntidade.setEscolhidoPre(entidade.getEscolhidoPre());
                this.preencheCampo(this.jtfNomeResponsavel, NOME_REPRESENTANTE, responsavelAtual.getNome());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String cnpj = String.format("%014d", entidade.getCgc());
                        TelaUC004.this.jtfCNPJ.setText(cnpj);
                        TelaUC004.this.jtfCNPJ.repaint();
                        Remessa remessa = DatacontrolHelper.getRemessaDataControl(TelaUC004.this.panelBinding.getBindingContext());
                        ServicoMCI servico = DatacontrolHelper.getServicoMCIAppModule(TelaUC004.this.panelBinding.getBindingContext());
                        TelaUC004.atualizaCNPJ(cnpj, servico, remessa);
                        log.info((Object)("-- atualizou cnpj: " + entidade.getCgc()));
                    }
                });
            } else {
                log.warn((Object)("cdEntidade [" + cdEntidade + "] < 1"));
            }
        }
        catch (ResponsaveisFault e) {
            e.printStackTrace();
            this.exibeMensagemWarning(e.getMessage());
            this.limparCampos();
        }
        catch (SOAPFaultException e) {
            e.printStackTrace();
            this.exibeMensagemWarning(e.getMessage());
            this.limparCampos();
        }
        catch (NoRouteToHostException e) {
            e.printStackTrace();
            this.exibeMensagemWarning(MSG_ERRO_CONEXAO);
        }
        catch (WebServiceException e) {
            e.printStackTrace();
            this.exibeMensagemWarning(MSG_ERRO_CONEXAO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.exibeMensagemErro(e);
        }
        catch (Error e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void preencheCampo(JTextField field, String key, String content) {
        if (content != null) {
            this.panelBinding.getControlBinding((Object)field).getCurrentRow().setAttribute(key, (Object)content);
            this.panelBinding.getControlBinding((Object)field).refreshControl();
        } else {
            this.panelBinding.getControlBinding((Object)field).getCurrentRow().setAttribute(key, (Object)" ");
            this.panelBinding.getControlBinding((Object)field).refreshControl();
        }
    }

    private void limparCampos() {
        this.viewRowImplEntidade = (RemessasMCIViewRowImpl)this.panelBinding.getControlBinding((Object)this.jtfNomeResponsavel).getCurrentRow();
        this.viewRowImplEntidade.setNomeRepresentante("");
        this.panelBinding.getControlBinding((Object)this.jtfNomeResponsavel).refreshControl();
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exemp) {
            exemp.printStackTrace();
        }
        TelaUC004 panel = new TelaUC004();
        panel.setBindingContext(JUTestFrame.startTestFrame((String)"DataBindings.cpx", (String)"null", (JPanel)panel, (JUPanelBinding)panel.getPanelBinding(), (Dimension)new Dimension(400, 300)));
        panel.revalidate();
    }

    public JUPanelBinding getPanelBinding() {
        return this.panelBinding;
    }

    private void unRegisterProjectGlobalVariables(BindingContext bindCtx) {
        JUUtil.unRegisterNavigationBarInterface((JUFormBinding)this.panelBinding, (BindingContext)bindCtx);
    }

    private void registerProjectGlobalVariables(BindingContext bindCtx) {
        JUUtil.registerNavigationBarInterface((JUFormBinding)this.panelBinding, (BindingContext)bindCtx);
    }

    @Override
    public void setBindingContext(BindingContext bindCtx) {
        if (this.panelBinding.getPanel() == null) {
            this.panelBinding = this.panelBinding.setup(bindCtx, (Object)this);
            this.registerProjectGlobalVariables(bindCtx);
            this.panelBinding.refreshControl();
            try {
                this.jbInit();
                this.panelBinding.refreshControl();
                this.bindingConcluido = true;
            }
            catch (Exception ex) {
                this.panelBinding.reportException((Throwable)ex);
            }
        }
    }

    private void preparaTamanhoCampos() {
        int MAX_CHARACTERS_REPRESENTANTE = 70;
        ((AbstractDocument)this.jtfRepresentante.getDocument()).setDocumentFilter(new DocumentSizeFilter(MAX_CHARACTERS_REPRESENTANTE));
    }

    public String identificaPoder() {
        Remessa remessa = DatacontrolHelper.getRemessaDataControl(this.panelBinding.getBindingContext());
        if (remessa != null) {
            String setor = remessa.getTipoSetor();
            if (setor.equals("P")) {
                return "P";
            }
            return "C";
        }
        return "";
    }

    @Override
    public void preparaTela() {
        MciWizardControle control = MciWizardHelper.getInstance().getForm().getPagina().getMciWizardControle();
        control.exibeBotaoObservacoes(false);
        BindingContext binding = this.panelBinding.getBindingContext();
        DCDataControl dc = binding.findDataControl("ServicoMCIDataControl");
        ServicoMCI ser = (ServicoMCI)dc.getDataProvider();
        this.setAnoAnterior(ser.buscaAnoExercicio());
        this.setPeriodoAnterior(ser.buscaPeriodo());
        this.setCdEntidadeAnterior(ser.buscaCdEntidade());
        Remessa remessa = DatacontrolHelper.getRemessaDataControl(this.panelBinding.getBindingContext());
        this.setCdEntidadeAnterior(remessa.getCdEntidade());
        if (remessa != null) {
            String foo;
            ViewObject vo = ser.findViewObject("RemessasMCIView");
            Row r = vo.getCurrentRow();
            if (r != null) {
                Integer value = (Integer)r.getAttribute("AnoExercicio");
                log.info((Object)("getAnoLabel: " + value + "; currvalue: " + this.jsAno.getModel().getValue()));
                if (value != null) {
                    this.jsAno.getModel().setValue(value);
                    this.setAnoAnterior(value);
                }
            }
            if ((foo = (String)r.getAttribute("Ehencmandato")) != null) {
                if (foo.equalsIgnoreCase("S")) {
                    this.jrbEncerramentoSim.setSelected(true);
                } else if (foo.equalsIgnoreCase("N")) {
                    this.jrbEncerramentoNao.setSelected(true);
                } else {
                    this.jrbEncerramentoNone.setSelected(true);
                }
            } else {
                this.jrbEncerramentoNone.setSelected(true);
            }
            foo = (String)r.getAttribute("Possuirpps");
            if (foo != null) {
                if (foo.equalsIgnoreCase("S")) {
                    this.jrbRPPSSim.setSelected(true);
                } else if (foo.equalsIgnoreCase("N")) {
                    this.jrbRPPSNao.setSelected(true);
                } else {
                    this.jrbRPPSNone.setSelected(true);
                }
            } else {
                this.jrbRPPSNone.setSelected(true);
            }
            foo = (String)r.getAttribute("Formaorg");
            if (foo != null) {
                if (foo.equalsIgnoreCase("F")) {
                    this.jrbOrganizacaoFundo.setSelected(true);
                } else if (foo.equalsIgnoreCase("A")) {
                    this.jrbOrganizacaoAutFund.setSelected(true);
                } else {
                    this.jrbOrganizacaoNone.setSelected(true);
                }
            } else {
                this.jrbOrganizacaoNone.setSelected(true);
            }
            Integer per = (Integer)r.getAttribute("CdPeriodo");
            this.setPeriodoAnterior(per);
            if (per == 3 || per == 5) {
                this.jrbEncerramentoSim.setVisible(true);
                this.jrbEncerramentoNao.setVisible(true);
                this.jlEncerramento.setVisible(true);
            } else {
                this.jrbEncerramentoNone.setSelected(true);
                this.jrbEncerramentoSim.setVisible(false);
                this.jrbEncerramentoNao.setVisible(false);
                this.jlEncerramento.setVisible(false);
            }
            if (remessa.getTipoSetor().equalsIgnoreCase("P")) {
                this.jrbRPPSSim.setVisible(true);
                this.jrbRPPSNao.setVisible(true);
                this.jlRPPS.setVisible(true);
            } else {
                this.jrbRPPSNone.setSelected(true);
                this.jrbRPPSSim.setVisible(false);
                this.jrbRPPSNao.setVisible(false);
                this.jlRPPS.setVisible(false);
            }
            if (this.jrbRPPSSim.isSelected() && remessa.getTipoSetor().equalsIgnoreCase("P")) {
                this.jrbRPPSSubFieldsSetVisible(true);
            } else {
                this.jrbOrganizacaoNone.setSelected(true);
                this.jrbRPPSSubFieldsSetVisible(false);
            }
            if (this.jrbOrganizacaoFundo.isSelected()) {
                this.jrbOrganizacaoFundoSubFieldsSetVisible(true);
            } else {
                this.jrbOrganizacaoFundoSubFieldsSetVisible(false);
            }
            ViewObject voEntidades = ser.findViewObject("EntidadesView");
            voEntidades.setWhereClause("Entidades.TIPO_SETOR_GOV = ?");
            voEntidades.setWhereClauseParam(0, (Object)remessa.getTipoSetor());
            voEntidades.executeQuery();
            if (remessa.getCdEntidade() != null) {
                this.validaEntidadeRemessa(ser, remessa);
            }
            this.jcbEntidades.addItem("Selecione um org\u00e3o");
        }
        this.jcbPeriodo.setEnabled(true);
    }

    private boolean validaCNPJEntidade(PopupMenuEvent e) {
        Remessa remessa = DatacontrolHelper.getRemessaDataControl(this.panelBinding.getBindingContext());
        BindingContext binding = this.panelBinding.getBindingContext();
        DCDataControl dc = binding.findDataControl("ServicoMCIDataControl");
        ServicoMCI ser = (ServicoMCI)dc.getDataProvider();
        if (this.bindingConcluido) {
            try {
                ViewRowImpl viewRowImplEntidade = (ViewRowImpl)this.jcbEntidades.getSelectedItem();
                if (viewRowImplEntidade == null) {
                    this.jcbEntidades.setSelectedIndex(0);
                }
            }
            catch (Exception exp) {
                log.warn((Object)("Erro na valida\u00e7\u00e3o: " + exp));
            }
        }
        this.validaEntidadeRemessa(ser, remessa);
        return true;
    }

    private void validaEntidadeRemessa(ServicoMCI servico, Remessa remessa) {
        ViewObject voRemessa = servico.findViewObject("RemessasMCIView");
        ViewObject voCNPJ = servico.findViewObject("EntidadesConsultaCNPJ");
        Row remessaRow = voRemessa.first();
        if (remessaRow != null) {
            remessa.setCdEntidade((Integer)remessaRow.getAttribute("CdEntidade"));
            this.setCdEntidadeAtual((Integer)remessaRow.getAttribute("CdEntidade"));
            voCNPJ.setWhereClauseParam(0, (Object)remessa.getCdEntidade());
            voCNPJ.setWhereClauseParam(1, (Object)remessa.getTipoSetor());
            voCNPJ.executeQuery();
            Row entidadeCNPJ = voCNPJ.first();
            if (entidadeCNPJ != null) {
                this.cnpjEncontrado = (String)entidadeCNPJ.getAttribute("Cnpj");
                this.setNomeEntidade((String)entidadeCNPJ.getAttribute("Nome"));
                this.jtfCNPJ.setText(this.cnpjEncontrado);
                this.jtfCNPJ.repaint();
            } else {
                this.cnpjEncontrado = "";
                this.jtfCNPJ.setText(this.cnpjEncontrado);
                this.jtfCNPJ.repaint();
            }
            remessaRow = null;
            voRemessa = null;
            voCNPJ = null;
        }
    }

    public int getAnoExercicio() {
        return (Integer)this.jsAno.getValue();
    }

    public void exibeMensagemWarning(String mensagem) {
        MciWizardForm form = MciWizardHelper.getInstance().getForm();
        JOptionPane.showMessageDialog(form, mensagem, "Aten\u00e7\u00e3o", 2);
    }

    private void exibeMensagemErro(Exception e) {
        MciWizardForm form = MciWizardHelper.getInstance().getForm();
        MciErrorDialog errorDialog = new MciErrorDialog(form);
        errorDialog.reportException((JUFormBinding)this.panelBinding, e);
    }

    public String getCnpjEntidade() {
        return this.jtfCNPJ.getText();
    }

    @Override
    public final void finalizaTela() {
    }

    @Override
    public boolean validaTela() {
        return true;
    }

    public boolean isEncMandatoSim() {
        return this.jrbEncerramentoSim.isSelected();
    }

    public boolean isEncMandatoNao() {
        return this.jrbEncerramentoNao.isSelected();
    }

    public boolean isEncMandatoNone() {
        return this.jrbEncerramentoNone.isSelected();
    }

    public boolean isRPPSSim() {
        return this.jrbRPPSSim.isSelected();
    }

    public boolean isRPPSNao() {
        return this.jrbRPPSNao.isSelected();
    }

    public boolean isRPPSNone() {
        return this.jrbRPPSNone.isSelected();
    }

    public boolean isOrganizacaoFundo() {
        return this.jrbOrganizacaoFundo.isSelected();
    }

    public boolean isOrganizacaoAutFund() {
        return this.jrbOrganizacaoAutFund.isSelected();
    }

    public boolean isOrganizacaoNone() {
        return this.jrbOrganizacaoNone.isSelected();
    }

    private void jcbPeriodo_itemStateChanged(ItemEvent e) {
        if (this.jcbPeriodo.getSelectedIndex() == 3 || this.jcbPeriodo.getSelectedIndex() == 5) {
            this.jrbEncerramentoSim.setVisible(true);
            this.jrbEncerramentoNao.setVisible(true);
            this.jlEncerramento.setVisible(true);
        } else {
            this.jrbEncerramentoSim.setVisible(false);
            this.jrbEncerramentoNao.setVisible(false);
            this.jlEncerramento.setVisible(false);
        }
    }

    private void jrbRPPSSubFieldsSetVisible(boolean v) {
        this.jrbOrganizacaoFundo.setVisible(v);
        this.jrbOrganizacaoAutFund.setVisible(v);
        this.jlOrganizacao.setVisible(v);
    }

    private void jrbOrganizacaoFundoSubFieldsSetVisible(boolean v) {
        this.jlNomeResponsavel.setVisible(v);
        this.jtfNomeResponsavel.setVisible(v);
        this.jlTelefoneResponsavel.setVisible(v);
        this.jtfTelefoneResponsavel.setVisible(v);
        this.jlEmailResponsavel.setVisible(v);
        this.jtfEmailResponsavel.setVisible(v);
    }

    private void jrbRPPSSim_itemStateChanged(ItemEvent e) {
        if (this.jrbRPPSSim.isSelected()) {
            this.jrbRPPSSubFieldsSetVisible(true);
        } else {
            this.jrbOrganizacaoNone.setSelected(true);
            this.jrbRPPSSubFieldsSetVisible(false);
        }
    }

    private void jrbOrganizacaoFundo_itemStateChanged(ItemEvent e) {
        if (this.jrbOrganizacaoFundo.isSelected()) {
            this.jrbOrganizacaoFundoSubFieldsSetVisible(true);
        } else {
            this.jrbOrganizacaoFundoSubFieldsSetVisible(false);
        }
    }

    public Integer getCdEntidadeAnterior() {
        return this.cdEntidadeAnterior;
    }

    public void setCdEntidadeAnterior(Integer cdEntidadeAnterior) {
        this.cdEntidadeAnterior = cdEntidadeAnterior;
    }

    public Integer getCdEntidadeAtual() {
        return this.cdEntidadeAtual;
    }

    public void setCdEntidadeAtual(Integer cdEntidadeAtual) {
        this.cdEntidadeAtual = cdEntidadeAtual;
    }

    private void jcbEntidades_focusLost(FocusEvent e) {
        this.jtfCNPJ.setText(this.cnpjEncontrado);
        this.jtfCNPJ.repaint();
    }

    public int getAnoAnterior() {
        return this.anoAnterior;
    }

    public void setAnoAnterior(int anoAnterior) {
        this.anoAnterior = anoAnterior;
    }

    public int getPeriodoAnterior() {
        return this.periodoAnterior;
    }

    public void setPeriodoAnterior(int periodoAnterior) {
        this.periodoAnterior = periodoAnterior;
    }

    public String getRepresentante() {
        return this.jtfRepresentante.getText();
    }

    public int getPeriodoExercicio() {
        return this.jcbPeriodo.getSelectedIndex();
    }

    public String getNomeEntidade() {
        return this.nomeEntidade;
    }

    public void setNomeEntidade(String nomeEnt) {
        this.nomeEntidade = nomeEnt;
    }

    public static Boolean getConsultaEntidadesAtivada() {
        return consultaEntidadesAtivada;
    }

    public static void setConsultaEntidadesAtivada(Boolean consultaEntidadesAtivada) {
        TelaUC004.consultaEntidadesAtivada = consultaEntidadesAtivada;
    }

    public static void atualizaCNPJ(String cnpj, ServicoMCI servico, Remessa remessa) {
        while (cnpj.length() < 14) {
            cnpj = "0" + cnpj;
        }
        log.info((Object)("atualizaCNPJ:: cd_entidade: " + remessa.getCdEntidade() + " ; cnpj: " + cnpj));
        servico.atualizaCNPJEntidade(String.valueOf(remessa.getCdEntidade()), cnpj);
        remessa.setCnpjEntidade(cnpj);
    }
}

