/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.visao.panel;

import br.gov.rs.tce.mci.beans.Pergunta;
import br.gov.rs.tce.mci.beans.PerguntaOpcao;
import br.gov.rs.tce.mci.beans.Perguntas;
import br.gov.rs.tce.mci.beans.Tela;
import br.gov.rs.tce.mci.beans.remessa.Remessa;
import br.gov.rs.tce.mci.modelo.decisao.NavegacaoTelasControle;
import br.gov.rs.tce.mci.modelo.servico.common.ServicoMCI;
import br.gov.rs.tce.mci.util.DatacontrolHelper;
import br.gov.rs.tce.mci.visao.MciModelo;
import br.gov.rs.tce.mci.visao.MciWizardControle;
import br.gov.rs.tce.mci.visao.MciWizardHelper;
import br.gov.rs.tce.mci.visao.util.Observacoes;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import oracle.adf.model.BindingContext;
import oracle.jbo.uicli.controls.JUPanel;
import oracle.jbo.uicli.jui.JUPanelBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TelaPerguntas
extends JPanel
implements MciModelo,
JUPanel,
ActionListener {
    private static final long serialVersionUID = 1L;
    private BindingContext _bindingContext;
    private Tela _tela;
    protected JUPanelBinding _panelBinding;
    protected Log log = LogFactory.getLog(this.getClass());
    Set<String> perguntas = new HashSet<String>();
    Map<String, String> perguntaValorInvalido = new HashMap<String, String>();
    Map<String, Map<String, String>> perguntaDependePergunta = new HashMap<String, Map<String, String>>();
    Map<String, Map<String, String>> perguntaOpcaoNecessitaObservacoes = new HashMap<String, Map<String, String>>();
    Map<JRadioButton, String> perguntaJRadioInvalido = new HashMap<JRadioButton, String>();
    Map<String, JPanel> panelPerguntas = new HashMap<String, JPanel>();
    Map<String, JTextField> textFieldsPerguntas = new HashMap<String, JTextField>();
    Map<String, String> respostasPerguntas = new HashMap<String, String>();
    Map<String, String> respostasExtPerguntas = new HashMap<String, String>();

    public void jbInit() throws Exception {
        this.setLayout(new BoxLayout(this, 3));
    }

    @Override
    public void setBindingContext(BindingContext bindCtx) {
        this._bindingContext = bindCtx;
        this._panelBinding = new JUPanelBinding();
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        NavegacaoTelasControle navegacao = (NavegacaoTelasControle)bindCtx.findDataControl("NavegacaoDataControl");
        this._tela = navegacao.getConfigTelaAtual();
    }

    public final Tela getConfigTela() {
        return this._tela;
    }

    public final void inicializaComponentesTela() {
        Perguntas ps = this._tela.getPerguntas();
        String mensagemPrev = null;
        JPanel tfpanel = null;
        for (Pergunta p : ps.getPerguntas()) {
            List<PerguntaOpcao> pos;
            this.perguntas.add(p.getCodigo());
            String mensagem = p.getMensagem();
            this.log.debug((Object)("inicializaComponentesTela: " + p.getCodigo() + " / mensagem=" + mensagem + " / mensagemPrev=" + mensagemPrev));
            JPanel jp = new JPanel();
            jp.setBorder(new EmptyBorder(0, 10, 0, 10));
            this.add(jp);
            this.panelPerguntas.put(p.getCodigo(), jp);
            if (p.getDependePergunta() != null) {
                HashMap<String, String> depende = new HashMap<String, String>();
                depende.put(p.getCodigo(), p.getDependeResposta());
                Map<String, String> dependencias = this.perguntaDependePergunta.get(p.getDependePergunta());
                if (dependencias == null) {
                    this.perguntaDependePergunta.put(p.getDependePergunta(), depende);
                } else {
                    dependencias.putAll(depende);
                }
            }
            jp.setLayout(new BoxLayout(jp, 3));
            if (mensagem != null) {
                JPanel jlPanel = new JPanel();
                jlPanel.setLayout(new BoxLayout(jlPanel, 2));
                JLabel jl = new JLabel(mensagem);
                jl.setHorizontalAlignment(0);
                jlPanel.add(Box.createGlue());
                jlPanel.add(jl);
                jlPanel.add(Box.createGlue());
                jp.add(jlPanel);
            }
            if ((pos = p.getOpcoes()).size() > 0) {
                ButtonGroup group = new ButtonGroup();
                JPanel radiopanel = new JPanel();
                for (PerguntaOpcao o : pos) {
                    JRadioButton radio = new JRadioButton();
                    radio.setActionCommand(o.getValor());
                    radio.setText(o.getLabel());
                    radio.addActionListener(this);
                    if (o.isOpcaoInvalida()) {
                        radio.setVisible(false);
                        this.perguntaJRadioInvalido.put(radio, p.getCodigo());
                        this.perguntaValorInvalido.put(p.getCodigo(), o.getValor());
                    }
                    if (o.isNecessarioObservacoes()) {
                        Map<String, String> ops = this.perguntaOpcaoNecessitaObservacoes.get(p.getCodigo());
                        if (ops == null) {
                            ops = new HashMap<String, String>();
                            this.perguntaOpcaoNecessitaObservacoes.put(p.getCodigo(), ops);
                        }
                        ops.put(o.getValor(), o.getMensagemObservacoesNecessarias());
                    }
                    group.add(radio);
                    radiopanel.add(radio);
                }
                jp.add(radiopanel);
            } else {
                String label = p.getLabel();
                Integer tamanho = p.getTamanho();
                if (label == null || label.equals("")) {
                    this.log.warn((Object)("pergunta textfield [" + p.getCodigo() + "] sem label"));
                }
                JLabel jl2 = new JLabel(label);
                JTextField jtf = new JTextField(tamanho != null ? tamanho : 15);
                this.textFieldsPerguntas.put(p.getCodigo(), jtf);
                if (tfpanel == null || mensagem != null || mensagemPrev != null) {
                    tfpanel = new JPanel();
                    jp.add(tfpanel);
                }
                tfpanel.add(jl2);
                tfpanel.add(jtf);
            }
            mensagemPrev = mensagem;
        }
    }

    @Override
    public final void preparaTela() {
        MciWizardControle control = MciWizardHelper.getInstance().getForm().getPagina().getMciWizardControle();
        control.exibeBotaoObservacoes(true);
        if (this.perguntas.size() == 0) {
            this.inicializaComponentesTela();
        }
        this.carregaRespostasDoBanco();
        this.setValorRespostasUI();
        this.validaInicial();
    }

    @Override
    public void finalizaTela() {
        MciWizardControle control = MciWizardHelper.getInstance().getForm().getPagina().getMciWizardControle();
        control.exibeBotaoObservacoes(false);
    }

    public JUPanelBinding getPanelBinding() {
        return this._panelBinding;
    }

    @Override
    public boolean validaTela() {
        ServicoMCI ser = DatacontrolHelper.getServicoMCIAppModule(this._bindingContext);
        Remessa remessa = DatacontrolHelper.getRemessaDataControl(this._bindingContext);
        Observacoes obs = new Observacoes();
        obs.buscaObservacoes(ser, remessa, this._tela.getCodigo());
        String observacoes = obs.getObservacoes();
        boolean observacoesEstaoPreenchidas = this.validaObservacoes(observacoes);
        this.populaRespostasExt();
        for (String perg : this.perguntas) {
            Map<String, String> opcoesNecessitamObservacao;
            String resp = this.respostasPerguntas.get(perg);
            String respExt = this.respostasExtPerguntas.get(perg);
            String valorInvalido = this.perguntaValorInvalido.get(perg);
            if (!this.perguntaDeveSerRespondida(perg)) continue;
            if (this.textFieldsPerguntas.containsKey(perg)) {
                if (!this.validaRespostaExt(respExt)) {
                    JOptionPane.showMessageDialog(this, "Todas as perguntas vis\u00edveis devem ser respondidas");
                    return false;
                }
            } else if (!this.validaResposta(resp, valorInvalido)) {
                JOptionPane.showMessageDialog(this, "Todas as perguntas vis\u00edveis devem ser respondidas");
                return false;
            }
            if ((opcoesNecessitamObservacao = this.perguntaOpcaoNecessitaObservacoes.get(perg)) == null || !opcoesNecessitamObservacao.containsKey(resp) || observacoesEstaoPreenchidas) continue;
            String msg = opcoesNecessitamObservacao.get(resp);
            JOptionPane.showMessageDialog(this, msg != null ? msg : "Observa\u00e7\u00f5es devem ser preenchidas");
            return false;
        }
        return true;
    }

    boolean validaObservacoes(String observacoes) {
        return observacoes != null && observacoes.trim().length() >= 3;
    }

    boolean validaResposta(String resp) {
        return resp != null && resp.length() == 1;
    }

    boolean validaResposta(String resp, String valorInvalido) {
        return resp != null && resp.length() == 1 && !resp.equals(valorInvalido);
    }

    boolean validaRespostaExt(String respExt) {
        return respExt != null && respExt.trim().length() > 0;
    }

    void populaRespostasExt() {
        for (Map.Entry<String, JTextField> me : this.textFieldsPerguntas.entrySet()) {
            JTextField tf = me.getValue();
            String cdPergunta = me.getKey();
            String resp = tf.getText();
            if (this.validaRespostaExt(resp)) {
                this.respostasExtPerguntas.put(cdPergunta, resp);
                continue;
            }
            this.respostasExtPerguntas.put(cdPergunta, null);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cdPergunta = this.findPergunta(e.getSource());
        if (cdPergunta != null) {
            this.respostasPerguntas.put(cdPergunta, e.getActionCommand());
            Map<String, String> dependencias = this.perguntaDependePergunta.get(cdPergunta);
            if (dependencias != null) {
                for (Map.Entry<String, String> deps : dependencias.entrySet()) {
                    JPanel panel = this.panelPerguntas.get(deps.getKey());
                    if (deps.getValue().equals(e.getActionCommand())) {
                        this.setEnabledDeep(panel, true);
                        continue;
                    }
                    this.setEnabledDeep(panel, false);
                }
            }
        }
    }

    void validaInicial() {
        for (String cdPergunta : this.perguntas) {
            Map<String, String> dependencias = this.perguntaDependePergunta.get(cdPergunta);
            if (dependencias == null) continue;
            String resposta = this.respostasPerguntas.get(cdPergunta);
            for (Map.Entry<String, String> deps : dependencias.entrySet()) {
                JPanel panel = this.panelPerguntas.get(deps.getKey());
                if (deps.getValue().equals(resposta)) {
                    this.setEnabledDeep(panel, true);
                    continue;
                }
                this.setEnabledDeep(panel, false);
            }
        }
    }

    String findPergunta(Object o) {
        if (o == null) {
            return null;
        }
        for (Map.Entry<String, JPanel> me : this.panelPerguntas.entrySet()) {
            if (!me.getValue().equals(o)) continue;
            return me.getKey();
        }
        if (o instanceof Component) {
            Component c = (Component)o;
            return this.findPergunta(c.getParent());
        }
        return null;
    }

    void setEnabledDeep(Component comp, boolean enabled) {
        JRadioButton jr;
        comp.setEnabled(enabled);
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                this.setEnabledDeep(cont.getComponent(i), enabled);
            }
        }
        if (!enabled && comp instanceof JRadioButton && this.perguntaJRadioInvalido.containsKey(jr = (JRadioButton)comp)) {
            jr.setSelected(true);
            String cdPergunta = this.perguntaJRadioInvalido.get(jr);
            this.respostasPerguntas.put(cdPergunta, this.perguntaValorInvalido.get(cdPergunta));
        }
        if (!enabled && comp instanceof JTextField) {
            JTextField jtf = (JTextField)comp;
            jtf.setText("");
        }
    }

    public boolean perguntaDeveSerRespondida(String codigo) {
        boolean retornoPadrao = false;
        boolean perguntaDependente = false;
        for (Map.Entry<String, Map<String, String>> ps : this.perguntaDependePergunta.entrySet()) {
            String pprinc = ps.getKey();
            for (Map.Entry<String, String> pdep : ps.getValue().entrySet()) {
                if (!pdep.getKey().equals(codigo)) continue;
                perguntaDependente = true;
                if (!pdep.getValue().equals(this.respostasPerguntas.get(pprinc))) continue;
                return true;
            }
        }
        return !perguntaDependente;
    }

    public Map<String, String> getRespostasPerguntas() {
        return this.respostasPerguntas;
    }

    public Map<String, String> getRespostasExtPerguntas() {
        return this.respostasExtPerguntas;
    }

    void carregaRespostasDoBanco() {
        ServicoMCI ser = DatacontrolHelper.getServicoMCIAppModule(this._bindingContext);
        Remessa remessa = DatacontrolHelper.getRemessaDataControl(this._bindingContext);
        for (String cdPerg : this.perguntas) {
            String resp = ser.getRespPergunta(cdPerg, true, false);
            String respExt = ser.getRespPergunta(cdPerg, false, true);
            this.log.debug((Object)("carregaRespostasDoBanco: pergunta " + cdPerg + ": resp: " + resp + " ; respExt: " + respExt + " (null? " + (respExt == null) + ")"));
            if (this.validaResposta(resp)) {
                this.respostasPerguntas.put(cdPerg, resp);
            }
            if (!this.validaRespostaExt(respExt)) continue;
            this.respostasExtPerguntas.put(cdPerg, respExt);
        }
        Observacoes obs = new Observacoes();
        obs.buscaObservacoes(ser, remessa, this._tela.getCodigo());
    }

    void setValorRespostasUI() {
        boolean bl;
        for (Map.Entry<String, String> re : this.respostasPerguntas.entrySet()) {
            JPanel panel = this.panelPerguntas.get(re.getKey());
            bl = this.setValorRadio(re, panel);
        }
        for (Map.Entry<String, String> re : this.respostasExtPerguntas.entrySet()) {
            JTextField jtf = this.textFieldsPerguntas.get(re.getKey());
            if (jtf == null) {
                this.log.debug((Object)("null textfield? perg=" + re.getKey()));
                continue;
            }
            bl = this.setValorTextField(re, jtf);
        }
    }

    boolean setValorRadio(Map.Entry<String, String> re, Component panel) {
        if (panel instanceof JRadioButton) {
            JRadioButton jr = (JRadioButton)panel;
            if (re.getValue() != null && re.getValue().equals(jr.getActionCommand())) {
                jr.setSelected(true);
                return true;
            }
        }
        if (panel instanceof Container) {
            Container cont = (Container)panel;
            for (int j = 0; j < cont.getComponentCount(); ++j) {
                boolean b = this.setValorRadio(re, cont.getComponent(j));
                if (!b) continue;
                return true;
            }
        }
        return false;
    }

    boolean setValorTextField(Map.Entry<String, String> re, JTextField jtf) {
        if (re.getValue() != null) {
            jtf.setText(re.getValue());
            return true;
        }
        return false;
    }
}

