/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.visao.action;

import br.gov.rs.tce.mci.beans.Tela;
import br.gov.rs.tce.mci.modelo.decisao.DecisaoNavegacaoTelas;
import br.gov.rs.tce.mci.modelo.decisao.NavegacaoTelasControle;
import br.gov.rs.tce.mci.visao.MciModelo;
import br.gov.rs.tce.mci.visao.MciWizardControle;
import br.gov.rs.tce.mci.visao.MciWizardForm;
import br.gov.rs.tce.mci.visao.MciWizardHelper;
import br.gov.rs.tce.mci.visao.MciWizardModelo;
import br.gov.rs.tce.mci.visao.action.MciAction;
import br.gov.rs.tce.mci.visao.action.MciActionFactory;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import oracle.adf.model.BindingContext;
import oracle.adf.model.binding.DCIteratorBinding;
import oracle.adf.model.generic.DCRowSetIteratorImpl;
import oracle.jbo.uicli.binding.JUFormBinding;
import oracle.jbo.uicli.controls.JUPanel;
import oracle.jbo.uicli.jui.JUPanelBinding;
import oracle.jbo.uicli.mom.JUMetaObjectManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MciAvancarAction
extends AbstractAction {
    private static Log log = LogFactory.getLog(MciAvancarAction.class);
    static MciWizardHelper helper = MciWizardHelper.getInstance();
    private static MciModelo nextPanel;
    private Tela proxTela;

    public MciAvancarAction(String text, String desc, Integer mnemonic) {
        super(text);
        this.putValue("ShortDescription", desc);
        this.putValue("MnemonicKey", mnemonic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        final MciWizardForm formPrincipal = helper.getForm();
        final MciWizardModelo modelo = helper.getForm().getPagina().getMciWizardModelo();
        final BindingContext bindingContext = helper.getForm().getBindingContext();
        final NavegacaoTelasControle navegacao = (NavegacaoTelasControle)bindingContext.findDataControl("NavegacaoDataControl");
        final Tela telaAtual = navegacao.getConfigTelaAtual();
        final MciModelo panelAtual = modelo.getTelaAtual();
        try {
            formPrincipal.defineCursor(3);
            this.desativaFormPrincipal(formPrincipal);
            boolean avancaTela = true;
            final MciAction actionAvancar = this.constroiActionAvancar(telaAtual);
            final MciWizardControle controle = helper.getForm().getPagina().getMciWizardControle();
            if (actionAvancar != null && actionAvancar.isCriaThreadTratamentoAcao()) {
                Thread thActionAvancar = new Thread(){

                    @Override
                    public void run() {
                        formPrincipal.defineCursor(3);
                        try {
                            controle.habilitaBotaoAvancar(false);
                            controle.habilitaBotaoVoltar(false);
                            if (actionAvancar.executaAction(panelAtual, bindingContext)) {
                                MciAvancarAction.this.avancarTela(telaAtual, navegacao, panelAtual, modelo);
                            } else {
                                MciAvancarAction.this.proxTela = DecisaoNavegacaoTelas.getInstancia().escolheProximaTela(telaAtual.getCodigo(), helper.getForm().getBindingContext());
                            }
                        }
                        catch (Exception e) {
                            MciAvancarAction.trataExcecao(e);
                        }
                        finally {
                            formPrincipal.defineCursor(0);
                            Tela telafinal = DecisaoNavegacaoTelas.getInstancia().getTelaFinal();
                            controle.habilitaBotaoVoltar(true);
                            controle.habilitaBotaoAvancar(true);
                            if (MciAvancarAction.this.proxTela.getCodigo().equals(telafinal.getCodigo())) {
                                controle.habilitaBotaoAvancar(false);
                            }
                        }
                    }
                };
                thActionAvancar.start();
            } else {
                boolean avancarProximaTela = true;
                if (actionAvancar != null) {
                    this.ativaFormPrincipal(formPrincipal);
                    avancarProximaTela = actionAvancar.executaAction(panelAtual, bindingContext);
                }
                if (avancarProximaTela) {
                    this.ativaFormPrincipal(formPrincipal);
                    this.avancarTela(telaAtual, navegacao, panelAtual, modelo);
                }
            }
        }
        catch (Exception ex) {
            MciAvancarAction.trataExcecao(ex);
        }
        finally {
            formPrincipal.defineCursor(0);
            this.ativaFormPrincipal(formPrincipal);
        }
    }

    private void desativaFormPrincipal(MciWizardForm formPrincipal) {
        formPrincipal.setFocusable(false);
        formPrincipal.setEnabled(false);
    }

    private void ativaFormPrincipal(MciWizardForm formPrincipal) {
        formPrincipal.setFocusable(true);
        formPrincipal.setEnabled(true);
    }

    private static void trataExcecao(Exception ex) {
        MciAvancarAction.trataExcecao(null, ex);
    }

    private static void trataExcecao(JUPanelBinding panelBind, Throwable ex) {
        ex.printStackTrace();
        log.error((Object)ex.getMessage(), ex);
        JUMetaObjectManager.reportException((JUFormBinding)panelBind, (Exception)((Exception)ex));
        if (ex.getCause() != null) {
            MciAvancarAction.trataExcecao(panelBind, ex.getCause());
        }
    }

    private MciAction constroiActionAvancar(Tela telaAtual) {
        String strTela = telaAtual.getActionAvancar();
        MciAction action = null;
        if (strTela != null && strTela.length() > 5) {
            action = MciActionFactory.getAction(strTela);
        }
        return action;
    }

    private void defineHabilitacaoBotaoAvancar(Tela proxTela) {
        Tela telafinal = DecisaoNavegacaoTelas.getInstancia().getTelaFinal();
        MciWizardControle controle = helper.getForm().getPagina().getMciWizardControle();
        if (telafinal.getCodigo().equalsIgnoreCase(proxTela.getCodigo())) {
            controle.habilitaBotaoAvancar(false);
            controle.habilitaBotaoVoltar(true);
            helper.getForm().getPagina().constroiComponente(true);
        } else {
            controle.habilitaBotaoVoltar(true);
            helper.getForm().getPagina().constroiComponente(false);
        }
    }

    public static void removeTelaDinamica(Tela tela, MciWizardModelo modelo) {
        if (tela != null && tela.isDinamica()) {
            modelo.removeTelaModelo(tela.getCodigo());
        }
    }

    public static void finalizaTela(MciModelo tela) {
        if (tela != null) {
            tela.finalizaTela();
        }
    }

    public static void exibeTela(MciWizardModelo modelo, Tela tela, BindingContext bindingContext) {
        nextPanel = modelo.getTelaModelo(tela);
        if (nextPanel == null) {
            nextPanel = MciWizardHelper.criaNovaTela(tela.getPanelClass(), bindingContext);
            modelo.adicionaTelaModelo(tela, nextPanel);
        }
        nextPanel.preparaTela();
        helper.exibeTela(tela, nextPanel);
    }

    private void atualizaADFBinding(NavegacaoTelasControle navegacao) {
        DCIteratorBinding b = navegacao.findBindingContainer("MciWizardCabecalhoUIModel").findIteratorBinding("telaAtualIterator");
        ((DCRowSetIteratorImpl)b.getRowSetIterator()).rebuildIteratorUpto(-1);
    }

    private void avancarTela(Tela telaAtual, NavegacaoTelasControle navegacao, MciModelo paneAtual, MciWizardModelo modelo) {
        try {
            BindingContext bindingContext = helper.getForm().getBindingContext();
            MciAvancarAction.finalizaTela(modelo.getTelaAtual());
            this.proxTela = navegacao.avancarTela(telaAtual.getCodigo(), bindingContext);
            this.defineHabilitacaoBotaoAvancar(this.proxTela);
            MciAvancarAction.removeTelaDinamica(telaAtual, modelo);
            if (log.isDebugEnabled()) {
                System.out.println("Exibindo tela: " + this.proxTela.getCodigo());
                log.debug((Object)("Exibindo tela: " + this.proxTela.getCodigo()));
            }
            MciAvancarAction.exibeTela(modelo, this.proxTela, bindingContext);
            this.atualizaADFBinding(navegacao);
        }
        catch (Exception ex) {
            if (!(paneAtual instanceof JUPanel)) {
                MciAvancarAction.trataExcecao(null, ex);
            }
            MciAvancarAction.trataExcecao(((JUPanel)paneAtual).getPanelBinding(), ex);
        }
    }
}

