/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.visao;

import br.gov.rs.tce.mci.util.DatabaseHelper;
import br.gov.rs.tce.mci.util.DatacontrolHelper;
import br.gov.rs.tce.mci.util.NavegacaoHelper;
import br.gov.rs.tce.mci.visao.MciErrorDialog;
import br.gov.rs.tce.mci.visao.MciWizardForm;
import br.gov.rs.tce.mci.visao.util.SplashScreen;
import java.awt.Font;
import java.awt.Toolkit;
import java.util.HashMap;
import javax.swing.UIManager;
import oracle.adf.model.BindingContext;
import oracle.adf.model.binding.DCErrorHandler;
import oracle.jbo.LocaleContext;
import oracle.jbo.common.DefLocaleContext;
import oracle.jbo.uicli.jui.JUEnvInfoProvider;
import oracle.jbo.uicli.mom.JUMetaObjectManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MciDesktop {
    private static Log log = LogFactory.getLog(MciDesktop.class);
    private BindingContext ctx;
    static final String versaoTeste = "" != null && !"".equals("") ? "".trim() : "";
    private static boolean _cargaBancoDados = false;

    public MciDesktop() {
        log.info((Object)("MCI " + MciDesktop.getVersaoTitulo()));
        this.initializeADFModel();
    }

    public static void main(String[] args) {
        try {
            NavegacaoHelper.init("DESKTOP");
            int screenRes = Toolkit.getDefaultToolkit().getScreenResolution();
            int fontSize = (int)Math.round(8.0 * (double)screenRes / 72.0);
            Font font = new Font("Microsoft Sans Serif", 0, fontSize);
            UIManager.put("Label.font", font);
            UIManager.put("Button.font", font);
            UIManager.put("CheckBox.font", font);
            UIManager.put("RadioButton.font", font);
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            log.error((Object)"Erro ao definir LookAndFeel", (Throwable)e);
        }
        new MciDesktop();
    }

    private void initializeADFModel() {
        final MciWizardForm mci = new MciWizardForm("MCI " + MciDesktop.getVersaoTitulo());
        String image = "/br/gov/rs/tce/mci/resource/imagens/splash_mci_2025.jpg";
        SplashScreen splashScreen = new SplashScreen(image, MciDesktop.getVersaoTitulo());
        splashScreen.splash();
        Thread thCarregaDatabindings = new Thread("Th-Carrega-Databindings.cpx"){

            @Override
            public void run() {
                try {
                    JUMetaObjectManager.setErrorHandler((DCErrorHandler)new MciErrorDialog(mci));
                    JUMetaObjectManager mgr = JUMetaObjectManager.getJUMom();
                    mgr.setJClientDefFactory(null);
                    MciDesktop.this.ctx = new BindingContext();
                    MciDesktop.this.ctx.put((Object)"_envInfo_Provider", (Object)new JUEnvInfoProvider());
                    MciDesktop.this.ctx.setLocaleContext((LocaleContext)new DefLocaleContext(null));
                    HashMap<String, BindingContext> map = new HashMap<String, BindingContext>(4);
                    map.put("_binding_Context", MciDesktop.this.ctx);
                    JUMetaObjectManager.loadCpx((String)"DataBindings.cpx", map);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Databindings carregados com sucesso.");
                    }
                }
                catch (Exception ex) {
                    MciDesktop.this.ctx = null;
                    ex.printStackTrace();
                    log.error((Object)ex.getMessage(), (Throwable)ex);
                    JUMetaObjectManager.reportException(null, (Exception)ex);
                    System.exit(1);
                }
            }
        };
        thCarregaDatabindings.start();
        try {
            thCarregaDatabindings.join();
            if (this.ctx != null) {
                mci.setBindingContext(this.ctx);
                try {
                    Thread thCargaBanco = this.carregaBancoDados(this.ctx);
                    thCargaBanco.join();
                    splashScreen.dispose();
                    mci.show();
                }
                catch (InterruptedException e) {
                    log.debug((Object)"InterruptedException", (Throwable)e);
                }
            } else {
                log.error((Object)"MciWizardForm n\u00e3o pode ser inicializado devido ao BindingContext ser nulo.");
            }
        }
        catch (InterruptedException e) {
            log.debug((Object)"InterruptedException", (Throwable)e);
        }
    }

    public static String getVersaoTitulo() {
        return "3.0.1.8" + versaoTeste;
    }

    private Thread carregaBancoDados(final BindingContext binding) {
        Thread thBanco = new Thread("Th-CargaDerby"){

            @Override
            public void run() {
                try {
                    DatacontrolHelper.getServicoMCIAppModule(binding);
                    log.debug((Object)"Banco de Dados Aberto OK");
                }
                catch (Exception e) {
                    log.error((Object)"Erro ao abrir banco de dados", (Throwable)e);
                    Exception exBanco = new Exception("N\u00e3o foi possivel abrir o Banco de Dados (" + e.getMessage() + ").", e);
                    JUMetaObjectManager.reportException(null, (Exception)exBanco);
                }
            }
        };
        thBanco.start();
        Thread thTrataFechamentoBanco = new Thread("finalizaDerby"){

            @Override
            public void run() {
                log.info((Object)"Executando thread para finalizar Derby...");
                DatabaseHelper.fechaDerbyDatabase();
            }
        };
        Runtime.getRuntime().addShutdownHook(thTrataFechamentoBanco);
        return thBanco;
    }

    public static boolean isCargaBancoDados() {
        return _cargaBancoDados;
    }
}

