/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.visao;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.TreeSet;

class CopiaDetalhesActionListener
implements ActionListener,
ClipboardOwner {
    String message;
    Exception ex;

    public CopiaDetalhesActionListener(String message, Exception ex) {
        this.message = message;
        this.ex = ex;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String versaoMCI = "versao-mci: 3.0.1.8\n";
        String mensagem = "mensagem: " + this.message + "\n\n";
        String systemProps = this.getSysProps();
        String networkInfo = "ip-address: " + this.getNetworkInfo() + "\n";
        String timeInfo = this.getTimeInfo();
        StringWriter stkWriter = new StringWriter();
        PrintWriter pw = new PrintWriter(stkWriter);
        this.putTrace(this.ex, pw);
        String bigMessage = versaoMCI + mensagem + CopiaDetalhesActionListener.permissoesEscrita() + systemProps + networkInfo + timeInfo + stkWriter.toString();
        StringSelection stringSelection = new StringSelection(bigMessage);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, this);
    }

    String getSysProps() {
        Properties p = System.getProperties();
        TreeSet<Object> ts = new TreeSet<Object>(p.keySet());
        Iterator<Object> it = ts.iterator();
        StringBuffer sb = new StringBuffer();
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = p.getProperty(key);
            sb.append(key + ": " + value + "\n");
        }
        return sb.toString();
    }

    static String permissoesEscrita() {
        String userDir;
        StringBuilder infoBuff = new StringBuilder();
        String dir = userDir = System.getProperty("user.dir");
        infoBuff.append("permissao-escrita [" + dir + "] = " + CopiaDetalhesActionListener.hasWritePermission(new File(dir)) + "\n");
        dir = userDir + File.separator + "remessa";
        infoBuff.append("permissao-escrita [" + dir + "] = " + CopiaDetalhesActionListener.hasWritePermission(new File(dir)) + "\n");
        dir = userDir + File.separator + "database";
        infoBuff.append("permissao-escrita [" + dir + "] = " + CopiaDetalhesActionListener.hasWritePermission(new File(dir)) + "\n");
        return infoBuff.toString();
    }

    String getNetworkInfo() {
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            return localhost.getHostAddress();
        }
        catch (UnknownHostException ure) {
            return ure.getMessage();
        }
    }

    String getTimeInfo() {
        Date now = new Date();
        return "t-id: " + now.getTime() + "\ndate: " + now + "\n";
    }

    void putTrace(Throwable t, PrintWriter pw) {
        pw.print("Throwable: " + t.getClass().getName() + "::\n");
        t.printStackTrace(pw);
        if (t.getCause() != null) {
            this.putTrace(t.getCause(), pw);
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    static boolean hasWritePermission(File dir) {
        try {
            File f = File.createTempFile("padtmp", "txt", dir);
            f.delete();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

