/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.util.test;

import br.gov.rs.tce.mci.util.EnviaArquivosHttp;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import junit.framework.Assert;
import junit.framework.TestCase;

public class EnviaArquivosHttpTest
extends TestCase {
    ServerSocket server;
    int SERVER_PORT = 15100;

    public EnviaArquivosHttpTest(String sTestName) {
        super(sTestName);
    }

    public void testenviaArquivos() {
        Thread th = this.criaServidor();
        try {
            EnviaArquivosHttp enviaHttp = new EnviaArquivosHttp(new URL("http://localhost:" + this.SERVER_PORT));
            enviaHttp.adicionaCampoComValor("titulo", "abc");
            enviaHttp.adicionaArquivo(EnviaArquivosHttp.criaIdentificadorArquivo("arquivo1", new File("test/teste.zip")));
        }
        catch (IOException e) {
            EnviaArquivosHttpTest.fail((String)e.getMessage());
        }
        try {
            th.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.fechaServidor();
    }

    private void fechaServidor() {
        try {
            this.server.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void testenviaArquivos1() {
    }

    public void testabreConexao() {
        try {
            HttpURLConnection httpURLConnection = EnviaArquivosHttp.abreConexaoHttp(new URL("http://localhost:" + this.SERVER_PORT));
        }
        catch (MalformedURLException e) {
            EnviaArquivosHttpTest.fail((String)e.getMessage());
        }
        catch (IOException e) {
            EnviaArquivosHttpTest.fail((String)e.getMessage());
        }
    }

    public void testiniciaEnvioHttp() throws Exception {
        try {
            DataOutputStream out = new DataOutputStream(new FileOutputStream("C:/http-test.zip"));
            EnviaArquivosHttp enviaHttp = new EnviaArquivosHttp(out);
            enviaHttp.adicionaCampoComValor("Campo1", "ValorCampo1");
            enviaHttp.adicionaArquivo(EnviaArquivosHttp.criaIdentificadorArquivo("arquivo1", new File("test/testeZip.zip")));
            enviaHttp.setDataOutputStream(out);
            enviaHttp.iniciaEnvioHttp();
        }
        catch (FileNotFoundException e) {
            EnviaArquivosHttpTest.fail((String)"N\u00e3o foi possivel criar arquivo de teste de saida");
        }
        catch (IOException e) {
            EnviaArquivosHttpTest.fail((String)("Ocorreu um erro no teste: " + e.getMessage()));
            e.printStackTrace();
        }
    }

    public void testanalisaResponse() {
    }

    public void testenviaInicioMultipartFormData() {
    }

    public void testenviaFinalMultipartFormData() {
    }

    public void testadicionaCampoFormulario() {
    }

    public void testadicinaArquivoBinario() {
    }

    public void testgeraBoudaryString() {
    }

    private Thread criaServidor() {
        boolean servidorCriado = false;
        Thread th = null;
        while (!servidorCriado) {
            try {
                this.server = new ServerSocket(this.SERVER_PORT);
                servidorCriado = true;
                System.out.println("Servidor aberto em: localhost:" + this.server.getLocalPort());
                th = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Socket sktCliente = EnviaArquivosHttpTest.this.server.accept();
                            new RecebeConexaoCliente(sktCliente);
                            EnviaArquivosHttpTest.this.server.close();
                        }
                        catch (Exception e) {
                            Assert.fail((String)("Erro ao tratar conexao do cliente. " + e.getMessage()));
                        }
                    }
                });
                th.start();
            }
            catch (IOException e) {
                ++this.SERVER_PORT;
            }
        }
        return th;
    }

    protected void setUp() throws Exception {
    }

    protected void tearDown() throws Exception {
    }

    class RecebeConexaoCliente {
        public RecebeConexaoCliente(Socket skt) throws IOException {
            DataInputStream is = new DataInputStream(skt.getInputStream());
            DataOutputStream os = new DataOutputStream(new FileOutputStream("C:/http-test.zip"));
            int numBytesToRead = 2048;
            int num = 2;
            while (num >= 0) {
                int availableBytesToRead = is.available();
                System.out.println("1");
                while ((availableBytesToRead = is.available()) > 0) {
                    System.out.println("2");
                    byte[] bufferBytesRead = availableBytesToRead >= numBytesToRead ? new byte[numBytesToRead] : new byte[availableBytesToRead];
                    int numberOfBytesRead = is.read(bufferBytesRead);
                    if (numberOfBytesRead == -1) break;
                    os.write(bufferBytesRead);
                    System.out.println(bufferBytesRead);
                }
                try {
                    Thread.sleep(1000L);
                    --num;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            os.flush();
            OutputStream sktOut = skt.getOutputStream();
            sktOut.write("HTTP/1.0 404 NOT FOUND\r\n\r\n".getBytes());
            sktOut.flush();
            System.out.println("Cliente desconectou: " + skt.getInetAddress());
        }
    }
}

