/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.util.test;

import br.gov.rs.tce.mci.util.CompactacaoHelper;
import java.io.File;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import junit.framework.Assert;
import junit.framework.TestCase;

public class CompactacaoHelperTest
extends TestCase {
    public CompactacaoHelperTest(String sTestName) {
        super(sTestName);
    }

    public void testCompacta() throws Exception {
        File[] files = new File[]{new File("test/teste.txt"), new File("test/teste1.txt")};
        File destino = new File("test/testeZip.zip");
        CompactacaoHelper ch = new CompactacaoHelper();
        ch.compacta(files, destino);
        Assert.assertTrue((boolean)new File("test/testeZip.zip").exists());
        Assert.assertEquals((long)28719L, (long)new File("test/testeZip.zip").length());
    }

    public void testDescompacta() throws Exception {
        File origem = new File("test/testeZip.zip");
        File destino = new File("test/");
        CompactacaoHelper ch = new CompactacaoHelper();
        ch.descompacta(origem, destino);
        ZipFile zipFile = new ZipFile(origem, 1);
        Enumeration<? extends ZipEntry> zipFileEntries = zipFile.entries();
        ZipEntry entry = zipFileEntries.nextElement();
        Assert.assertEquals((String)"C:\\Projetos\\XDE Workspace\\Siapc-PAD-Modelo\\test\\teste.txt", (String)entry.getName());
        entry = zipFileEntries.nextElement();
        Assert.assertEquals((String)"C:\\Projetos\\XDE Workspace\\Siapc-PAD-Modelo\\test\\teste1.txt", (String)entry.getName());
    }

    public void testDivideArquivo() throws Exception {
        File origem = new File("test/testeZip.zip");
        CompactacaoHelper ch = new CompactacaoHelper();
        try {
            ch.divideArquivo(origem, 10000L);
            Assert.assertTrue((boolean)true);
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertTrue((boolean)new File("test/testeZip.p01").exists());
        Assert.assertTrue((boolean)new File("test/testeZip.p02").exists());
        Assert.assertTrue((boolean)new File("test/testeZip.p03").exists());
    }

    public void testMontaArquivo() throws Exception {
        CompactacaoHelper ch = new CompactacaoHelper();
        try {
            File[] file = new File[]{new File("test/testeZip.p02"), new File("test/testeZip.p01"), new File("test/testeZip.p03")};
            ch.montaArquivo(file, "zip");
        }
        catch (Exception e) {
            Assert.fail();
        }
        Assert.assertTrue((boolean)new File("test/testeZip.zip").exists());
        Assert.assertEquals((long)28719L, (long)new File("test/testeZip.zip").length());
    }

    public void testBuscaArquivos() {
        CompactacaoHelper ch = new CompactacaoHelper();
        File[] files = CompactacaoHelper.buscaArquivos(new File("test/"));
        Assert.assertNotNull((String)"O array n\u00e3o pode ser nulo", (Object)files);
    }
}

