/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.util;

import br.gov.rs.tce.mci.beans.remessa.Remessa;
import br.gov.rs.tce.mci.beans.types.TipoPeriodoList;
import br.gov.rs.tce.mci.beans.types.TipoPoderList;
import br.gov.rs.tce.mci.util.RemessaUtil;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public final class ResolveStringConstantes {
    private static final String[] ARRAY_NOMES_CONTANTES = new String[]{"ANO_EXERCICIO_REMESSA", "ANO_EXERCICIO_ANTERIOR_REMESSA", "PERIODO_EXTENSO", "PERIODO_EXTENSO_ANTERIOR", "TIPO_SETOR_GOV"};
    private static final String ANO_EXERCICIO_REMESSA = ARRAY_NOMES_CONTANTES[0];
    private static final String ANO_EXERCICIO_ANTERIOR_REMESSA = ARRAY_NOMES_CONTANTES[1];
    private static final String PERIODO_EXTENSO = ARRAY_NOMES_CONTANTES[2];
    private static final String PERIODO_EXTENSO_ANTERIOR = ARRAY_NOMES_CONTANTES[3];
    private static final String TIPO_SETOR_GOV = ARRAY_NOMES_CONTANTES[4];
    static NumberFormat nfInteger;
    static DateFormat nfData;
    static DateFormat nfMesExtenso;

    private ResolveStringConstantes() {
    }

    public static Object getValorString(String nomeConstante, Remessa remessa) {
        Object valor = null;
        StringBuilder palavra = new StringBuilder();
        int tamanho = nomeConstante.length() - 1;
        if (remessa != null) {
            if (nomeConstante.equals(ANO_EXERCICIO_REMESSA)) {
                valor = remessa.getAnoExercicio();
            } else if (nomeConstante.equals(ANO_EXERCICIO_ANTERIOR_REMESSA)) {
                valor = remessa.getAnoExercicio() - 1;
            } else if (nomeConstante.equals(PERIODO_EXTENSO)) {
                valor = TipoPeriodoList.valueOf(Integer.toString(remessa.getPeriodoInformacoes())).toString();
            } else if (nomeConstante.equals(PERIODO_EXTENSO_ANTERIOR)) {
                palavra.append(TipoPeriodoList.valueOf(Integer.toString(RemessaUtil.getPeriodoAnterior(remessa)).toString()));
                palavra.append(RemessaUtil.getPeriodoAnterior(remessa) == Integer.parseInt("3") ? " do exerc\u00edcio anterior " : " do exerc\u00edcio atual ");
                valor = palavra.toString().toLowerCase();
            } else if (nomeConstante.equals(TIPO_SETOR_GOV)) {
                valor = TipoPoderList.valueOf(remessa.getTipoSetor()).toString();
            }
        } else {
            throw new IllegalStateException("Verifique o algoritmo que chamou este m\u00e9todo, o valor da remessa do arquivo nao est\u00e1 disponivel (null).");
        }
        return valor;
    }

    public static String formataStringComConstantes(String texto, Remessa remessa) {
        if (texto != null) {
            StringBuffer textoBuffer = new StringBuffer(texto);
            Object[] valores = ResolveStringConstantes.extraiNomesContantes(textoBuffer, remessa);
            Locale loc = new Locale("pt", "BR");
            MessageFormat formato = new MessageFormat(textoBuffer.toString(), loc);
            for (int i = 0; i < valores.length; ++i) {
                if (valores[i] instanceof Integer) {
                    formato.setFormatByArgumentIndex(i, nfInteger);
                    continue;
                }
                if (!(valores[i] instanceof Date)) continue;
                formato.setFormatByArgumentIndex(i, nfData);
            }
            StringBuffer textoFormatado = new StringBuffer(textoBuffer.length());
            formato.format(valores, textoFormatado, (FieldPosition)null);
            return textoFormatado.toString();
        }
        return null;
    }

    public static String resolveConstantesTexto(String texto, Remessa remessa) {
        return ResolveStringConstantes.resolveConstantesTexto(texto, remessa, '{', '}');
    }

    public static String resolveConstantesTexto(String texto, Remessa remessa, char tokenAbertura, char tokenFechamento) {
        if (texto != null) {
            StringBuilder textoBuilder = new StringBuilder(texto);
            int inicio = 0;
            int fim = 0;
            while (textoBuilder.indexOf(String.valueOf(tokenAbertura)) >= 0) {
                int tamanho = textoBuilder.length();
                inicio = textoBuilder.indexOf(String.valueOf(tokenAbertura));
                fim = textoBuilder.indexOf(String.valueOf(tokenFechamento));
                String constante = textoBuilder.substring(inicio + 1, fim);
                String constanteValor = ResolveStringConstantes.getValorString(constante, remessa).toString();
                textoBuilder.replace(inicio, fim + 1, constanteValor);
            }
            return textoBuilder.toString();
        }
        return null;
    }

    private static Object[] extraiNomesContantes(StringBuffer texto, Remessa remessa) {
        return ResolveStringConstantes.extraiNomesContantes(texto, remessa, '{', '}');
    }

    private static Object[] extraiNomesContantes(StringBuffer texto, Remessa remessa, char tokenAbertura, char tokenFechamento) {
        int numConstantes = 0;
        for (int i = 0; i < texto.length(); ++i) {
            if (texto.charAt(i) != tokenAbertura) continue;
            ++numConstantes;
        }
        Object[] constantes = new Object[numConstantes];
        int inicio = 0;
        int fim = 0;
        int idxConstante = 0;
        int tamanho = texto.length();
        for (int i = 0; i < tamanho; ++i) {
            if (texto.charAt(i) == tokenAbertura) {
                inicio = i + 1;
                continue;
            }
            if (texto.charAt(i) != tokenFechamento) continue;
            fim = i;
            String constante = texto.substring(inicio, fim);
            constantes[idxConstante] = ResolveStringConstantes.getValorString(constante, remessa);
            texto.delete(inicio, fim);
            String txtIdxConstante = String.valueOf(idxConstante);
            texto.insert(inicio, txtIdxConstante);
            ++idxConstante;
            i -= fim - inicio;
            i += txtIdxConstante.length();
            tamanho -= fim - inicio;
            tamanho += txtIdxConstante.length();
        }
        return constantes;
    }

    static {
        nfMesExtenso = new SimpleDateFormat("MMMMM", new Locale("pt", "BR"));
        nfInteger = NumberFormat.getIntegerInstance(new Locale("pt", "BR"));
        nfInteger.setGroupingUsed(false);
        nfData = new SimpleDateFormat("dd/MM/yyyy", new Locale("pt", "BR"));
        nfMesExtenso = new SimpleDateFormat("MMMMM", new Locale("pt", "BR"));
    }
}

