/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.util;

import br.gov.rs.tce.mci.beans.Mensagem;
import br.gov.rs.tce.mci.beans.Mensagens;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.xml.Marshaller;
import org.xml.sax.InputSource;

public class MensagensXMLGenerator {
    private static final String MAPPING_CONF = "mapping-mensagens.xml";
    Mensagens mensagens;
    Set unicos = new HashSet(200);
    static boolean verbose = false;

    public MensagensXMLGenerator(String origemCsv, String destinoXml) throws Exception {
        this.mensagens = new Mensagens();
        this.leArquivoCSV(new File(origemCsv));
        File xml = new File(destinoXml);
        this.gravaXML(xml);
        System.out.println("Foram lidas " + this.mensagens.getMensagemCount() + " mensagens.\nXML gerado: " + xml.getAbsolutePath());
    }

    private void gravaXML(File arquivo) throws Exception {
        Mapping mapping = new Mapping();
        InputSource source = new InputSource(this.getClass().getClassLoader().getResourceAsStream(MAPPING_CONF));
        mapping.loadMapping(source);
        Marshaller mar = new Marshaller((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(arquivo), "UTF-8"));
        mar.setMarshalExtendedType(false);
        mar.marshal((Object)this.mensagens);
    }

    private void leArquivoCSV(File arquivo) throws IOException {
        LineNumberReader reader = new LineNumberReader(new InputStreamReader((InputStream)new FileInputStream(arquivo), "ISO-8859-1"));
        String linha = null;
        int i = 0;
        ArrayList<Mensagem> lista = new ArrayList<Mensagem>(600);
        while ((linha = reader.readLine()) != null) {
            if (linha.startsWith("//") || linha.startsWith(";;") || linha.trim().length() == 0) continue;
            Mensagem msg = new Mensagem();
            String[] valores = linha.split(";");
            msg.setCodigo(valores[0].trim());
            msg.setTexto(valores[1].trim());
            msg.setTipo(valores[2].trim());
            if (verbose) {
                System.out.println("Linha: " + ++i + " - " + msg.getTexto());
            }
            lista.add(msg);
        }
        Collections.sort(lista, new Comparator(){

            public int compare(Object o1, Object o2) {
                Mensagem m1 = (Mensagem)o1;
                Mensagem m2 = (Mensagem)o2;
                return Collator.getInstance().compare(m1.getTexto(), m2.getTexto());
            }
        });
        for (int j = 0; j < lista.size(); ++j) {
            Mensagem m = (Mensagem)lista.get(j);
            this.mensagens.addMensagem(m);
            this.unicos.add(m.getTexto());
        }
    }

    public static void main(String[] args) {
        if (args == null || args.length != 2) {
            System.out.println("Uso: MensagensXMLGenerator <origem-csv> <destino-xml>");
        }
        if (args.length == 3) {
            verbose = Boolean.valueOf(args[2]);
        }
        verbose = true;
        try {
            new MensagensXMLGenerator("test/mensagens_validacao.csv", "test/mensagens_validacao.xml");
        }
        catch (Exception e) {
            System.err.println("Ocorreu um erro na gera\u00e7\u00e3o: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

