/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.util;

import br.gov.rs.tce.mci.beans.remessa.RemessaInfo;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.zip.CRC32;

public class CodigoBarrasHelper {
    public static final int RELATORIO_MCI_EXECUTIVO = 4;
    public static final int RELATORIO_MCI_LEGISLATIVO = 5;
    static NumberFormat formatter = new DecimalFormat("0000000000");

    private CodigoBarrasHelper() {
    }

    public static String constroiCodigoBarra(RemessaInfo remessa, int tipoRelatorio) {
        CRC32 gerador = new CRC32();
        Integer exercicio = remessa.getAnoExercicio();
        byte[] digest = remessa.getDigestRemessaArray();
        int periodo = remessa.getCodPeriodo();
        String grupoEntrega = remessa.getGrupoEntrega();
        switch (tipoRelatorio) {
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Tipo de relat\u00f3rio n\u00e3o \u00e9 v\u00e1lido, use as constantes definidas na classe.");
            }
        }
        if (exercicio == null) {
            throw new IllegalArgumentException("AnoExercicio n\u00e3o pode ser nulo.");
        }
        if (digest == null) {
            throw new IllegalArgumentException("Digest da remessa n\u00e3o pode ser nulo.");
        }
        if (grupoEntrega == null) {
            throw new IllegalArgumentException("Grupo de Entrega n\u00e3o pode ser nulo.");
        }
        int grupoEntregaInt = Integer.parseInt(grupoEntrega);
        gerador.update(digest);
        String crc32 = formatter.format(gerador.getValue());
        String anoExecicio = exercicio.toString().substring(2);
        StringBuffer codigoBarras = new StringBuffer(17);
        codigoBarras.append(periodo).append(anoExecicio).append(String.format("%02d", tipoRelatorio)).append(String.format("%02d", grupoEntregaInt)).append(crc32);
        return codigoBarras.toString();
    }
}

