/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.modelo.seguranca;

import br.gov.rs.tce.mci.excecao.ConfiguracaoException;
import br.gov.rs.tce.mci.excecao.SegurancaException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class CriptografiaControle {
    static final byte[] salt = new byte[]{-57, 115, 33, -116, 126, -56, -18, -103};
    static final int count = 20;
    static final PBEParameterSpec pbeParamSpec = new PBEParameterSpec(salt, 20);
    static SecretKeyFactory keyFacArquivos = null;
    static SecretKeyFactory keyFacTexto = null;
    static final String PBE_MD5_DES = "PBEWithMD5AndDES";
    static final String BLOWFISH = "Blowfish";
    public static final String SENHA = "P@D.WEB?D&SKTOP;";

    private CriptografiaControle() {
    }

    public static void criptografa(File arquivoOrigem, File arquivoDestino, String senha) throws SegurancaException, FileNotFoundException {
        FileInputStream fis = new FileInputStream(arquivoOrigem);
        FileOutputStream fos = new FileOutputStream(arquivoDestino);
        try {
            PBEKeySpec keySpec = new PBEKeySpec(senha.toCharArray());
            SecretKey pbeKey = keyFacArquivos.generateSecret(keySpec);
            Cipher pbeCipher = Cipher.getInstance(PBE_MD5_DES);
            pbeCipher.init(1, (Key)pbeKey, pbeParamSpec);
            CipherInputStream cis = new CipherInputStream(fis, pbeCipher);
            byte[] b = new byte[8];
            int i = cis.read(b);
            while (i != -1) {
                fos.write(b, 0, i);
                i = cis.read(b);
            }
        }
        catch (Exception e) {
            throw new SegurancaException(e);
        }
        finally {
            try {
                fis.close();
                fos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void descriptografa(File arquivoOrigem, File arquivoDestino, String senha) throws SegurancaException, FileNotFoundException {
        FileInputStream fis = new FileInputStream(arquivoOrigem);
        FileOutputStream fos = new FileOutputStream(arquivoDestino);
        try {
            PBEKeySpec keySpec = new PBEKeySpec(senha.toCharArray());
            SecretKey pbeKey = keyFacArquivos.generateSecret(keySpec);
            Cipher pbeCipher = Cipher.getInstance(PBE_MD5_DES);
            pbeCipher.init(2, (Key)pbeKey, pbeParamSpec);
            CipherInputStream cis = new CipherInputStream(fis, pbeCipher);
            byte[] b = new byte[8];
            int i = cis.read(b);
            while (i != -1) {
                fos.write(b, 0, i);
                i = cis.read(b);
            }
        }
        catch (Exception e) {
            throw new SegurancaException(e);
        }
    }

    public static byte[] criptografaTexto(String texto, String senha) throws SegurancaException {
        byte[] textoCriptografado = null;
        try {
            SecretKeySpec pbeKey = new SecretKeySpec(senha.getBytes(), BLOWFISH);
            Cipher pbeCipher = Cipher.getInstance(BLOWFISH);
            pbeCipher.init(1, pbeKey);
            textoCriptografado = pbeCipher.doFinal(texto.getBytes());
        }
        catch (Exception e) {
            throw new SegurancaException(e);
        }
        return textoCriptografado;
    }

    public static String descriptografaTexto(byte[] texto, String senha) throws SegurancaException {
        String textoCriptografado = null;
        try {
            SecretKeySpec pbeKey = new SecretKeySpec(senha.getBytes(), BLOWFISH);
            Cipher pbeCipher = Cipher.getInstance(BLOWFISH);
            pbeCipher.init(2, pbeKey);
            textoCriptografado = new String(pbeCipher.doFinal(texto));
        }
        catch (Exception e) {
            throw new SegurancaException(e);
        }
        return textoCriptografado;
    }

    static {
        try {
            keyFacArquivos = SecretKeyFactory.getInstance(PBE_MD5_DES);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ConfiguracaoException(e.getMessage());
        }
    }
}

