/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.modelo.seguranca;

import br.gov.rs.tce.mci.excecao.MCIRuntimeException;
import br.gov.rs.tce.mci.excecao.SegurancaException;
import br.gov.rs.tce.mci.util.Base64Utils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class AssinaturaDigitalControle {
    public static final String CERTIFICADO_PROVISORIO_REMESSA = "remessa" + File.separator + "tcenet-bdl.200.0A7D.pfx";
    private static final String PKCS12_KEYSTORE_TYPE = "PKCS12";
    private static final String X509_CERTIFICATE_TYPE = "X.509";
    private static final String CODIFICACAO_CADEIA_CERTIFICACAO = "PkiPath";
    private static final String ALGORITMO_ASSINATURA_DIGITAL = "SHA1withRSA";
    public static final String ALGORITMO_DIGEST_PADRAO = "SHA1";
    private static final String[] ALGORITMO_CRIPTOGRAFIA_ASSIMETRICA = new String[]{"RSA", "BC"};

    private static KeyStore loadKeyStoreFromPFXFile(File aFileName, String aKeyStorePassword) throws GeneralSecurityException, IOException {
        FileInputStream keyStoreStream = null;
        if (aFileName == null) {
            aFileName = new File(CERTIFICADO_PROVISORIO_REMESSA);
        }
        keyStoreStream = new FileInputStream(aFileName);
        KeyStore keyStore = KeyStore.getInstance(PKCS12_KEYSTORE_TYPE);
        char[] password = aKeyStorePassword.toCharArray();
        keyStore.load(keyStoreStream, password);
        return keyStore;
    }

    private static PrivateKeyAndCertificationChain getPrivateKeyAndCertChain(KeyStore aKeyStore, String aKeyPassword) throws GeneralSecurityException {
        char[] password = aKeyPassword.toCharArray();
        Enumeration<String> aliasesEnum = aKeyStore.aliases();
        if (aliasesEnum.hasMoreElements()) {
            String alias = aliasesEnum.nextElement();
            Certificate[] certificationChain = aKeyStore.getCertificateChain(alias);
            PrivateKey privateKey = (PrivateKey)aKeyStore.getKey(alias, password);
            PrivateKeyAndCertificationChain result = new PrivateKeyAndCertificationChain();
            result.mPrivateKey = privateKey;
            result.mCertificationChain = certificationChain;
            return result;
        }
        return null;
    }

    private static String encodeX509CertChainToBase64(Certificate[] aCertificationChain) throws CertificateException {
        List<Certificate> certList = Arrays.asList(aCertificationChain);
        CertificateFactory certFactory = CertificateFactory.getInstance(X509_CERTIFICATE_TYPE);
        CertPath certPath = certFactory.generateCertPath(certList);
        byte[] certPathEncoded = certPath.getEncoded(CODIFICACAO_CADEIA_CERTIFICACAO);
        String base64encodedCertChain = Base64Utils.base64Encode(certPathEncoded);
        return base64encodedCertChain;
    }

    private static CertPath decodeX509CertChainFromBase64(String aCertificationChainBase64) throws CertificateException {
        byte[] certPathData = Base64Utils.base64Decode(aCertificationChainBase64);
        ByteArrayInputStream certIs = new ByteArrayInputStream(certPathData);
        CertificateFactory certFactory = CertificateFactory.getInstance(X509_CERTIFICATE_TYPE);
        CertPath certPath = certFactory.generateCertPath(certIs);
        return certPath;
    }

    public static CertificationChainAndSignature assinaDigitalmenteArquivo(byte[] digestDados, File keyStoreFile, String keyStorePassword) {
        CertificationChainAndSignatureBase64Encoded result = new CertificationChainAndSignatureBase64Encoded();
        try {
            KeyStore keyStore = AssinaturaDigitalControle.loadKeyStoreFromPFXFile(keyStoreFile, keyStorePassword);
            PrivateKeyAndCertificationChain prvKeyChain = AssinaturaDigitalControle.getPrivateKeyAndCertChain(keyStore, keyStorePassword);
            byte[] signature = AssinaturaDigitalControle.criptAssymetric(digestDados, prvKeyChain.mPrivateKey);
            result.mSignature = Base64Utils.base64Encode(signature);
            result.mCertificationChain = AssinaturaDigitalControle.encodeX509CertChainToBase64(prvKeyChain.mCertificationChain);
        }
        catch (IOException e) {
            throw new SegurancaException(e);
        }
        catch (GeneralSecurityException e) {
            throw new SegurancaException(e);
        }
        return result;
    }

    public static synchronized CertificationChainAndSignature assinaDigitalmenteArquivo(File arquivo, File keyStoreFile, String keyStorePassword) {
        CertificationChainAndSignatureBase64Encoded result = new CertificationChainAndSignatureBase64Encoded();
        try {
            KeyStore keyStore = AssinaturaDigitalControle.loadKeyStoreFromPFXFile(keyStoreFile, keyStorePassword);
            PrivateKeyAndCertificationChain prvKeyChain = AssinaturaDigitalControle.getPrivateKeyAndCertChain(keyStore, keyStorePassword);
            byte[] signature = AssinaturaDigitalControle.assinaDigitalmente(arquivo, prvKeyChain.mPrivateKey);
            result.mSignature = Base64Utils.base64Encode(signature);
            result.mCertificationChain = AssinaturaDigitalControle.encodeX509CertChainToBase64(prvKeyChain.mCertificationChain);
        }
        catch (IOException e) {
            throw new SegurancaException(e);
        }
        catch (GeneralSecurityException e) {
            throw new SegurancaException(e);
        }
        return result;
    }

    private static byte[] assinaDigitalmente(File arquivo, PrivateKey key) {
        byte[] signature = new byte[]{};
        try {
            Signature sign = Signature.getInstance(ALGORITMO_ASSINATURA_DIGITAL);
            sign.initSign(key);
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(arquivo));
            byte[] data = new byte[2048];
            int read = 0;
            while ((read = ((InputStream)fis).read(data)) > 0) {
                sign.update(data, 0, read);
            }
            signature = sign.sign();
        }
        catch (SignatureException se) {
            throw new SegurancaException(se);
        }
        catch (InvalidKeyException ike) {
            throw new SegurancaException(ike);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new SegurancaException(nsae);
        }
        catch (IOException ioe) {
            throw new SegurancaException(ioe);
        }
        return signature;
    }

    public static boolean validaAssinaturaDigital(File arquivo, String encodedCertPath, byte[] signature) {
        CertPath certPath = null;
        try {
            certPath = AssinaturaDigitalControle.decodeX509CertChainFromBase64(encodedCertPath);
        }
        catch (CertificateException e) {
            throw new SegurancaException(e);
        }
        return AssinaturaDigitalControle.validaAssinaturaDigital(arquivo, certPath, signature);
    }

    public static boolean validaAssinaturaDigital(File arquivo, CertPath certPath, byte[] signature) {
        int ultimoCert = 0;
        Certificate clientCert = certPath.getCertificates().get(ultimoCert);
        return AssinaturaDigitalControle.validaAssinaturaDigital(arquivo, clientCert.getPublicKey(), signature);
    }

    public static boolean validaAssinaturaDigital(File arquivo, PublicKey key, byte[] signature) {
        boolean isValid = false;
        try {
            Signature sign = Signature.getInstance(ALGORITMO_ASSINATURA_DIGITAL);
            sign.initVerify(key);
            BufferedInputStream fis = new BufferedInputStream(new FileInputStream(arquivo));
            byte[] data = new byte[2048];
            int read = 0;
            while ((read = ((InputStream)fis).read(data)) != -1) {
                sign.update(data, 0, read);
            }
            isValid = sign.verify(signature);
        }
        catch (SignatureException se) {
            throw new SegurancaException(se);
        }
        catch (InvalidKeyException ike) {
            throw new SegurancaException(ike);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new SegurancaException(nsae);
        }
        catch (IOException ioe) {
            throw new SegurancaException(ioe);
        }
        return isValid;
    }

    public static byte[] descriptAssymetric(byte[] inputData, Key key) throws Exception {
        Cipher cipher = Cipher.getInstance(ALGORITMO_CRIPTOGRAFIA_ASSIMETRICA[0], ALGORITMO_CRIPTOGRAFIA_ASSIMETRICA[1]);
        return AssinaturaDigitalControle.descriptAssymetric(cipher, inputData, key);
    }

    public static byte[] descriptAssymetric(Cipher cipher, byte[] inputData, Key key) throws Exception {
        cipher.init(2, key);
        return cipher.doFinal(inputData);
    }

    public static byte[] criptAssymetric(byte[] inputData, Key key) throws SegurancaException {
        byte[] criptData = new byte[]{};
        try {
            Cipher cipher = Cipher.getInstance(ALGORITMO_CRIPTOGRAFIA_ASSIMETRICA[0], ALGORITMO_CRIPTOGRAFIA_ASSIMETRICA[1]);
            criptData = AssinaturaDigitalControle.criptAssymetric(cipher, inputData, key);
        }
        catch (NoSuchProviderException e) {
            throw new SegurancaException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new SegurancaException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SegurancaException(e);
        }
        return criptData;
    }

    public static byte[] criptAssymetric(Cipher cipher, byte[] inputData, Key key) throws SegurancaException {
        byte[] encripted = new byte[]{};
        try {
            cipher.init(1, key);
            encripted = cipher.doFinal(inputData);
        }
        catch (InvalidKeyException e) {
            throw new SegurancaException(e);
        }
        catch (BadPaddingException e) {
            throw new SegurancaException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new SegurancaException(e);
        }
        return encripted;
    }

    public static byte[] calculaDigest(File file) {
        return AssinaturaDigitalControle.calculaDigest(file, ALGORITMO_DIGEST_PADRAO);
    }

    public static byte[] calculaDigest(File file, String algoritmo) {
        MessageDigest digester = AssinaturaDigitalControle.createDigest(algoritmo);
        return AssinaturaDigitalControle.calculaDigest(file, digester);
    }

    public static byte[] calculaDigest(byte[] dados, String algoritmoDigest) {
        return AssinaturaDigitalControle.calculaDigest(dados, AssinaturaDigitalControle.createDigest(algoritmoDigest));
    }

    public static byte[] calculaDigest(byte[] dados) {
        return AssinaturaDigitalControle.calculaDigest(dados, AssinaturaDigitalControle.createDigest());
    }

    public static byte[] calculaDigest(byte[] dados, MessageDigest digester) {
        if (digester == null) {
            throw new IllegalArgumentException("Digester n\u00e3o pode ser nulo");
        }
        return digester.digest(dados);
    }

    public static byte[] calculaDigest(File file, MessageDigest digester) {
        if (digester == null) {
            throw new IllegalArgumentException("Digester n\u00e3o pode ser nulo");
        }
        InputStream fis = null;
        try {
            fis = new BufferedInputStream(new DigestInputStream(new FileInputStream(file), digester));
            byte[] data = new byte[2048];
            int read = 0;
            while ((read = fis.read(data)) != -1) {
            }
        }
        catch (IOException e) {
            throw new MCIRuntimeException(e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        byte[] digest = digester.digest();
        return digest;
    }

    public static MessageDigest createDigest() {
        return AssinaturaDigitalControle.createDigest(ALGORITMO_DIGEST_PADRAO);
    }

    public static MessageDigest createDigest(String algoritmo) {
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance(algoritmo);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SegurancaException(e);
        }
        return digest;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public static interface CertificationChainAndSignature {
        public String getCertificationChain();

        public String getSignature();
    }

    private static class CertificationChainAndSignatureBase64Encoded
    implements CertificationChainAndSignature {
        private String mCertificationChain = null;
        private String mSignature = null;

        private CertificationChainAndSignatureBase64Encoded() {
        }

        @Override
        public String getCertificationChain() {
            return this.mCertificationChain;
        }

        @Override
        public String getSignature() {
            return this.mSignature;
        }
    }

    static class PrivateKeyAndCertificationChain {
        public PrivateKey mPrivateKey;
        public Certificate[] mCertificationChain;

        PrivateKeyAndCertificationChain() {
        }
    }
}

