/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.modelo.relatorio;

import br.gov.rs.tce.command.CommandRunner;
import br.gov.rs.tce.mci.beans.ConsultasExtracaoList;
import br.gov.rs.tce.mci.beans.TipoBancoDados;
import br.gov.rs.tce.mci.beans.remessa.Remessa;
import br.gov.rs.tce.mci.excecao.RelatorioControleException;
import br.gov.rs.tce.mci.modelo.ConfiguracaoControle;
import br.gov.rs.tce.mci.modelo.exportacao.ExportacaoDados;
import br.gov.rs.tce.mci.modelo.relatorio.ClassloaderURIResolver;
import br.gov.rs.tce.mci.modelo.servico.common.ServicoMCI;
import br.gov.rs.tce.mci.util.DatabaseHelper;
import br.gov.rs.tce.mci.util.IndicadorProgresso;
import java.awt.Desktop;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import oracle.jbo.ApplicationModule;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.Driver;

public final class RelatorioControle
implements IndicadorProgresso {
    static Log log = LogFactory.getLog(RelatorioControle.class);
    private ChangeListener _listenerEventos;
    private int _progresso;
    private String _situacao;

    public RelatorioControle() {
    }

    public RelatorioControle(ChangeListener listener) {
        this._listenerEventos = listener;
    }

    private void constroiRelatorio(File arquivoSaidaPDF, String arquivoXML, String arquivoXSL, boolean isUTF8) throws RelatorioControleException {
        FileOutputStream outfile = null;
        InputStreamReader isXSL = null;
        InputStreamReader isXML = null;
        String formatEncoding = "";
        formatEncoding = isUTF8 ? "UTF-8" : "ISO-8859-1";
        try {
            this.setSituacao("Gerando arquivo PDF: " + arquivoSaidaPDF.getName());
            outfile = new FileOutputStream(arquivoSaidaPDF);
            Driver driver = new Driver();
            driver.setOutputStream((OutputStream)outfile);
            driver.setRenderer(1);
            System.setProperty("javax.xml.transform.TransformerFactory", "org.apache.xalan.processor.TransformerFactoryImpl");
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setURIResolver(new ClassloaderURIResolver());
            isXSL = new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(arquivoXSL), formatEncoding);
            if (isXSL == null) {
                throw new RelatorioControleException("Arquivo XSL do relat\u00f3rio n\u00e3o foi encontrado.", arquivoXSL);
            }
            StreamSource source = new StreamSource(isXSL);
            Transformer transformer = factory.newTransformer(source);
            isXML = new InputStreamReader((InputStream)new FileInputStream(new File(arquivoXML)), formatEncoding);
            if (isXML == null) {
                throw new RelatorioControleException("Arquivo XML do relat\u00f3rio n\u00e3o foi encontrado.", arquivoXML);
            }
            transformer.transform(new StreamSource(isXML), new SAXResult(driver.getContentHandler()));
        }
        catch (Exception e) {
            try {
                throw new RelatorioControleException("Ocorre um erro durante a gera\u00e7\u00e3o do relat\u00f3rio [" + e.getMessage() + "]", arquivoSaidaPDF.getName(), e);
            }
            catch (Throwable throwable) {
                RelatorioControle.fechaArquivo(isXML);
                RelatorioControle.fechaArquivo(isXSL);
                RelatorioControle.fechaArquivo(outfile);
                throw throwable;
            }
        }
        RelatorioControle.fechaArquivo(isXML);
        RelatorioControle.fechaArquivo(isXSL);
        RelatorioControle.fechaArquivo(outfile);
    }

    private static void fechaArquivo(OutputStream outfile) {
        try {
            if (outfile != null) {
                outfile.close();
            }
        }
        catch (Exception e) {
            log.error((Object)new RelatorioControleException("Erro ao fechar o arquivo.", e.getMessage(), e));
        }
    }

    private static void fechaArquivo(Reader reader) {
        try {
            if (reader != null) {
                reader.close();
            }
        }
        catch (Exception e) {
            log.error((Object)new RelatorioControleException("Erro ao fechar o arquivo.", e.getMessage(), e));
        }
    }

    public void geraRelatorios(Remessa remessa, ApplicationModule app, File diretorioDestino) {
        this.geraRelatorios(remessa, app, null, diretorioDestino, true, true);
    }

    public void geraRelatorios(Remessa remessa, ApplicationModule app, ChangeListener listenerGeracaoXML, File diretorioDestino, boolean geraXML, boolean geraPDF) {
        ConsultasExtracaoList consultasMCI = (ConsultasExtracaoList)ConfiguracaoControle.carregaDadosArquivoXML("extracao", new File("consultas-relmci.xml"), geraXML);
        ExportacaoDados exp = new ExportacaoDados(app, listenerGeracaoXML);
        TipoBancoDados tpBanco = DatabaseHelper.recuperaTipoBancoDados(app);
        this.setProgresso(0);
        if (geraXML) {
            this.geraDadosXML(listenerGeracaoXML, diretorioDestino, "relmci.pdf", "relmci.xml", "relmci.xsl", consultasMCI, remessa, tpBanco, exp);
        }
        if (geraPDF) {
            this.setSituacao("Gerando arquivos para relat\u00f3rio do MCI");
            this.transformaPDF(listenerGeracaoXML, diretorioDestino, "relmci.pdf", "relmci.xml", "relmci.xsl", remessa, tpBanco);
        }
    }

    private void geraDadosXML(ChangeListener listener, File diretorioDestino, String nomeArquivoDadosPDF, String nomeArquivoDadosXML, String nomeArquivoXSL, ConsultasExtracaoList consultasSQL, Remessa remessa, TipoBancoDados tpBanco, ExportacaoDados exp) {
        this.setSituacao("Preparando para gerar dados XML.");
        this.preparaArquivoDadosRelatorio(diretorioDestino + File.separator + nomeArquivoDadosXML, consultasSQL, remessa, tpBanco, exp);
    }

    private File transformaPDF(ChangeListener listener, File diretorioDestino, String nomeArquivoDadosPDF, String nomeArquivoDadosXML, String nomeArquivoXSL, Remessa remessa, TipoBancoDados tpBanco) {
        this.setSituacao("Preparando transforma\u00e7\u00e3o do Relat\u00f3rio.");
        RelatorioControle relatorio = new RelatorioControle(listener);
        File saidaPDF = new File(diretorioDestino + File.separator + nomeArquivoDadosPDF);
        relatorio.constroiRelatorio(saidaPDF, diretorioDestino + File.separator + nomeArquivoDadosXML, nomeArquivoXSL, false);
        return saidaPDF;
    }

    private void preparaArquivoDadosRelatorio(String arquivo, ConsultasExtracaoList consultas, Remessa remessa, TipoBancoDados tpBanco, ExportacaoDados exp) {
        try {
            exp.montaXMLsaida(consultas, new File(arquivo), remessa, tpBanco, false);
        }
        catch (Exception e) {
            throw new RelatorioControleException("Erro durante a gera\u00e7\u00e3o do arquivo de sa\u00edda do relat\u00f3rio.", arquivo, e);
        }
    }

    public static boolean visualiza(File arquivoRelatorio) {
        try {
            if (Desktop.isDesktopSupported()) {
                log.info((Object)("Usando Desktop.getDesktop().open(): " + arquivoRelatorio));
                Desktop.getDesktop().open(arquivoRelatorio);
                log.info((Object)"Usou Desktop.getDesktop().open()...");
                return true;
            }
            String comando = null;
            boolean wait = true;
            if (SystemUtils.IS_OS_WINDOWS_95 || SystemUtils.IS_OS_WINDOWS_98 || SystemUtils.IS_OS_WINDOWS_ME) {
                comando = "command.com /C start acrord32 \"" + arquivoRelatorio.getAbsolutePath() + "\"";
            } else if (SystemUtils.IS_OS_WINDOWS) {
                comando = "cmd.exe /C start acrord32 \"" + arquivoRelatorio.getAbsolutePath() + "\"";
            } else if (SystemUtils.IS_OS_UNIX) {
                comando = "xdg-open \"" + arquivoRelatorio.getAbsolutePath() + "\"";
                wait = false;
            } else {
                log.warn((Object)("sistema operacional desconhecido (utilizando como se windows NT) - os.name=" + System.getProperty("os.name")));
                comando = "cmd.exe /C start acrord32 \"" + arquivoRelatorio.getAbsolutePath() + "\"";
            }
            CommandRunner runer = new CommandRunner();
            System.out.println("Comando para Abrir PDF: " + comando);
            return runer.execute(comando, wait) < 1;
        }
        catch (Exception error) {
            log.error((Object)"Exception ao visualizar", (Throwable)error);
            throw new RelatorioControleException("O Arquivo solicitado n\u00e3o pode ser visualizado.", arquivoRelatorio.getAbsoluteFile().toString());
        }
    }

    public File geraRelatorioRVE(File destino, Remessa remessa, ServicoMCI servicoMCI, ChangeListener listenerGeracaoXML) {
        ConsultasExtracaoList consultasMCI = (ConsultasExtracaoList)ConfiguracaoControle.carregaDadosArquivoXML("extracao", new File("consultas-relmci.xml"), true);
        ExportacaoDados exp = new ExportacaoDados(servicoMCI, listenerGeracaoXML);
        TipoBancoDados tpBanco = DatabaseHelper.recuperaTipoBancoDados(servicoMCI);
        this.setProgresso(0);
        this.geraDadosXML(listenerGeracaoXML, destino, "relmci.pdf", "relmci.xml", "relmci.xsl", consultasMCI, remessa, tpBanco, exp);
        File saidaPDF = this.transformaPDF(listenerGeracaoXML, destino, "relmci.pdf", "relmci.xml", "relmci.xsl", remessa, tpBanco);
        this.setProgresso(100);
        return saidaPDF;
    }

    private void setProgresso(int progresso) {
        this._progresso = progresso;
        this.fireChangeEvent();
    }

    @Override
    public int getProgresso() {
        return this._progresso;
    }

    private void setSituacao(String situacao) {
        this._situacao = situacao;
        this.fireChangeEvent();
    }

    @Override
    public String getSituacao() {
        return this._situacao;
    }

    private void fireChangeEvent() {
        if (this._listenerEventos != null) {
            ChangeEvent change = new ChangeEvent(this);
            this._listenerEventos.stateChanged(change);
        }
    }
}

