/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.modelo.mensagem;

import br.gov.rs.tce.mci.beans.Mensagem;
import br.gov.rs.tce.mci.beans.Mensagens;
import br.gov.rs.tce.mci.modelo.ConfiguracaoControle;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MensagemFactory {
    private Mensagens _mensagens = MensagemFactory.carregaMensagens();
    protected static MensagemFactory _instancia;
    protected static final Log log;
    static final boolean LOG_ERROR_ENABLED;

    private MensagemFactory() {
    }

    public static Mensagens carregaMensagens() {
        Mensagens mensagens = (Mensagens)ConfiguracaoControle.carregaDadosArquivoXML("mensagens");
        return mensagens;
    }

    public static MensagemFactory getInstancia() {
        if (_instancia == null) {
            _instancia = new MensagemFactory();
        }
        return _instancia;
    }

    private String geraMensagem(String patternMensagem, Object[] argumentos) {
        Object[] newArgumentos = null;
        newArgumentos = this.formataArgumentos(argumentos);
        return MessageFormat.format(patternMensagem, newArgumentos);
    }

    private Object[] formataArgumentos(Object[] argumentos) {
        Object[] newArgumentos = null;
        if (argumentos != null && argumentos.length > 0) {
            newArgumentos = new Object[argumentos.length];
            for (int index = 0; index < argumentos.length; ++index) {
                if (argumentos[index] instanceof Double) {
                    newArgumentos[index] = DecimalFormat.getCurrencyInstance().format(argumentos[index]);
                }
                if (argumentos[index] instanceof BigDecimal) {
                    if (((BigDecimal)argumentos[index]).scale() == 2) {
                        newArgumentos[index] = DecimalFormat.getCurrencyInstance().format(argumentos[index]);
                        continue;
                    }
                    newArgumentos[index] = String.valueOf(argumentos[index]);
                    continue;
                }
                newArgumentos[index] = argumentos[index] instanceof java.sql.Date || argumentos[index] instanceof Date ? new SimpleDateFormat("dd/MM/yyyy").format(argumentos[index]) : String.valueOf(argumentos[index]);
            }
        }
        return newArgumentos;
    }

    private Mensagem getMensagemPorCodigo(String codigoMensagem) {
        return this._mensagens.getMensagemPorCodigo(codigoMensagem);
    }

    static {
        log = LogFactory.getLog(MensagemFactory.class);
        LOG_ERROR_ENABLED = log.isErrorEnabled();
    }
}

