/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.modelo.importacao;

import br.gov.rs.tce.mci.beans.remessa.Remessa;
import br.gov.rs.tce.mci.modelo.importacao.ImportaDados;
import java.io.File;
import java.util.Map;
import oracle.jbo.ApplicationModule;

public abstract class AbstractRecuperaArquivos {
    private ApplicationModule app;
    private Map processadores;
    public static final int COMMIT_AFTER = 0;
    public static final int UNCOMMIT_AFTER = 1;
    public static final String VO_PAD_XML_TAG_COD_BARRAS_REMESSA = "CodBarrasRemessa";

    public AbstractRecuperaArquivos(ApplicationModule app) {
        this.app = app;
    }

    public abstract void carregaProcessadores();

    public String getDefaultEncoding() {
        return "UTF-8";
    }

    public void recuperaArquivos(File arquivo, Remessa remessa, int commitType) {
        ImportaDados imp = new ImportaDados(this.app);
        imp.setProcessadores(this.processadores);
        imp.importar(arquivo, remessa, this.getDefaultEncoding());
        if (commitType == 0) {
            this.app.getTransaction().commit();
        }
    }

    public void setApp(ApplicationModule app) {
        this.app = app;
    }

    public ApplicationModule getApp() {
        return this.app;
    }

    public void setProcessadores(Map processadores) {
        this.processadores = processadores;
    }

    public Map getProcessadores() {
        return this.processadores;
    }
}

