/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.modelo.decisao;

import br.gov.rs.tce.mci.beans.ConfigTelas;
import br.gov.rs.tce.mci.beans.Tela;
import br.gov.rs.tce.mci.excecao.DecisaoTelaException;
import br.gov.rs.tce.mci.excecao.MCIRuntimeException;
import br.gov.rs.tce.mci.excecao.TelaNaoEncontradaException;
import br.gov.rs.tce.mci.modelo.decisao.DecisaoNavegacaoFactory;
import br.gov.rs.tce.mci.modelo.decisao.DecisaoProximaTela;
import java.util.HashMap;
import java.util.Map;
import oracle.adf.model.BindingContext;

public final class DecisaoNavegacaoTelas {
    private Map _decisaoProximaTela = new HashMap();
    private static DecisaoNavegacaoTelas _instancia;
    private ConfigTelas _config = DecisaoNavegacaoFactory.getInstancia().getConfigTelas();

    private DecisaoNavegacaoTelas() {
    }

    public static DecisaoNavegacaoTelas getInstancia() {
        if (_instancia == null) {
            _instancia = new DecisaoNavegacaoTelas();
        }
        return _instancia;
    }

    public Tela escolheProximaTela(String codigoTelaAtual, BindingContext binding) throws DecisaoTelaException {
        Tela tela = null;
        String codigo = null;
        DecisaoProximaTela dec = (DecisaoProximaTela)this._decisaoProximaTela.get(codigoTelaAtual);
        if (dec != null) {
            codigo = dec.escolheProximaTela(codigoTelaAtual, binding);
            if (codigo == null || codigo.length() < 2) {
                throw new IllegalStateException("A classe de decis\u00e3o " + dec.getClass().getName() + " n\u00e3o retornou nenhum c\u00f3digo de tela, verifique a l\u00f3gica da classe de decis\u00e3o!");
            }
            tela = this._config.getTelaPorCodigo(codigo);
        } else {
            tela = this._config.getTelaPorCodigo(codigoTelaAtual);
            if (tela != null) {
                if (tela.getProximaTela() != null) {
                    tela = this._config.getTelaPorCodigo(tela.getProximaTela());
                } else {
                    if (tela.getDecisaoProxima() == null) {
                        throw new DecisaoTelaException("O arquivo _config-telas deve conter pelo menos um valor para uma das tags \"proxima-tela\" ou \"decisao-proxima\" : " + tela.getCodigo());
                    }
                    dec = this.retornaClasseDecisaoTela(tela.getDecisaoProxima());
                    this._decisaoProximaTela.put(codigoTelaAtual, dec);
                    codigo = dec.escolheProximaTela(codigoTelaAtual, binding);
                    tela = this._config.getTelaPorCodigo(codigo);
                }
            }
        }
        return tela;
    }

    private DecisaoProximaTela retornaClasseDecisaoTela(String nome) {
        DecisaoProximaTela tela = null;
        try {
            tela = (DecisaoProximaTela)Class.forName(nome).newInstance();
        }
        catch (Exception e) {
            throw new DecisaoTelaException("Erro ao instanciar classe: " + nome);
        }
        return tela;
    }

    public Tela getTelaPorCodigo(String codigoTela) {
        Tela tela = this._config.getTelaPorCodigo(codigoTela);
        if (tela == null) {
            throw new DecisaoTelaException("Tela n\u00e3o encontrada com c\u00f3digo: '" + codigoTela + "'");
        }
        return tela;
    }

    public ConfigTelas getConfigTelas() {
        return this._config;
    }

    public Tela getTelaInicial() {
        String telaInicial = this._config.getTelaInicial();
        if (telaInicial == null) {
            throw new TelaNaoEncontradaException(new MCIRuntimeException("Tela inicial nao definida no ConfigTelas."));
        }
        Tela t = this._config.getTelaPorCodigo(telaInicial);
        return t;
    }

    public Tela getTelaFinal() {
        String tela = this._config.getTelaFinal();
        if (tela == null) {
            throw new TelaNaoEncontradaException(new MCIRuntimeException("Tela final nao definida no ConfigTelas."));
        }
        Tela t = this._config.getTelaPorCodigo(tela);
        return t;
    }
}

