/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.modelo.ajuda;

import br.gov.rs.tce.mci.excecao.MciAjudaException;
import java.net.URL;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class MciAjudaHelperDesktop {
    private static final String helpSetName = "MCI.hs";
    private Log log = LogFactory.getLog(MciAjudaHelperDesktop.class);
    private static MciAjudaHelperDesktop _instance;
    private HelpSet helpSet = null;
    private HelpBroker helpBroker = null;

    private MciAjudaHelperDesktop() {
    }

    public static MciAjudaHelperDesktop getInstance() {
        if (_instance == null) {
            _instance = new MciAjudaHelperDesktop();
        }
        return _instance;
    }

    public boolean exibeAjuda(String codigoTela) throws MciAjudaException {
        boolean exibeOK = false;
        if (this.helpSet == null) {
            this.createHelpSet();
            this.helpBroker = this.helpSet.createHelpBroker();
        }
        try {
            this.helpBroker.setCurrentID("html." + codigoTela);
            this.helpBroker.setDisplayed(true);
            exibeOK = true;
        }
        catch (Exception ex) {
            throw new MciAjudaException("Ocorreu um erro ao exibir o Help c\u00f3digo: " + codigoTela, ex);
        }
        return exibeOK;
    }

    private String getRealCodigo(String codigo) {
        URL urlArquivo = this.getClass().getResource("/html/" + codigo + ".html");
        String codigoRetorno = null;
        if (urlArquivo != null) {
            codigoRetorno = codigo;
        } else {
            codigo = codigo.substring(0, 5);
            urlArquivo = this.getClass().getResource("/html/" + codigo + ".html");
            if (urlArquivo != null) {
                codigoRetorno = codigo;
            }
        }
        return codigoRetorno;
    }

    private void createHelpSet() throws MciAjudaException {
        ClassLoader loader = this.getClass().getClassLoader();
        URL url = HelpSet.findHelpSet((ClassLoader)loader, (String)helpSetName);
        if (url == null) {
            throw new MciAjudaException("O sistema n\u00e3o encontrou o arquivo de configura\u00e7\u00e3o do Help");
        }
        try {
            this.helpSet = new HelpSet(loader, url);
        }
        catch (HelpSetException hSE) {
            throw new MciAjudaException(hSE.getMessage(), (Exception)((Object)hSE));
        }
    }
}

