/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.beans.types;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class TipoPoderList
implements Serializable {
    public static final String EXECUTIVO_ABRV_TYPE = "P";
    public static final TipoPoderList EXECUTIVO = new TipoPoderList("Poder Executivo", "P");
    public static final String LEGISLATIVO_ABRV_TYPE = "C";
    public static final TipoPoderList LEGISLATIVO = new TipoPoderList("Poder Legislativo", "C");
    private static HashMap _abrvMemberTable = TipoPoderList.initAbreviaturas();
    private String _name = null;
    private String _abreviatura = null;

    private TipoPoderList(String value, String abreviatura) {
        this._abreviatura = abreviatura;
        this._name = value;
    }

    public static Iterator enumerate() {
        return _abrvMemberTable.values().iterator();
    }

    public static Collection listaPoder() {
        return Collections.unmodifiableCollection(_abrvMemberTable.values());
    }

    private static HashMap initAbreviaturas() {
        LinkedHashMap<String, TipoPoderList> members = new LinkedHashMap<String, TipoPoderList>();
        members.put(EXECUTIVO_ABRV_TYPE, EXECUTIVO);
        members.put(LEGISLATIVO_ABRV_TYPE, LEGISLATIVO);
        return members;
    }

    private Object readResolve() {
        return TipoPoderList.valueOf(this._name);
    }

    public String toString() {
        return this._name;
    }

    public static TipoPoderList valueOf(String string) {
        Object obj = null;
        if (string != null) {
            obj = _abrvMemberTable.get(string);
        }
        if (obj == null) {
            String err = "'" + string + "' is not a valid TipoPoderList";
            throw new IllegalArgumentException(err);
        }
        return obj;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setAbreviatura(String _abreviatura) {
        this._abreviatura = _abreviatura;
    }

    public String getAbreviatura() {
        return this._abreviatura;
    }
}

