/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.beans;

import br.gov.rs.tce.mci.beans.ConsultaSQL;
import br.gov.rs.tce.mci.beans.Parametro;
import br.gov.rs.tce.mci.beans.TipoBancoDados;
import br.gov.rs.tce.mci.beans.remessa.Remessa;
import br.gov.rs.tce.mci.excecao.ConfiguracaoException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ParametrosList
implements Serializable {
    public static final String PARAM_CONSULTA_SQL = "consulta-sql";
    public static final String PARAM_CONSULTA_SQL_DERBY = "consulta-sql-derby";
    public static final String PARAMS_CONSULTA_SQL = "consulta.parametro";
    public static final String REF_CONSULTAS_QUADROS = "quadros";
    private Map _parametrosMap = new LinkedHashMap();

    public void adicionaParametro(Parametro vParametro) throws IndexOutOfBoundsException {
        this._parametrosMap.put(vParametro.getNome(), vParametro);
    }

    public Parametro getParametroPorNome(String nome) {
        if (nome == null) {
            throw new IllegalArgumentException("O nome do parametro n\u00e3o pode ser nulo");
        }
        return (Parametro)this._parametrosMap.get(nome.toLowerCase());
    }

    public Map getParametroMap() {
        return this._parametrosMap;
    }

    protected List buscaParametros(String nomeParametro, TipoBancoDados tpBanco) {
        ArrayList<String> valores = new ArrayList<String>();
        for (Parametro param : this._parametrosMap.values()) {
            String banco = param.getBanco();
            if (!param.getNome().startsWith(nomeParametro)) continue;
            if (banco == null) {
                valores.add(param.getValor());
                continue;
            }
            if (!TipoBancoDados.valueOf(banco).equals(tpBanco)) continue;
            valores.add(param.getValor());
        }
        return valores;
    }

    public ConsultaSQL recuperaConsultaSQL(Remessa remessa, String nomeParametro, TipoBancoDados tpBanco) {
        ConsultaSQL consultaSQL = null;
        String sql = null;
        Parametro param = null;
        if (tpBanco.equals(TipoBancoDados.ORACLE_DB)) {
            param = this.getParametroPorNome(PARAM_CONSULTA_SQL);
        } else if (tpBanco.equals(TipoBancoDados.DERBY_DB) && (param = this.getParametroPorNome(PARAM_CONSULTA_SQL_DERBY)) == null) {
            param = this.getParametroPorNome(PARAM_CONSULTA_SQL);
        }
        if (param == null) {
            throw new ConfiguracaoException("N\u00e3o foi localizado um parametro de consulta neste quadro.");
        }
        String refExterna = param.getReferenciaExterna();
        if (refExterna != null) {
            consultaSQL = ParametrosList.resolveReferenciaSQL(param.getValor(), refExterna);
            List nomesParametros = this.buscaParametros(nomeParametro, tpBanco);
            Object[] valores = this.recuperaValorParametros(nomesParametros, remessa);
            consultaSQL.setValores(valores);
        } else {
            if (param == null) {
                throw new IllegalArgumentException("N\u00e3o foi possivel localizar nenhuma consulta SQL nesta lista de parametros");
            }
            sql = param.getValor();
            List nomesParametros = this.buscaParametros(nomeParametro, tpBanco);
            Object[] valores = this.recuperaValorParametros(nomesParametros, remessa);
            consultaSQL = new ConsultaSQL(sql, valores);
        }
        return consultaSQL;
    }

    private static ConsultaSQL resolveReferenciaSQL(String valor, String refExterna) {
        ConsultaSQL sql = null;
        if (refExterna == null) {
            throw new IllegalArgumentException("RefExterna n\u00e3o pode ser nulo");
        }
        if (valor == null) {
            throw new IllegalArgumentException("Valor n\u00e3o pode ser nulo");
        }
        if (sql == null) {
            throw new IllegalStateException("N\u00e3o foi possivel localizar uma consulta com o nome: " + valor);
        }
        return sql;
    }

    protected Object[] recuperaValorParametros(List nomeParametros, Remessa remessa) {
        int qtdParametros = nomeParametros.size();
        Object[] retorno = new Object[qtdParametros];
        for (int i = 0; i < qtdParametros; ++i) {
            String valorParametro = (String)nomeParametros.get(i);
            retorno[i] = valorParametro;
        }
        return retorno;
    }
}

