/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mci.beans;

import java.io.Serializable;

public final class Mensagem
implements Serializable {
    protected String _tipo;
    protected String _codigo;
    protected String _texto;
    public static final String MENSAGEM_ERRO = "E";
    public static final String MENSAGEM_AVISO = "W";
    public static final String MENSAGEM_INFORMATIVA = "I";

    public String getCodigo() {
        return this._codigo;
    }

    public String getTexto() {
        return this._texto;
    }

    public String getTipo() {
        return this._tipo;
    }

    public void setCodigo(String codigo) {
        this._codigo = codigo;
    }

    public void setTexto(String texto) {
        this._texto = texto;
    }

    public void setTipo(String tipo) {
        Mensagem.verificaTipoMensagem(tipo);
        this._tipo = tipo.toUpperCase();
    }

    public static void verificaTipoMensagem(String tipo) {
        if (tipo == null || "".equals(tipo)) {
            throw new IllegalArgumentException("Tipo de mensagem vazio n\u00e3o \u00e9 permitido, tipo v\u00e1lidos [I, W, E].");
        }
        if (!(MENSAGEM_AVISO.equalsIgnoreCase(tipo) || MENSAGEM_ERRO.equalsIgnoreCase(tipo) || MENSAGEM_INFORMATIVA.equalsIgnoreCase(tipo))) {
            throw new IllegalArgumentException("Tipo de mensagem inv\u00e1lido [" + tipo + "], tipo v\u00e1lidos [I, W, E].");
        }
    }
}

