/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.adf.util;

import java.util.HashMap;
import java.util.Set;
import oracle.adf.model.BindingContext;
import oracle.adf.model.binding.DCBindingContainer;
import oracle.adf.model.binding.DCControlBinding;
import oracle.adf.model.binding.DCIteratorBinding;
import oracle.jbo.uicli.binding.JUIteratorDef;
import oracle.jbo.uicli.jui.JUPanelBinding;
import oracle.jbo.uicli.jui.JUTableBinding;
import oracle.jbo.uicli.jui.JUTableDef;

public class DataBindingHelper
extends Exception {
    private DataBindingHelper() {
    }

    public static JUIteratorDef createIteratorDef(String voName, int rangeSize) {
        JUIteratorDef iterDef = new JUIteratorDef();
        iterDef.setSubType("DCIterator");
        iterDef.setDefClassName(JUIteratorDef.class.getName());
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("Binds", voName);
        props.put("RangeSize", Integer.toString(rangeSize));
        iterDef.init(props);
        return iterDef;
    }

    private static JUTableDef createTableDef(String tableDefName, String[] colunas, String iteratorBindingName) {
        JUTableDef tableDef = new JUTableDef();
        tableDef.setSubType("DCTable");
        HashMap<String, Object> propsTable = new HashMap<String, Object>();
        propsTable.put("AttrNames", colunas);
        propsTable.put("IterBinding", iteratorBindingName);
        propsTable.put("id", tableDefName);
        propsTable.put("ColumnSort", "false");
        tableDef.init(propsTable);
        return tableDef;
    }

    public static DCIteratorBinding adicionaIteratorBinding(BindingContext bindingContext, JUPanelBinding panelBinding, String nomeIterator, String nomeAppModule, String nomeViewObject) {
        return DataBindingHelper.adicionaIteratorBinding(bindingContext, panelBinding, nomeIterator, nomeAppModule, nomeViewObject, null);
    }

    public static DCIteratorBinding adicionaIteratorBinding(BindingContext bindingContext, JUPanelBinding panelBinding, String nomeIterator, String nomeAppModule, String nomeViewObject, Set iteratorNames) {
        JUIteratorDef iterDef = DataBindingHelper.createIteratorDef(nomeAppModule + "." + nomeViewObject, 10);
        DCIteratorBinding iter = iterDef.createIterBinding(bindingContext, (DCBindingContainer)panelBinding);
        iter.setRangeSize(-1);
        panelBinding.addIteratorBinding(nomeIterator, iter);
        String name = iter.getName();
        if (iteratorNames != null) {
            iteratorNames.add(name);
        }
        return iter;
    }

    public static JUTableBinding adicionaTableBinding(BindingContext bindingContext, JUPanelBinding panelBinding, String nomeBindingTabela, String[] colunas, String iterName) {
        return DataBindingHelper.adicionaTableBinding(bindingContext, panelBinding, nomeBindingTabela, colunas, iterName, null);
    }

    public static JUTableBinding adicionaTableBinding(BindingContext bindingContext, JUPanelBinding panelBinding, String nomeBindingTabela, String[] colunas, String iterName, Set tableControlNames) {
        JUTableDef tableDef = DataBindingHelper.createTableDef(nomeBindingTabela, colunas, iterName);
        DCControlBinding dcControl = tableDef.createControlBinding((DCBindingContainer)panelBinding);
        String name = dcControl.getName();
        if (tableControlNames != null) {
            tableControlNames.add(name);
        }
        return (JUTableBinding)dcControl;
    }

    public static String criaNomeIteratorDef(String nome) {
        String nomeDef = (nome + "IteratorDef").replace('-', '_');
        return nomeDef;
    }

    public static String criaNomeTableDef(String nome) {
        String nomeDef = (nome + "TableDef").replace('-', '_');
        return nomeDef;
    }
}

