/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.operation;

import java.math.BigInteger;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.operation.AbstractBatchOperation;
import org.dbunit.operation.OperationData;

public class InsertOperation
extends AbstractBatchOperation {
    InsertOperation() {
    }

    public OperationData getOperationData(ITableMetaData metaData, BigInteger ignoreMapping, IDatabaseConnection connection) throws DataSetException {
        Column[] columns = metaData.getColumns();
        StringBuffer sqlBuffer = new StringBuffer(128);
        sqlBuffer.append("insert into ");
        sqlBuffer.append(this.getQualifiedName(connection.getSchema(), metaData.getTableName(), connection));
        sqlBuffer.append(" (");
        String columnSeparator = "";
        for (int i = 0; i < columns.length; ++i) {
            if (ignoreMapping.testBit(i)) continue;
            String columnName = this.getQualifiedName(null, columns[i].getColumnName(), connection);
            sqlBuffer.append(columnSeparator);
            sqlBuffer.append(columnName);
            columnSeparator = ", ";
        }
        sqlBuffer.append(") values (");
        String valueSeparator = "";
        for (int i = 0; i < columns.length; ++i) {
            if (ignoreMapping.testBit(i)) continue;
            sqlBuffer.append(valueSeparator);
            sqlBuffer.append("?");
            valueSeparator = ", ";
        }
        sqlBuffer.append(")");
        return new OperationData(sqlBuffer.toString(), columns);
    }

    protected BigInteger getIngnoreMapping(ITable table, int row) throws DataSetException {
        Column[] columns = table.getTableMetaData().getColumns();
        int n = columns.length;
        int byteNum = n / 8;
        byte[] result = new byte[byteNum + 2];
        for (int i = 0; i < n; ++i) {
            Object value = table.getValue(row, columns[i].getColumnName());
            if (value != null) continue;
            int n2 = result.length - i / 8 - 1;
            result[n2] = (byte)(result[n2] | 1 << i % 8);
        }
        return new BigInteger(result);
    }

    protected boolean equalsIgnoreMapping(BigInteger ignoreMapping, ITable table, int row) throws DataSetException {
        Column[] columns = table.getTableMetaData().getColumns();
        for (int i = 0; i < columns.length; ++i) {
            boolean bit = ignoreMapping.testBit(i);
            Object value = table.getValue(row, columns[i].getColumnName());
            if ((!bit || value == null) && (bit || value != null)) continue;
            return false;
        }
        return true;
    }
}

