/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.dbunit.dataset.CachedDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.xml.FlatDtdDataSet;
import org.dbunit.dataset.xml.FlatXmlProducer;
import org.dbunit.dataset.xml.FlatXmlWriter;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FlatXmlDataSet
extends CachedDataSet {
    private static final String DEFAULT_ENCODING = "UTF8";

    public FlatXmlDataSet(InputSource source) throws IOException, DataSetException {
        super(new FlatXmlProducer(source));
    }

    public FlatXmlDataSet(File xmlFile) throws IOException, DataSetException {
        this(xmlFile, true);
    }

    public FlatXmlDataSet(File xmlFile, boolean dtdMetadata) throws IOException, DataSetException {
        super(new FlatXmlProducer(new InputSource(xmlFile.toURL().toString()), dtdMetadata));
    }

    public FlatXmlDataSet(Reader xmlReader) throws IOException, DataSetException {
        this(xmlReader, true);
    }

    public FlatXmlDataSet(Reader xmlReader, boolean dtdMetadata) throws IOException, DataSetException {
        super(new FlatXmlProducer(new InputSource(xmlReader), dtdMetadata));
    }

    public FlatXmlDataSet(Reader xmlReader, Reader dtdReader) throws IOException, DataSetException {
        super(new FlatXmlProducer(new InputSource(xmlReader), new DtdEntityResolver(dtdReader)));
    }

    public FlatXmlDataSet(Reader xmlReader, IDataSet metaDataSet) throws IOException, DataSetException {
        super(new FlatXmlProducer(new InputSource(xmlReader), metaDataSet));
    }

    public FlatXmlDataSet(InputStream xmlStream) throws IOException, DataSetException {
        this(xmlStream, true);
    }

    public FlatXmlDataSet(InputStream xmlStream, boolean dtdMetadata) throws IOException, DataSetException {
        super(new FlatXmlProducer(new InputSource(xmlStream), dtdMetadata));
    }

    public FlatXmlDataSet(InputStream xmlStream, InputStream dtdStream) throws IOException, DataSetException {
        super(new FlatXmlProducer(new InputSource(xmlStream), new DtdEntityResolver(dtdStream)));
    }

    public FlatXmlDataSet(InputStream xmlStream, IDataSet metaDataSet) throws IOException, DataSetException {
        super(new FlatXmlProducer(new InputSource(xmlStream), metaDataSet));
    }

    public static void write(IDataSet dataSet, OutputStream out) throws IOException, DataSetException {
        OutputStreamWriter writer = new OutputStreamWriter(out, DEFAULT_ENCODING);
        FlatXmlDataSet.write(dataSet, writer);
    }

    public static void write(IDataSet dataSet, Writer writer) throws IOException, DataSetException {
        FlatXmlDataSet.write(dataSet, writer, null);
    }

    public static void write(IDataSet dataSet, Writer writer, String encoding) throws IOException, DataSetException {
        FlatXmlWriter datasetWriter = new FlatXmlWriter(writer, encoding);
        datasetWriter.setIncludeEmptyTable(true);
        datasetWriter.write(dataSet);
    }

    public static void writeDtd(IDataSet dataSet, OutputStream out) throws IOException, DataSetException {
        FlatDtdDataSet.write(dataSet, out);
    }

    private static class DtdEntityResolver
    implements EntityResolver {
        InputSource _dtdSource;

        public DtdEntityResolver(InputSource dtdSource) {
            this._dtdSource = dtdSource;
        }

        public DtdEntityResolver(Reader dtdReader) {
            this(new InputSource(dtdReader));
        }

        public DtdEntityResolver(InputStream dtdStream) {
            this(new InputSource(dtdStream));
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            return this._dtdSource;
        }
    }
}

