/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.filter;

import java.util.ArrayList;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.filter.ITableFilter;

public abstract class AbstractTableFilter
implements ITableFilter {
    public String[] getTableNames(IDataSet dataSet) throws DataSetException {
        String[] tableNames = dataSet.getTableNames();
        ArrayList<String> nameList = new ArrayList<String>();
        for (int i = 0; i < tableNames.length; ++i) {
            String tableName = tableNames[i];
            if (!this.isValidName(tableName)) continue;
            nameList.add(tableName);
        }
        return nameList.toArray(new String[0]);
    }

    public ITableIterator iterator(IDataSet dataSet, boolean reversed) throws DataSetException {
        return new FilterIterator(reversed ? dataSet.reverseIterator() : dataSet.iterator());
    }

    public abstract /* synthetic */ boolean isValidName(String var1) throws DataSetException;

    private class FilterIterator
    implements ITableIterator {
        private final ITableIterator _iterator;

        public FilterIterator(ITableIterator iterator) {
            this._iterator = iterator;
        }

        public boolean next() throws DataSetException {
            while (this._iterator.next()) {
                if (!AbstractTableFilter.this.isValidName(this._iterator.getTableMetaData().getTableName())) continue;
                return true;
            }
            return false;
        }

        public ITableMetaData getTableMetaData() throws DataSetException {
            return this._iterator.getTableMetaData();
        }

        public ITable getTable() throws DataSetException {
            return this._iterator.getTable();
        }
    }
}

