/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import java.util.ArrayList;
import java.util.List;
import org.dbunit.dataset.AbstractTable;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableMetaData;
import org.dbunit.dataset.ITableMetaData;

public class DefaultTable
extends AbstractTable {
    private final ITableMetaData _metaData;
    protected final List _rowList;

    public DefaultTable(ITableMetaData metaData, List list) {
        this._metaData = metaData;
        this._rowList = list;
    }

    public DefaultTable(String tableName) {
        this._metaData = new DefaultTableMetaData(tableName, new Column[0]);
        this._rowList = new ArrayList();
    }

    public DefaultTable(String tableName, Column[] columns, List list) {
        this._metaData = new DefaultTableMetaData(tableName, columns);
        this._rowList = list;
    }

    public DefaultTable(String tableName, Column[] columns) {
        this._metaData = new DefaultTableMetaData(tableName, columns);
        this._rowList = new ArrayList();
    }

    protected DefaultTable(ITableMetaData metaData) {
        this._metaData = metaData;
        this._rowList = new ArrayList();
    }

    public void addRow() throws DataSetException {
        int columnCount = this._metaData.getColumns().length;
        this._rowList.add(new Object[columnCount]);
    }

    public void addRow(Object[] values) throws DataSetException {
        this._rowList.add(values);
    }

    public void setValue(int row, String column, Object value) throws DataSetException {
        this.assertValidRowIndex(row);
        Object[] rowValues = (Object[])this._rowList.get(row);
        rowValues[this.getColumnIndex((String)column)] = value;
    }

    public ITableMetaData getTableMetaData() {
        return this._metaData;
    }

    public int getRowCount() {
        return this._rowList.size();
    }

    public Object getValue(int row, String column) throws DataSetException {
        this.assertValidRowIndex(row);
        Object[] rowValues = (Object[])this._rowList.get(row);
        return rowValues[this.getColumnIndex(column)];
    }
}

