/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util.builder;

import java.util.HashMap;
import java.util.Vector;
import oracle.i18n.util.Sort;
import oracle.i18n.util.builder.NLTParserException;
import oracle.i18n.util.builder.NLTSchemaParser;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BootParser
extends NLTSchemaParser {
    private static final String HEXPREFIX = "0000";

    public BootParser(String string) throws NLTParserException {
        super(string);
        this.topNode = BootParser.findNode((Node)this.doc, "NLSBOOT");
        if (this.topNode == null) {
            throw new NLTParserException("Pattern NLSBOOT not found!");
        }
    }

    public String getVERSION() {
        return this.getStringValue("VERSION");
    }

    public HashMap getLanguage() throws NLTParserException {
        NodeList nodeList = BootParser.findNodes(this.topNode, "LANGUAGE");
        int n = nodeList.getLength();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeName() != "LANGUAGE") continue;
            String string = node.getFirstChild().getNodeValue();
            NamedNodeMap namedNodeMap = node.getAttributes();
            node = namedNodeMap.getNamedItem("id");
            String string2 = node.getNodeValue();
            hashMap.put(string, BootParser.formatFileName("lx0", string2));
        }
        return hashMap;
    }

    public HashMap getTerritory() throws NLTParserException {
        NodeList nodeList = BootParser.findNodes(this.topNode, "TERRITORY");
        int n = nodeList.getLength();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < n; ++i) {
            String string;
            Node node = nodeList.item(i);
            if (node.getNodeName() != "TERRITORY") continue;
            String string2 = node.getFirstChild().getNodeValue();
            NamedNodeMap namedNodeMap = node.getAttributes();
            node = namedNodeMap.getNamedItem("id");
            String string3 = node.getNodeValue();
            node = namedNodeMap.getNamedItem("language");
            hashMap.put(string2, BootParser.formatFileName("lx1", string3));
            if (node == null) continue;
            String string4 = node.getNodeValue();
            int n2 = 0;
            int n3 = 0;
            int n4 = 1;
            while ((n3 = string4.indexOf(44, n2)) != -1) {
                string = string4.substring(n2, n3);
                hashMap.put(string + "_" + string2, BootParser.formatFileName("lx1", string3, n4++));
                n2 = n3 + 1;
            }
            string = string4.substring(n2);
            hashMap.put(string + "_" + string2, BootParser.formatFileName("lx1", string3, n4));
        }
        return hashMap;
    }

    public String[] getAvailableCharacterSet() throws NLTParserException {
        NodeList nodeList = BootParser.findNodes(this.topNode, "CHARACTER_SET");
        int n = nodeList.getLength();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < n; ++i) {
            String string;
            Node node = nodeList.item(i);
            if (node.getNodeName() != "CHARACTER_SET") continue;
            String string2 = node.getFirstChild().getNodeValue();
            NamedNodeMap namedNodeMap = node.getAttributes();
            if ((node = namedNodeMap.getNamedItem("support")) != null && (string = node.getNodeValue()) != null && string.equals("conversion_only")) continue;
            node = namedNodeMap.getNamedItem("id");
            string = node.getNodeValue();
            int n2 = 0;
            int n3 = 0;
            while ((n3 = string2.indexOf(44, n2)) != -1) {
                vector.add(string2.substring(n2, n3));
                n2 = n3 + 1;
            }
            vector.add(string2.substring(n2));
        }
        vector.trimToSize();
        Object[] objectArray = new String[vector.size()];
        objectArray = vector.toArray(objectArray);
        Sort.quickSort(objectArray, 0, objectArray.length - 1);
        return objectArray;
    }

    public HashMap getCharacterSet() throws NLTParserException {
        NodeList nodeList = BootParser.findNodes(this.topNode, "CHARACTER_SET");
        int n = nodeList.getLength();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeName() != "CHARACTER_SET") continue;
            String string = node.getFirstChild().getNodeValue();
            NamedNodeMap namedNodeMap = node.getAttributes();
            node = namedNodeMap.getNamedItem("id");
            String string2 = node.getNodeValue();
            int n2 = 0;
            int n3 = 0;
            while ((n3 = string.indexOf(44, n2)) != -1) {
                hashMap.put(string.substring(n2, n3), string2);
                n2 = n3 + 1;
            }
            hashMap.put(string.substring(n2), string2);
        }
        return hashMap;
    }

    public HashMap getLinguistic() throws NLTParserException {
        NodeList nodeList = BootParser.findNodes(this.topNode, "LINGUISTIC_DEFINITION");
        int n = nodeList.getLength();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeName() != "LINGUISTIC_DEFINITION") continue;
            String string = node.getFirstChild().getNodeValue();
            NamedNodeMap namedNodeMap = node.getAttributes();
            node = namedNodeMap.getNamedItem("id");
            String string2 = node.getNodeValue();
            hashMap.put(string, BootParser.formatFileName("lx3", string2));
        }
        return hashMap;
    }

    public HashMap getTable() throws NLTParserException {
        NodeList nodeList = BootParser.findNodes(this.topNode, "TABLE");
        int n = nodeList.getLength();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeName() != "TABLE") continue;
            String string = node.getFirstChild().getNodeValue();
            NamedNodeMap namedNodeMap = node.getAttributes();
            node = namedNodeMap.getNamedItem("id");
            String string2 = node.getNodeValue();
            hashMap.put(string, BootParser.formatFileName("lx4", string2));
        }
        return hashMap;
    }

    private HashMap getIdtoObject(String string) throws NLTParserException {
        NodeList nodeList = BootParser.findNodes(this.topNode, string);
        int n = nodeList.getLength();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeName() != string) continue;
            String string2 = node.getFirstChild().getNodeValue();
            NamedNodeMap namedNodeMap = node.getAttributes();
            node = namedNodeMap.getNamedItem("id");
            String string3 = node.getNodeValue();
            int n2 = 0;
            n2 = string2.indexOf(44);
            if (n2 != -1) {
                hashMap.put(string3, string2.substring(0, n2));
                continue;
            }
            hashMap.put(string3, string2);
        }
        return hashMap;
    }

    public HashMap getIdtoLanguage() throws NLTParserException {
        return this.getIdtoObject("LANGUAGE");
    }

    public HashMap getIdtoTerritory() throws NLTParserException {
        return this.getIdtoObject("TERRITORY");
    }

    public HashMap getIdtoCharacterSet() throws NLTParserException {
        return this.getIdtoObject("CHARACTER_SET");
    }

    public HashMap getIdtoLinguistic() throws NLTParserException {
        return this.getIdtoObject("LINGUISTIC_DEFINITION");
    }

    public HashMap getIdtoTable() throws NLTParserException {
        return this.getIdtoObject("TABLE");
    }

    private static String formatFileName(String string, String string2) {
        String string3 = Integer.toHexString(Integer.parseInt(string2));
        String string4 = HEXPREFIX.substring(0, HEXPREFIX.length() - string3.length()) + string3;
        return string + string4;
    }

    private static String formatFileName(String string, String string2, int n) {
        String string3 = Integer.toHexString(Integer.parseInt(string2));
        String string4 = Integer.toHexString(n);
        String string5 = HEXPREFIX.substring(0, HEXPREFIX.length() - string3.length()) + string3 + string4;
        return string + string5;
    }
}

