/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.util;

import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TimeZone;
import oracle.i18n.util.OraResourceBundle;

public class OraDisplayLocaleInfo {
    private static int m_initv = 1;
    private static final Hashtable m_cache = new Hashtable(m_initv);
    private static final String M_C_LANGUAGE_RESB = "oracle.i18n.util.message.LanguageTranslations";
    private static final String M_C_TERRITORY_RESB = "oracle.i18n.util.message.TerritoryTranslations";
    private static final String M_C_LANG_TERRIT_RESB = "oracle.i18n.util.message.LanguageTerritoryTranslations";
    private static final String M_C_TIMEZONE_RESB = "oracle.i18n.util.message.TimeZoneTranslations";
    private static final String M_C_LINGUISTIC_SORT_RESB = "oracle.i18n.util.message.LinguisticSortTranslations";
    private static final String M_C_CHARACTER_SET_RESB = "oracle.i18n.util.message.CharacterSetTranslations";
    private static final String M_C_CURRENCY_RESB = "oracle.i18n.util.message.CurrencyTranslations";
    private static final OraDisplayLocaleInfo m_english_odli = new OraDisplayLocaleInfo(new Locale("en", ""), null);
    private final ResourceBundle m_language_resb;
    private final ResourceBundle m_territory_resb;
    private final ResourceBundle m_lang_territ_resb;
    private final Locale m_locale;
    private final Locale m_defLocale;

    private OraDisplayLocaleInfo(Locale locale, Locale locale2) {
        this.m_locale = locale;
        this.m_defLocale = locale2;
        this.m_language_resb = OraResourceBundle.getBundle(M_C_LANGUAGE_RESB, locale, locale2, this.getClass().getClassLoader());
        this.m_territory_resb = OraResourceBundle.getBundle(M_C_TERRITORY_RESB, locale, locale2, this.getClass().getClassLoader());
        this.m_lang_territ_resb = OraResourceBundle.getBundle(M_C_LANG_TERRIT_RESB, locale, locale2, this.getClass().getClassLoader());
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public static OraDisplayLocaleInfo getInstance(Locale locale) {
        return OraDisplayLocaleInfo.getInstance(locale, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OraDisplayLocaleInfo getInstance(Locale locale, Locale locale2) {
        OraDisplayLocaleInfo oraDisplayLocaleInfo = null;
        Hashtable hashtable = m_cache;
        synchronized (hashtable) {
            oraDisplayLocaleInfo = (OraDisplayLocaleInfo)m_cache.get(locale);
            if (oraDisplayLocaleInfo == null) {
                oraDisplayLocaleInfo = new OraDisplayLocaleInfo(locale, locale2);
                m_cache.put(locale, oraDisplayLocaleInfo);
            }
        }
        return oraDisplayLocaleInfo;
    }

    public String getDisplayLocale(Locale locale) {
        return this.getDisplayLocale(locale.getLanguage(), locale.getCountry());
    }

    public String getDisplayLocale(String string, String string2) {
        if (string2 != null && !string2.equals("")) {
            try {
                String string3 = this.m_lang_territ_resb.getString(string.toLowerCase());
                String string4 = this.m_territory_resb.getString(string2.toUpperCase());
                Object[] objectArray = new Object[]{string4};
                return MessageFormat.format(string3, objectArray);
            }
            catch (MissingResourceException missingResourceException) {
                return string + " (" + string2 + ")";
            }
            catch (NullPointerException nullPointerException) {
                return "";
            }
        }
        try {
            return this.m_language_resb.getString(string.toLowerCase());
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getDisplayLanguage(Locale locale) {
        try {
            return this.getDisplayLanguage(locale.getLanguage());
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getDisplayLanguage(String string) {
        try {
            return this.m_language_resb.getString(string.toLowerCase());
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getDisplayCountry(Locale locale) {
        try {
            return this.getDisplayCountry(locale.getCountry());
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getDisplayCountry(String string) {
        try {
            return this.m_territory_resb.getString(string.toUpperCase());
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getDisplayTerritory(String string) {
        return this.getDisplayCountry(string);
    }

    public String getDisplayTimeZone(TimeZone timeZone) {
        if (timeZone != null) {
            return this.getDisplayTimeZone(timeZone.getID());
        }
        return this.getDisplayTimeZone("");
    }

    public String getDisplayTimeZone(String string) {
        ResourceBundle resourceBundle = OraResourceBundle.getBundle(M_C_TIMEZONE_RESB, this.m_locale, this.m_defLocale, this.getClass().getClassLoader());
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            int n = TimeZone.getTimeZone(string).getRawOffset() / 1000;
            String string2 = " ";
            if (n > 0) {
                string2 = "+";
            } else if (n < 0) {
                n *= -1;
                string2 = "-";
            }
            int n2 = n / 3600;
            String string3 = "0" + new Integer(n2).toString();
            String string4 = "0" + new Integer((n - n2 * 3600) / 60).toString();
            return "(UTC" + string2 + string3.substring(0, 2) + ":" + string4.substring(0, 2) + ")";
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getDisplayLinguisticSort(String string) {
        ResourceBundle resourceBundle = OraResourceBundle.getBundle(M_C_LINGUISTIC_SORT_RESB, this.m_locale, this.m_defLocale, this.getClass().getClassLoader());
        try {
            return resourceBundle.getString(string.toLowerCase());
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getDisplayCharacterSet(String string) {
        ResourceBundle resourceBundle = OraResourceBundle.getBundle(M_C_CHARACTER_SET_RESB, this.m_locale, this.m_defLocale, this.getClass().getClassLoader());
        try {
            return resourceBundle.getString(string.toUpperCase());
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    public String getDisplayCurrency(String string) {
        ResourceBundle resourceBundle = OraResourceBundle.getBundle(M_C_CURRENCY_RESB, this.m_locale, this.m_defLocale, this.getClass().getClassLoader());
        try {
            return resourceBundle.getString(string.toUpperCase());
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
    }

    static {
        m_cache.put(Locale.ENGLISH, m_english_odli);
    }
}

