/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.model.generic.toplink;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import oracle.adf.model.BindingContext;
import oracle.adf.model.generic.toplink.PersistenceManager;
import oracle.adf.model.generic.toplink.TopLinkDataControl;
import oracle.jbo.JboException;
import oracle.jbo.common.Diagnostic;
import oracle.toplink.sessionbroker.SessionBroker;
import oracle.toplink.sessions.DatabaseSession;
import oracle.toplink.sessions.Session;
import oracle.toplink.sessions.UnitOfWork;

public class TransactionBroker {
    protected static final int CLIENT_SESSION_TYPE = 1;
    protected static final int CLIENT_SESSION_BROKER_TYPE = 2;
    protected static final int SHARED_SESSION_BROKER_TYPE = 3;
    protected static final int SHARED_DATABASE_SESSION_TYPE = 4;
    protected static final int ISOLATED_DATABASE_SESSION_TYPE = 5;
    private Session session;
    private UnitOfWork unitOfWork;
    private PersistenceManager persistenceManager;
    private Collection associatedDataControls;
    private BindingContext applicationBindingContext;
    private int brokerType;
    boolean shouldPerformDeletesFirst;

    protected TransactionBroker(BindingContext bindingContext, Session session, PersistenceManager persistenceManager, int n, boolean bl) {
        this.initialize(bindingContext, session, persistenceManager, n, bl);
    }

    protected void initialize(BindingContext bindingContext, Session session, PersistenceManager persistenceManager, int n, boolean bl) {
        this.associatedDataControls = new Vector();
        this.applicationBindingContext = bindingContext;
        this.session = session;
        this.persistenceManager = persistenceManager;
        this.brokerType = n;
        this.shouldPerformDeletesFirst = bl;
        this.resetUnitOfWork();
    }

    protected synchronized void commitTransaction() {
        Diagnostic.println((String)"TOPLINK ADF: Calling TopLink.commit");
        this.unitOfWork.commitAndResume();
        this.notifyTransactionCommitted();
    }

    protected synchronized void rollbackTransaction() {
        Diagnostic.println((String)"TOPLINK ADF: Calling TopLink.rollback");
        this.unitOfWork.revertAndResume();
        this.notifyTransactionRolledback();
    }

    protected synchronized void resetState() {
        Diagnostic.println((String)"TOPLINK ADF: Calling TopLink.resetState");
        this.resetUnitOfWork();
        this.notifyStateReset();
    }

    protected void notifyTransactionCommitted() {
        Iterator iterator = this.associatedDataControls();
        while (iterator.hasNext()) {
            TopLinkDataControl topLinkDataControl = (TopLinkDataControl)((Object)iterator.next());
            topLinkDataControl.commitPerformed();
        }
    }

    protected void notifyTransactionRolledback() {
        Iterator iterator = this.associatedDataControls();
        while (iterator.hasNext()) {
            TopLinkDataControl topLinkDataControl = (TopLinkDataControl)((Object)iterator.next());
            topLinkDataControl.rollbackPerformed();
        }
    }

    protected void notifyStateReset() {
        Iterator iterator = this.associatedDataControls();
        while (iterator.hasNext()) {
            TopLinkDataControl topLinkDataControl = (TopLinkDataControl)((Object)iterator.next());
            topLinkDataControl.resetStatePerformed();
        }
    }

    protected synchronized void resetTransactionalResources() {
        this.resetUnitOfWork();
        Iterator iterator = this.associatedDataControls();
        while (iterator.hasNext()) {
            TopLinkDataControl topLinkDataControl = (TopLinkDataControl)((Object)iterator.next());
            topLinkDataControl.transactionalResourcesReset();
        }
    }

    protected void resetUnitOfWork() {
        if (this.unitOfWork != null) {
            this.unitOfWork.release();
        }
        this.unitOfWork = this.session.acquireUnitOfWork();
        this.unitOfWork.setShouldPerformDeletesFirst(this.shouldPerformDeletesFirst);
    }

    protected Object registerInTransaction(Object object) {
        return this.unitOfWork.registerObject(object);
    }

    protected Object createNewInstance(Class clazz) {
        return this.unitOfWork.newInstance(clazz);
    }

    protected Object createNewInstance(Class clazz, boolean bl) {
        Object object = this.unitOfWork.newInstance(clazz);
        if (bl) {
            this.unitOfWork.assignSequenceNumber(object);
        }
        return object;
    }

    protected Object deleteObject(Object object) {
        return this.unitOfWork.deleteObject(object);
    }

    protected synchronized void release(TopLinkDataControl topLinkDataControl) {
        this.removeDataControl(topLinkDataControl);
        if (this.associatedDataControls.isEmpty()) {
            Exception exception = null;
            try {
                this.releaseUnitOfWork();
            }
            catch (Exception exception2) {
                exception = exception2;
            }
            try {
                this.releaseSession();
            }
            catch (Exception exception3) {
                exception = exception3;
            }
            this.getPersistenceManager().removeTransactionBroker(this);
            if (exception != null) {
                throw new JboException((Throwable)exception);
            }
        }
    }

    protected void releaseUnitOfWork() {
        this.unitOfWork.release();
        this.unitOfWork = null;
    }

    protected void releaseSession() {
        switch (this.brokerType) {
            case 1: {
                this.session.release();
                break;
            }
            case 2: {
                ((SessionBroker)this.session).releaseClientSessionBroker();
                break;
            }
            case 5: {
                DatabaseSession databaseSession = (DatabaseSession)this.session;
                if (databaseSession.isInTransaction()) {
                    databaseSession.rollbackTransaction();
                }
                databaseSession.logout();
                databaseSession.release();
                break;
            }
        }
        this.session = null;
    }

    protected Object executeReadAllQuery(Class clazz) {
        return this.unitOfWork.readAllObjects(clazz);
    }

    protected Object executeQuery(Class clazz, String string, Vector vector) {
        return this.unitOfWork.executeQuery(string, clazz, vector);
    }

    protected void addDataControl(TopLinkDataControl topLinkDataControl) {
        this.associatedDataControls.add(topLinkDataControl);
    }

    protected void removeDataControl(TopLinkDataControl topLinkDataControl) {
        this.associatedDataControls.remove((Object)topLinkDataControl);
    }

    protected boolean isDataControlRegistered(TopLinkDataControl topLinkDataControl) {
        return this.associatedDataControls.contains((Object)topLinkDataControl);
    }

    protected Iterator associatedDataControls() {
        return this.associatedDataControls.iterator();
    }

    protected PersistenceManager getPersistenceManager() {
        return this.persistenceManager;
    }

    protected BindingContext getApplicationBindingContext() {
        return this.applicationBindingContext;
    }

    protected UnitOfWork getUnitOfWork() {
        return this.unitOfWork;
    }

    protected Session getSession() {
        return this.session;
    }
}

