/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.model.generic.toplink;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import oracle.adf.model.BindingContext;
import oracle.adf.model.generic.toplink.TopLinkADFConstants;
import oracle.adf.model.generic.toplink.TransactionBroker;
import oracle.jbo.JboException;
import oracle.jbo.common.JBOClass;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.helper.ConversionManager;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.sessionbroker.SessionBroker;
import oracle.toplink.sessions.DatabaseSession;
import oracle.toplink.sessions.Project;
import oracle.toplink.threetier.ClientSession;
import oracle.toplink.threetier.ServerSession;
import oracle.toplink.tools.sessionconfiguration.XMLSessionConfigLoader;
import oracle.toplink.tools.sessionmanagement.SessionManager;
import oracle.toplink.tools.workbench.XMLProjectReader;

public class PersistenceManager
implements TopLinkADFConstants {
    private Map sessionsLocationsToSessionManagers;
    private Collection transactionBrokerDescriptors;
    private Collection clientTransactionBrokersHolders;

    PersistenceManager() {
        this.initialize();
    }

    protected void initialize() {
        this.sessionsLocationsToSessionManagers = new HashMap();
        this.transactionBrokerDescriptors = new Vector();
        this.clientTransactionBrokersHolders = new Vector();
        ConversionManager.getDefaultManager().setShouldUseClassLoaderFromCurrentThread(true);
    }

    public synchronized TransactionBroker getTransactionBrokerFor(BindingContext bindingContext, Map map) {
        String string = (String)map.get("DeploymentDescriptorFileName");
        String string2 = (String)map.get("TopLinkSessionsXMLFileName");
        String string3 = (String)map.get("TopLinkSessionName");
        boolean bl = Boolean.valueOf((String)map.get("TopLinkShouldPerformDeletesFirst"));
        this.checkParameters(string, string2, string3);
        TransactionBroker transactionBroker = string != null ? this.getTransactionBroker(bindingContext, string, bl) : this.getTransactionBroker(bindingContext, string2, string3, bl);
        return transactionBroker;
    }

    private void checkParameters(String string, String string2, String string3) {
        if (string == null && string2 == null && string3 == null) {
            throw new JboException("ERROR: No Parameters specified for this Data Control.");
        }
        if (string != null && string2 != null && string3 != null) {
            throw new JboException("ERROR: Ambiguous Parameters. Either the deployment descriptor location OR the sessions.xml and Session name should be specified.");
        }
        if (string == null && (string2 == null || string3 == null)) {
            throw new JboException("ERROR: When using the sessions.xml, both a sessions.xml location and Session name must be specified.");
        }
    }

    synchronized TransactionBroker getTransactionBroker(BindingContext bindingContext, String string, boolean bl) {
        TransactionBroker transactionBroker = this.findTransactionBroker(bindingContext, string);
        if (transactionBroker == null) {
            Project project = XMLProjectReader.read((String)string, (ClassLoader)JBOClass.getCurrentClassLoader());
            DatabaseSession databaseSession = project.createDatabaseSession();
            databaseSession.login();
            transactionBroker = new TransactionBroker(bindingContext, (oracle.toplink.sessions.Session)databaseSession, this, 5, bl);
            this.addTransactionBroker(transactionBroker, string);
        }
        return transactionBroker;
    }

    synchronized TransactionBroker getTransactionBroker(BindingContext bindingContext, String string, String string2, boolean bl) {
        TransactionBroker transactionBroker = this.findTransactionBroker(bindingContext, string, string2);
        if (transactionBroker == null) {
            int n;
            ClientSession clientSession;
            SessionManager sessionManager = this.findSessionManager(string);
            if (sessionManager == null) {
                sessionManager = new SessionManager();
                this.addSessionManager(string, sessionManager);
            }
            Session session = null;
            try {
                session = sessionManager.getSession(string2, true);
            }
            catch (ValidationException validationException) {
                // empty catch block
            }
            if (session == null) {
                session = sessionManager.getSession(new XMLSessionConfigLoader(string), string2, JBOClass.getCurrentClassLoader(), true, true);
            }
            if (session == null) {
                throw new JboException("Problem encountered loading Session named: " + string2 + " from file: " + string);
            }
            if (session.isServerSession()) {
                clientSession = ((ServerSession)session).acquireClientSession();
                n = 1;
            } else if (session.isSessionBroker() && session.isServerSession()) {
                clientSession = ((SessionBroker)session).acquireClientSessionBroker();
                n = 2;
            } else if (session.isSessionBroker()) {
                clientSession = session;
                n = 3;
            } else {
                clientSession = session;
                n = 4;
            }
            transactionBroker = new TransactionBroker(bindingContext, (oracle.toplink.sessions.Session)clientSession, this, n, bl);
            this.addTransactionBroker(transactionBroker, string, string2, true);
            this.getClientTransactionBrokersHolder(string, string2).addTransactionBroker(transactionBroker);
        }
        return transactionBroker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransactionBroker findTransactionBroker(BindingContext bindingContext, String string) {
        Collection collection = this.transactionBrokerDescriptors;
        synchronized (collection) {
            Iterator iterator = this.transactionBrokerDescriptors.iterator();
            while (iterator.hasNext()) {
                TransactionBrokerDescriptor transactionBrokerDescriptor = (TransactionBrokerDescriptor)iterator.next();
                if (!transactionBrokerDescriptor.isBrokerFor(bindingContext, string)) continue;
                TransactionBroker transactionBroker = transactionBrokerDescriptor.getTransactionBroker();
                return transactionBroker;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransactionBroker findTransactionBroker(BindingContext bindingContext, String string, String string2) {
        Collection collection = this.transactionBrokerDescriptors;
        synchronized (collection) {
            Iterator iterator = this.transactionBrokerDescriptors.iterator();
            while (iterator.hasNext()) {
                TransactionBrokerDescriptor transactionBrokerDescriptor = (TransactionBrokerDescriptor)iterator.next();
                if (!transactionBrokerDescriptor.isBrokerFor(bindingContext, string, string2)) continue;
                TransactionBroker transactionBroker = transactionBrokerDescriptor.getTransactionBroker();
                return transactionBroker;
            }
        }
        return null;
    }

    private void addTransactionBroker(TransactionBroker transactionBroker, String string) {
        TransactionBrokerDescriptor transactionBrokerDescriptor = new TransactionBrokerDescriptor(transactionBroker, string);
        this.transactionBrokerDescriptors.add(transactionBrokerDescriptor);
    }

    private void addTransactionBroker(TransactionBroker transactionBroker, String string, String string2, boolean bl) {
        TransactionBrokerDescriptor transactionBrokerDescriptor = new TransactionBrokerDescriptor(transactionBroker, string, string2, bl);
        this.transactionBrokerDescriptors.add(transactionBrokerDescriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void removeTransactionBroker(TransactionBroker transactionBroker) {
        TransactionBrokerDescriptor transactionBrokerDescriptor = null;
        Collection collection = this.transactionBrokerDescriptors;
        synchronized (collection) {
            Iterator iterator = this.transactionBrokerDescriptors.iterator();
            while (iterator.hasNext()) {
                transactionBrokerDescriptor = (TransactionBrokerDescriptor)iterator.next();
                if (!transactionBrokerDescriptor.isBrokerFor(transactionBroker)) continue;
                iterator.remove();
                break;
            }
        }
        this.removeClientTransactionBrokersHolderIfNecessary(transactionBrokerDescriptor);
    }

    private synchronized void removeClientTransactionBrokersHolderIfNecessary(TransactionBrokerDescriptor transactionBrokerDescriptor) {
        ClientTransactionBrokersHolder clientTransactionBrokersHolder;
        if (transactionBrokerDescriptor == null) {
            return;
        }
        if (transactionBrokerDescriptor.isThreeTierBroker() && (clientTransactionBrokersHolder = this.findClientTransactionBrokersHolder(transactionBrokerDescriptor.getFileLocation(), transactionBrokerDescriptor.getSessionName())) != null) {
            clientTransactionBrokersHolder.removeTransactionBroker(transactionBrokerDescriptor.getTransactionBroker());
            if (!clientTransactionBrokersHolder.hasTransactionBrokers()) {
                this.removeClientTransactionBrokersHolder(clientTransactionBrokersHolder);
                SessionManager sessionManager = this.findSessionManager(clientTransactionBrokersHolder.getSessionsXMLLocation());
                if (sessionManager != null) {
                    sessionManager.destroySession(clientTransactionBrokersHolder.getSessionName());
                    if (sessionManager.getSessions().isEmpty()) {
                        this.removeSessionManager(clientTransactionBrokersHolder.getSessionsXMLLocation());
                    }
                }
            }
        }
    }

    private ClientTransactionBrokersHolder getClientTransactionBrokersHolder(String string, String string2) {
        ClientTransactionBrokersHolder clientTransactionBrokersHolder = this.findClientTransactionBrokersHolder(string, string2);
        if (clientTransactionBrokersHolder == null) {
            clientTransactionBrokersHolder = new ClientTransactionBrokersHolder(string, string2);
            this.addClientTransactionBrokersHolder(clientTransactionBrokersHolder);
        }
        return clientTransactionBrokersHolder;
    }

    private ClientTransactionBrokersHolder findClientTransactionBrokersHolder(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        Iterator iterator = this.clientTransactionBrokersHolderCopy();
        while (iterator.hasNext()) {
            ClientTransactionBrokersHolder clientTransactionBrokersHolder = (ClientTransactionBrokersHolder)iterator.next();
            if (!clientTransactionBrokersHolder.getSessionsXMLLocation().equals(string) || !clientTransactionBrokersHolder.getSessionName().equals(string2)) continue;
            return clientTransactionBrokersHolder;
        }
        return null;
    }

    private synchronized void addClientTransactionBrokersHolder(ClientTransactionBrokersHolder clientTransactionBrokersHolder) {
        this.clientTransactionBrokersHolders.add(clientTransactionBrokersHolder);
    }

    private synchronized void removeClientTransactionBrokersHolder(ClientTransactionBrokersHolder clientTransactionBrokersHolder) {
        this.clientTransactionBrokersHolders.remove(clientTransactionBrokersHolder);
    }

    private Iterator clientTransactionBrokersHolderCopy() {
        return new ArrayList(this.clientTransactionBrokersHolders).iterator();
    }

    private void addSessionManager(String string, SessionManager sessionManager) {
        this.sessionsLocationsToSessionManagers.put(string, sessionManager);
    }

    private SessionManager findSessionManager(String string) {
        return (SessionManager)this.sessionsLocationsToSessionManagers.get(string);
    }

    private void removeSessionManager(String string) {
        this.sessionsLocationsToSessionManagers.remove(string);
    }

    private class ClientTransactionBrokersHolder {
        private Collection clientTransactionBrokerDescriptors = new Vector();
        private String sessionsXMLLocation;
        private String sessionName;

        private ClientTransactionBrokersHolder(String string, String string2) {
            this.sessionsXMLLocation = string;
            this.sessionName = string2;
        }

        private void addTransactionBroker(TransactionBroker transactionBroker) {
            this.clientTransactionBrokerDescriptors.add(transactionBroker);
        }

        private void removeTransactionBroker(TransactionBroker transactionBroker) {
            this.clientTransactionBrokerDescriptors.remove(transactionBroker);
        }

        private boolean containsTransactionBroker(TransactionBroker transactionBroker) {
            return this.clientTransactionBrokerDescriptors.contains(transactionBroker);
        }

        private boolean hasTransactionBrokers() {
            return this.clientTransactionBrokerDescriptors.isEmpty() ^ true;
        }

        private String getSessionsXMLLocation() {
            return this.sessionsXMLLocation;
        }

        private String getSessionName() {
            return this.sessionName;
        }
    }

    private class TransactionBrokerDescriptor {
        private String fileLocation;
        private String sessionName;
        private TransactionBroker transactionBroker;
        private boolean isThreeTier;

        private /* synthetic */ void $init$() {
            this.isThreeTier = false;
        }

        private TransactionBrokerDescriptor(TransactionBroker transactionBroker, String string, String string2, boolean bl) {
            this(transactionBroker, string, string2);
            this.isThreeTier = bl;
        }

        private TransactionBrokerDescriptor(TransactionBroker transactionBroker, String string) {
            this.$init$();
            this.fileLocation = string;
            this.transactionBroker = transactionBroker;
        }

        private TransactionBrokerDescriptor(TransactionBroker transactionBroker, String string, String string2) {
            this(transactionBroker, string);
            this.sessionName = string2;
        }

        private boolean isBrokerFor(BindingContext bindingContext, String string, String string2) {
            return string.equalsIgnoreCase(this.fileLocation) && string2.equals(this.sessionName) && this.transactionBroker.getApplicationBindingContext() == bindingContext;
        }

        private boolean isBrokerFor(BindingContext bindingContext, String string) {
            return this.sessionName == null && string.equalsIgnoreCase(this.fileLocation) && this.transactionBroker.getApplicationBindingContext() == bindingContext;
        }

        private boolean isBrokerFor(TransactionBroker transactionBroker) {
            return transactionBroker == this.transactionBroker;
        }

        private TransactionBroker getTransactionBroker() {
            return this.transactionBroker;
        }

        private String getFileLocation() {
            return this.fileLocation;
        }

        private String getSessionName() {
            return this.sessionName;
        }

        private boolean isThreeTierBroker() {
            return this.isThreeTier;
        }
    }
}

