/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.io.Serializable;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.ColorObj;

public class BorderObj
implements Serializable {
    static final int DOTTED_SIZE = 2;
    private ColorObj m_ColorObj = new ColorObj();

    public BorderObj() {
    }

    public BorderObj(Color color) {
        this.m_ColorObj.setColor(color);
    }

    public BorderObj(BorderObj borderObj) {
        this.copy(borderObj);
    }

    public void copy(BorderObj borderObj) {
        this.m_ColorObj.copy(borderObj.m_ColorObj);
    }

    public Color getColor() {
        return this.m_ColorObj.getColor();
    }

    public void paint(Graphics graphics, Point point, Point point2) {
        graphics.setColor(this.m_ColorObj.getColor());
        graphics.drawLine(point.x, point.y, point2.x, point2.y);
    }

    public void paint(Graphics graphics, Perspective perspective, Polygon polygon) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(new BasicStroke(1.0f, 1, 1));
        graphics2D.setColor(this.m_ColorObj.getColor());
        VC vC = perspective.getVC();
        graphics2D.drawPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    public void paint(Graphics graphics, Perspective perspective, Area area) {
        graphics.setColor(this.m_ColorObj.getColor());
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (Perspective.compareVersions(Perspective.m_JavaVersion, "1.4.0") == -1 || perspective.getPrimitiveAntialiasing()) {
            graphics2D.draw(area);
        } else {
            graphics2D.setStroke(new BasicStroke(1.01f));
            graphics2D.draw(area);
            graphics2D.setStroke(new BasicStroke(1.0f));
        }
    }

    public void paint(Graphics graphics, Perspective perspective, Arc2D arc2D) {
        graphics.setColor(this.m_ColorObj.getColor());
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (Perspective.compareVersions(Perspective.m_JavaVersion, "1.4.0") == -1 || perspective.getPrimitiveAntialiasing()) {
            graphics2D.draw(arc2D);
        } else {
            graphics2D.setStroke(new BasicStroke(1.01f));
            graphics2D.draw(arc2D);
            graphics2D.setStroke(new BasicStroke(1.0f));
        }
    }

    public void paint(Graphics graphics, Perspective perspective, GeneralPath generalPath) {
        graphics.setColor(this.m_ColorObj.getColor());
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.draw(generalPath);
    }

    public void paint(Graphics graphics, Polygon polygon) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(new BasicStroke(1.0f, 1, 1));
        graphics2D.setColor(this.m_ColorObj.getColor());
        graphics2D.drawPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    public void paint(Graphics graphics, Rectangle rectangle) {
        graphics.setColor(this.m_ColorObj.getColor());
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void paint(Graphics graphics, Rectangle rectangle, boolean bl) {
        graphics.setColor(this.m_ColorObj.getColor());
        int n = rectangle.x;
        int n2 = rectangle.x + rectangle.width - 2;
        while (n <= n2) {
            graphics.drawLine(n, rectangle.y, n + 2, rectangle.y);
            n += 4;
        }
        n = rectangle.x;
        while (n <= n2) {
            graphics.drawLine(n, rectangle.y + rectangle.height, n + 2, rectangle.y + rectangle.height);
            n += 4;
        }
        int n3 = rectangle.y;
        int n4 = rectangle.y + rectangle.height - 2;
        while (n3 <= n4) {
            graphics.drawLine(rectangle.x, n3, rectangle.x, n3 + 2);
            n3 += 4;
        }
        n3 = rectangle.y;
        n4 = rectangle.y + rectangle.height - 2;
        while (n3 <= n4) {
            graphics.drawLine(rectangle.x + rectangle.width, n3, rectangle.x + rectangle.width, n3 + 2);
            n3 += 4;
        }
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x + 1, rectangle.y);
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + 1);
        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x, rectangle.y + rectangle.height);
        graphics.drawLine(rectangle.x, rectangle.y + rectangle.height, rectangle.x + 1, rectangle.y + rectangle.height);
        graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        graphics.drawLine(rectangle.x + rectangle.width, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width, rectangle.y);
        graphics.drawLine(rectangle.x + rectangle.width, rectangle.y, rectangle.x + rectangle.width, rectangle.y + 1);
    }

    public void paintOval(Graphics graphics, Rectangle rectangle) {
        graphics.setColor(this.m_ColorObj.getColor());
        graphics.drawOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setColor(Color color) {
        this.m_ColorObj.setColor(color);
    }

    public void paint(Graphics graphics, Point point, Point point2, int n) {
        graphics.setColor(this.m_ColorObj.getColor());
        graphics.drawLine(point.x, point.y, point2.x, point2.y);
        graphics.fillRect(point.x, point.y, point2.x - point2.y, n);
    }

    public void paintOval(Graphics graphics, Rectangle rectangle, int n, int n2) {
        graphics.setColor(this.m_ColorObj.getColor());
        graphics.drawOval(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }
}

