/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.io.Serializable;
import java.util.Vector;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.MarkerTemplate;

public class MarkerTemplateArray
implements Serializable {
    Vector m_vectMarkerTemplate = new Vector(0);
    public static final int SQUARE_MARKERTEMPLATE_INDEX = 1;
    public static final MarkerTemplate PRESET_NULL = new MarkerTemplate();
    public static final MarkerTemplate PRESET_SQUARE = new MarkerTemplate(MarkerTemplate.MARKER_SQUARE);
    public static final MarkerTemplate PRESET_CIRCLE = new MarkerTemplate(MarkerTemplate.MARKER_SQUARE, true);
    public static final MarkerTemplate PRESET_DIAMOND = new MarkerTemplate(MarkerTemplate.MARKER_SQUARE, 3);
    public static final MarkerTemplate PRESET_PLUS = new MarkerTemplate(MarkerTemplate.MARKER_SQUARE, 5);
    public static final MarkerTemplate PRESET_TRIANGLE_DN = new MarkerTemplate(MarkerTemplate.MARKER_SQUARE, 6);
    public static final MarkerTemplate PRESET_TRIANGLE_UP = new MarkerTemplate(MarkerTemplate.MARKER_SQUARE, 7);
    public static final MarkerTemplate PRESET_DEPTHCIRCLE = new MarkerTemplate(MarkerTemplate.MARKER_SQUARE, true);
    public static final MarkerTemplate PRESET_BUBBLE = new MarkerTemplate(MarkerTemplate.MARKER_SQUARE, 9);

    public MarkerTemplateArray() {
        this.m_vectMarkerTemplate.addElement(PRESET_NULL);
        this.m_vectMarkerTemplate.addElement(PRESET_SQUARE);
        this.m_vectMarkerTemplate.addElement(PRESET_CIRCLE);
        this.m_vectMarkerTemplate.addElement(PRESET_DIAMOND);
        this.m_vectMarkerTemplate.addElement(PRESET_PLUS);
        this.m_vectMarkerTemplate.addElement(PRESET_TRIANGLE_DN);
        this.m_vectMarkerTemplate.addElement(PRESET_TRIANGLE_UP);
    }

    public int getLoopedMarkerShape(int n) {
        int n2 = this.findNextTemplateSlot() - 1;
        int n3 = n % n2;
        return ++n3;
    }

    public MarkerTemplate getMarkerTemplate(int n) {
        MarkerTemplate markerTemplate = null;
        markerTemplate = n >= 0 && n < this.m_vectMarkerTemplate.size() ? (MarkerTemplate)this.m_vectMarkerTemplate.elementAt(n) : (MarkerTemplate)this.m_vectMarkerTemplate.elementAt(1);
        return markerTemplate;
    }

    protected int findNextTemplateSlot() {
        int n = this.m_vectMarkerTemplate.size();
        return n;
    }

    public int registerMarkerTemplate(MarkerTemplate markerTemplate) throws AssertionException {
        this.checkValidMarkerTemplate(markerTemplate);
        int n = this.findNextTemplateSlot();
        this.m_vectMarkerTemplate.addElement(markerTemplate);
        return n;
    }

    public void setMarkerTemplate(int n, MarkerTemplate markerTemplate) throws AssertionException {
        if (n < 0) {
            throw new AssertionException(String.valueOf(String.valueOf("Can't set marker template; bad value for index: ")) + n);
        }
        this.checkValidMarkerTemplate(markerTemplate);
        if (n >= this.m_vectMarkerTemplate.size()) {
            this.m_vectMarkerTemplate.addElement(markerTemplate);
        } else {
            this.m_vectMarkerTemplate.setElementAt(markerTemplate, n);
        }
    }

    protected void checkValidMarkerTemplate(MarkerTemplate markerTemplate) {
        if (markerTemplate == null) {
            throw new AssertionException("Can't register marker template is null");
        }
        if (!markerTemplate.isValid()) {
            throw new AssertionException("Can't register marker template type is invalid or polygon bounds > 900");
        }
    }
}

