/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.Axis2DObj;
import oracle.dss.graph.pfj.AxisTemplate;
import oracle.dss.graph.pfj.DataFormat;
import oracle.dss.graph.pfj.DataItem;
import oracle.dss.graph.pfj.DatumObj;
import oracle.dss.graph.pfj.GroupsEnumerator;
import oracle.dss.graph.pfj.JChart_2D_Standard;
import oracle.dss.graph.pfj.Line;
import oracle.dss.graph.pfj.MarkerObj;
import oracle.dss.graph.pfj.MarkerTemplate;
import oracle.dss.graph.pfj.MarkerTemplateArray;
import oracle.dss.graph.pfj.MinMaxObj;
import oracle.dss.graph.pfj.ParetoFrameObj;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.RelativeAxisObj;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.TDGNumberFormat;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.DetLine;
import oracle.dss.graph.pfj.draw.DetPolygon;
import oracle.dss.graph.pfj.draw.DetRect;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.SimpleBlackBoxObj;

public class JChart_2D_Pareto
extends JChart_2D_Standard {
    public static final double DEPTH_FACTOR = 12.0;
    public static final double UNSHADED = 1.0;
    public static final double SHADING_FRONT = 1.0;
    public static final double SHADING_TOP = 0.8;
    public static final double SHADING_SIDE = 0.6;
    public static final double SHADING_BOTTOM = 0.4;
    public static final boolean DRAW_NEG_SERIES = true;
    public static final boolean DRAW_POS_SERIES = false;
    boolean m_bFromZero;
    boolean m_bBipolar;
    boolean m_bDualY;
    int m_nLineThick;
    Point[] m_seriesBackOffsets;
    Point[] m_seriesFrontOffsets;
    double m_fThreshholdPercent = 0.2;
    int[] m_nThreshold;
    double[] m_fThresholdValue;
    public boolean m_bParetoPlotFromLeft;
    public boolean m_bParetoThresholdEnabled;
    boolean m_bFirstPassWithDepth;
    public boolean m_bDebugPrint;
    int m_nConverge = 250;

    public void calc() {
        boolean bl;
        super.calc();
        this.m_bFirstPassWithDepth = true;
        double d = this.m_Perspective.getParetoDisplayThreshold();
        if (d < 1.0) {
            this.m_bParetoThresholdEnabled = false;
        } else {
            this.m_fThreshholdPercent = d / 100.0;
            this.m_bParetoThresholdEnabled = true;
        }
        boolean bl2 = bl = this.m_bHorz && this.m_nDepthAngle > 90;
        if (this.wantDepthEffect()) {
            this.m_seriesBackOffsets = new Point[this.m_nTotalSeries];
            this.m_seriesFrontOffsets = new Point[this.m_nTotalSeries];
            SeriesEnumerator seriesEnumerator = this.getResetSeriesEnumerator();
            while (seriesEnumerator.hasMoreElements()) {
                int n = seriesEnumerator.nextSeries();
                PfjAssert.pfjAssert(n >= 0 && n < this.m_nTotalSeries);
                this.m_seriesBackOffsets[n] = this.calcSeriesOffset(n, false);
                this.m_seriesFrontOffsets[n] = this.calcSeriesOffset(n, true);
            }
        }
        this.calcParetoData();
        if (this.m_bParetoThresholdEnabled) {
            this.findThresholdValues();
        }
        this.calcBarOrdinalCoords();
        if (this.m_bParetoThresholdEnabled) {
            this.makeRects();
        }
        this.drawBarRisers();
        this.drawLineRisers();
        if (this.m_bDataTextDisplay) {
            this.drawDataValues();
        }
        this.fireInapropriateDataEvent();
    }

    protected void calcDataAbsolute() {
        SeriesEnumerator seriesEnumerator = this.getResetSeriesEnumerator();
        GroupsEnumerator groupsEnumerator = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        double d = 0.0;
        int n = this.calcRisersPerPixel();
        boolean bl = this.m_Perspective.isNumberFormatCallBack();
        int n2 = this.m_Perspective.getDataTextFormat();
        String string = this.m_Perspective.getDataTextFormatPattern();
        this.m_numYCoords = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_dataOK = new boolean[this.m_nTotalSeries][this.m_nTotalGroups];
        if (this.m_bDataTextDisplay) {
            this.m_DataLabel = new String[this.m_nTotalSeries][this.m_nTotalGroups];
        }
        int n3 = this.m_Perspective.getDisplayParetoSeries();
        groupsEnumerator.reset();
        while (groupsEnumerator.hasMoreElements()) {
            int n4 = groupsEnumerator.nextGroup();
            this.m_dataOK[n3][n4] = true;
            RelativeAxisObj relativeAxisObj = this.whichAxisForSeries(n3, null);
            if (relativeAxisObj == null) continue;
            DatumObj datumObj = this.getDataValue(n3, n4, DataItem.DI_GENERAL);
            d = datumObj.m_fValue;
            if (!datumObj.m_bOK) {
                this.m_dataOK[n3][n4] = false;
            }
            if (d < 0.0) {
                this.m_negativeVal = true;
            }
            if (d <= 0.0 && relativeAxisObj.isLogScale()) {
                this.m_dataOK[n3][n4] = false;
                d = 0.0;
            }
            if (this.isIgnoredOffScale(relativeAxisObj, d)) {
                this.m_dataOK[n3][n4] = false;
                d = 0.0;
            }
            if (d == 0.0 && datumObj.m_bOK) {
                this.m_zeroVal = true;
            }
            if (d > 0.0) {
                this.m_positiveVal = true;
            }
            d = Math.abs(d);
            this.m_numYCoords[n3][n4] = (int)relativeAxisObj.getValueCoord(d);
            if (!this.m_bDataTextDisplay) continue;
            if (bl) {
                int n5 = this.axisAssignedToSeries(n3, DataItem.DI_GENERAL);
                this.m_Perspective.getNumberFormatCallBack().setState(3, n3, n4, n5, -3);
                this.m_DataLabel[n3][n4] = this.m_Perspective.getNumberFormatCallBack().toString(d);
                continue;
            }
            this.m_DataLabel[n3][n4] = TDGNumberFormat.toString(this.m_Perspective, n2, d, string);
        }
    }

    public Point calcSeriesOffset(int n, boolean bl) {
        Point point;
        if (bl) {
            double d = this.calcFrontOffset(this.m_seriesPlanes[n], this.m_nDepthPlanes);
            point = this.m_Frame.getDepthOffset(d);
        } else {
            double d = this.calcBackOffset(this.m_seriesPlanes[n], this.m_nDepthPlanes);
            point = this.m_Frame.getDepthOffset(d);
        }
        return point;
    }

    protected void copyParams() {
        super.copyParams();
        this.m_bFromZero = this.m_gt.isWaterfall() ? false : this.m_Perspective.getScaleFromZero();
        this.m_bBipolar = this.m_gt.isBipolar();
        this.m_bDualY = this.m_gt.isDualY();
        this.m_nLineThick = this.m_Perspective.getDataLineThickness();
    }

    private void drawAxisBarRisersAbsolute(boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6 = bl5 = this.m_nDepthAngle > 90;
        if (this.m_bHorz) {
            bl4 = true;
            bl3 = true;
        } else {
            bl4 = bl5;
            bl3 = bl5;
        }
        boolean bl7 = !bl3;
        boolean bl8 = !bl4;
        SeriesEnumerator seriesEnumerator = this.getResetSeriesEnumerator(bl7);
        GroupsEnumerator groupsEnumerator = new GroupsEnumerator(this.m_Perspective, this.m_Access, bl8);
        int n = seriesEnumerator.getFirstSeries();
        int n2 = seriesEnumerator.getLastSeries();
        int n3 = groupsEnumerator.getFirstGroup();
        while (groupsEnumerator.hasMoreElements()) {
            int n4;
            RelativeAxisObj relativeAxisObj;
            int n5;
            int n6 = groupsEnumerator.nextGroup();
            PfjAssert.pfjAssert(n6 >= 0 && n6 < this.m_nTotalGroups);
            if (bl) {
                seriesEnumerator.reset();
                n5 = this.m_Perspective.getDisplayParetoSeries();
                PfjAssert.pfjAssert(n5 >= 0 && n5 < this.m_nTotalSeries);
                relativeAxisObj = this.whichAxisForSeries(n5, null);
                if (relativeAxisObj != null) {
                    n4 = relativeAxisObj.getAxisObjID();
                    if (n4 != 0 && this.m_bBipolar) continue;
                    this.drawOneBarRiser(n5, n6, seriesEnumerator, groupsEnumerator);
                }
            }
            if (!bl2 || !this.m_bBipolar) continue;
            seriesEnumerator.reset();
            while (seriesEnumerator.hasMoreElements()) {
                n5 = seriesEnumerator.nextSeries();
                PfjAssert.pfjAssert(n5 >= 0 && n5 < this.m_nTotalSeries);
                relativeAxisObj = this.whichAxisForSeries(n5, null);
                if (relativeAxisObj == null || (n4 = relativeAxisObj.getAxisObjID()) != 1 && this.m_bBipolar) continue;
                this.drawOneBarRiser(n5, n6, seriesEnumerator, groupsEnumerator);
            }
        }
    }

    private void drawAxisLineRisers(int n) {
        boolean bl;
        boolean bl2 = bl = this.m_nDepthAngle > 90;
        if (this.m_bParetoThresholdEnabled) {
            bl = false;
        }
        boolean bl3 = this.m_bHorz || bl;
        boolean bl4 = !bl3;
        boolean bl5 = true;
        SeriesEnumerator seriesEnumerator = this.getResetSeriesEnumerator(bl5);
        GroupsEnumerator groupsEnumerator = new GroupsEnumerator(this.m_Perspective, this.m_Access, bl4);
        int n2 = this.m_Perspective.getDisplayParetoSeries();
        RelativeAxisObj relativeAxisObj = this.whichAxisForSeries(n2, null);
        if (relativeAxisObj != null) {
            int n3 = relativeAxisObj.getAxisObjID();
            if (n3 != n && (!this.m_bAbsolute || this.m_bBipolar)) {
                return;
            }
            if (this.m_Perspective.getConnectLineMarkers()) {
                groupsEnumerator.reset();
                while (groupsEnumerator.hasMoreElements()) {
                    int n4 = groupsEnumerator.nextGroup();
                    PfjAssert.pfjAssert(n4 >= 0 && n4 < this.m_nTotalGroups);
                    if (!bl4 && n4 == groupsEnumerator.getFirstGroup()) continue;
                    this.drawOneLineRiser(n2, n4, groupsEnumerator);
                }
            }
            if (this.m_nDepthRadius > 0) {
                if (this.m_bMarkerDisplay) {
                    this.drawMarkersWithDepth(n2);
                } else if (!this.m_bMarkerDisplay && this.m_Perspective.getTransparentMarkers()) {
                    this.drawTransparentMarkersWithDepth(n2);
                }
            }
        }
    }

    private void drawBarGroup(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, GroupsEnumerator groupsEnumerator) {
        int n2 = 0;
        boolean bl5 = !bl3;
        int n3 = groupsEnumerator.getFirstGroup();
        SeriesEnumerator seriesEnumerator = this.getResetSeriesEnumerator(bl5);
        int n4 = seriesEnumerator.getFirstSeries();
        int n5 = seriesEnumerator.getLastSeries();
        while (seriesEnumerator.hasMoreElements()) {
            boolean bl6;
            int n6 = seriesEnumerator.nextSeries();
            n6 = this.m_Perspective.getDisplayParetoSeries();
            PfjAssert.pfjAssert(n6 >= 0 && n6 < this.m_nTotalSeries);
            RelativeAxisObj relativeAxisObj = this.whichAxisForSeries(n6, null);
            if (relativeAxisObj == null) continue;
            int n7 = (int)relativeAxisObj.getValueCoord(0.0);
            boolean bl7 = relativeAxisObj.isDescending();
            boolean bl8 = bl7 ? this.m_numYCoords[n6][n] > n7 : (bl6 = this.m_numYCoords[n6][n] < n7);
            if (bl6 != bl4) continue;
            n2 = relativeAxisObj.getAxisObjID();
            if (!bl && n2 == 0 || !bl2 && n2 == 1) continue;
            this.drawOneBarRiser(n6, n, seriesEnumerator, groupsEnumerator);
        }
    }

    private void drawBarRisers() {
        if (this.m_bBipolar) {
            this.drawAxisBarRisersAbsolute(false, true);
            this.drawAxisBarRisersAbsolute(true, false);
        } else if (this.m_bDualY) {
            this.drawAxisBarRisersAbsolute(true, true);
        } else {
            this.drawAxisBarRisersAbsolute(true, false);
        }
    }

    private void drawLineRisers() {
        if (this.wantDepthEffect()) {
            this.drawLinesWithDepth();
        } else {
            if (this.m_Perspective.getConnectLineMarkers()) {
                this.drawLines(false);
            }
            if (this.m_bMarkerDisplay) {
                this.drawMarkers();
            }
            if (!this.m_bMarkerDisplay && this.m_Perspective.getTransparentMarkers()) {
                this.drawTransparentMarkers();
            }
        }
    }

    protected void drawLinesWithDepth() {
        if (this.m_bBipolar) {
            this.drawAxisLineRisers(1);
            this.drawAxisLineRisers(0);
        } else if (this.m_bDualY) {
            this.drawAxisLineRisers(0);
            this.drawAxisLineRisers(1);
        } else {
            this.drawAxisLineRisers(0);
        }
    }

    private void drawOneBarRiser(int n, int n2, SeriesEnumerator seriesEnumerator, GroupsEnumerator groupsEnumerator) {
        int n3 = this.m_numYCoords[n][n2];
        int n4 = seriesEnumerator.getFirstSeries();
        int n5 = seriesEnumerator.getLastSeries();
        int n6 = groupsEnumerator.getFirstGroup();
        int n7 = groupsEnumerator.getLastGroup();
        if (!this.m_dataOK[n][n2]) {
            return;
        }
        Axis2DObj axis2DObj = (Axis2DObj)this.whichAxisForSeries(n, null);
        if (axis2DObj != null) {
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            int n14 = (int)axis2DObj.getValueCoord(0.0);
            boolean bl = axis2DObj.isDescending();
            BlackBoxIF blackBoxIF = this.assignSeriesColor(n, n2);
            BlackBoxIF blackBoxIF2 = this.getMissingDataBlackBox(n, n2);
            if (blackBoxIF2 == null) {
                blackBoxIF2 = blackBoxIF;
            }
            boolean bl2 = bl ? n3 > n14 : n3 < n14;
            int n15 = this.prevSeriesForAxis(n, n2, axis2DObj, bl2);
            boolean bl3 = this.wantRisersFromZero(axis2DObj);
            int n16 = this.m_bAbsolute || n15 == -2 ? (bl3 ? n14 : (int)axis2DObj.getBaseCoord()) : this.m_numYCoords[n15][n2];
            if (bl3) {
                n13 = bl != bl2 ? n3 : n16;
                n12 = bl != bl2 ? n16 : n3;
            } else {
                n13 = bl ? n3 : n16;
                int n17 = n12 = bl ? n16 : n3;
            }
            if (this.m_bHorz) {
                n11 = n13;
                n10 = n12;
                n9 = this.m_ordCoords[n][n2] - this.m_barThickCoord / 2;
                n8 = n9 + this.m_barThickCoord;
            } else {
                n9 = n13;
                n8 = n12;
                n11 = this.m_ordCoords[n][n2] - this.m_barThickCoord / 2;
                n10 = n11 + this.m_barThickCoord;
            }
            Rectangle rectangle = new Rectangle(n11, n9, n10 - n11, n8 - n9);
            if (this.wantDepthEffect() && this.m_Frame != null) {
                this.drawTwoHalfDBarRiser(n, n2, rectangle, blackBoxIF2);
            } else {
                IdentObj identObj = new IdentObj(277, n, n2);
                new DetRect(this.m_Detectiv, identObj, rectangle, blackBoxIF2, this.m_rClip);
            }
        }
    }

    private void drawTwoHalfDBarRiser(int n, int n2, Rectangle rectangle, BlackBoxIF blackBoxIF) {
        double d;
        Polygon polygon;
        Point point = this.m_seriesBackOffsets[n];
        Point point2 = this.m_seriesFrontOffsets[n];
        rectangle.x -= point2.x;
        rectangle.y -= point2.y;
        if (this.m_nDepthAngle != 90) {
            int n3 = this.m_nDepthAngle > 90 ? rectangle.x : rectangle.x + rectangle.width;
            polygon = new Polygon();
            polygon.addPoint(n3, rectangle.y);
            polygon.addPoint(n3, rectangle.y + rectangle.height);
            polygon.addPoint(n3 + (point2.x - point.x), rectangle.y + rectangle.height + (point2.y - point.y));
            polygon.addPoint(n3 + (point2.x - point.x), rectangle.y + (point2.y - point.y));
            polygon.addPoint(n3, rectangle.y);
            d = this.m_bColorAutoshadeRisers ? 0.6 : 1.0;
            IdentObj identObj = new IdentObj(312, n, n2);
            new DetPolygon(this.m_Detectiv, identObj, polygon, blackBoxIF, d);
        }
        if (this.m_nDepthAngle != 0 && this.m_nDepthAngle != 180) {
            polygon = new Polygon();
            polygon.addPoint(rectangle.x, rectangle.y + rectangle.height);
            polygon.addPoint(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
            polygon.addPoint(rectangle.x + rectangle.width + (point2.x - point.x), rectangle.y + rectangle.height + (point2.y - point.y));
            polygon.addPoint(rectangle.x + (point2.x - point.x), rectangle.y + rectangle.height + (point2.y - point.y));
            polygon.addPoint(rectangle.x, rectangle.y + rectangle.height);
            d = 0.8;
            IdentObj identObj = new IdentObj(313, n, n2);
            new DetPolygon(this.m_Detectiv, identObj, polygon, blackBoxIF, d);
        }
        IdentObj identObj = new IdentObj(277, n, n2);
        if (this.m_bColorAutoshadeRisers) {
            d = 1.0;
            polygon = new Polygon();
            polygon.addPoint(rectangle.x, rectangle.y);
            polygon.addPoint(rectangle.x + rectangle.width, rectangle.y);
            polygon.addPoint(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
            polygon.addPoint(rectangle.x, rectangle.y + rectangle.height);
            polygon.addPoint(rectangle.x, rectangle.y);
            new DetPolygon(this.m_Detectiv, identObj, polygon, blackBoxIF, d);
        } else {
            new DetRect(this.m_Detectiv, identObj, rectangle, blackBoxIF, null);
        }
    }

    private void drawOneLineRiser(int n, int n2, GroupsEnumerator groupsEnumerator) {
        BlackBoxIF blackBoxIF = null;
        BlackBoxIF blackBoxIF2 = null;
        BlackBoxIF blackBoxIF3 = null;
        Point point = null;
        Point point2 = null;
        double d = 1.0;
        int n3 = this.m_numYCoords[n][n2];
        int n4 = groupsEnumerator.getFirstGroup();
        int n5 = groupsEnumerator.getLastGroup();
        int n6 = groupsEnumerator.peekAtGroupBefore(n2);
        int n7 = groupsEnumerator.peekAtGroupAfter(n2);
        int n8 = groupsEnumerator.peekAtGroupAfter(n7);
        int n9 = groupsEnumerator.peekAtGroupBefore(n6);
        boolean bl = this.m_nDepthAngle > 90;
        boolean bl2 = n4 <= n5;
        PfjAssert.pfjAssert(n4 >= 0 && n5 >= 0 && n2 >= 0 && n2 < this.m_nTotalGroups);
        if (!this.m_bParetoThresholdEnabled && (bl2 ? n7 == -1 : n6 == -1)) {
            return;
        }
        if (this.m_nDepthRadius <= 0) {
            throw new AssertionException("Can't draw 2.5D lines without positive DepthRadius");
        }
        if (this.m_Frame == null) {
            throw new AssertionException("Can't draw 2.5D lines without m_Frame");
        }
        Rectangle rectangle = this.m_Frame.getBackWallBounds();
        if (rectangle == null) {
            throw new AssertionException("Can't draw 2.5D lines when m_Frame has no bounding rect");
        }
        double d2 = this.m_bHorz ? (double)rectangle.width / 12.0 : (double)rectangle.height / 12.0;
        int n10 = (int)(d2 * (double)this.m_nLineThick / (double)100);
        RelativeAxisObj relativeAxisObj = this.whichAxisForSeries(n, null);
        if (relativeAxisObj != null) {
            Polygon polygon;
            boolean bl3;
            boolean bl4;
            Polygon polygon2;
            int n11;
            int n12;
            int n13;
            int n14;
            boolean bl5;
            double d3;
            double d4;
            int n15;
            int n16;
            int n17;
            int n18;
            RelativeAxisObj relativeAxisObj2;
            int n19;
            int n20;
            Point point3;
            boolean bl6;
            int n21 = (int)relativeAxisObj.getValueCoord(0.0);
            boolean bl7 = relativeAxisObj.isDescending();
            if (this.m_bParetoThresholdEnabled) {
                blackBoxIF2 = this.assignSeriesColor(new IdentObj(491, n, n2));
                blackBoxIF3 = this.assignSeriesColor(new IdentObj(492, n, n2));
            } else {
                blackBoxIF = this.assignSeriesColor(new IdentObj(473, n, n2));
            }
            BlackBoxIF blackBoxIF4 = this.getMissingDataBlackBox(n, n2);
            if (blackBoxIF4 == null) {
                blackBoxIF4 = blackBoxIF;
            }
            BlackBoxIF blackBoxIF5 = null;
            BlackBoxIF blackBoxIF6 = null;
            if (this.m_bParetoThresholdEnabled) {
                blackBoxIF5 = this.getMissingDataBlackBox(n, n2);
                blackBoxIF6 = this.getMissingDataBlackBox(n, n2);
                if (blackBoxIF5 == null) {
                    blackBoxIF5 = blackBoxIF2;
                }
                if (blackBoxIF6 == null) {
                    blackBoxIF6 = blackBoxIF3;
                }
            }
            boolean bl8 = bl7 ? n3 > n21 : (bl6 = n3 < n21);
            if (this.wantDepthEffect()) {
                Point point4 = this.m_seriesBackOffsets[n];
                point3 = this.m_seriesFrontOffsets[n];
                n20 = point3.x - point4.x;
                n19 = point3.y - point4.y;
            } else {
                point3 = new Point();
                n20 = 0;
                n19 = 0;
            }
            Polygon polygon3 = new Polygon();
            point = this.getParetoCoords(n, n2);
            if (this.m_bParetoThresholdEnabled && this.m_fThreshholdPercent < 1.0 && this.m_bFirstPassWithDepth && this.m_fParetoYCoords[n][n2] > this.m_fThresholdValue[n] && (relativeAxisObj2 = this.whichAxisForSeries(n, null)) != null) {
                point = new Point();
                point.y = (int)relativeAxisObj2.getValueCoord(this.m_fThresholdValue[n]);
                int n22 = (int)this.calcThresholdXPos(point.y, n, n2);
                point.x = n22 + this.m_barThickCoord / 2 + this.m_nConverge;
                this.m_bFirstPassWithDepth = false;
                n18 = point.x - point3.x;
                n17 = point.y - point3.y;
                polygon3.addPoint(n18, n17);
                point2 = bl2 ? this.getParetoCoords(n, n2) : this.getParetoCoords(n, n2);
                n16 = point2.x - point3.x;
                n15 = point2.y - point3.y;
                polygon3.addPoint(n16, n15);
                d4 = Math.atan2(n15 - n17, n16 - n18);
                d3 = d4 * 57.29577951308232;
                if (this.m_nDepthAngle <= 90) {
                    bl5 = this.m_bHorz ? d3 < (double)(this.m_nDepthAngle - 180) : d3 > (double)this.m_nDepthAngle;
                } else {
                    boolean bl9 = bl5 = d3 + (double)180 < (double)this.m_nDepthAngle;
                }
                if (this.m_bHorz) {
                    n14 = n16 - n10;
                    n13 = n15;
                    n12 = n18 - n10;
                    n11 = n17;
                } else {
                    n14 = n16;
                    n13 = n15 - n10;
                    n12 = n18;
                    n11 = n17 - n10;
                }
                polygon3.addPoint(n14, n13);
                polygon3.addPoint(n12, n11);
                polygon3.addPoint(n18, n17);
                if (bl5) {
                    polygon2 = new Polygon();
                    polygon2.addPoint(n14, n13);
                    polygon2.addPoint(n12, n11);
                    polygon2.addPoint(n12 + n20, n11 + n19);
                    polygon2.addPoint(n14 + n20, n13 + n19);
                    polygon2.addPoint(n14, n13);
                } else {
                    polygon2 = new Polygon();
                    polygon2.addPoint(n18, n17);
                    polygon2.addPoint(n16, n15);
                    polygon2.addPoint(n16 + n20, n15 + n19);
                    polygon2.addPoint(n18 + n20, n17 + n19);
                    polygon2.addPoint(n18, n17);
                }
                if (this.m_bColorAutoshadeRisers) {
                    d = this.m_bHorz ? 0.6 : (bl5 ? 0.4 : 0.8);
                }
                if (n2 >= this.m_nThreshold[n]) {
                    new DetPolygon(this.m_Detectiv, new IdentObj(496, n, n2), polygon2, blackBoxIF6, d);
                } else {
                    new DetPolygon(this.m_Detectiv, new IdentObj(495, n, n2), polygon2, blackBoxIF5, d);
                }
                if (this.m_bColorAutoshadeRisers) {
                    d = 1.0;
                }
                if (n2 >= this.m_nThreshold[n]) {
                    new DetPolygon(this.m_Detectiv, new IdentObj(492, n, n2), polygon3, blackBoxIF6, d);
                } else {
                    new DetPolygon(this.m_Detectiv, new IdentObj(491, n, n2), polygon3, blackBoxIF5, d);
                }
                boolean bl10 = bl4 = bl || this.m_bHorz;
                if (bl2) {
                    bl3 = bl4 ? n2 == n4 || n6 != -1 && !this.m_dataOK[n][n6] : n7 == n5 || n8 != -1 && !this.m_dataOK[n][n8];
                } else if (bl4) {
                    bl3 = n2 == n5 || n7 != -1 && !this.m_dataOK[n][n7];
                } else {
                    boolean bl11 = bl3 = n6 == n4 || n9 != -1 && !this.m_dataOK[n][n9];
                }
                if (bl3) {
                    polygon = new Polygon();
                    if (bl4) {
                        polygon.addPoint(n18, n17);
                        polygon.addPoint(n12, n11);
                        polygon.addPoint(n12 + n20, n11 + n19);
                        polygon.addPoint(n18 + n20, n17 + n19);
                        polygon.addPoint(n18, n17);
                    } else {
                        polygon.addPoint(n16, n15);
                        polygon.addPoint(n14, n13);
                        polygon.addPoint(n14 + n20, n13 + n19);
                        polygon.addPoint(n16 + n20, n15 + n19);
                        polygon.addPoint(n16, n15);
                    }
                    if (this.m_bColorAutoshadeRisers) {
                        double d5 = d = this.m_bHorz ? 0.8 : 0.6;
                    }
                    if (n2 >= this.m_nThreshold[n]) {
                        new DetPolygon(this.m_Detectiv, new IdentObj(498, n, n2), polygon, blackBoxIF6, d);
                    } else {
                        new DetPolygon(this.m_Detectiv, new IdentObj(497, n, n2), polygon, blackBoxIF5, d);
                    }
                }
            }
            if (bl2 ? n7 == -1 : n6 == -1) {
                return;
            }
            point = this.getParetoCoords(n, n2);
            n18 = point.x - point3.x;
            n17 = point.y - point3.y;
            polygon3.addPoint(n18, n17);
            point2 = bl2 ? this.getParetoCoords(n, n7) : this.getParetoCoords(n, n6);
            n16 = point2.x - point3.x;
            n15 = point2.y - point3.y;
            polygon3.addPoint(n16, n15);
            d4 = Math.atan2(n15 - n17, n16 - n18);
            d3 = d4 * 57.29577951308232;
            if (this.m_nDepthAngle <= 90) {
                bl5 = this.m_bHorz ? d3 < (double)(this.m_nDepthAngle - 180) : d3 > (double)this.m_nDepthAngle;
            } else {
                boolean bl12 = bl5 = d3 + (double)180 < (double)this.m_nDepthAngle;
            }
            if (this.m_bHorz) {
                n14 = n16 - n10;
                n13 = n15;
                n12 = n18 - n10;
                n11 = n17;
            } else {
                n14 = n16;
                n13 = n15 - n10;
                n12 = n18;
                n11 = n17 - n10;
            }
            polygon3.addPoint(n14, n13);
            polygon3.addPoint(n12, n11);
            polygon3.addPoint(n18, n17);
            if (bl5) {
                polygon2 = new Polygon();
                polygon2.addPoint(n14, n13);
                polygon2.addPoint(n12, n11);
                polygon2.addPoint(n12 + n20, n11 + n19);
                polygon2.addPoint(n14 + n20, n13 + n19);
                polygon2.addPoint(n14, n13);
            } else {
                polygon2 = new Polygon();
                polygon2.addPoint(n18, n17);
                polygon2.addPoint(n16, n15);
                polygon2.addPoint(n16 + n20, n15 + n19);
                polygon2.addPoint(n18 + n20, n17 + n19);
                polygon2.addPoint(n18, n17);
            }
            if (this.m_bColorAutoshadeRisers) {
                d = this.m_bHorz ? 0.6 : (bl5 ? 0.4 : 0.8);
            }
            if (this.m_bParetoThresholdEnabled) {
                if (n2 >= this.m_nThreshold[n]) {
                    new DetPolygon(this.m_Detectiv, new IdentObj(496, n, n2), polygon2, blackBoxIF6, d);
                } else {
                    new DetPolygon(this.m_Detectiv, new IdentObj(495, n, n2), polygon2, blackBoxIF5, d);
                }
            } else {
                new DetPolygon(this.m_Detectiv, new IdentObj(475, n), polygon2, blackBoxIF4, d);
            }
            if (this.m_bColorAutoshadeRisers) {
                d = 1.0;
            }
            if (this.m_bParetoThresholdEnabled) {
                if (n2 >= this.m_nThreshold[n]) {
                    new DetPolygon(this.m_Detectiv, new IdentObj(492, n, n2), polygon3, blackBoxIF6, d);
                } else {
                    new DetPolygon(this.m_Detectiv, new IdentObj(491, n, n2), polygon3, blackBoxIF5, d);
                }
            } else {
                new DetPolygon(this.m_Detectiv, new IdentObj(473, n), polygon3, blackBoxIF4, d);
            }
            boolean bl13 = bl4 = bl || this.m_bHorz;
            if (bl2) {
                bl3 = bl4 ? n2 == n4 || n6 != -1 && !this.m_dataOK[n][n6] : n7 == n5 || n8 != -1 && !this.m_dataOK[n][n8];
            } else if (bl4) {
                bl3 = n2 == n5 || n7 != -1 && !this.m_dataOK[n][n7];
            } else {
                boolean bl14 = bl3 = n6 == n4 || n9 != -1 && !this.m_dataOK[n][n9];
            }
            if (bl3) {
                polygon = new Polygon();
                if (bl4) {
                    polygon.addPoint(n18, n17);
                    polygon.addPoint(n12, n11);
                    polygon.addPoint(n12 + n20, n11 + n19);
                    polygon.addPoint(n18 + n20, n17 + n19);
                    polygon.addPoint(n18, n17);
                } else {
                    polygon.addPoint(n16, n15);
                    polygon.addPoint(n14, n13);
                    polygon.addPoint(n14 + n20, n13 + n19);
                    polygon.addPoint(n16 + n20, n15 + n19);
                    polygon.addPoint(n16, n15);
                }
                if (this.m_bColorAutoshadeRisers) {
                    double d6 = d = this.m_bHorz ? 0.8 : 0.6;
                }
                if (this.m_bParetoThresholdEnabled) {
                    if (n2 >= this.m_nThreshold[n]) {
                        new DetPolygon(this.m_Detectiv, new IdentObj(498, n, n2), polygon, blackBoxIF6, d);
                    } else {
                        new DetPolygon(this.m_Detectiv, new IdentObj(497, n, n2), polygon, blackBoxIF5, d);
                    }
                } else {
                    new DetPolygon(this.m_Detectiv, new IdentObj(476, n), polygon, blackBoxIF4, d);
                }
            }
        }
    }

    protected Point getCoords(int n, int n2) {
        int n3 = this.m_ordCoords[n][n2] + this.m_barThickCoord / 2;
        Point point = this.m_bHorz ? new Point(this.m_numYCoords[n][n2], n3) : new Point(this.m_nParetoCoordsVC[n][n2], this.m_numYCoords[n][n2]);
        return point;
    }

    protected Point getVCPositionsXY(int n, double d, double d2) throws AssertionException {
        SeriesEnumerator seriesEnumerator = this.m_sEnumForward;
        int n2 = seriesEnumerator.getFirstSeries();
        Axis2DObj axis2DObj = (Axis2DObj)this.m_O1Axis;
        Axis2DObj axis2DObj2 = (Axis2DObj)this.whichAxisForSeries(n, null);
        int n3 = (int)axis2DObj.getLowCoord((double)(n - n2), d);
        int n4 = n3 + this.m_barThickCoord / 2;
        int n5 = (int)axis2DObj2.getValueCoord(d2);
        if (this.wantDepthEffect()) {
            Point point = this.m_seriesFrontOffsets[n];
            n4 -= point.x;
            n5 -= point.y;
        }
        if (this.m_bHorz) {
            return new Point(n5, n4);
        }
        return new Point(n4, n5);
    }

    public boolean isBottomStackedArea(int n) {
        return this.isVisibleStackedArea(n, false);
    }

    public boolean isTopStackedArea(int n) {
        return this.isVisibleStackedArea(n, true);
    }

    public boolean isVisibleStackedArea(int n, boolean bl) {
        int n2 = this.getAxisAssignment(n);
        boolean bl2 = !bl;
        boolean bl3 = true;
        SeriesEnumerator seriesEnumerator = this.getResetSeriesEnumerator(bl2);
        while (bl3 && seriesEnumerator.hasMoreElements()) {
            boolean bl4;
            int n3 = seriesEnumerator.nextSeries();
            boolean bl5 = bl2 ? n3 >= n : (bl4 = n3 <= n);
            if (bl4) break;
            if (this.m_seriesTypes[n3] != 3 || this.getAxisAssignment(n3) != n2) continue;
            bl3 = false;
        }
        return bl3;
    }

    protected String processDataTextTemplate(String[] stringArray, String string) {
        String string2 = string;
        return string2;
    }

    protected boolean wantDepthEffect() {
        return this.m_nDepthRadius > 0 && this.m_gt.wantDepthEffect();
    }

    protected boolean wantRisersFromZero(RelativeAxisObj relativeAxisObj) {
        boolean bl = this.m_bFromZero;
        if (!bl) {
            bl = relativeAxisObj.hasNegData() && !this.m_bAbsolute && !relativeAxisObj.isLogScale();
        }
        return bl;
    }

    protected Point getParetoCoords(int n, int n2) {
        Point point = new Point(this.m_nParetoCoordsVC[n][n2], this.m_nParetoYCoordsVC[n][n2]);
        return point;
    }

    protected MinMaxObj findLimits(int n, int n2, boolean bl, MinMaxObj minMaxObj) {
        double d = 0.0;
        double d2 = 0.0;
        MinMaxObj minMaxObj2 = new MinMaxObj(bl);
        DataFormat dataFormat = this.m_Access.getDataFormat();
        int n3 = dataFormat.getNumDataItems();
        int[] nArray = new int[this.m_nTotalSeries];
        int n4 = 0;
        while (n4 < this.m_nTotalSeries) {
            nArray[n4] = this.getAxisAssignment(n4);
            ++n4;
        }
        this.setNonDataLimits(minMaxObj2);
        if (n2 == 1) {
            n4 = 0;
            while (n4 < this.m_nTotalSeries) {
                if (n != 0 && n != 1 && n != 2 && n != 3 && n != 4 || nArray[n4] == n) {
                    d2 = 0.0;
                    int n5 = 0;
                    while (n5 < this.m_nTotalGroups) {
                        int n6 = 0;
                        while (n6 < n3) {
                            DataItem dataItem = dataFormat.getDataItem(n6);
                            if (!dataItem.ignoreInScaling() && AxisTemplate.isSameType(dataItem.getAssocAxis(), n)) {
                                DatumObj datumObj = this.getDataValue(n4, n5, dataItem);
                                double d3 = datumObj.m_fValue;
                                d2 += d3;
                                if (!(!datumObj.m_bOK || d3 <= 0.0 && this.isBadValueInLogscale(n, d3) || minMaxObj != null && (d3 < minMaxObj.getAdjMin() || d3 > minMaxObj.getAdjMax()))) {
                                    minMaxObj2.testRawValue(d2);
                                }
                            }
                            ++n6;
                        }
                        ++n5;
                    }
                }
                ++n4;
            }
        } else {
            throw new AssertionException(1, 5, n2);
        }
        return minMaxObj2;
    }

    protected void createY1Axis(boolean bl, boolean bl2, int n, int n2) {
        MinMaxObj minMaxObj;
        boolean bl3 = this.m_Perspective.getY1MustIncludeZero() && !this.m_Perspective.getY1LogScale();
        MinMaxObj minMaxObj2 = this.findLimits(0, this.m_scaling, bl3, null);
        this.m_Y1Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.Y1_AXIS, minMaxObj2, bl, bl2, n, n2);
        this.calcParetoMax(this.m_Y1Axis, AxisTemplate.Y1_AXIS);
        if (this.isZoomingArmed() && (minMaxObj = this.createMinMaxZoom(this.m_Y1Axis)) != null) {
            this.m_Y1Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.Y1_AXIS, minMaxObj, bl, bl2, n, n2);
        }
    }

    protected void calcBarOrdinalCoords() {
        SeriesEnumerator seriesEnumerator = this.m_sEnumForward;
        GroupsEnumerator groupsEnumerator = this.m_gEnumForward;
        this.m_ordCoords = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_barThickCoord = this.m_Perspective.getConnectParetoBars() ? (int)(this.m_O1Axis.getHighCoord(0, 1) - this.m_O1Axis.getHighCoord(0, 0)) : (int)(this.m_O1Axis.getHighCoord(0, 0) - this.m_O1Axis.getLowCoord(0, 0));
        int n = 0;
        while (n < this.m_nSeries) {
            int n2 = seriesEnumerator.seriesAt(n);
            PfjAssert.pfjAssert(n2 >= 0 && n2 < this.m_nTotalSeries);
            int n3 = this.getAxisAssignment(n2);
            int n4 = 0;
            if (this.m_gt.isDualY() && this.m_bStacked && n3 == 1) {
                n4 = 1;
            }
            int n5 = 0;
            while (n5 < this.m_nGroups) {
                int n6 = groupsEnumerator.groupAt(n5);
                PfjAssert.pfjAssert(n6 >= 0 && n6 < this.m_nTotalGroups);
                this.m_ordCoords[n2][n6] = this.m_bAbsolute ? (int)this.m_O1Axis.getLowCoord(n, n5) : (int)this.m_O1Axis.getLowCoord(n4, n5);
                ++n5;
            }
            ++n;
        }
    }

    protected void createY2Axis(boolean bl, boolean bl2, int n, int n2) {
        MinMaxObj minMaxObj;
        boolean bl3 = this.m_Perspective.getY2MustIncludeZero() && !this.m_Perspective.getY2LogScale();
        MinMaxObj minMaxObj2 = this.findLimits(1, this.m_scaling, bl3, null);
        if (this.m_nDepthRadius > 0 && this.m_nDepthAngle > 90 && !bl) {
            bl2 = !bl2;
        }
        this.m_Y2Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.Y2_AXIS, minMaxObj2, bl, bl2, n, n2);
        this.calcParetoMax(this.m_Y2Axis, AxisTemplate.Y2_AXIS);
        if (this.isZoomingArmed() && (minMaxObj = this.createMinMaxZoom(this.m_Y2Axis)) != null) {
            this.m_Y2Axis = new Axis2DObj(this.m_Perspective, this.m_Access, AxisTemplate.Y2_AXIS, minMaxObj, bl, bl2, n, n2);
        }
    }

    protected void drawTransparentMarkers() {
        GroupsEnumerator groupsEnumerator = this.getResetGroupsEnumerator();
        int n = this.m_Perspective.getDisplayParetoSeries();
        PfjAssert.pfjAssert(n >= 0 && n < this.m_nTotalSeries);
        IdentObj identObj = new IdentObj(this.m_Perspective.getParetoLineMarker().getObjectID(), n);
        int n2 = n % this.m_nSeriesLooping;
        IdentObj identObj2 = new IdentObj(this.m_Perspective.getParetoLineMarker().getObjectID(), n2);
        MarkerTemplate markerTemplate = MarkerTemplateArray.PRESET_SQUARE;
        groupsEnumerator.reset();
        while (groupsEnumerator.hasMoreElements()) {
            double d;
            int n3 = groupsEnumerator.nextGroup();
            PfjAssert.pfjAssert(n3 >= 0 && n3 < this.m_nTotalGroups);
            if (!this.m_dataOK[n][n3]) continue;
            Point point = this.getParetoCoords(n, n3);
            int n4 = this.getTransparentMarkerDimension().width;
            int n5 = n4;
            double d2 = this.m_Perspective.m_VC.virtToDestWidth((double)n5);
            if (d2 > (d = this.m_Perspective.m_VC.virtToDestHeight((double)n4))) {
                n5 = (int)((double)n5 * d / d2);
            } else {
                n4 = (int)((double)n4 * d2 / d);
            }
            IdentObj identObj3 = new IdentObj(474, n, n3);
            SimpleBlackBoxObj simpleBlackBoxObj = new SimpleBlackBoxObj(this.m_Perspective, identObj3, false);
            simpleBlackBoxObj.setTransparentFillColor(true);
            new MarkerObj(this.m_Detectiv, new IdentObj(474, n, n3), markerTemplate, point, n5, n4, simpleBlackBoxObj, null, true, false, 0, 0, 0, false);
        }
    }

    protected void drawMarkers() {
        GroupsEnumerator groupsEnumerator = this.getResetGroupsEnumerator();
        int n = this.m_Perspective.getDisplayParetoSeries();
        PfjAssert.pfjAssert(n >= 0 && n < this.m_nTotalSeries);
        IdentObj identObj = new IdentObj(this.m_Perspective.getParetoLineMarker().getObjectID(), n);
        int n2 = n % this.m_nSeriesLooping;
        IdentObj identObj2 = new IdentObj(this.m_Perspective.getParetoLineMarker().getObjectID(), n2);
        MarkerTemplate markerTemplate = this.getMarkerShape(identObj2);
        groupsEnumerator.reset();
        while (groupsEnumerator.hasMoreElements()) {
            int n3;
            int n4 = groupsEnumerator.nextGroup();
            PfjAssert.pfjAssert(n4 >= 0 && n4 < this.m_nTotalGroups);
            if (!this.m_dataOK[n][n4]) continue;
            Point point = this.getParetoCoords(n, n4);
            int n5 = n3 = this.getMarkerSize(n, n4);
            if (this.m_bSquareMarkers) {
                double d;
                double d2 = this.m_Perspective.m_VC.virtToDestWidth((double)n5);
                if (d2 > (d = this.m_Perspective.m_VC.virtToDestHeight((double)n3))) {
                    n5 = (int)((double)n5 * d / d2);
                } else {
                    n3 = (int)((double)n3 * d2 / d);
                }
            }
            BlackBoxIF blackBoxIF = this.assignSeriesColor(new IdentObj(474, n, n4));
            new MarkerObj(this.m_Detectiv, new IdentObj(474, n, n4), markerTemplate, point, n5, n3, blackBoxIF, null, true);
        }
    }

    protected void drawLines(boolean bl) {
        int n;
        int n2;
        SeriesEnumerator seriesEnumerator = this.getResetSeriesEnumerator();
        GroupsEnumerator groupsEnumerator = this.getResetGroupsEnumerator();
        int n3 = 0;
        int n4 = 0;
        Point point = null;
        Point point2 = null;
        BlackBoxIF blackBoxIF = null;
        BlackBoxIF blackBoxIF2 = null;
        boolean bl2 = false;
        boolean bl3 = true;
        point = new Point();
        point2 = new Point();
        int n5 = this.m_Perspective.getDisplayParetoSeries();
        PfjAssert.pfjAssert(n5 >= 0 && n5 < this.m_nTotalSeries);
        IdentObj identObj = new IdentObj(this.m_Perspective.getParetoLineRiser().getObjectID(), n5);
        groupsEnumerator.reset();
        if (groupsEnumerator.hasMoreElements()) {
            bl2 = true;
        }
        while (groupsEnumerator.hasMoreElements()) {
            int n6;
            RelativeAxisObj relativeAxisObj;
            n4 = groupsEnumerator.nextGroup();
            PfjAssert.pfjAssert(n4 >= 0 && n4 < this.m_nTotalGroups);
            point = this.getParetoCoords(n5, n4);
            point2 = this.getParetoCoords(n5, n3);
            if (this.m_bParetoThresholdEnabled) {
                blackBoxIF2 = this.m_fParetoYCoords[n5][n4] > this.m_fThresholdValue[n5] ? this.assignSeriesColor(new IdentObj(492, n5, n4)) : this.assignSeriesColor(new IdentObj(491, n5, n4));
            } else {
                blackBoxIF = this.assignSeriesColor(new IdentObj(473, n5, n4));
            }
            if (this.m_bParetoThresholdEnabled) {
                blackBoxIF2.setBorderColor(blackBoxIF2.getFillColor());
            } else {
                blackBoxIF.setBorderColor(blackBoxIF.getFillColor());
            }
            if (this.m_bParetoThresholdEnabled && this.m_fThreshholdPercent < 1.0 && bl3 && this.m_fParetoYCoords[n5][n4] > this.m_fThresholdValue[n5] && (relativeAxisObj = this.whichAxisForSeries(n5, null)) != null) {
                point.y = (int)relativeAxisObj.getValueCoord(this.m_fThresholdValue[n5]);
                n6 = (int)this.calcThresholdXPos(point.y, n5, n4);
                point.x = n6 + this.m_barThickCoord / 2 + this.m_nConverge;
                bl3 = false;
                n2 = this.m_Perspective.getLineWidth(identObj);
                n = this.m_Perspective.getLineStyle(identObj);
                new DetLine(this.m_Detectiv, new IdentObj(492, n5, n4), point.x, point.y, point2.x, point2.y, blackBoxIF2, null, n2, n);
            }
            if (!groupsEnumerator.hasMoreElements()) continue;
            n3 = groupsEnumerator.peekAtNextGroup();
            PfjAssert.pfjAssert(n3 >= 0 && n3 < this.m_nTotalGroups);
            point = this.getParetoCoords(n5, n4);
            point2 = this.getParetoCoords(n5, n3);
            n2 = this.m_Perspective.getLineWidth(identObj);
            n = this.m_Perspective.getLineStyle(identObj);
            boolean bl4 = true;
            if (this.m_nFillMissingData != 0) {
                n6 = this.m_Access.m_DataStorage.isMissingDataFilledIn(n5, n4) ? 1 : 0;
                int n7 = this.m_Perspective.getNumMissingDataSegments();
                if (n6 != 0 && n7 != 0) {
                    this.drawMissingLineData(n7, point, point2, n5, n4, blackBoxIF, n2, n);
                    bl4 = false;
                }
            }
            if (!bl4) continue;
            if (this.m_bParetoThresholdEnabled) {
                if (this.m_fParetoYCoords[n5][n4] > this.m_fThresholdValue[n5]) {
                    new DetLine(this.m_Detectiv, new IdentObj(492, n5, n4), point.x, point.y, point2.x, point2.y, blackBoxIF2, null, n2, n);
                    continue;
                }
                new DetLine(this.m_Detectiv, new IdentObj(491, n5, n4), point.x, point.y, point2.x, point2.y, blackBoxIF2, null, n2, n);
                continue;
            }
            new DetLine(this.m_Detectiv, new IdentObj(473, n5, n4), point.x, point.y, point2.x, point2.y, blackBoxIF, null, n2, n);
        }
        if (bl && this.m_dataOK[n5][0] && this.m_dataOK[n5][n4] && bl2) {
            point = this.getParetoCoords(n5, n4);
            point2 = this.getParetoCoords(n5, 0);
            blackBoxIF = this.assignSeriesColor(new IdentObj(473, n5, n4));
            blackBoxIF.setBorderColor(blackBoxIF.getFillColor());
            n2 = this.m_Perspective.getLineWidth(identObj);
            n = this.m_Perspective.getLineStyle(identObj);
            new DetLine(this.m_Detectiv, new IdentObj(473, n5, n4), point.x, point.y, point2.x, point2.y, blackBoxIF, null, n2, n);
        }
    }

    protected void drawMissingLineData(int n, Point point, Point point2, int n2, int n3, BlackBoxIF blackBoxIF, int n4, int n5) {
        Line line = new Line(point, point2);
        int n6 = n * 2 + 1;
        int n7 = 1;
        while (n7 < n6) {
            Point point3 = line.fractionalPoint(n7, n6);
            Point point4 = line.fractionalPoint(n7 + 1, n6);
            IdentObj identObj = new IdentObj(258, n2, n3);
            new DetLine(this.m_Detectiv, identObj, point3.x, point3.y, point4.x, point4.y, blackBoxIF, null, n4, n5);
            ++n7;
            ++n7;
        }
    }

    protected void drawMarkersWithDepth(int n) {
        int n2;
        int n3;
        Point point;
        Point point2;
        GroupsEnumerator groupsEnumerator = this.getResetGroupsEnumerator();
        Point point3 = new Point();
        if (this.m_nDepthRadius <= 0) {
            throw new AssertionException("Can't draw 2.5D markers without positive DepthRadius");
        }
        if (this.m_Frame == null) {
            throw new AssertionException("Can't draw 2.5D markers without m_Frame");
        }
        PfjAssert.pfjAssert(n >= 0 && n < this.m_nTotalSeries);
        int n4 = n % this.m_nSeriesLooping;
        IdentObj identObj = new IdentObj(this.m_Perspective.getParetoLineMarker().getObjectID(), n4);
        MarkerTemplate markerTemplate = this.getMarkerShape(identObj);
        if (markerTemplate.m_markerType == 2) {
            markerTemplate = MarkerTemplateArray.PRESET_DEPTHCIRCLE;
        }
        if (this.m_nDepthRadius > 0 && this.m_nDepthPlanes > 0) {
            double d = this.calcFrontOffset(this.m_seriesPlanes[n], this.m_nDepthPlanes);
            point2 = this.m_Frame.getDepthOffset(d);
            double d2 = this.calcBackOffset(this.m_seriesPlanes[n], this.m_nDepthPlanes);
            point = this.m_Frame.getDepthOffset(d2);
            n3 = point2.x - point.x;
            n2 = point2.y - point.y;
            n3 = 3 * n3;
            n2 = 3 * n2;
        } else {
            point2 = new Point();
            point = new Point();
            n3 = 0;
            n2 = 0;
        }
        groupsEnumerator.reset();
        while (groupsEnumerator.hasMoreElements()) {
            int n5;
            int n6 = groupsEnumerator.nextGroup();
            PfjAssert.pfjAssert(n6 >= 0 && n6 < this.m_nTotalGroups);
            if (!this.m_dataOK[n][n6]) continue;
            Point point4 = this.getParetoCoords(n, n6);
            point3.x = point4.x - point2.x;
            point3.y = point4.y - point2.y;
            int n7 = n5 = this.getMarkerSize(n, n6);
            if (this.m_bSquareMarkers) {
                double d;
                double d3 = this.m_Perspective.m_VC.virtToDestWidth((double)n7);
                if (d3 > (d = this.m_Perspective.m_VC.virtToDestHeight((double)n5))) {
                    n7 = (int)((double)n7 * d / d3);
                } else {
                    n5 = (int)((double)n5 * d3 / d);
                }
            }
            BlackBoxIF blackBoxIF = this.assignSeriesColor(new IdentObj(474, n, n6));
            IdentObj identObj2 = new IdentObj(474, n, n6);
            identObj2.setMiscID(0);
            new MarkerObj(this.m_Detectiv, identObj2, markerTemplate, point3, n7, n5, blackBoxIF, null, true, true, n3, n2, this.m_nDepthAngle);
        }
    }

    protected void drawTransparentMarkersWithDepth(int n) {
        int n2;
        int n3;
        int n4;
        Point point;
        Point point2;
        GroupsEnumerator groupsEnumerator = this.getResetGroupsEnumerator();
        Point point3 = new Point();
        if (this.m_nDepthRadius <= 0) {
            throw new AssertionException("Can't draw 2.5D markers without positive DepthRadius");
        }
        if (this.m_Frame == null) {
            throw new AssertionException("Can't draw 2.5D markers without m_Frame");
        }
        PfjAssert.pfjAssert(n >= 0 && n < this.m_nTotalSeries);
        int n5 = n % this.m_nSeriesLooping;
        IdentObj identObj = new IdentObj(this.m_Perspective.getParetoLineMarker().getObjectID(), n5);
        MarkerTemplate markerTemplate = MarkerTemplateArray.PRESET_SQUARE;
        if (this.m_nDepthRadius > 0 && this.m_nDepthPlanes > 0) {
            double d = this.calcFrontOffset(this.m_seriesPlanes[n], this.m_nDepthPlanes);
            point2 = this.m_Frame.getDepthOffset(d);
            double d2 = this.calcBackOffset(this.m_seriesPlanes[n], this.m_nDepthPlanes);
            point = this.m_Frame.getDepthOffset(d2);
            n4 = point2.x - point.x;
            n3 = point2.y - point.y;
            n4 = 3 * n4;
            n3 = 3 * n3;
        } else {
            point2 = new Point();
            point = new Point();
            n4 = 0;
            n3 = 0;
        }
        int n6 = n2 = this.getTransparentMarkerDimension().width;
        groupsEnumerator.reset();
        while (groupsEnumerator.hasMoreElements()) {
            double d;
            int n7 = groupsEnumerator.nextGroup();
            PfjAssert.pfjAssert(n7 >= 0 && n7 < this.m_nTotalGroups);
            if (!this.m_dataOK[n][n7]) continue;
            Point point4 = this.getParetoCoords(n, n7);
            point3.x = point4.x - point2.x;
            point3.y = point4.y - point2.y;
            double d3 = this.m_Perspective.m_VC.virtToDestWidth((double)n6);
            if (d3 > (d = this.m_Perspective.m_VC.virtToDestHeight((double)n2))) {
                n6 = (int)((double)n6 * d / d3);
            } else {
                n2 = (int)((double)n2 * d3 / d);
            }
            IdentObj identObj2 = new IdentObj(474, n, n7);
            identObj2.setMiscID(0);
            SimpleBlackBoxObj simpleBlackBoxObj = new SimpleBlackBoxObj(this.m_Perspective, identObj2, false);
            simpleBlackBoxObj.setTransparentFillColor(true);
            new MarkerObj(this.m_Detectiv, identObj2, markerTemplate, point3, n6, n2, simpleBlackBoxObj, null, true, true, n4, n3, this.m_nDepthAngle, false);
        }
    }

    protected void calcParetoMax(RelativeAxisObj relativeAxisObj, AxisTemplate axisTemplate) {
        SeriesEnumerator seriesEnumerator = this.getResetSeriesEnumerator();
        GroupsEnumerator groupsEnumerator = this.getResetGroupsEnumerator();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = Double.MAX_VALUE;
        this.m_fMaxParetoActuals = new double[this.m_nTotalSeries];
        this.m_fMinParetoActuals = new double[this.m_nTotalSeries];
        this.m_nThreshold = new int[this.m_nTotalSeries];
        this.m_fThresholdValue = new double[this.m_nTotalSeries];
        seriesEnumerator.reset();
        while (seriesEnumerator.hasMoreElements()) {
            int n = seriesEnumerator.nextSeries();
            PfjAssert.pfjAssert(n >= 0 && n < this.m_nTotalSeries);
            this.m_fMaxParetoActuals[n] = 0.0;
            d = 0.0;
            d3 = Double.MAX_VALUE;
            this.m_fMinParetoActuals[n] = Double.MAX_VALUE;
            groupsEnumerator.reset();
            while (groupsEnumerator.hasMoreElements()) {
                int n2 = groupsEnumerator.nextGroup();
                PfjAssert.pfjAssert(n2 >= 0 && n2 < this.m_nTotalGroups);
                DatumObj datumObj = this.getDataValue(n, n2, DataItem.DI_GENERAL);
                d2 = datumObj.m_fValue;
                this.m_fMaxParetoActuals[n] = d += Math.abs(d2);
                if (!(Math.abs(d2) < d3)) continue;
                this.m_fMinParetoActuals[n] = d3 = Math.abs(d2);
            }
            relativeAxisObj.setParetoSeriesMaximum(n, this.m_fMaxParetoActuals[n]);
            relativeAxisObj.setParetoSeriesMinimum(n, this.m_fMinParetoActuals[n]);
        }
    }

    protected void findThresholdValues() {
        SeriesEnumerator seriesEnumerator = this.getResetSeriesEnumerator();
        GroupsEnumerator groupsEnumerator = this.getResetGroupsEnumerator();
        double d = this.m_fThreshholdPercent;
        seriesEnumerator.reset();
        block0: while (seriesEnumerator.hasMoreElements()) {
            int n = seriesEnumerator.nextSeries();
            double d2 = this.m_fParetoYCoords[n][0] + (this.m_fParetoYCoords[n][this.m_nTotalGroups - 1] - this.m_fParetoYCoords[n][0]) * d;
            double d3 = 0.0;
            groupsEnumerator.reset();
            while (groupsEnumerator.hasMoreElements()) {
                int n2 = groupsEnumerator.nextGroup();
                DatumObj datumObj = this.getDataValue(n, n2, DataItem.DI_GENERAL);
                double d4 = datumObj.m_fValue;
                if (!((d3 += Math.abs(d4)) > d2)) continue;
                this.m_nThreshold[n] = n2;
                this.m_fThresholdValue[n] = d2;
                if (!this.m_bDebugPrint) continue block0;
                System.out.println(String.valueOf(String.valueOf(" value ")) + d2 + " for series " + n + "  " + this.m_nParetoCoordsVC[n][n2 - 1]);
                continue block0;
            }
        }
    }

    protected void makeRects() {
        RelativeAxisObj relativeAxisObj;
        Rectangle rectangle = this.m_Perspective.getRect(this.m_Perspective.getFrame());
        Rectangle rectangle2 = new Rectangle(rectangle);
        Rectangle rectangle3 = new Rectangle(rectangle);
        int n = rectangle.width / this.m_nGroups;
        int n2 = this.m_Perspective.getDisplayParetoSeries();
        int n3 = this.m_nThreshold[n2];
        if (this.m_bDebugPrint) {
            System.out.println(String.valueOf(String.valueOf(" value ")) + this.m_nParetoYCoordsVC[n2][0] + " for series " + n2 + "  " + this.m_fThresholdValue[n2] + " " + this.m_nParetoYCoordsVC[n2][1] + " group " + n3);
        }
        if ((relativeAxisObj = this.whichAxisForSeries(n2, null)) != null) {
            int n4 = (int)relativeAxisObj.getValueCoord(this.m_fMaxParetoActuals[n2] * this.m_fThreshholdPercent);
            if (this.m_fThreshholdPercent < 1.0) {
                double d = this.calcThresholdXPos(n4, n2, n3);
                rectangle3.x = (int)d + this.m_barThickCoord / 2 + this.m_nConverge;
                rectangle3.y = rectangle.y;
                rectangle3.height = rectangle.height;
                int n5 = Math.abs(rectangle.x) + rectangle3.x;
                rectangle3.width = rectangle.width - n5;
                this.m_Perspective.setRect(this.m_Perspective.getParetoChartFrame2(), rectangle3);
                rectangle2.x = rectangle.x;
                rectangle2.y = rectangle.y;
                rectangle2.height = rectangle.height;
                rectangle2.width = rectangle.width - rectangle3.width;
                this.m_Perspective.setRect(this.m_Perspective.getParetoChartFrame1(), rectangle2);
                ((ParetoFrameObj)this.m_Frame).drawFrameSections();
                ((ParetoFrameObj)this.m_Frame).drawMajorGrids(this.m_O1Axis, AxisTemplate.X1_AXIS);
                ((ParetoFrameObj)this.m_Frame).drawMajorGrids(this.m_Y1Axis, AxisTemplate.Y1_AXIS);
            }
        }
    }

    public boolean wantLegend() {
        return false;
    }

    public void createFrame() {
        this.m_Frame = new ParetoFrameObj(this.m_Perspective);
    }

    private double calcThresholdXPos(int n, int n2, int n3) {
        Rectangle rectangle = this.m_Perspective.getRect(this.m_Perspective.getFrame());
        int n4 = rectangle.width / this.m_nGroups;
        int n5 = this.m_barThickCoord / 2;
        int n6 = n3 > 0 ? n3 - 1 : n3 + 1;
        double d = n6;
        double d2 = n3;
        double d3 = this.m_fParetoYCoords[n2][n3];
        double d4 = this.m_fParetoYCoords[n2][n6];
        double d5 = (d3 - d4) / (d2 - d);
        double d6 = d3 - d2 * d5;
        double d7 = (this.m_fThresholdValue[n2] - d6) / d5;
        double d8 = (double)rectangle.x + (double)n4 * d7;
        if (this.m_bDebugPrint) {
            System.out.println(String.valueOf(String.valueOf(" Group No  ")) + d7);
        }
        if (this.m_bDebugPrint) {
            System.out.println(String.valueOf(String.valueOf("xVD = ")) + d8);
        }
        if (this.m_bParetoPlotFromLeft) {
            n5 = this.m_barThickCoord;
        }
        return d8 + (double)n5;
    }
}

