/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.Serializable;
import oracle.dss.graph.pfj.DataScroller;
import oracle.dss.graph.pfj.JGraphType;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.DetLine;
import oracle.dss.graph.pfj.draw.DetPolygon;
import oracle.dss.graph.pfj.draw.DetRect;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.math.FP;

public class FrameObj
implements Serializable {
    static final int SIDE_OFFSET = 100;
    static final int BOTTOM_OFFSET = 200;
    public static final int XDEPTH_OFFSET_RATIO = 3;
    protected Perspective m_Perspective;
    protected IdentObj m_id;
    protected Rectangle m_rect;
    protected boolean m_bLooseBounds;
    protected Polygon m_polySide;
    protected Polygon m_polyBottom;
    protected int m_depthAngle;
    protected int m_depthRadius;
    protected double m_dx;
    protected double m_dy;
    protected DataScroller m_dsGroup;

    public FrameObj(Perspective perspective) {
        this(perspective, false);
    }

    public FrameObj(Perspective perspective, boolean bl) {
        this.m_Perspective = perspective;
        this.m_id = new IdentObj(2);
        this.m_rect = null;
        this.m_polySide = null;
        this.m_polyBottom = null;
        this.m_bLooseBounds = bl;
        this.m_dsGroup = null;
    }

    public void calc() {
        boolean bl;
        JGraphType jGraphType = this.m_Perspective.getJGraphType();
        this.m_rect = this.m_Perspective.getRect(this.m_id);
        this.m_depthAngle = this.m_Perspective.getDepthAngle();
        this.m_depthRadius = this.m_Perspective.getDepthRadius();
        if (this.m_depthAngle < 0 || this.m_depthAngle > 180 || this.m_depthRadius < 0 || this.m_depthRadius > 100) {
            this.m_depthRadius = 0;
        }
        if (!(jGraphType.isBLAType() || jGraphType.isScatter() || jGraphType.isBubble() || jGraphType.isPolar())) {
            this.m_depthRadius = 0;
        }
        boolean bl2 = bl = this.m_depthRadius > 0;
        if (bl) {
            double d = this.m_rect.width / 3;
            double d2 = d * (double)this.m_depthRadius / (double)100;
            this.m_dx = d2 * Math.cos((double)this.m_depthAngle * (Math.PI / 180));
            this.m_dy = d2 * Math.sin((double)this.m_depthAngle * (Math.PI / 180));
            if (this.m_depthAngle != 90 && FP.nonzero(this.m_dx)) {
                int n = this.m_depthAngle < 90 ? this.m_rect.x : this.m_rect.x + this.m_rect.width;
                this.m_polySide = new Polygon();
                this.m_polySide.addPoint(n, this.m_rect.y);
                this.m_polySide.addPoint(n, this.m_rect.y + this.m_rect.height);
                this.m_polySide.addPoint(n - (int)this.m_dx, this.m_rect.y + this.m_rect.height - (int)this.m_dy);
                this.m_polySide.addPoint(n - (int)this.m_dx, this.m_rect.y - (int)this.m_dy);
                this.m_polySide.addPoint(n, this.m_rect.y);
            }
            if (this.m_depthAngle != 0 && this.m_depthAngle != 180 && FP.nonzero(this.m_dy)) {
                this.m_polyBottom = new Polygon();
                this.m_polyBottom.addPoint(this.m_rect.x, this.m_rect.y);
                this.m_polyBottom.addPoint(this.m_rect.x + this.m_rect.width, this.m_rect.y);
                this.m_polyBottom.addPoint(this.m_rect.x + this.m_rect.width - (int)this.m_dx, this.m_rect.y - (int)this.m_dy);
                this.m_polyBottom.addPoint(this.m_rect.x - (int)this.m_dx, this.m_rect.y - (int)this.m_dy);
                this.m_polyBottom.addPoint(this.m_rect.x, this.m_rect.y);
            }
        }
        if (this.m_Perspective.getFrameDisplay()) {
            BlackBoxObj blackBoxObj = new BlackBoxObj(this.m_Perspective, this.m_id);
            new DetRect(this.m_Perspective.getDetectiv(), this.m_id, this.m_rect.x, this.m_rect.y, this.m_rect.width, this.m_rect.height, blackBoxObj, null, true, true, this.m_bLooseBounds);
            if (bl) {
                BlackBoxObj blackBoxObj2;
                IdentObj identObj;
                if (this.m_depthAngle != 90 && FP.nonzero(this.m_dx)) {
                    identObj = new IdentObj(15);
                    blackBoxObj2 = new BlackBoxObj(this.m_Perspective, identObj);
                    new DetPolygon(this.m_Perspective.getDetectiv(), identObj, this.m_polySide, (BlackBoxIF)blackBoxObj2, 1.0);
                }
                if (this.m_depthAngle != 0 && this.m_depthAngle != 180 && FP.nonzero(this.m_dy)) {
                    identObj = new IdentObj(16);
                    blackBoxObj2 = new BlackBoxObj(this.m_Perspective, identObj);
                    new DetPolygon(this.m_Perspective.getDetectiv(), identObj, this.m_polyBottom, (BlackBoxIF)blackBoxObj2, 1.0);
                }
            }
            this.m_dsGroup = new DataScroller(this.m_Perspective, this.getFrontWallBounds(), jGraphType.isOrientHorz(), true);
        }
    }

    public void calcDataScrollers() {
        if (this.m_dsGroup != null) {
            this.m_dsGroup.calc();
            if (this.m_depthRadius > 0) {
                // empty if block
            }
        }
    }

    public void drawSeparator(boolean bl, double d) {
        if (d < 0.0 || d > 1.0) {
            return;
        }
        IdentObj identObj = new IdentObj(17);
        BlackBoxObj blackBoxObj = new BlackBoxObj(this.m_Perspective, identObj);
        int n = this.m_Perspective.getLineWidth(this.m_Perspective.getFrameSeparator());
        Rectangle rectangle = new Rectangle(this.m_rect.x, this.m_rect.y, this.m_rect.width, this.m_rect.height);
        if (bl) {
            if (this.m_Perspective.isGroupScrollerPresent()) {
                int n2 = this.m_Perspective.m_VC.destToVirtWidth(12);
                rectangle.x += n2;
                rectangle.width -= n2;
            }
            int n3 = (int)((double)rectangle.x + d * (double)rectangle.width);
            int n4 = rectangle.y;
            if (this.m_depthRadius > 0) {
                Polygon polygon = new Polygon();
                polygon.addPoint(n3, n4);
                polygon.addPoint(n3, n4 + rectangle.height);
                polygon.addPoint(n3 - (int)this.m_dx, n4 + rectangle.height - (int)this.m_dy);
                polygon.addPoint(n3 - (int)this.m_dx, n4 - (int)this.m_dy);
                polygon.addPoint(n3, n4);
                new DetPolygon(this.m_Perspective.getDetectiv(), identObj, polygon, (BlackBoxIF)blackBoxObj, 1.0);
            } else {
                new DetLine(this.m_Perspective.getDetectiv(), identObj, n3, n4, n3, n4 + rectangle.height, blackBoxObj, null, n);
            }
        } else {
            if (this.m_Perspective.isGroupScrollerPresent()) {
                int n5 = this.m_Perspective.m_VC.destToVirtHeight(8);
                rectangle.y += n5;
                rectangle.height -= n5;
            }
            int n6 = rectangle.x;
            int n7 = (int)((double)rectangle.y + d * (double)rectangle.height);
            if (this.m_depthRadius > 0) {
                Polygon polygon = new Polygon();
                polygon.addPoint(n6, n7);
                polygon.addPoint(n6 + rectangle.width, n7);
                polygon.addPoint(n6 + rectangle.width - (int)this.m_dx, n7 - (int)this.m_dy);
                polygon.addPoint(n6 - (int)this.m_dx, n7 - (int)this.m_dy);
                polygon.addPoint(n6, n7);
                new DetPolygon(this.m_Perspective.getDetectiv(), identObj, polygon, (BlackBoxIF)blackBoxObj, 1.0);
            } else {
                new DetLine(this.m_Perspective.getDetectiv(), identObj, n6, n7, n6 + rectangle.width, n7, blackBoxObj, null, n);
            }
        }
    }

    public Rectangle getBackWallBounds() {
        return new Rectangle(this.m_rect.x, this.m_rect.y, this.m_rect.width, this.m_rect.height);
    }

    public Rectangle getFrontWallBounds() {
        return new Rectangle(this.m_rect.x - (int)this.m_dx, this.m_rect.y - (int)this.m_dy, this.m_rect.width, this.m_rect.height);
    }

    public Point getDepthOffset(double d) {
        if (d < 0.0) {
            d = 0.0;
        } else if (d > 1.0) {
            d = 1.0;
        }
        double d2 = d * this.m_dx;
        double d3 = d * this.m_dy;
        Point point = new Point((int)d2, (int)d3);
        return point;
    }

    public Rectangle getBottomEdge() {
        Rectangle rectangle = this.m_rect.getBounds();
        if (this.m_depthRadius > 0 && this.m_polyBottom != null) {
            int n = rectangle.x;
            int n2 = rectangle.width;
            rectangle = this.m_polyBottom.getBounds();
            if (this.m_depthAngle > 90) {
                rectangle.x = rectangle.x + rectangle.width - n2;
            }
            rectangle.width = n2;
        }
        return rectangle;
    }

    public Rectangle getLeftEdge() {
        Rectangle rectangle = this.m_depthRadius > 0 && this.m_depthAngle < 90 && this.m_polySide != null ? this.m_polySide.getBounds() : this.m_rect.getBounds();
        return rectangle;
    }

    public Rectangle getRightEdge() {
        Rectangle rectangle = this.m_depthRadius > 0 && this.m_depthAngle > 90 && this.m_polySide != null ? this.m_polySide.getBounds() : this.m_rect.getBounds();
        return rectangle;
    }

    public void drawFrameBorders(int n) {
        int n2;
        BlackBoxObj blackBoxObj = new BlackBoxObj(this.m_Perspective, this.m_id);
        IdentObj identObj = new IdentObj(this.m_id);
        identObj.setMiscID(1);
        new DetLine(this.m_Perspective.getDetectiv(), identObj, this.m_rect.x, this.m_rect.y, this.m_rect.x + this.m_rect.width, this.m_rect.y, blackBoxObj, null, false, false, n);
        identObj = new IdentObj(this.m_id);
        identObj.setMiscID(2);
        new DetLine(this.m_Perspective.getDetectiv(), identObj, this.m_rect.x + this.m_rect.width, this.m_rect.y + this.m_rect.height, this.m_rect.x + this.m_rect.width, this.m_rect.y, blackBoxObj, null, false, false, n);
        identObj = new IdentObj(this.m_id);
        identObj.setMiscID(3);
        new DetLine(this.m_Perspective.getDetectiv(), identObj, this.m_rect.x, this.m_rect.y + this.m_rect.height, this.m_rect.x + this.m_rect.width, this.m_rect.y + this.m_rect.height, blackBoxObj, null, false, false, n);
        identObj = new IdentObj(this.m_id);
        identObj.setMiscID(4);
        new DetLine(this.m_Perspective.getDetectiv(), identObj, this.m_rect.x, this.m_rect.y, this.m_rect.x, this.m_rect.y + this.m_rect.height, blackBoxObj, null, false, false, n);
        if (this.m_depthAngle != 90 && FP.nonzero(this.m_dx)) {
            n2 = 0;
            while (n2 < this.m_polySide.npoints - 2) {
                identObj = new IdentObj(this.m_id);
                identObj.setMiscID(100 + n2);
                new DetLine(this.m_Perspective.getDetectiv(), identObj, this.m_polySide.xpoints[n2], this.m_polySide.ypoints[n2], this.m_polySide.xpoints[n2 + 1], this.m_polySide.ypoints[n2 + 1], (BlackBoxIF)blackBoxObj, null, false, false);
                ++n2;
            }
        }
        if (this.m_depthAngle != 0 && this.m_depthAngle != 180 && FP.nonzero(this.m_dy)) {
            n2 = 0;
            while (n2 < this.m_polyBottom.npoints - 2) {
                identObj = new IdentObj(this.m_id);
                identObj.setMiscID(200 + n2);
                new DetLine(this.m_Perspective.getDetectiv(), identObj, this.m_polyBottom.xpoints[n2], this.m_polyBottom.ypoints[n2], this.m_polyBottom.xpoints[n2 + 1], this.m_polyBottom.ypoints[n2 + 1], (BlackBoxIF)blackBoxObj, null, false, false);
                ++n2;
            }
        }
    }

    public boolean isGroupScrollerPresent() {
        boolean bl = this.m_dsGroup != null && this.m_dsGroup.isPresent();
        return bl;
    }

    public void releaseReferences() {
        if (this.m_dsGroup != null) {
            this.m_dsGroup.releaseReferences();
        }
        this.m_Perspective = null;
    }
}

