/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import oracle.dss.graph.DataFilterImpl;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphDefaultValues;
import oracle.dss.graph.UIGraph;
import oracle.dss.graph.gui.UIGraphAdapter;
import oracle.dss.util.DataAccess;
import oracle.dss.util.DataException;
import oracle.dss.util.ErrorHandler;
import oracle.dss.util.WaitData;

public class DataFilterAdapter
extends DataFilterImpl {
    protected boolean[] m_graphCategoriesSet;
    private UIGraph m_graph;

    public DataFilterAdapter(UIGraph uIGraph) {
        this.m_graph = uIGraph;
        this.d_totalMeasures = GraphDefaultValues.getTotalMeasures();
        this.m_graphCategoriesSet = new boolean[12];
        int n = 0;
        while (n < 12) {
            this.m_graphCategoriesSet[n] = false;
            ++n;
        }
    }

    public void setMeasures(int[] nArray, int n) {
        super.setMeasures(nArray, n);
        this.m_graphCategoriesSet[this.m_graphCategory] = true;
    }

    public void setMeasures(int n, int[] nArray, int n2) {
        super.setMeasures(n, nArray, n2);
        this.m_graphCategoriesSet[this.getGraphCategory((int)n)] = true;
    }

    public Object getValue(int n, int n2) {
        int n3 = this.getDataAccessRow(n);
        int n4 = this.getDataAccessColumn(n2);
        try {
            Object object = null;
            object = this.getDataAccess().getValue(n3, n4, "dataUnformatted");
            if (object instanceof WaitData) {
                Object var6_7 = null;
                return var6_7;
            }
            Object object2 = object;
            return object2;
        }
        catch (DataException dataException) {
            this.getErrorHandler().error(dataException, this.getClass().getName(), "getValue");
            Object var6_9 = null;
            return var6_9;
        }
    }

    protected void initMeasuresFromGraph(Graph graph) {
        int[][] nArray = ((DataFilterImpl)graph.getDataFilter()).getMArray();
        int n = 0;
        while (n < 12) {
            if (nArray[n] != null) {
                this.m_measuresArrays[n] = new int[nArray[n].length];
                int n2 = 0;
                while (n2 < nArray[n].length) {
                    this.m_measuresArrays[n][n2] = nArray[n][n2];
                    ++n2;
                }
            }
            ++n;
        }
    }

    protected void applyMeasuresToGraph(Graph graph) {
        int[][] nArray = ((DataFilterImpl)graph.getDataFilter()).getMArray();
        int n = 0;
        while (n < 12) {
            if (this.m_graphCategoriesSet[n]) {
                nArray[n] = new int[this.m_measuresArrays[n].length];
                int n2 = 0;
                while (n2 < this.m_measuresArrays[n].length) {
                    nArray[n][n2] = this.m_measuresArrays[n][n2];
                    ++n2;
                }
            }
            ++n;
        }
    }

    protected void needRec() {
    }

    protected DataAccess getDataAccess() {
        return ((UIGraphAdapter)this.m_graph).getDataAccess();
    }

    protected ErrorHandler getErrorHandler() {
        return ((UIGraphAdapter)this.m_graph).getErrorHandler();
    }

    protected void cleanUp() {
        this.m_graph = null;
    }
}

