/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.util.Vector;
import oracle.dss.graph.GraphTypeAndSubtype;
import oracle.dss.graph.GraphTypeConverter;
import oracle.dss.graph.Type;
import oracle.dss.graph.UIGraph;

public class GraphUtils {
    public static boolean is3DDisabled(UIGraph uIGraph) {
        Type type = GraphUtils.getCurrentType(uIGraph);
        if (type == null) {
            return true;
        }
        return !type.supports3D || !type.supportsNon3D;
    }

    public static boolean isGradientDisabled(UIGraph uIGraph) {
        if (uIGraph != null) {
            int n = uIGraph.getGraphType();
            return GraphUtils.isLineGraph(n) || n == 76 || n == 79 || n == 12;
        }
        return true;
    }

    private static Type getCurrentType(UIGraph uIGraph) {
        if (uIGraph != null) {
            GraphTypeConverter graphTypeConverter = uIGraph.getGraphTypeConverter();
            GraphTypeAndSubtype graphTypeAndSubtype = graphTypeConverter.getTypeAndSubtype(uIGraph);
            Vector vector = graphTypeConverter.getTypes();
            int n = 0;
            while (n < vector.size()) {
                Type type = (Type)vector.elementAt(n);
                if (graphTypeAndSubtype.type == type.id) {
                    return type;
                }
                ++n;
            }
        }
        return null;
    }

    public static boolean isBubbleGraph(int n) {
        return n >= 89 && n <= 92;
    }

    public static boolean isLineGraph(int n) {
        return n >= 41 && n <= 54;
    }

    public static boolean isPieGraph(int n) {
        return n >= 55 && n <= 60 || n >= 93 && n <= 94;
    }

    public static boolean isPolarGraph(int n) {
        return n == 65 || n == 66;
    }

    public static boolean isRadarGraph(int n) {
        return n >= 67 && n <= 69;
    }

    public static boolean isScatterGraph(int n) {
        return n >= 61 && n <= 64;
    }

    public static boolean isStockGraph(int n) {
        return n >= 70 && n <= 84 || n == 88;
    }

    public static boolean isPercentGraph(int n) {
        switch (n) {
            case 23: 
            case 30: 
            case 35: 
            case 47: {
                return true;
            }
        }
        return false;
    }

    public static boolean is3DGraph(int n) {
        return n >= 0 && n <= 14;
    }

    public static boolean isDotType(int n) {
        return GraphUtils.isScatterGraph(n) || GraphUtils.isBubbleGraph(n) || GraphUtils.isPolarGraph(n);
    }

    public static boolean isLegendEnabled(int n) {
        return !(GraphUtils.is3DGraph(n) && n != 12 || n == 102 || n >= 70 && n <= 72) && n != 84;
    }

    public static boolean isDataMarkerSupported(UIGraph uIGraph) {
        int n = uIGraph.getGraphType();
        return GraphUtils.isLineGraph(n) || GraphUtils.isDotType(n) || n == 102 || uIGraph.getGraphTypeConverter().isCombinationType(uIGraph);
    }
}

