/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.pivot.PageItem;
import oracle.bali.ewt.pivot.PagingPivotEvent;
import oracle.bali.ewt.pivot.PagingPivotListener;
import oracle.bali.ewt.util.WindowUtils;
import oracle.dss.dataView.BaseTitle;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.ControllerAdapter;
import oracle.dss.dataView.DataComponentHandle;
import oracle.dss.dataView.DataviewPagingComponent;
import oracle.dss.dataView.DataviewUtils;
import oracle.dss.dataView.GroupComponentHandle;
import oracle.dss.dataView.NonDataComponentHandle;
import oracle.dss.dataView.PageItemComponentHandle;
import oracle.dss.dataView.SeriesComponentHandle;
import oracle.dss.dataView.ViewComponent;
import oracle.dss.graph.DataCallback;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphController;
import oracle.dss.graph.GraphFootnote;
import oracle.dss.graph.GraphModel;
import oracle.dss.graph.GraphPagingControl;
import oracle.dss.graph.GraphSubtitle;
import oracle.dss.graph.GraphTitle;
import oracle.dss.graph.NotEnoughData;
import oracle.dss.graph.PFJ;
import oracle.dss.graph.pfj.KeyState;
import oracle.dss.graph.pfj.TDGMouseState;
import oracle.dss.graph.pfj.TDGNotEnoughData;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.event.TDGError;
import oracle.dss.graph.pfj.event.TDGErrorListener;
import oracle.dss.graph.pfj.event.TDGEvent;
import oracle.dss.graph.pfj.event.TDGListener;
import oracle.dss.util.DataException;
import oracle.dss.util.GroupComponentInfo;

public class GraphControllerAdapter
extends ControllerAdapter
implements GraphController,
TDGListener,
PagingPivotListener,
PropertyChangeListener,
TDGErrorListener {
    protected Graph m_graph;
    protected GraphModel m_model;
    protected PFJ m_pfj;
    protected int m_selectedComponentHandle = 67;
    protected int m_currentComponentHandle;
    protected boolean m_isCursorOnResizeHandle;
    protected int m_resizeCursorValue;
    protected ComponentHandle m_currentHandle;
    protected ComponentHandle m_selectedObject;
    private boolean _m_selectingPageItem;
    private boolean m_shiftKey;
    private boolean m_canDrill;
    private static final String m_method_perspectiveEvent = "public void perspectiveEvent( TDGEvent event )";

    public GraphControllerAdapter(Graph graph, GraphModel graphModel) {
        super(graph);
        this.m_graph = graph;
        this.m_model = graphModel;
        this.m_pfj = this.m_graph.getPFJ();
        this.m_pfj.addPerspectiveListener(this);
        this.m_pfj.addErrorListener(this);
        this.m_isCursorOnResizeHandle = false;
        this.m_pfj.addFocusListener(this);
        graph.getPagingControl().addKeyListener(this);
        graph.getPagingControl().addMouseListener(this);
        graph.getPagingControl().addMouseMotionListener(this);
        graph.getPagingControl().addFocusListener(this);
        ((GraphPagingControl)graph.getPagingControl()).addPagingPropertyListener(this);
        ((GraphPagingControl)graph.getPagingControl()).addPagingPivotListener(this);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseEvent = mouseEvent;
        final NonDataComponentHandle nonDataComponentHandle = this.getNonDataComponent((ViewComponent)mouseEvent.getSource());
        if (nonDataComponentHandle.getID() == 6 || nonDataComponentHandle.getID() == 7 || nonDataComponentHandle.getID() == 8) {
            Component component = (Component)mouseEvent.getSource();
            if (!component.isFocusTraversable()) {
                Component component2 = SwingUtilities.getRoot(component);
                component2.requestFocus();
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    this.setSelectedObject(nonDataComponentHandle);
                }
            });
        }
        this.processViewMouseEvent(mouseEvent, nonDataComponentHandle);
    }

    public void pivot(PagingPivotEvent pagingPivotEvent) {
        int n = 0;
        try {
            block4: {
                try {
                    int n2 = pagingPivotEvent.getSourceIndex();
                    int n3 = pagingPivotEvent.getDestinationIndex();
                    n = n2 < n3 ? 3 : 2;
                    this.setCursor(WindowUtils.getWindow((Component)this.m_graph), this.getCursorType(2));
                    if (!this.m_graph.getGraphModel().getControllerActions().canPivot(this.m_graph, 2, 2, n2, n3, n)) break block4;
                    this.m_graph.getGraphModel().getControllerActions().pivotGestureHappened(this.m_graph, 2, 2, n2, n3, n);
                }
                catch (DataException dataException) {
                    this.m_graph.getErrorHandler().error(dataException, this.getClass().getName(), "pivot");
                    Object var6_7 = null;
                    this.setCursor(WindowUtils.getWindow((Component)this.m_graph), this.getCursorType(0));
                }
            }
            Object var6_6 = null;
            this.setCursor(WindowUtils.getWindow((Component)this.m_graph), this.getCursorType(0));
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.setCursor(WindowUtils.getWindow((Component)this.m_graph), this.getCursorType(0));
            throw throwable;
        }
    }

    public void swap(PagingPivotEvent pagingPivotEvent) {
        try {
            block4: {
                try {
                    int n = pagingPivotEvent.getSourceIndex();
                    int n2 = pagingPivotEvent.getDestinationIndex();
                    this.setCursor(WindowUtils.getWindow((Component)this.m_graph), this.getCursorType(2));
                    if (!this.m_graph.getGraphModel().getControllerActions().canPivot(this.m_graph, 2, 2, n, n2, 1)) break block4;
                    this.m_graph.getGraphModel().getControllerActions().pivotGestureHappened(this.m_graph, 2, 2, n, n2, 1);
                }
                catch (DataException dataException) {
                    this.m_graph.getErrorHandler().error(dataException, this.getClass().getName(), "swap");
                    Object var5_6 = null;
                    this.setCursor(WindowUtils.getWindow((Component)this.m_graph), this.getCursorType(0));
                }
            }
            Object var5_5 = null;
            this.setCursor(WindowUtils.getWindow((Component)this.m_graph), this.getCursorType(0));
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.setCursor(WindowUtils.getWindow((Component)this.m_graph), this.getCursorType(0));
            throw throwable;
        }
    }

    protected void setCursor(Component component, Cursor cursor) {
        component.setCursor(cursor);
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = 0;
            while (n < container.getComponentCount()) {
                this.setCursor(container.getComponent(n), cursor);
                ++n;
            }
        }
    }

    private boolean _isDrillUpComponent(int n) {
        boolean bl = false;
        switch (n) {
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                bl = true;
            }
        }
        return bl;
    }

    private void _drillUp(ComponentHandle componentHandle) {
        int n;
        boolean bl = this.m_graph.isDataRowShownAsASeries();
        int n2 = n = bl ? 1 : 0;
        if (componentHandle.getID() == 70) {
            n = bl ? 0 : 1;
        }
        try {
            int n3 = 16;
            if (this.m_model.getDataAccess().getLayerCount(n) > 0 && this.m_model.getControllerActions().canDrill(this.m_graph, n, 0, 0, n3)) {
                this.m_model.getControllerActions().drillGestureHappened(this.m_graph, n, 0, 0, n3);
            }
        }
        catch (DataException dataException) {
            this.m_graph.getErrorHandler().error(dataException, this.getClass().getName(), "_mouseClicked");
        }
    }

    private boolean _canDrill(ComponentHandle componentHandle) {
        boolean bl = false;
        boolean bl2 = this.m_graph.isDataRowShownAsASeries();
        if (this.m_graph.isDrillingEnabled() && this.m_graph.isDrillingSupported() && this.m_graph.isMetadataDrillSupported()) {
            switch (componentHandle.getID()) {
                case 17: 
                case 18: 
                case 59: {
                    int n = bl2 ? 1 : 0;
                    bl = this.m_graph.getDrillState(n, ((SeriesComponentHandle)componentHandle).getSeries());
                    break;
                }
                case 14: 
                case 38: 
                case 40: {
                    int n = bl2 ? 1 : 0;
                    bl = this.m_graph.getDrillState(n, ((DataComponentHandle)componentHandle).getSeries());
                    break;
                }
                case 10: 
                case 13: 
                case 32: {
                    int n = bl2 ? 1 : 0;
                    int n2 = 0;
                    n2 = this.m_graph.isPie(this.m_graph.getGraphType()) ? ((DataComponentHandle)componentHandle).getSeries() : ((SeriesComponentHandle)componentHandle).getSeries();
                    bl = this.m_graph.getDrillState(n, n2);
                    break;
                }
                case 24: 
                case 28: {
                    GroupComponentInfo groupComponentInfo = (GroupComponentInfo)componentHandle.getComponentInfo();
                    if (this.m_pfj.isTimeAxis() && groupComponentInfo.getLayer() == 0 && this.m_pfj.getO1LabelCallBack().getNumLevels() == 2) {
                        bl = false;
                        break;
                    }
                    int n = bl2 ? 0 : 1;
                    bl = this.m_graph.getDrillState(n, ((GroupComponentHandle)componentHandle).getGroup());
                    break;
                }
                case 70: 
                case 71: 
                case 72: 
                case 73: {
                    bl = true;
                }
            }
        }
        return bl;
    }

    private boolean _isMovableSubcomponent(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 16: 
            case 27: 
            case 29: {
                return true;
            }
        }
        return false;
    }

    private void _mouseMoved(TDGEvent tDGEvent) {
        TDGMouseState tDGMouseState = (TDGMouseState)tDGEvent.getDataObject();
        ComponentHandle componentHandle = this.m_graph.getGraphComponentHandle(tDGMouseState);
        this.m_currentComponentHandle = componentHandle.getID();
        if (componentHandle != null && !componentHandle.equals(this.m_currentHandle)) {
            this.m_currentHandle = componentHandle;
            this.m_canDrill = this._canDrill(componentHandle);
            this.setGraphCursor(this.m_currentComponentHandle);
        }
        this.mouseEvent = tDGMouseState.getMouseEvent();
        this.processViewMouseMotionEvent(tDGMouseState.getMouseEvent(), componentHandle);
    }

    private void _mousePressed(TDGEvent tDGEvent) {
        TDGMouseState tDGMouseState = (TDGMouseState)tDGEvent.getDataObject();
        ComponentHandle componentHandle = this.m_graph.getGraphComponentHandle(tDGMouseState);
        this.mouseEvent = tDGMouseState.getMouseEvent();
        this.processViewMouseEvent(tDGMouseState.getMouseEvent(), componentHandle);
    }

    private void _mouseDragged(TDGEvent tDGEvent) {
        TDGMouseState tDGMouseState = (TDGMouseState)tDGEvent.getDataObject();
        ComponentHandle componentHandle = this.m_graph.getGraphComponentHandle(tDGMouseState);
        this._updatePlacementFlags();
        this.mouseEvent = tDGMouseState.getMouseEvent();
        this.processViewMouseMotionEvent(tDGMouseState.getMouseEvent(), componentHandle);
    }

    private void _mouseClicked(TDGEvent tDGEvent) {
        TDGMouseState tDGMouseState = (TDGMouseState)tDGEvent.getDataObject();
        ComponentHandle componentHandle = this.m_graph.getGraphComponentHandle(tDGMouseState);
        this.mouseEvent = tDGMouseState.getMouseEvent();
        this.processViewMouseEvent(tDGMouseState.getMouseEvent(), componentHandle);
        int n = 2;
        switch (componentHandle.getID()) {
            case 18: 
            case 24: 
            case 28: 
            case 59: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                n = 1;
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 17: 
            case 32: 
            case 38: 
            case 40: {
                n = 2;
            }
        }
        if (SwingUtilities.isLeftMouseButton(tDGMouseState.getMouseEvent()) && tDGMouseState.getMouseEvent().getClickCount() == n && this.m_model.isDrillingEnabled() && this.m_graph.isEnabled() && this.m_canDrill) {
            if (this._isDrillUpComponent(componentHandle.getID())) {
                this._drillUp(componentHandle);
                return;
            }
            int[] nArray = this.m_graph.getDrillParameters(componentHandle);
            if (nArray == null) {
                return;
            }
            try {
                int n2 = 0;
                n2 = this.m_shiftKey ? 2 : 1;
                if (this.m_model.getDataAccess().getLayerCount(nArray[0]) > 0 && this.m_model.getControllerActions().canDrill(this.m_graph, nArray[0], nArray[1], nArray[2], n2)) {
                    this.m_model.getControllerActions().drillGestureHappened(this.m_graph, nArray[0], nArray[1], nArray[2], n2);
                }
            }
            catch (DataException dataException) {
                this.m_graph.getErrorHandler().error(dataException, this.getClass().getName(), "_mouseClicked");
            }
        }
    }

    private void _mouseReleased(TDGEvent tDGEvent) {
        TDGMouseState tDGMouseState = (TDGMouseState)tDGEvent.getDataObject();
        ComponentHandle componentHandle = this.m_graph.getGraphComponentHandle(tDGMouseState);
        this.mouseEvent = tDGMouseState.getMouseEvent();
        this.processViewMouseEvent(tDGMouseState.getMouseEvent(), componentHandle);
    }

    private void _mouseEntered(TDGEvent tDGEvent) {
        TDGMouseState tDGMouseState = (TDGMouseState)tDGEvent.getDataObject();
        ComponentHandle componentHandle = this.m_graph.getGraphComponentHandle(tDGMouseState);
        this.mouseEvent = tDGMouseState.getMouseEvent();
        this.processViewMouseEvent(tDGMouseState.getMouseEvent(), componentHandle);
    }

    private void _mouseExited(TDGEvent tDGEvent) {
        TDGMouseState tDGMouseState = (TDGMouseState)tDGEvent.getDataObject();
        ComponentHandle componentHandle = this.m_graph.getGraphComponentHandle(tDGMouseState);
        this.mouseEvent = tDGMouseState.getMouseEvent();
        this.processViewMouseEvent(tDGMouseState.getMouseEvent(), componentHandle);
    }

    private void _keyTyped(TDGEvent tDGEvent) {
        KeyState keyState = (KeyState)tDGEvent.getDataObject();
        this.processViewKeyEvent(keyState.getKeyEvent(), null);
    }

    private void _keyPressed(TDGEvent tDGEvent) {
        KeyState keyState = (KeyState)tDGEvent.getDataObject();
        this.m_shiftKey = keyState.getKeyEvent().getKeyCode() == 16;
        this.processViewKeyEvent(keyState.getKeyEvent(), null);
    }

    private void _keyReleased(TDGEvent tDGEvent) {
        KeyState keyState = (KeyState)tDGEvent.getDataObject();
        this.m_shiftKey = false;
        this.processViewKeyEvent(keyState.getKeyEvent(), null);
    }

    private void _afterSelect(TDGEvent tDGEvent) {
        this.setSelectedObject(null);
        Object object = tDGEvent.getDataObject();
        ComponentHandle componentHandle = this.m_graph.getSelectedObject();
        this.m_selectedComponentHandle = componentHandle == null ? 67 : componentHandle.getID();
        if (this.m_currentComponentHandle == this.m_selectedComponentHandle) {
            this.setGraphCursor(this.m_selectedComponentHandle);
        }
        this.fireComponentSelected(this.m_graph, componentHandle);
    }

    private void _updatePlacementFlags() {
        ComponentHandle componentHandle = this.m_graph.getSelectedObject();
        int n = -1;
        if (componentHandle != null) {
            n = componentHandle.getID();
        }
        if (n == 29 || n == 27) {
            this.m_graph.setFrameSizeAutomatic(false);
        } else if (n == 16) {
            this.m_graph.getLegendArea().setRectDefault(false);
        } else if (n == 0) {
            if (this.m_graph.getTitle() instanceof GraphTitle) {
                ((GraphTitle)this.m_graph.getTitle()).setRectDefault(false);
            }
        } else if (n == 1) {
            if (this.m_graph.getSubtitle() instanceof GraphSubtitle) {
                ((GraphSubtitle)this.m_graph.getSubtitle()).setRectDefault(false);
            }
        } else if (n == 2 && this.m_graph.getFootnote() instanceof GraphFootnote) {
            ((GraphFootnote)this.m_graph.getFootnote()).setRectDefault(false);
        }
    }

    private void _resizeHandle() {
        this.m_isCursorOnResizeHandle = true;
        switch (this.m_resizeCursorValue) {
            case 6: {
                this.m_pfj.setCursor(this.m_nwResizeCursor);
                break;
            }
            case 8: {
                this.m_pfj.setCursor(this.m_nResizeCursor);
                break;
            }
            case 7: {
                this.m_pfj.setCursor(this.m_neResizeCursor);
                break;
            }
            case 11: {
                this.m_pfj.setCursor(this.m_eResizeCursor);
                break;
            }
            case 5: {
                this.m_pfj.setCursor(this.m_seResizeCursor);
                break;
            }
            case 9: {
                this.m_pfj.setCursor(this.m_sResizeCursor);
                break;
            }
            case 4: {
                this.m_pfj.setCursor(this.m_swResizeCursor);
                break;
            }
            case 10: {
                this.m_pfj.setCursor(this.m_wResizeCursor);
                break;
            }
            default: {
                this.m_isCursorOnResizeHandle = false;
            }
        }
    }

    private void _notEnoughData(TDGEvent tDGEvent) {
        TDGNotEnoughData tDGNotEnoughData = (TDGNotEnoughData)tDGEvent.getDataObject();
        int n = -1;
        if (this.m_graph.isExcelOrDeskTop()) {
            try {
                tDGNotEnoughData.nNumActualColsOfData = ((DataCallback)this.m_graph.getDataFilter()).getDataAccess().getEdgeExtent(0);
                tDGNotEnoughData.nNumActualRowsOfData = ((DataCallback)this.m_graph.getDataFilter()).getDataAccess().getEdgeExtent(1);
            }
            catch (Exception exception) {
                tDGNotEnoughData.nNumActualColsOfData = 0;
                tDGNotEnoughData.nNumActualRowsOfData = 0;
            }
            boolean bl = this.m_graph.isDataRowShownAsASeries();
            if (bl) {
                tDGNotEnoughData.nNumNeededColsOfData = 1;
                tDGNotEnoughData.nNumNeededRowsOfData = 2;
            } else {
                tDGNotEnoughData.nNumNeededColsOfData = 2;
                tDGNotEnoughData.nNumNeededRowsOfData = 1;
            }
            tDGNotEnoughData.bEnoughRowsOfData = true;
            tDGNotEnoughData.bEnoughColsOfData = true;
            if (tDGNotEnoughData.nNumActualColsOfData < tDGNotEnoughData.nNumNeededColsOfData) {
                tDGNotEnoughData.bEnoughColsOfData = false;
            }
            if (tDGNotEnoughData.nNumActualRowsOfData < tDGNotEnoughData.nNumNeededRowsOfData) {
                tDGNotEnoughData.bEnoughRowsOfData = false;
            }
        }
        if (!tDGNotEnoughData.bEnoughRowsOfData && !tDGNotEnoughData.bEnoughColsOfData) {
            n = 3;
        } else if (!tDGNotEnoughData.bEnoughRowsOfData) {
            n = 2;
        } else if (!tDGNotEnoughData.bEnoughColsOfData) {
            n = 1;
        } else {
            this.m_graph.getErrorHandler().log("unknown insufficient data condition", this.getClass().getName(), "_notEnoughData(TDGEvent event)");
        }
        NotEnoughData notEnoughData = new NotEnoughData();
        notEnoughData.insufficientDataCondition = n;
        notEnoughData.actualColumnCount = tDGNotEnoughData.nNumActualColsOfData;
        notEnoughData.requiredColumnCount = tDGNotEnoughData.nNumNeededColsOfData;
        notEnoughData.actualRowCount = tDGNotEnoughData.nNumActualRowsOfData;
        notEnoughData.requiredRowCount = tDGNotEnoughData.nNumNeededRowsOfData;
        this.m_graph.notEnoughData(notEnoughData);
    }

    public void setSelectedObject(ComponentHandle componentHandle) {
        this.m_selectedObject = componentHandle;
        this._m_selectingPageItem = true;
        this.changeTitleSelectedState(false);
        if (componentHandle != null && componentHandle.getComponent() instanceof BaseTitle) {
            ((BaseTitle)componentHandle.getComponent()).setSelected(true);
            this.m_pfj.setSelection((IdentObj)null);
            this.fireComponentSelected(this.m_graph, componentHandle);
        } else if (componentHandle instanceof PageItemComponentHandle) {
            PageItemComponentHandle pageItemComponentHandle = (PageItemComponentHandle)componentHandle;
            DataviewUtils.selectPageItem(this.m_graph, pageItemComponentHandle.getPageItem());
            this.m_pfj.setSelection((IdentObj)null);
            this.fireComponentSelected(this.m_graph, componentHandle);
        } else {
            this.m_selectedComponentHandle = 67;
            if (this.m_graph.getPagingControl().getPagingComponent() != null) {
                this.m_graph.getPagingControl().getPagingComponent().setSelectedItem(null);
            }
        }
        this._m_selectingPageItem = false;
    }

    public ComponentHandle getSelectedObject() {
        return this.m_selectedObject;
    }

    public void setCursorType(Cursor cursor, int n) {
        Cursor cursor2 = this.m_pfj.getCursor();
        if (cursor2 != null && cursor2.equals(this.getCursorType(n))) {
            this.m_pfj.setCursor(cursor);
        }
        if (n < 0 || n > 16) {
            this.m_graph.getErrorHandler().log("invalid cursor type", this.getClass().getName(), "setCursorType(Cursor c, int type)");
        } else {
            super.setCursorType(cursor, n);
        }
    }

    public void setWaitCursorForced(boolean bl) {
        super.setWaitCursorForced(bl);
        this.setGraphCursor(this.m_currentComponentHandle);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        PageItem pageItem;
        DataviewPagingComponent dataviewPagingComponent;
        int n;
        if (!this._m_selectingPageItem && propertyChangeEvent.getSource() instanceof DataviewPagingComponent && propertyChangeEvent.getPropertyName() == "selectedIndex" && (n = (dataviewPagingComponent = (DataviewPagingComponent)propertyChangeEvent.getSource()).getIndex(pageItem = dataviewPagingComponent.getSelectedItem())) != -1) {
            this.m_graph.selectObject(new PageItemComponentHandle(4, "PageItem", dataviewPagingComponent, n));
        }
    }

    public void setGraphCursor(int n) {
        if (this.m_isWaitCursor) {
            if (!this.m_pfj.getCursor().equals(this.m_waitCursor)) {
                this.m_pfj.setCursor(this.m_waitCursor);
            }
            return;
        }
        if (this.m_graph.getMouseActions() != 1) {
            if (this.m_pfj.getCursor() == null || !this.m_pfj.getCursor().equals(this.m_defaultCursor)) {
                this.m_pfj.setCursor(this.m_defaultCursor);
            }
            return;
        }
        if (this.m_model.isDrillingEnabled() && this.m_graph.isEnabled() && this.m_canDrill) {
            switch (n) {
                case 10: 
                case 13: 
                case 14: 
                case 17: 
                case 32: 
                case 38: 
                case 40: 
                case 73: {
                    return;
                }
            }
            if (!this.m_pfj.getCursor().equals(this.m_drillCursor)) {
                this.m_pfj.setCursor(this.m_drillCursor);
            }
            return;
        }
        if (n == this.m_selectedComponentHandle) {
            if (this._isMovableSubcomponent(n)) {
                if (this.m_graph.isMouseMovingEnabled()) {
                    if (this.m_isCursorOnResizeHandle) {
                        this._resizeHandle();
                        return;
                    }
                    if (!this.m_pfj.getCursor().equals(this.m_moveCursor)) {
                        this.m_pfj.setCursor(this.m_moveCursor);
                    }
                }
            } else if (!this.m_pfj.getCursor().equals(this.m_defaultCursor)) {
                this.m_pfj.setCursor(this.m_defaultCursor);
            }
        } else {
            if (this.m_isCursorOnResizeHandle) {
                this._resizeHandle();
                return;
            }
            this.m_pfj.setCursor(this.m_defaultCursor);
        }
        this.m_isCursorOnResizeHandle = false;
    }

    public void errorEvent(TDGError tDGError) {
        int n = tDGError.getID();
        switch (n) {
            case 3978: {
                this.m_graph.getErrorHandler().log("No Image has been specified as the texture.", this.getClass().getName(), "errorEvent(oracle.dss.graph.pfj.event.TDGError event)");
                break;
            }
        }
    }

    public void perspectiveEvent(TDGEvent tDGEvent) {
        Object object = tDGEvent.getSource();
        int n = tDGEvent.getBitSet();
        String string = null;
        if ((n & 2) > 0 && (n & 1) > 0 && (n & 4) > 0) {
            string = "null, negative and zero";
        } else if ((n & 2) > 0 && (n & 1) > 0) {
            string = "negative and zero";
        } else if ((n & 2) > 0 && (n & 4) > 0) {
            string = "negative and null";
        } else if ((n & 1) > 0 && (n & 4) > 0) {
            string = "zero and null";
        } else if ((n & 1) > 0) {
            string = "zero";
        } else if ((n & 4) > 0) {
            string = "null";
        } else if ((n & 2) > 0) {
            string = "negative";
        }
        if (object == this.m_pfj) {
            switch (tDGEvent.getID()) {
                case 3968: {
                    this._mouseMoved(tDGEvent);
                    break;
                }
                case 3965: {
                    this._mousePressed(tDGEvent);
                    break;
                }
                case 3966: {
                    this._mouseDragged(tDGEvent);
                    break;
                }
                case 3967: {
                    this._mouseReleased(tDGEvent);
                    break;
                }
                case 3974: {
                    this._mouseClicked(tDGEvent);
                    break;
                }
                case 3973: {
                    this._mouseEntered(tDGEvent);
                    break;
                }
                case 3972: {
                    this._mouseExited(tDGEvent);
                    break;
                }
                case 3969: {
                    this._keyPressed(tDGEvent);
                    break;
                }
                case 3970: {
                    this._keyReleased(tDGEvent);
                    break;
                }
                case 3971: {
                    this._keyTyped(tDGEvent);
                    break;
                }
                case 3959: {
                    this._afterSelect(tDGEvent);
                    break;
                }
                case 3976: {
                    this.m_resizeCursorValue = (Integer)tDGEvent.getDataObject();
                    this._resizeHandle();
                    break;
                }
                case 3975: {
                    this._notEnoughData(tDGEvent);
                    break;
                }
                case 3985: {
                    this.m_graph.processAlertEvent(3);
                    this.m_graph.getErrorHandler().log("inappropriate data: partial group", this.getClass().getName(), m_method_perspectiveEvent);
                    break;
                }
                case 3980: {
                    this.m_graph.processAlertEvent(4);
                    this.m_graph.getErrorHandler().log("inappropriate data: stock high less than low", this.getClass().getName(), m_method_perspectiveEvent);
                    break;
                }
                case 3984: {
                    this.m_graph.processAlertEvent(5);
                    this.m_graph.getErrorHandler().log("inappropriate data: stock open or close not between high and low", this.getClass().getName(), m_method_perspectiveEvent);
                    break;
                }
                case 3992: {
                    this.m_graph.processAlertEvent(6);
                    this.m_graph.getErrorHandler().log(String.valueOf(String.valueOf("inappropriate data: all values are ")) + string, this.getClass().getName(), m_method_perspectiveEvent);
                    break;
                }
                case 3993: {
                    this.m_graph.processAlertEvent(7);
                    this.m_graph.getErrorHandler().log("inappropriate data: all data null", this.getClass().getName(), m_method_perspectiveEvent);
                    break;
                }
                case 3994: {
                    this.m_graph.processAlertEvent(8);
                    this.m_graph.getErrorHandler().log(String.valueOf(String.valueOf("inappropriate data: partial data ")) + string, this.getClass().getName(), m_method_perspectiveEvent);
                    break;
                }
                case 3995: {
                    this.m_graph.processAlertEvent(9);
                    this.m_graph.getErrorHandler().log("inappropriate data: partial data is null", this.getClass().getName(), m_method_perspectiveEvent);
                    break;
                }
                case 3996: {
                    this.m_graph.processAlertEvent(10);
                    this.m_graph.getErrorHandler().log(String.valueOf(String.valueOf("inappropriate data: all axis data ")) + string, this.getClass().getName(), m_method_perspectiveEvent);
                    break;
                }
                case 3997: {
                    this.m_graph.processAlertEvent(11);
                    this.m_graph.getErrorHandler().log("inappropriate data: axis data is null", this.getClass().getName(), m_method_perspectiveEvent);
                    break;
                }
                case 3998: {
                    this.m_graph.getErrorHandler().log("inappropriate data: dates are out of order", this.getClass().getName(), m_method_perspectiveEvent);
                    break;
                }
                case 3999: {
                    this.m_graph.getErrorHandler().log("inappropriate data: dates have irregular interval", this.getClass().getName(), m_method_perspectiveEvent);
                    break;
                }
                case 4000: {
                    this.m_graph.getErrorHandler().log("inappropriate data: dates are missing in the sequence", this.getClass().getName(), m_method_perspectiveEvent);
                    break;
                }
                case 4001: {
                    this.m_graph.getLegendArea().setPositionForRect();
                    break;
                }
                case 4002: {
                    this.m_graph.getErrorHandler().log("formats for all relevant time axis elements are NONE", this.getClass().getName(), m_method_perspectiveEvent);
                    break;
                }
                case 3962: {
                    this._afterSelect(tDGEvent);
                    break;
                }
                default: {
                    return;
                }
            }
        }
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_graph.getPagingControl().removeKeyListener(this);
        this.m_graph.getPagingControl().removeMouseListener(this);
        this.m_graph.getPagingControl().removeMouseMotionListener(this);
        this.m_graph.getPagingControl().removeFocusListener(this);
        ((GraphPagingControl)this.m_graph.getPagingControl()).removePagingPropertyListener(this);
        ((GraphPagingControl)this.m_graph.getPagingControl()).removePagingPivotListener(this);
        this.m_pfj.removeFocusListener(this);
        this.m_pfj.removePerspectiveListener(this);
        this.m_pfj.removeErrorListener(this);
    }
}

