/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.bali.ewt.util.LocaleUtils;
import oracle.dss.graph.Graph;
import oracle.dss.graph.GraphFootnote;
import oracle.dss.graph.GraphSubtitle;
import oracle.dss.graph.GraphTitle;
import oracle.dss.graph.pfj.Access;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.AutoLabelLayout;
import oracle.dss.graph.pfj.CircularAxisObj;
import oracle.dss.graph.pfj.DataRange;
import oracle.dss.graph.pfj.DateGroupLabels;
import oracle.dss.graph.pfj.JChart_2D_Circular;
import oracle.dss.graph.pfj.JChart_Base;
import oracle.dss.graph.pfj.LegendObj;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.ReferenceLineObj;
import oracle.dss.graph.pfj.TitleObj;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.DetObj;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;

public class BILabelLayout
implements AutoLabelLayout {
    private static final int MINIMUM_FRAME_DEPTH = 3000;
    private static final int MINIMUM_FRAME_EXTENT = 8000;
    private static final double MIN_FONTHEIGHT_RATIO = 1.0;
    private static final double MIN_FONTHEIGHT_RATIO_WRAP = 1.5;
    private static final int MIMIMUM_SIGNIFICANT_SHIFT = 100;
    private static final int DEFAULT_LABEL_MARGIN = 100;
    private static final int DEFAULT_WRAPPING_DEPTH = 40;
    private static final int MINIMUM_WRAPPING_GAIN = 15;
    private static final int WRAPPING_DEPTH_INCREMENT = 3;
    private static final int MAX_ROTATED_WRAPPED_LINES = 5;
    private static final int DEFAULT_MARGIN = 10;
    private static final int PAIR_MARGIN = 5;
    private static final int DEFAULT_AXIS_TITLE_MARGIN = 10;
    private static final int DEFAULT_AXIS_MARGIN_INSIDE = 5;
    private static final int INTERSECTING_EXTRA_MARGIN = 3;
    private static final int SIGNIFICANT_DIFF = 1000;
    private static final int LB_PLAIN = 0;
    private static final int LB_STAGGERED = 1;
    private static final int LB_WORDWRAPPED = 2;
    private static final int LB_ROTATED = 3;
    private static final int LEFT_SIDE = 0;
    private static final int TOP_SIDE = 1;
    private static final int RIGHT_SIDE = 2;
    private static final int BOTTOM_SIDE = 3;
    private static final int MARKER_SIZE = 11;
    private static final int GRAPH_MARGIN = 10;
    private static final int GRAPH_LEGEND_GAP = 10;
    private int m_graphMarginV;
    private int m_graphMarginH;
    private int m_graphLegendGapV;
    private int m_graphLegendGapH;
    private int m_maxBottomY;
    private int m_maxTopY;
    private boolean m_reset;
    private boolean m_legendDisplay;
    private Graph m_graph;

    public BILabelLayout(Graph graph) {
        this.m_graph = graph;
    }

    public boolean isAutoLayoutEnabled() {
        return this.m_reset || this.m_graph.getAutoLayout() == 1 || this.m_graph.getAutoLayout() == 2;
    }

    public void doAutoLayoutAndReset(boolean bl) {
        this.m_reset = bl;
    }

    public void logTruncatedError(IdentObj identObj) {
        if (identObj.getObjectID() == this.m_graph.getPFJ().getLegendArea().getObjectID()) {
            this.m_graph.processAlertEvent(0);
            this.m_graph.getErrorHandler().log("legend text truncated", this.getClass().getName(), "logTruncatedError");
        } else if (identObj.getObjectID() == this.m_graph.getPFJ().getO1Label().getObjectID()) {
            this.m_graph.processAlertEvent(13);
            this.m_graph.getErrorHandler().log("O1 Labels truncated", this.getClass().getName(), "logTruncatedError");
        } else if (identObj.getObjectID() == 295) {
            this.m_graph.processAlertEvent(14);
            this.m_graph.getErrorHandler().log("Slice Labels truncated", this.getClass().getName(), "logTruncatedError");
        } else {
            this.m_graph.processAlertEvent(2);
            this.m_graph.getErrorHandler().log("axis title truncated", this.getClass().getName(), "logTruncatedError");
        }
    }

    public void logAllMarkersError() {
        this.m_graph.processAlertEvent(1);
        this.m_graph.getErrorHandler().log("All legend markers are not displayed", this.getClass().getName(), "logAllMarkersError");
    }

    public boolean adjustProperties(Perspective perspective, Access access, JChart_Base jChart_Base, int n, LegendObj legendObj, TitleObj titleObj, TitleObj titleObj2, TitleObj titleObj3, Vector[] vectorArray, Object object) {
        int n2 = this.m_graph.getGraphType();
        this._setLegendDisplayed(legendObj);
        if (n2 >= 0 && n2 <= 14 && n2 != 12) {
            return false;
        }
        Graphics graphics = perspective.getGraphicsContext();
        boolean bl = perspective.getJGraphType().getAxisDescriptor().hasO1();
        boolean bl2 = jChart_Base instanceof JChart_2D_Circular;
        if (n2 == 12 || this.m_reset || this.m_graph.getAutoLayout() == 2 || !this._isTitlesLayoutValid(perspective, graphics) || !this._isLegendLayoutValid(perspective, legendObj, graphics) || bl && !BILabelLayout.isO1LabelsLayoutValid(perspective, graphics, access, n, object, bl2, this.m_graph) || !BILabelLayout.isDataAxisLayoutValid(perspective, graphics, vectorArray, object, this.m_graph, bl2)) {
            if (n2 != 12) {
                perspective.setAdditionalBottomAxisMargin(0);
                VC vC = perspective.getVC();
                this.m_graphMarginV = vC.destToVirtHeight(10);
                this.m_graphMarginH = vC.destToVirtWidth(10);
                this.m_graphLegendGapV = vC.destToVirtHeight(10);
                this.m_graphLegendGapH = vC.destToVirtWidth(10);
            }
            if (this._isLegendDisplayed() && this.m_graph.getLegendArea().getAutomaticPlacement() == 1) {
                int n3 = this.m_graph.getLegendArea().calcAutomaticPosition();
                if (this.m_reset) {
                    this.m_graph.getLegendArea().setPosition(n3);
                } else {
                    this.m_graph.getLegendArea().setAutomaticPosition(n3, this.m_reset);
                }
            }
            if (n2 == 12) {
                return true;
            }
            boolean bl3 = this.m_graph.getLegendArea().isAlongGraphEdge();
            if (bl3) {
                this.doLegendAutoLayout(graphics, legendObj, access, jChart_Base, perspective, this.m_reset);
                this.doTitlesAutoLayout(graphics, perspective, titleObj, titleObj2, titleObj3, bl3);
            } else {
                this.doTitlesAutoLayout(graphics, perspective, titleObj, titleObj2, titleObj3, bl3);
                this.doLegendAutoLayout(graphics, legendObj, access, jChart_Base, perspective, this.m_reset);
            }
            this.maximizePlotArea(legendObj, perspective);
            if (this.m_reset) {
                this.m_graph.getLegendArea().setRectDefault(false);
            }
            this.doDataAxisAutoLayout(perspective, graphics, vectorArray, object, bl2);
            if (bl) {
                this.doO1LabelsAutoLayout(perspective, graphics, access, n, object, bl2, this.m_graph);
            }
            this.centerLegend(perspective, legendObj);
            this.readjustTitles(perspective, bl3);
        }
        IdentObj identObj = perspective.getO1Label();
        perspective.putToLookNoCalc(identObj, Attr.Autofit, new Boolean(false), !this.m_reset);
        perspective.putToLookNoCalc(new IdentObj(2000), Attr.O1LabelAutoAngle, new Integer(0), !this.m_reset);
        perspective.putToLookNoCalc(perspective.getX1Title(), Attr.TitleTextWrap, Boolean.FALSE, !this.m_reset);
        perspective.putToLookNoCalc(perspective.getY1Title(), Attr.TitleTextWrap, Boolean.FALSE, !this.m_reset);
        perspective.putToLookNoCalc(perspective.getY2Title(), Attr.TitleTextWrap, Boolean.FALSE, !this.m_reset);
        perspective.putToLookNoCalc(BILabelLayout.getO1AxisTitle(perspective), Attr.TitleTextWrap, Boolean.FALSE, !this.m_reset);
        if (perspective.getAutoSkip(identObj) == 1) {
            perspective.putToLookNoCalc(identObj, Attr.AutoSkip, new Integer(0), !this.m_reset);
        }
        if (this.m_graph.isHorizontal()) {
            perspective.putToLookNoCalc(perspective.getY1Label(), Attr.RightTextJustHoriz, new Integer(1), !this.m_reset);
            perspective.putToLookNoCalc(perspective.getY2Label(), Attr.RightTextJustHoriz, new Integer(1), !this.m_reset);
        } else {
            perspective.putToLookNoCalc(perspective.getY1Label(), Attr.RightTextJustHoriz, new Integer(2), !this.m_reset);
            perspective.putToLookNoCalc(perspective.getY2Label(), Attr.RightTextJustHoriz, new Integer(2), !this.m_reset);
        }
        if (this.m_reset) {
            this.m_graph.getO1TickLabel().setPropertyOverrideFlags(9);
            this.m_graph.getX1Title().setPropertyOverrideFlags(3);
            this.m_graph.getY1Title().setPropertyOverrideFlags(3);
            this.m_graph.getY2Title().setPropertyOverrideFlags(3);
            this.m_graph.getO1Title().setPropertyOverrideFlags(3);
            this.m_graph.getY1TickLabel().setPropertyOverrideFlags(2);
            this.m_graph.getY2TickLabel().setPropertyOverrideFlags(2);
        }
        return true;
    }

    public void restoreProperties(Perspective perspective, Object object) {
    }

    public Object createContext() {
        return new _PropertyContext();
    }

    private static double getAngleFromRelAngle(double d, Perspective perspective) {
        double d2 = d * 360.0 + 90.0 + (double)perspective.getPieRotate();
        if (d2 > 360.0) {
            d2 -= 360.0;
        }
        return d2;
    }

    private void doCircularLabelsAutoLayout(Perspective perspective, Graphics graphics, Access access, Vector vector, boolean bl) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Rectangle rectangle = perspective.getRect(perspective.getFrame());
        IdentObj identObj = null;
        identObj = bl ? perspective.getX1Label() : perspective.getO1Label();
        if (perspective.getTextRotation(identObj) != 0) {
            n = n2 = (int)((double)rectangle.width * 0.1);
            n4 = n3 = (int)((double)rectangle.height * 0.1);
            if (n2 > 0) {
                rectangle.width -= n2;
            }
            if (n > 0) {
                rectangle.x += n;
                rectangle.width -= n;
            }
            if (n3 > 0) {
                rectangle.height -= n3 + perspective.getVC().destToVirtHeight(10);
            }
            if (n4 > 0) {
                rectangle.height -= n4 + perspective.getVC().destToVirtHeight(10);
                rectangle.y = rectangle.y + n4 + perspective.getVC().destToVirtHeight(10);
            }
            perspective.putToLookNoCalc(perspective.getFrame(), Attr.FrameRect, rectangle, !this.m_reset);
            return;
        }
        Rectangle rectangle2 = this.m_graph.getLegendArea().getRect();
        int n5 = 0;
        int n6 = 0;
        if (access != null) {
            DataRange dataRange = access.getViewableDataRangeSG(perspective);
            n5 = dataRange.getColStart();
            n6 = dataRange.getColStop();
        } else if (vector != null) {
            n5 = 0;
            n6 = vector.size() - 1;
        } else {
            return;
        }
        int n7 = n6 - n5 + 1;
        FontMetrics fontMetrics = BILabelLayout.getFontMetrics(graphics, perspective, identObj);
        int n8 = BILabelLayout.getPFJFontHeight(fontMetrics);
        double d = 1.0;
        if (this.m_graph.getGraphType() == 67 || this.m_graph.getGraphType() == 68) {
            if (n7 != 0) {
                d = 1.0 / (double)n7;
            }
        } else if (n7 > 1) {
            d = 1.0 / (double)(n7 - 1);
        }
        int n9 = this.m_graph.getLegendArea().getAutomaticPosition();
        int n10 = -16000;
        int n11 = 16000;
        if (perspective.getDisplay(perspective.getLegendArea()) && n9 == 3) {
            n10 = rectangle2.x + rectangle2.width;
        } else if (perspective.getDisplay(perspective.getLegendArea()) && n9 == 2) {
            n11 = rectangle2.x;
        }
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = n5;
        while (n16 <= n6) {
            Rectangle rectangle3;
            int n17;
            double d2 = 0.0;
            d2 = this.m_graph.getGraphType() == 67 || this.m_graph.getGraphType() == 68 ? (double)n16 * d + d / (double)2 : (double)n16 * d;
            double d3 = BILabelLayout.getAngleFromRelAngle(d2, perspective);
            Point point = new Point(0, 0);
            Point point2 = new Point();
            point2.x = rectangle.x + rectangle.width / 2;
            point2.y = rectangle.y + rectangle.height / 2;
            Dimension dimension = new Dimension();
            dimension.width = rectangle.width;
            dimension.height = rectangle.height;
            Dimension dimension2 = perspective.getVC().getVirtDimension();
            CircularAxisObj.polarToCartesian(point, d3, 1.0, dimension, point2, perspective.getVC());
            String string = null;
            string = bl ? (String)vector.elementAt(n16) : perspective.getGroupLabel(n16);
            int n18 = 0;
            if (string != null) {
                n18 = perspective.getVC().destToVirtWidth(fontMetrics.stringWidth(string)) + perspective.getVC().destToVirtWidth(10);
            }
            if (d3 > 355.0 || d3 < 5.0) {
                n17 = Math.min(dimension2.height / 2 - point.y, point.y + dimension2.height / 2);
                rectangle3 = new Rectangle(point.x, point.y - n17, dimension2.width / 2 - point.x, 2 * n17);
                if (n18 > n11 - point.x && n2 < n18 - (n11 - point.x)) {
                    n2 = n18 - (n11 - point.x);
                }
                ++n14;
            } else if (d3 < 80.0) {
                rectangle3 = new Rectangle(point.x, point.y, dimension2.width / 2 - point.x, dimension2.height / 2 - point.y);
                if (n18 > n11 - point.x && n2 < n18 - (n11 - point.x)) {
                    n2 = n18 - (n11 - point.x);
                }
                ++n14;
            } else if (d3 < 100.0) {
                if (n4 < perspective.getVC().destToVirtHeight(n8)) {
                    n4 = perspective.getVC().destToVirtHeight(n8);
                }
                ++n13;
            } else if (d3 < 175.0) {
                rectangle3 = new Rectangle(-dimension2.width / 2, point.y, point.x + dimension2.width / 2, dimension2.height / 2 - point.y);
                if (n18 > point.x - n10 && n < n18 - (point.x - n10)) {
                    n = n18 - (point.x - n10);
                }
                ++n15;
            } else if (d3 < 185.0) {
                n17 = Math.min(dimension2.height / 2 - point.y, point.y + dimension2.height / 2);
                rectangle3 = new Rectangle(-dimension2.width / 2, point.y - n17, point.x + dimension2.width / 2, 2 * n17);
                if (n18 > point.x - n10 && n < n18 - (point.x - n10)) {
                    n = n18 - (point.x - n10);
                }
                ++n15;
            } else if (d3 < 260.0) {
                rectangle3 = new Rectangle(-dimension2.width / 2, -dimension2.height / 2, point.x + dimension2.width / 2, dimension2.height / 2 + point.y);
                if (n18 > point.x - n10 && n < n18 - (point.x - n10)) {
                    n = n18 - (point.x - n10);
                }
                ++n15;
            } else if (d3 < 280.0) {
                if (n3 < perspective.getVC().destToVirtHeight(n8)) {
                    n3 = perspective.getVC().destToVirtHeight(n8);
                }
                ++n12;
            } else {
                rectangle3 = new Rectangle(point.x, -dimension2.height / 2, dimension2.width / 2 - point.x, point.y + dimension2.height / 2);
                if (n18 > n11 - point.x && n2 < n18 - (n11 - point.x)) {
                    n2 = n18 - (n11 - point.x);
                }
                ++n14;
            }
            ++n16;
        }
        n16 = perspective.getVC().virtToDestWidth(rectangle.width);
        int n19 = 0;
        int n20 = 1;
        int n21 = 2;
        int n22 = n19;
        if (n2 > rectangle.width / 4 && !bl) {
            n22 = n20;
            n2 = rectangle.width / 4;
            int n23 = n16 / 2 / Math.max(n14, n15);
            if (n23 >= n8 * 3) {
                if (n3 > 0) {
                    n3 += perspective.getVC().destToVirtHeight(n8);
                }
                if (n4 > 0) {
                    n4 += perspective.getVC().destToVirtHeight(n8);
                }
            } else {
                n22 = n21;
            }
        }
        int n24 = n19;
        if (n > rectangle.width / 4 && !bl) {
            n24 = n20;
            n = rectangle.width / 4;
            int n25 = n16 / 2 / Math.max(n14, n15);
            if (n25 >= n8 * 3) {
                if (n3 > 0) {
                    n3 += perspective.getVC().destToVirtHeight(n8);
                }
                if (n4 > 0) {
                    n4 += perspective.getVC().destToVirtHeight(n8);
                }
            } else {
                n24 = n21;
            }
        }
        boolean bl2 = false;
        if (n22 == n21 || n24 == n21) {
            bl2 = false;
        } else if (n22 == n20 || n24 == n20) {
            bl2 = true;
        }
        if (n2 > 0) {
            rectangle.width -= n2;
        }
        if (n > 0) {
            rectangle.x += n;
            rectangle.width -= n;
        }
        if (n3 > 0) {
            rectangle.height -= n3;
        }
        if (n4 > 0) {
            rectangle.height -= n4;
            rectangle.y += n4;
        }
        perspective.putToLookNoCalc(perspective.getFrame(), Attr.FrameRect, rectangle, !this.m_reset);
        perspective.putToLookNoCalc(identObj, Attr.TextWrap, new Boolean(bl2), !this.m_reset);
    }

    private static boolean isCircularLabelsLayoutValid(Perspective perspective, Graphics graphics, Access access, Graph graph, boolean bl, Vector vector) {
        int n = 0;
        int n2 = 0;
        if (access != null) {
            DataRange dataRange = access.getViewableDataRangeSG(perspective);
            n = dataRange.getColStart();
            n2 = dataRange.getColStop();
        } else if (vector != null) {
            n = 0;
            n2 = vector.size() - 1;
        } else {
            return false;
        }
        int n3 = n2 - n + 1;
        IdentObj identObj = null;
        identObj = bl ? perspective.getX1Label() : perspective.getO1Label();
        FontMetrics fontMetrics = BILabelLayout.getFontMetrics(graphics, perspective, identObj);
        int n4 = BILabelLayout.getPFJFontHeight(fontMetrics);
        double d = 1.0 / (double)n3;
        Rectangle rectangle = perspective.getRect(perspective.getFrame());
        int n5 = graph.getLegendArea().getPosition();
        Rectangle rectangle2 = graph.getLegendArea().getRect();
        int n6 = Math.abs(-16000 - rectangle.x);
        int n7 = 16000 - (rectangle.x + rectangle.width);
        int n8 = -16000;
        int n9 = 16000;
        if (n5 == 3) {
            n6 = rectangle.x - (rectangle2.x + rectangle2.width);
            n8 = rectangle2.x + rectangle2.width;
        } else if (n5 == 2) {
            n7 = rectangle2.x - (rectangle.x + rectangle.width);
            n9 = rectangle2.x;
        }
        if (n6 < 0 || n7 < 0) {
            return false;
        }
        int n10 = n;
        while (n10 <= n2) {
            Rectangle rectangle3;
            int n11;
            double d2 = (double)n10 * d + d / (double)2;
            double d3 = BILabelLayout.getAngleFromRelAngle(d2, perspective);
            Point point = new Point(0, 0);
            Point point2 = new Point();
            point2.x = rectangle.x + rectangle.width / 2;
            point2.y = rectangle.y + rectangle.height / 2;
            Dimension dimension = new Dimension();
            dimension.width = rectangle.width;
            dimension.height = rectangle.height;
            Dimension dimension2 = perspective.getVC().getVirtDimension();
            CircularAxisObj.polarToCartesian(point, d3, 1.0, dimension, point2, perspective.getVC());
            String string = null;
            string = bl ? (String)vector.elementAt(n10) : perspective.getGroupLabel(n10);
            if (d3 > 355.0 || d3 < 5.0) {
                n11 = Math.min(dimension2.height / 2 - point.y, point.y + dimension2.height / 2);
                rectangle3 = new Rectangle(point.x, point.y - n11, dimension2.width / 2 - point.x, 2 * n11);
                if (string != null && perspective.getVC().destToVirtWidth(fontMetrics.stringWidth(string)) > n9 - point.x) {
                    return false;
                }
            } else if (d3 < 80.0) {
                rectangle3 = new Rectangle(point.x, point.y, dimension2.width / 2 - point.x, dimension2.height / 2 - point.y);
                if (string != null && perspective.getVC().destToVirtWidth(fontMetrics.stringWidth(string)) > n9 - point.x) {
                    return false;
                }
            } else if (!(d3 < 100.0)) {
                if (d3 < 175.0) {
                    rectangle3 = new Rectangle(-dimension2.width / 2, point.y, point.x + dimension2.width / 2, dimension2.height / 2 - point.y);
                    if (string != null && perspective.getVC().destToVirtWidth(fontMetrics.stringWidth(string)) > point.x - n8) {
                        return false;
                    }
                } else if (d3 < 185.0) {
                    n11 = Math.min(dimension2.height / 2 - point.y, point.y + dimension2.height / 2);
                    rectangle3 = new Rectangle(-dimension2.width / 2, point.y - n11, point.x + dimension2.width / 2, 2 * n11);
                    if (string != null && perspective.getVC().destToVirtWidth(fontMetrics.stringWidth(string)) > point.x - n8) {
                        return false;
                    }
                } else if (d3 < 260.0) {
                    rectangle3 = new Rectangle(-dimension2.width / 2, -dimension2.height / 2, point.x + dimension2.width / 2, dimension2.height / 2 + point.y);
                    if (string != null && perspective.getVC().destToVirtWidth(fontMetrics.stringWidth(string)) > point.x - n8) {
                        return false;
                    }
                } else if (!(d3 < 280.0)) {
                    rectangle3 = new Rectangle(point.x, -dimension2.height / 2, dimension2.width / 2 - point.x, point.y + dimension2.height / 2);
                    if (string != null && perspective.getVC().destToVirtWidth(fontMetrics.stringWidth(string)) > n9 - point.x) {
                        return false;
                    }
                }
            }
            ++n10;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isO1LabelsLayoutValid(Perspective perspective, Graphics graphics, Access access, int n, Object object, boolean bl, Graph graph) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        if (bl) {
            return BILabelLayout.isCircularLabelsLayoutValid(perspective, graphics, access, graph, false, null);
        }
        IdentObj identObj = perspective.getO1Label();
        if (!perspective.getDisplay(identObj)) {
            return true;
        }
        boolean bl2 = n == 6;
        FontMetrics fontMetrics = BILabelLayout.getFontMetrics(graphics, perspective, identObj);
        int n9 = BILabelLayout.getPFJFontHeight(fontMetrics);
        int n10 = perspective.getTextRotation(identObj);
        boolean bl3 = n10 == 1 || n10 == 2;
        boolean bl4 = perspective.isChartOrientHorz();
        int n11 = 0;
        n11 = bl4 && !bl3 || !bl4 && bl3 ? 5 : TextStyleObj.calcAxisLabelGap(fontMetrics.getFont().getSize());
        if (perspective.isTimeAxis()) {
            Rectangle rectangle;
            Rectangle rectangle2;
            int n12;
            Rectangle rectangle3 = BILabelLayout.getLabelSpace(graphics, perspective, BILabelLayout.getO1AxisTitle(perspective), perspective.getRect(perspective.getFrame()));
            int n13 = n12 = perspective.getVC().virtToDestWidth(rectangle3.width);
            DateGroupLabels dateGroupLabels = (DateGroupLabels)perspective.getO1LabelCallBack();
            Vector vector = dateGroupLabels.getAllLabels(0);
            int n14 = vector.size();
            if (!bl2) {
                n13 = n12 / n14;
            } else if (n14 > 1) {
                n13 = n12 / (n14 - 1);
            }
            int n15 = 0;
            int n16 = (n14 - 1) % (perspective.getNestedSkipCount(0) + 1);
            int n17 = n14 - 1 - n16;
            int n18 = n15 * n13;
            int n19 = n16 * n13;
            if (!bl2) {
                n18 += n13 / 2;
                n19 += n13 / 2;
            }
            int n20 = fontMetrics.stringWidth((String)vector.elementAt(0)) / 2;
            int n21 = fontMetrics.stringWidth((String)vector.elementAt(n17)) / 2;
            int n22 = n20 - n18;
            if (n22 > 0 && BILabelLayout.intersectsComponents(perspective, rectangle2 = new Rectangle(rectangle3.x - (n22 = perspective.getVC().destToVirtWidth(n22)), rectangle3.y, n22, rectangle3.height))) {
                return false;
            }
            int n23 = n21 - n19;
            if (n23 > 0 && BILabelLayout.intersectsComponents(perspective, rectangle = new Rectangle(rectangle3.x + rectangle3.width, rectangle3.y, n23 = perspective.getVC().destToVirtWidth(n23), rectangle3.height))) {
                return false;
            }
            int n24 = BILabelLayout.getAxisTitleHeight(graphics, perspective, BILabelLayout.getO1AxisTitle(perspective), false);
            int n25 = n9;
            if (dateGroupLabels.getAllLabels(1) == null) return rectangle3.height >= perspective.getVC().destToVirtHeight(n24 + n25);
            n25 *= 2;
            return rectangle3.height >= perspective.getVC().destToVirtHeight(n24 + n25);
        }
        DataRange dataRange = access.getViewableDataRangeSG(perspective);
        int n26 = dataRange.getColStart();
        int n27 = dataRange.getColStop();
        int n28 = n27 - n26 + 1;
        if (n28 < 1) {
            return true;
        }
        String[] stringArray = new String[n28];
        int n29 = 0;
        int n30 = n26;
        while (n30 <= n27) {
            stringArray[n29++] = perspective.getGroupLabel(n30);
            ++n30;
        }
        ((_PropertyContext)object).m_O1Labels = stringArray;
        Rectangle rectangle = perspective.getRect(perspective.getFrame());
        Rectangle rectangle4 = BILabelLayout.getLabelSpace(graphics, perspective, BILabelLayout.getO1AxisTitle(perspective), rectangle);
        if (bl4) {
            n8 = perspective.getVC().virtToDestHeight(rectangle4.height);
            n7 = perspective.getVC().virtToDestWidth(rectangle4.width);
        } else {
            n8 = perspective.getVC().virtToDestWidth(rectangle4.width);
            n7 = perspective.getVC().virtToDestHeight(rectangle4.height);
        }
        int n31 = 0;
        int n32 = 0;
        if (perspective.getAutoSkip(identObj) == 2 && (n31 = perspective.getSkipCount(identObj)) > 0) {
            n32 = perspective.getSkipBegin(identObj);
            if (n32 >= n28) {
                n32 = 0;
            } else if (n32 > n31) {
                n32 %= n31 + 1;
            }
        }
        int n33 = (n28 - n32 + n31) / (n31 + 1);
        boolean bl5 = perspective.getLabelStagger(identObj);
        boolean bl6 = perspective.getTextWrap(identObj);
        if (bl2 || n31 > 0 || bl5 || n33 == 1) {
            int n34;
            int n35;
            n6 = n8;
            if (!bl2) {
                n6 = n8 / n28;
            } else if (n28 > 1) {
                n6 = n8 / (n28 - 1);
            }
            n5 = n32;
            n4 = (n28 - n32 - 1) % (n31 + 1);
            int n36 = n28 - 1 - n4;
            n3 = n5 * n6;
            n2 = n4 * n6;
            if (!bl2) {
                n3 += n6 / 2;
                n2 += n6 / 2;
            }
            int n37 = 0;
            int n38 = 0;
            if (bl4 && !bl3 || !bl4 && bl3) {
                n38 = n37 = n9 / 2;
            } else if (bl6) {
                n35 = n6;
                if (bl5) {
                    n35 *= 2;
                }
                n38 = n37 = (int)((double)(n35 - n11) / 2.0);
            } else {
                n37 = fontMetrics.stringWidth(stringArray[0]) / 2;
                n38 = fontMetrics.stringWidth(stringArray[n36]) / 2;
            }
            n35 = n37 - n3;
            if (n35 > 0) {
                Rectangle rectangle5;
                if (bl4) {
                    n35 = perspective.getVC().destToVirtHeight(n35);
                    rectangle5 = new Rectangle(rectangle4.x, rectangle4.y + rectangle4.height, rectangle4.width, n35);
                } else {
                    n35 = perspective.getVC().destToVirtWidth(n35);
                    rectangle5 = new Rectangle(rectangle4.x - n35, rectangle4.y, n35, rectangle4.height);
                }
                if (BILabelLayout.intersectsComponents(perspective, rectangle5)) {
                    return false;
                }
            }
            if ((n34 = n38 - n2) > 0) {
                Rectangle rectangle6;
                if (bl4) {
                    n34 = perspective.getVC().destToVirtHeight(n34);
                    rectangle6 = new Rectangle(rectangle4.x, rectangle4.y - n34, rectangle4.width, n34);
                } else {
                    n34 = perspective.getVC().destToVirtWidth(n34);
                    rectangle6 = new Rectangle(rectangle4.x + rectangle4.width, rectangle4.y, n34, rectangle4.height);
                }
                if (BILabelLayout.intersectsComponents(perspective, rectangle6)) {
                    return false;
                }
            }
        }
        n6 = (int)((double)n8 / ((double)n9 * 1.0));
        if (bl2) {
            ++n6;
        }
        if (n6 <= 0) {
            n6 = 1;
        }
        if (n33 > n6) {
            return false;
        }
        if (n33 <= 1) return true;
        n5 = 0;
        n4 = 0;
        if (bl4 && bl3 || !bl4 && !bl3) {
            n4 = n7;
            n5 = !bl2 || n28 == 1 ? n8 / n28 : n8 / (n28 - 1);
            if (bl5) {
                n4 /= 2;
                n5 *= 2;
            }
            if (n28 > 1) {
                n5 -= n11;
            }
            n5 *= n31 + 1;
        } else {
            n5 = n7;
            n4 = !bl2 || n28 == 1 ? n8 / n28 : n8 / (n28 - 1);
            if (bl5) {
                n4 *= 2;
                n5 /= 2;
                n5 -= n11;
            }
            n4 *= n31 + 1;
        }
        if (n4 < n9) {
            return false;
        }
        int[] nArray = new int[n33];
        n3 = BILabelLayout.getLongestLabelWidth(fontMetrics, stringArray, n31, n32, nArray);
        if (!bl6) {
            if (n3 <= n5) return true;
            if (bl4 || bl3) return false;
            n2 = 1;
            if (bl5) {
                n2 = 2;
            }
            if (BILabelLayout.verifyPairLengths(nArray, n2, n5 - 5)) return true;
            return false;
        }
        if (n5 * (n4 / n9) >= n3 && -1 != BILabelLayout.wordWrap(fontMetrics, stringArray, n31, n32, n5, n4)) return true;
        return false;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void doO1LabelsAutoLayout(Perspective var1_1, Graphics var2_2, Access var3_3, int var4_4, Object var5_5, boolean var6_6, Graph var7_7) {
        if (var6_6) {
            this.doCircularLabelsAutoLayout(var1_1, var2_2, var3_3, null, false);
            return;
        }
        var8_8 = var1_1.getO1Label();
        if (!var1_1.getDisplay(var8_8)) {
            return;
        }
        var9_9 = var4_4 == 6;
        var10_10 = var1_1.isChartOrientHorz();
        var11_11 = BILabelLayout.getFontMetrics(var2_2, var1_1, var8_8);
        var12_12 = BILabelLayout.getPFJFontHeight(var11_11);
        var13_13 = TextStyleObj.calcAxisLabelGap(var11_11.getFont().getSize());
        var14_14 = 5;
        var15_15 = new Rectangle(var1_1.getRect(var1_1.getFrame()));
        if (var10_10) {
            var16_16 = BILabelLayout.getAxisTitleHeight(var2_2, var1_1, BILabelLayout.getO1AxisTitle(var1_1), true);
            var15_15.x += var16_16;
            var15_15.width -= var16_16;
        } else {
            var16_16 = BILabelLayout.getAxisTitleHeight(var2_2, var1_1, BILabelLayout.getO1AxisTitle(var1_1), false);
            var15_15.y += var16_16;
            var15_15.height -= var16_16;
        }
        var17_17 = BILabelLayout.adjustFrameFor3D(var1_1, var15_15);
        if (var10_10) {
            var17_17.y -= 100;
            var19_18 = var15_15.height + 200;
            var18_19 = var1_1.getVC().virtToDestHeight(var19_18);
        } else {
            var17_17.x -= 100;
            var19_18 = var15_15.width + 200;
            var18_19 = var1_1.getVC().virtToDestWidth(var19_18);
        }
        if (var18_19 <= 0) {
            return;
        }
        if (var1_1.isTimeAxis()) {
            var20_20 = var15_15.height - 3000;
            if (var20_20 <= 0) {
                return;
            }
            var21_22 = var1_1.getVC().destToVirtWidth(10);
            var22_24 = var1_1.getVC().destToVirtHeight(10);
            var23_27 = var1_1.getVC().getVirtCoords();
            var24_29 = null;
            var25_31 = null;
            var26_33 = new Rectangle(var23_27.x + var21_22, var17_17.y, var23_27.width - 2 * var21_22, var20_20);
            var24_29 = new Rectangle(var26_33);
            var25_31 = null;
            var27_35 = var1_1.getLegendArea();
            if (this._isLegendDisplayed() && var26_33.intersects(var28_37 = var1_1.getRect(var27_35))) {
                var29_39 = var26_33.intersection(var28_37);
                if (var29_39.x > var17_17.x) {
                    if (var29_39.y <= var26_33.y) {
                        var24_29.width = var29_39.x - var24_29.x - var21_22;
                    } else {
                        var25_31 = new Rectangle(var26_33.x, var26_33.y, var29_39.x - var26_33.x - var21_22, var26_33.height);
                        var24_29.height = var29_39.y - var26_33.y - var22_24;
                    }
                } else {
                    var30_42 = var29_39.x + var29_39.width + var21_22;
                    if (var29_39.y <= var26_33.y) {
                        var24_29.x = var30_42;
                        var24_29.width = var26_33.x + var26_33.width - var30_42;
                    } else {
                        var25_31 = new Rectangle(var30_42, var26_33.y, var26_33.x + var26_33.width - var30_42, var19_18);
                        var24_29.height = var29_39.y - var26_33.y - var22_24;
                    }
                }
            }
            var29_40 = var12_12;
            var30_43 = (DateGroupLabels)var1_1.getO1LabelCallBack();
            var31_45 = 1;
            if (var30_43.getAllLabels(1) != null) {
                var29_40 *= 2;
                var31_45 = 2;
            }
            var28_37 = var24_29.height > (var32_47 = var1_1.getVC().destToVirtHeight(5 + var29_40)) ? var24_29 : var25_31;
            var33_49 = var17_17.x - var28_37.x;
            var34_51 = false;
            var35_53 = var30_43.getAllLabels(0);
            var36_55 = 0;
            if (var9_9) {
                var36_55 = var1_1.getVC().destToVirtWidth(var11_11.stringWidth((String)var35_53.elementAt(0))) / 2;
            }
            if (var33_49 < var36_55) {
                var15_15.width -= var36_55 - var33_49;
                var15_15.x += var36_55 - var33_49;
                var33_49 = var36_55;
            }
            if ((var37_58 = var28_37.width - (var19_18 = var15_15.width + 200) - var33_49) < var36_55) {
                var15_15.width -= var36_55 - var37_58;
                var37_58 = var36_55;
            }
            var1_1.setLeftRightOffsets(var33_49 + 100, var37_58 + 100);
            var15_15.y += var32_47;
            var15_15.height -= var32_47;
            var1_1.putToLookNoCalc(var1_1.getFrame(), Attr.FrameRect, var15_15, this.m_reset == false);
            var1_1.formatDates();
            if (var30_43.getAllLabels(1) != null && var31_45 == 1) {
                var15_15.y += var1_1.getVC().destToVirtHeight(var12_12);
                var15_15.height -= var1_1.getVC().destToVirtHeight(var12_12);
            } else if (var30_43.getAllLabels(1) == null && var31_45 == 2) {
                var15_15.y -= var1_1.getVC().destToVirtHeight(var12_12);
                var15_15.height += var1_1.getVC().destToVirtHeight(var12_12);
            }
            var1_1.putToLookNoCalc(var1_1.getFrame(), Attr.FrameRect, var15_15, this.m_reset == false);
            return;
        }
        var20_21 = ((_PropertyContext)var5_5).m_O1Labels;
        var21_23 = 0;
        if (var20_21 != null) {
            var21_23 = var20_21.length;
        } else {
            var22_25 = var3_3.getViewableDataRangeSG(var1_1);
            var23_28 = var22_25.getColStart();
            var24_30 = var22_25.getColStop();
            var21_23 = var24_30 - var23_28 + 1;
            if (var21_23 < 1) {
                return;
            }
            var20_21 = new String[var21_23];
            var25_32 = 0;
            var26_34 = var23_28;
            while (var26_34 <= var24_30) {
                var20_21[var25_32++] = var1_1.getGroupLabel(var26_34);
                ++var26_34;
            }
        }
        var22_26 = var1_1.getO1LabelAutoAngle();
        var23_28 = var22_26 != 0 ? 1 : 0;
        var24_30 = var1_1.getAutoSkip(var8_8) == 1 ? 1 : 0;
        var25_32 = 0;
        if (var24_30 != 0) {
            var26_34 = (int)((double)var18_19 / ((double)var12_12 * 1.0));
            if (var26_34 == 0) {
                var25_32 = var21_23 - 1;
            } else if (var21_23 > var26_34) {
                var25_32 = (int)Math.ceil((double)(var21_23 - var26_34) / (double)var26_34);
            }
        }
        var26_34 = 0;
        var27_36 = false;
        var28_38 = false;
        var29_41 = 0;
        var30_44 = 0;
        if (var24_30 != 0) {
            var29_41 = var25_32;
        } else if (var1_1.getAutoSkip(var8_8) == 2 && (var29_41 = var1_1.getSkipCount(var8_8)) > 0) {
            var30_44 = var1_1.getSkipBegin(var8_8);
            if (var30_44 >= var21_23) {
                var30_44 = 0;
            } else if (var30_44 > var29_41) {
                var30_44 %= var29_41 + 1;
            }
        }
        var31_46 = false;
        var32_48 = var1_1.getVC().getVirtCoords();
        var33_50 = var29_41;
        var34_52 = null;
        var35_54 = null;
        if (!var10_10) {
            var36_56 = var15_15.height - 3000;
            if (var36_56 <= 0) {
                return;
            }
            var37_59 = var1_1.getVC().destToVirtWidth(10);
            var38_61 = var1_1.getVC().destToVirtHeight(10);
            var39_63 = new Rectangle(var32_48.x + var37_59, var17_17.y, var32_48.width - 2 * var37_59, var36_56);
            var34_52 = new Rectangle((Rectangle)var39_63);
            var35_54 = null;
            var40_64 = var1_1.getLegendArea();
            if (this._isLegendDisplayed() && var39_63.intersects(var41_65 = var1_1.getRect((IdentObj)var40_64))) {
                var42_69 = var39_63.intersection(var41_65);
                if (var42_69.x > var17_17.x) {
                    if (var42_69.y <= var39_63.y) {
                        var34_52.width = var42_69.x - var34_52.x - var37_59;
                    } else {
                        var35_54 = new Rectangle(var39_63.x, var39_63.y, var42_69.x - var39_63.x - var37_59, var39_63.height);
                        var34_52.height = var42_69.y - var39_63.y - var38_61;
                    }
                } else {
                    var43_72 = var42_69.x + var42_69.width + var37_59;
                    if (var42_69.y <= var39_63.y) {
                        var34_52.x = var43_72;
                        var34_52.width = var39_63.x + var39_63.width - var43_72;
                    } else {
                        var35_54 = new Rectangle(var43_72, var39_63.y, var39_63.x + var39_63.width - var43_72, var19_18);
                        var34_52.height = var42_69.y - var39_63.y - var38_61;
                    }
                }
            }
        } else {
            var36_56 = var15_15.width - 3000;
            if (var36_56 <= 0) {
                return;
            }
            var34_52 = new Rectangle(var17_17.x, var17_17.y, var36_56, var19_18);
        }
        var36_57 = new Rectangle[]{var34_52, var35_54};
        var37_60 = new int[]{0, 1, 2, 3};
        var38_62 = new int[]{2, 0, 1, 3};
        var39_63 = new int[]{3, 0, 1, 2};
        var40_64 = new int[]{3, 2, 0, 1};
        while (!var31_46) {
            var41_66 = (var21_23 - var30_44 + var29_41) / (var29_41 + 1);
            var42_70 = (var21_23 - var30_44 - 1) % (var29_41 + 1);
            var43_72 = var21_23 - 1 - var42_70;
            var50_77 = 0.0;
            if (!var9_9) {
                var50_77 = 0.5;
            }
            if (var10_10) {
                var46_74 = 1.0 - ((double)var30_44 + var50_77) / (double)var21_23;
                var44_73 = 1.0 - ((double)var42_70 + var50_77) / (double)var21_23;
            } else {
                var44_73 = 1.0 - ((double)var30_44 + var50_77) / (double)var21_23;
                var46_74 = 1.0 - ((double)var42_70 + var50_77) / (double)var21_23;
            }
            var54_80 = var17_17.x;
            if (var10_10) {
                var54_80 = var17_17.y;
            }
            var52_78 = var54_80 + (int)((1.0 - var44_73) * (double)var19_18);
            var53_79 = var54_80 + (int)(var46_74 * (double)var19_18);
            var48_75 = var11_11.stringWidth(var20_21[var30_44]) / 2;
            var49_76 = var11_11.stringWidth(var20_21[var43_72]) / 2;
            var57_83 = 0;
            if (var10_10) {
                var55_81 = var52_78 - var1_1.getVC().destToVirtHeight(var49_76);
                var56_82 = var53_79 + var1_1.getVC().destToVirtHeight(var48_75);
                var57_83 = var1_1.getVC().destToVirtHeight(var13_13);
            } else {
                var55_81 = var52_78 - var1_1.getVC().destToVirtWidth(var48_75);
                var56_82 = var53_79 + var1_1.getVC().destToVirtWidth(var49_76);
                var57_83 = var1_1.getVC().destToVirtWidth(var13_13);
            }
            var58_84 = var19_18;
            if (!var9_9) {
                var58_84 = var19_18 / var21_23;
            } else if (var21_23 > 1) {
                var58_84 = var19_18 / (var21_23 - 1);
            }
            var59_85 = (int)((double)((var58_84 - var57_83) * (var29_41 + 1)) / 2.0);
            var60_86 = var52_78 - var59_85;
            var61_87 = var53_79 + var59_85;
            var62_88 = var54_80 + var19_18;
            var63_89 = new int[var41_66];
            var64_90 = BILabelLayout.getLongestLabelWidth(var11_11, var20_21, var29_41, var30_44, var63_89);
            var65_91 = 0;
            var66_92 = 0;
            var67_93 = 0;
            var68_94 = 0;
            var69_95 = 0;
            while (var69_95 < var36_57.length && !var31_46) {
                block93: {
                    if (var36_57[var69_95] == null) break;
                    var65_91 = var10_10 == false ? var1_1.getVC().virtToDestHeight(var36_57[var69_95].height) - 5 : var1_1.getVC().virtToDestWidth(var36_57[var69_95].width) - 5;
                    var66_92 = var12_12;
                    if (var69_95 == 0 && var36_57[1] != null && var65_91 < var66_92) break block93;
                    var70_96 /* !! */  = var37_60;
                    var71_98 = var36_57[var69_95].x;
                    var72_99 = var36_57[var69_95].x + var36_57[var69_95].width;
                    if (var10_10) {
                        var70_96 /* !! */  = (int[])var39_63;
                        var71_98 = var36_57[var69_95].y;
                        var72_99 = var36_57[var69_95].y + var36_57[var69_95].height;
                    }
                    if (var55_81 < var71_98 && var60_86 - var55_81 > 1000 || var72_99 < var56_82 && var56_82 - var61_87 > 1000) {
                        var70_96 /* !! */  = var38_62;
                        if (var10_10) {
                            var70_96 /* !! */  = (int[])var40_64;
                        }
                    }
                    var73_100 = null;
                    var74_102 = 0;
                    var75_106 = 0;
                    var76_110 = 0;
                    var77_111 = 0;
                    while (var77_111 < var70_96 /* !! */ .length && !var31_46) {
                        block96: {
                            block95: {
                                block98: {
                                    block97: {
                                        block94: {
                                            var78_112 = var18_19;
                                            if (var70_96 /* !! */ [var77_111] != 3) break block94;
                                            if ((var23_28 != 0 || var10_10 || var1_1.getTextRotation(var8_8) != 0) && (var23_28 != 0 || !var10_10 || var1_1.getTextRotation(var8_8) == 0)) break block95;
                                            break block96;
                                        }
                                        if (var23_28 == 0 && !var10_10 && var1_1.getTextRotation(var8_8) != 0 || var23_28 == 0 && var10_10 && var1_1.getTextRotation(var8_8) == 0) break block96;
                                        if (var70_96 /* !! */ [var77_111] != 2) break block97;
                                        var79_113 = var71_98 - var60_86;
                                        var80_114 = var61_87 - var72_99;
                                        var81_115 = BILabelLayout.getPlotAreaShifts(var79_113, var80_114, var44_73, var46_74, var19_18 - 8000, var41_66);
                                        if (var81_115 == null) break block96;
                                        var75_106 = var81_115[0];
                                        var76_110 = var81_115[1];
                                        break block98;
                                    }
                                    if (var73_100 == null && (var73_100 = BILabelLayout.getPlotAreaShifts(var79_113 = var71_98 - var55_81, var80_114 = var56_82 - var72_99, var44_73, var46_74, var19_18 - 8000, var41_66)) == null) break block96;
                                    var75_106 = var73_100[0];
                                    var76_110 = var73_100[1];
                                }
                                var78_112 = var10_10 != false ? var1_1.getVC().virtToDestHeight(var19_18 - var75_106 - var76_110) : var1_1.getVC().virtToDestWidth(var19_18 - var75_106 - var76_110);
                                var74_102 = var9_9 == false || var41_66 == 1 ? var78_112 * (var29_41 + 1) / var21_23 - var13_13 : var78_112 * (var29_41 + 1) / (var21_23 - 1) - var13_13;
                            }
                            switch (var70_96 /* !! */ [var77_111]) {
                                case 0: {
                                    if (var64_90 > var74_102 && (var10_10 || !BILabelLayout.verifyPairLengths(var63_89, 1, var74_102 - 5))) ** GOTO lbl332
                                    var31_46 = true;
                                    ** GOTO lbl332
                                }
                                case 1: {
                                    var79_113 = var12_12 * 2;
                                    var80_114 = var74_102 * 2 + var13_13;
                                    if (var79_113 > var65_91 || var64_90 > var80_114 && (var10_10 || !BILabelLayout.verifyPairLengths(var63_89, 2, var80_114 - 5))) ** GOTO lbl332
                                    var26_34 = 1;
                                    var66_92 = var79_113;
                                    var31_46 = true;
                                    ** GOTO lbl332
                                }
                                case 2: {
                                    if (!((double)var74_102 > (double)var12_12 * 1.5) || var64_90 >= var65_91 / var12_12 * var74_102 || (var81_116 = BILabelLayout.wordWrap(var11_11, var20_21, var29_41, var30_44, var74_102, var65_91)) <= 0) ** GOTO lbl332
                                    var31_46 = true;
                                    var66_92 = var81_116;
                                    var28_38 = true;
                                    var49_76 = var48_75 = var74_102 / 2;
                                    ** GOTO lbl332
                                }
                                case 3: {
                                    var81_117 = 0;
                                    var82_118 = new int[5][2];
                                    var83_119 = 0;
                                    while (var83_119 < 5) {
                                        var84_121 = var10_10 != false ? var1_1.getVC().destToVirtHeight(var12_12 * (var83_119 + 1) / 2) : var1_1.getVC().destToVirtWidth(var12_12 * (var83_119 + 1) / 2);
                                        var85_122 = var52_78 - var84_121;
                                        var87_124 = BILabelLayout.getPlotAreaShifts(var71_98 - var85_122, (var86_123 = var53_79 + var84_121) - var72_99, var44_73, var46_74, var19_18 - 8000, var41_66);
                                        if (var87_124 == null) break;
                                        var82_118[var83_119][0] = var87_124[0];
                                        var82_118[var83_119][1] = var87_124[1];
                                        var88_125 = var10_10 != false ? var1_1.getVC().virtToDestHeight(var19_18 - var87_124[0] - var87_124[1]) : var1_1.getVC().virtToDestWidth(var19_18 - var87_124[0] - var87_124[1]);
                                        var89_126 = var9_9 == false || var41_66 == 1 ? var88_125 * (var29_41 + 1) / var21_23 - var14_14 : var88_125 * (var29_41 + 1) / (var21_23 - 1) - var14_14;
                                        if ((var83_119 + 1) * var12_12 > var89_126) break;
                                        var81_117 = var83_119 + 1;
                                        ++var83_119;
                                    }
                                    if (var81_117 < 1) break;
                                    if (var64_90 > var65_91 || var64_90 > 40) ** GOTO lbl317
                                    var31_46 = true;
                                    var27_36 = true;
                                    var66_92 = var64_90;
                                    var75_106 = var82_118[0][0];
                                    var76_110 = var82_118[0][1];
                                    var49_76 = var48_75 = var12_12 / 2;
                                    ** GOTO lbl332
lbl317:
                                    // 1 sources

                                    if (var64_90 > var65_91 * var81_117) break;
                                    var83_120 = BILabelLayout.getWordLengths(var11_11, var20_21, var29_41, var30_44);
                                    var84_121 = 40;
                                    while (var84_121 <= var65_91 && !var31_46) {
                                        if (var64_90 <= var84_121 * var81_117 && (var85_122 = BILabelLayout.wordWrap(var11_11, var83_120, var84_121, var84_121 + 3 < var65_91, var81_117)) > 0) {
                                            var31_46 = true;
                                            var27_36 = true;
                                            if (var85_122 > 1) {
                                                var28_38 = true;
                                            }
                                            var66_92 = var84_121;
                                            var75_106 = var82_118[var85_122 - 1][0];
                                            var76_110 = var82_118[var85_122 - 1][1];
                                            var49_76 = var48_75 = var12_12 * var85_122 / 2;
                                        }
                                        var84_121 += 3;
                                    }
                                }
lbl332:
                                // 9 sources

                                default: {
                                    if (!var31_46) break;
                                    var67_93 = var75_106;
                                    var68_94 = var76_110;
                                }
                            }
                        }
                        ++var77_111;
                    }
                }
                ++var69_95;
            }
            if (!var31_46) {
                if (var41_66 > 1 && var24_30 != 0) {
                    ++var29_41;
                } else {
                    var31_46 = true;
                    if (var21_23 > 1 && (var23_28 != 0 || !var10_10 && var1_1.getTextRotation(var8_8) != 0 || var10_10 && var1_1.getTextRotation(var8_8) == 0)) {
                        var29_41 = var33_50;
                        var27_36 = true;
                        var66_92 = Math.min(var65_91, var64_90);
                    }
                }
            }
            if (!var31_46) continue;
            if (var10_10) {
                var69_95 = var1_1.getVC().destToVirtWidth(var66_92 + 5);
                var15_15.x += var69_95;
                var15_15.width -= var69_95;
                var15_15.y += var67_93;
                var15_15.height -= var67_93 + var68_94;
                continue;
            }
            var69_95 = var1_1.getVC().destToVirtHeight(var66_92 + 5);
            var15_15.y += var69_95;
            var15_15.height -= var69_95;
            var15_15.x += var67_93;
            var15_15.width -= var67_93 + var68_94;
            var70_97 = false;
            var71_98 = 0;
            var72_99 = var1_1.getVC().virtToDestWidth(var15_15.width);
            if ((double)var48_75 > (1.0 - var44_73) * (double)var72_99) {
                var70_97 = true;
            }
            if ((double)var49_76 > (1.0 - var46_74) * (double)var72_99) {
                var71_98 = 1;
            }
            var73_101 = 0;
            if (var70_97 && var1_1.getTextRotation(var74_103 = var1_1.getY1Label()) == 0) {
                var75_107 = BILabelLayout.getFontMetrics(var2_2, var1_1, var74_103);
                var73_101 = BILabelLayout.getPFJFontHeight(var75_107) / 2;
            }
            if (var71_98 != 0 && var1_1.getJGraphType().getAxisDescriptor().hasY2() && var1_1.getTextRotation(var74_104 = var1_1.getY2Label()) == 0) {
                var75_108 = BILabelLayout.getFontMetrics(var2_2, var1_1, var74_104);
                var76_110 = BILabelLayout.getPFJFontHeight(var75_108) / 2;
                if (var26_34 != 0 && var41_66 % 2 == 0) {
                    var76_110 -= var12_12;
                }
                if (var76_110 > var73_101) {
                    var73_101 = var76_110;
                }
            }
            if (var73_101 <= false || (var74_105 = var73_101 + 3 - 5) <= 0) continue;
            var75_109 = var1_1.getVC().destToVirtHeight(var74_105);
            var15_15.y += var75_109;
            var15_15.height -= var75_109;
            var1_1.setAdditionalBottomAxisMargin(var75_109);
        }
        if (var24_30 != 0) {
            var1_1.putToLookNoCalc(var8_8, Attr.AutoSkip, new Integer(2), this.m_reset == false);
            var1_1.putToLookNoCalc(var8_8, Attr.SkipCount, new Integer(var29_41), this.m_reset == false);
            var1_1.putToLookNoCalc(var8_8, Attr.SkipBegin, new Integer(0), this.m_reset == false);
            if (this.m_reset) {
                this.m_graph.getO1TickLabel().setPropertyOverrideFlags(6);
                this.m_graph.getO1TickLabel().setPropertyOverrideFlags(7);
                this.m_graph.getO1TickLabel().setPropertyOverrideFlags(8);
            }
        }
        if (var23_28 != 0) {
            var41_67 = 0;
            if (var10_10 && !var27_36 || !var10_10 && var27_36) {
                var41_67 = var22_26 == 1 ? 1 : 2;
            }
            var1_1.putToLookNoCalc(var8_8, Attr.TextRotation, new Integer(var41_67), this.m_reset == false);
            if (this.m_reset) {
                this.m_graph.getO1TickLabel().setPropertyOverrideFlags(1);
            }
        }
        var41_68 = 1;
        var42_71 = var1_1.getTextRotation(var8_8);
        if (var10_10 && var42_71 == 0 || !var10_10 && var42_71 == 1) {
            var41_68 = 2;
        } else if (!var10_10 && var42_71 == 2) {
            var41_68 = 0;
        }
        var1_1.putToLookNoCalc(var8_8, Attr.TextJustHoriz, new Integer(var41_68), this.m_reset == false);
        var1_1.putToLookNoCalc(var8_8, Attr.LabelStagger, new Boolean((boolean)var26_34), this.m_reset == false);
        var1_1.putToLookNoCalc(var8_8, Attr.TextWrap, new Boolean(var28_38), this.m_reset == false);
        var1_1.putToLookNoCalc(var1_1.getFrame(), Attr.FrameRect, var15_15, this.m_reset == false);
        if (this.m_reset) {
            this.m_graph.getO1TickLabel().setPropertyOverrideFlags(2);
            this.m_graph.getO1TickLabel().setPropertyOverrideFlags(4);
            this.m_graph.getO1TickLabel().setPropertyOverrideFlags(3);
        }
    }

    private static boolean isDataAxisLayoutValid(Perspective perspective, Graphics graphics, Vector[] vectorArray, Object object, Graph graph, boolean bl) {
        int[] nArray;
        int n;
        IdentObj identObj;
        IdentObj identObj2;
        if (bl) {
            return BILabelLayout.isCircularLabelsLayoutValid(perspective, graphics, null, graph, true, vectorArray[7]);
        }
        boolean bl2 = perspective.isChartOrientHorz();
        IdentObj identObj3 = perspective.getFrame();
        if (vectorArray[8] != null) {
            IdentObj identObj4 = perspective.getY1Label();
            IdentObj identObj5 = perspective.getY1Title();
            return BILabelLayout.validateDataAxisSide(perspective, graphics, perspective.getPieFrame(), identObj4, identObj5, vectorArray[8], 2, 1);
        }
        if (vectorArray[7] != null) {
            identObj2 = perspective.getX1Label();
            identObj = perspective.getX1Title();
            n = perspective.getAxisSide(perspective.getX1Axis());
            nArray = BILabelLayout.getAxisSides(n, bl2, true);
            if (nArray[0] != -1 && !BILabelLayout.validateDataAxisSide(perspective, graphics, identObj3, identObj2, identObj, vectorArray[7], nArray[0], nArray[2])) {
                return false;
            }
            if (nArray[1] != -1 && !BILabelLayout.validateDataAxisSide(perspective, graphics, identObj3, identObj2, identObj, vectorArray[7], nArray[1], nArray[2])) {
                return false;
            }
        }
        if (vectorArray[0] != null) {
            identObj2 = perspective.getY1Label();
            identObj = perspective.getY1Title();
            n = perspective.getAxisSide(perspective.getY1Axis());
            nArray = BILabelLayout.getAxisSides(n, bl2, false);
            if (nArray[0] != -1 && !BILabelLayout.validateDataAxisSide(perspective, graphics, identObj3, identObj2, identObj, vectorArray[0], nArray[0], nArray[2])) {
                return false;
            }
            if (nArray[1] != -1 && !BILabelLayout.validateDataAxisSide(perspective, graphics, identObj3, identObj2, identObj, vectorArray[0], nArray[1], nArray[2])) {
                return false;
            }
        }
        if (vectorArray[1] != null) {
            identObj2 = perspective.getY2Label();
            identObj = perspective.getY2Title();
            n = perspective.getAxisSide(perspective.getY2Axis());
            nArray = BILabelLayout.getAxisSides(n, bl2, false);
            if (nArray[0] != -1 && !BILabelLayout.validateDataAxisSide(perspective, graphics, identObj3, identObj2, identObj, vectorArray[1], nArray[0], nArray[2])) {
                return false;
            }
            if (nArray[1] != -1 && !BILabelLayout.validateDataAxisSide(perspective, graphics, identObj3, identObj2, identObj, vectorArray[1], nArray[1], nArray[2])) {
                return false;
            }
        }
        return true;
    }

    private void doDataAxisAutoLayout(Perspective perspective, Graphics graphics, Vector[] vectorArray, Object object, boolean bl) {
        int n;
        int[] nArray;
        int n2;
        IdentObj identObj;
        Serializable serializable;
        if (bl) {
            this.doCircularLabelsAutoLayout(perspective, graphics, null, vectorArray[7], true);
            return;
        }
        int[] nArray2 = new int[4];
        boolean bl2 = perspective.isChartOrientHorz();
        IdentObj identObj2 = perspective.getFrame();
        Attr attr = Attr.FrameRect;
        if (vectorArray[7] != null) {
            serializable = perspective.getX1Label();
            identObj = perspective.getX1Title();
            n2 = perspective.getAxisSide(perspective.getX1Axis());
            nArray = BILabelLayout.getAxisSides(n2, bl2, true);
            if (nArray[0] != -1 && (n = BILabelLayout.getRequiredDataAxisSpace(perspective, graphics, serializable, identObj, vectorArray[7], nArray[0])) > nArray2[nArray[0]]) {
                nArray2[nArray[0]] = n;
            }
            if (nArray[1] != -1 && (n = BILabelLayout.getRequiredDataAxisSpace(perspective, graphics, serializable, identObj, vectorArray[7], nArray[1])) > nArray2[nArray[1]]) {
                nArray2[nArray[1]] = n;
            }
            if (nArray[2] != -1 && (n = BILabelLayout.getRequiredDataAxisPerpendSpace(perspective, graphics, serializable, identObj, vectorArray[7], nArray[2])) > nArray2[nArray[2]]) {
                nArray2[nArray[2]] = n;
            }
        }
        if (vectorArray[0] != null) {
            serializable = perspective.getY1Label();
            identObj = perspective.getY1Title();
            n2 = perspective.getAxisSide(perspective.getY1Axis());
            nArray = BILabelLayout.getAxisSides(n2, bl2, false);
            if (nArray[0] != -1 && (n = BILabelLayout.getRequiredDataAxisSpace(perspective, graphics, serializable, identObj, vectorArray[0], nArray[0])) > nArray2[nArray[0]]) {
                nArray2[nArray[0]] = n;
            }
            if (nArray[1] != -1 && (n = BILabelLayout.getRequiredDataAxisSpace(perspective, graphics, serializable, identObj, vectorArray[0], nArray[1])) > nArray2[nArray[1]]) {
                nArray2[nArray[1]] = n;
            }
            if (nArray[2] != -1 && (n = BILabelLayout.getRequiredDataAxisPerpendSpace(perspective, graphics, serializable, identObj, vectorArray[0], nArray[2])) > nArray2[nArray[2]]) {
                nArray2[nArray[2]] = n;
            }
        }
        if (vectorArray[1] != null) {
            serializable = perspective.getY2Label();
            identObj = perspective.getY2Title();
            n2 = perspective.getAxisSide(perspective.getY2Axis());
            nArray = BILabelLayout.getAxisSides(n2, bl2, false);
            if (nArray[0] != -1 && (n = BILabelLayout.getRequiredDataAxisSpace(perspective, graphics, serializable, identObj, vectorArray[1], nArray[0])) > nArray2[nArray[0]]) {
                nArray2[nArray[0]] = n;
            }
            if (nArray[1] != -1 && (n = BILabelLayout.getRequiredDataAxisSpace(perspective, graphics, serializable, identObj, vectorArray[1], nArray[1])) > nArray2[nArray[1]]) {
                nArray2[nArray[1]] = n;
            }
            if (nArray[2] != -1 && (n = BILabelLayout.getRequiredDataAxisPerpendSpace(perspective, graphics, serializable, identObj, vectorArray[1], nArray[2])) > nArray2[nArray[2]]) {
                nArray2[nArray[2]] = n;
            }
        }
        if (vectorArray[8] != null) {
            identObj2 = perspective.getPieFrame();
            attr = Attr.PieFrameRect;
            serializable = perspective.getY1Label();
            n2 = BILabelLayout.getRequiredDataAxisSpace(perspective, graphics, serializable, identObj = perspective.getY1Title(), vectorArray[8], 2);
            if (n2 > nArray2[2]) {
                nArray2[2] = n2;
            }
            if ((n2 = BILabelLayout.getRequiredDataAxisPerpendSpace(perspective, graphics, serializable, identObj, vectorArray[8], 1)) > nArray2[1]) {
                nArray2[1] = n2;
            }
        }
        serializable = new Rectangle(perspective.getRect(identObj2));
        ((Rectangle)serializable).x += nArray2[0];
        ((Rectangle)serializable).width -= nArray2[0];
        ((Rectangle)serializable).width -= nArray2[2];
        ((Rectangle)serializable).y += nArray2[3];
        ((Rectangle)serializable).height -= nArray2[3];
        ((Rectangle)serializable).height -= nArray2[1];
        perspective.putToLookNoCalc(identObj2, attr, serializable, !this.m_reset);
    }

    private static int[] getAxisSides(int n, boolean bl, boolean bl2) {
        int[] nArray = new int[3];
        if (n == 0 || n == 2) {
            if (bl && bl2 || !bl && !bl2) {
                nArray[0] = 0;
                nArray[2] = 1;
            } else {
                nArray[0] = 3;
                nArray[2] = 2;
            }
        } else {
            nArray[0] = -1;
        }
        if (n == 1 || n == 2) {
            if (bl && bl2 || !bl && !bl2) {
                nArray[1] = 2;
                nArray[2] = 1;
            } else {
                nArray[1] = 1;
                nArray[2] = 2;
            }
        } else {
            nArray[1] = -1;
        }
        return nArray;
    }

    private static boolean validateDataAxisSide(Perspective perspective, Graphics graphics, IdentObj identObj, IdentObj identObj2, IdentObj identObj3, Vector vector, int n, int n2) {
        int n3 = BILabelLayout.getRequiredDataAxisSpace(perspective, graphics, identObj2, identObj3, vector, n);
        int n4 = BILabelLayout.getRequiredDataAxisPerpendSpace(perspective, graphics, identObj2, identObj3, vector, n2);
        Rectangle rectangle = perspective.getRect(identObj);
        Point point = BILabelLayout.adjustFrameFor3D(perspective, rectangle);
        int n5 = point.x - rectangle.x;
        int n6 = point.y - rectangle.y;
        Rectangle rectangle2 = null;
        switch (n) {
            case 0: {
                if (n5 < 0) {
                    rectangle2 = new Rectangle(point.x - n3, point.y, n3, rectangle.height + n4);
                    break;
                }
                rectangle2 = new Rectangle(rectangle.x - n3, rectangle.y, n3, rectangle.height + n4);
                break;
            }
            case 1: {
                if (n6 > 0) {
                    rectangle2 = new Rectangle(point.x, point.y + rectangle.height, rectangle.width + n4, n3);
                    break;
                }
                rectangle2 = new Rectangle(rectangle.x, rectangle.y + rectangle.height, rectangle.width + n4, n3);
                break;
            }
            case 2: {
                if (n5 > 0) {
                    rectangle2 = new Rectangle(point.x + rectangle.width, point.y, n3, rectangle.height + n4);
                    break;
                }
                rectangle2 = new Rectangle(rectangle.x + rectangle.width, rectangle.y, n3, rectangle.height + n4);
                break;
            }
            case 3: {
                rectangle2 = n6 < 0 ? new Rectangle(point.x, point.y - n3, rectangle.width + n4, n3) : new Rectangle(rectangle.x, rectangle.y - n3, rectangle.width + n4, n3);
            }
        }
        return !BILabelLayout.intersectsComponents(perspective, rectangle2);
    }

    private static int getRequiredDataAxisPerpendSpace(Perspective perspective, Graphics graphics, IdentObj identObj, IdentObj identObj2, Vector vector, int n) {
        int n2;
        boolean bl = n == 1;
        boolean bl2 = perspective.getTextRotation(identObj) != 0;
        FontMetrics fontMetrics = BILabelLayout.getFontMetrics(graphics, perspective, identObj);
        int n3 = BILabelLayout.getPFJFontHeight(fontMetrics);
        if (bl && bl2 || !bl && !bl2) {
            n3 = 0;
            n2 = 0;
            while (n2 < vector.size()) {
                int n4;
                String string = (String)vector.elementAt(n2);
                if (string != null && (n4 = fontMetrics.stringWidth(string)) > n3) {
                    n3 = n4;
                }
                ++n2;
            }
        }
        n3 = (double)(n3 /= 2) < (double)10 - (double)n3 * 0.4 ? 0 : (int)((double)n3 - ((double)10 - (double)n3 * 0.4));
        n2 = bl ? perspective.getVC().destToVirtHeight(n3) : perspective.getVC().destToVirtWidth(n3);
        return n2;
    }

    private static int getRequiredDataAxisSpace(Perspective perspective, Graphics graphics, IdentObj identObj, IdentObj identObj2, Vector vector, int n) {
        int n2;
        boolean bl = n == 0 || n == 2;
        int n3 = BILabelLayout.getAxisTitleHeight(graphics, perspective, identObj2, bl);
        boolean bl2 = perspective.getTextRotation(identObj) != 0;
        boolean bl3 = perspective.getLabelStagger(identObj);
        FontMetrics fontMetrics = BILabelLayout.getFontMetrics(graphics, perspective, identObj);
        int n4 = BILabelLayout.getPFJFontHeight(fontMetrics);
        if (bl && !bl2 || !bl && bl2) {
            n4 = 0;
            n2 = 0;
            while (n2 < vector.size()) {
                int n5;
                String string = (String)vector.elementAt(n2);
                if (string != null && (n5 = fontMetrics.stringWidth(string)) > n4) {
                    n4 = n5;
                }
                ++n2;
            }
        }
        if (bl3) {
            n4 *= 2;
        }
        n2 = bl ? perspective.getVC().destToVirtWidth(n4) + n3 : perspective.getVC().destToVirtHeight(n4 += 5) + n3;
        return n2;
    }

    private void doTitlesAutoLayout(Graphics graphics, Perspective perspective, TitleObj titleObj, TitleObj titleObj2, TitleObj titleObj3, boolean bl) {
        Rectangle rectangle;
        Rectangle rectangle2;
        IdentObj identObj = perspective.getTitle();
        IdentObj identObj2 = perspective.getSubtitle();
        Rectangle rectangle3 = this.calculateTitleRect(graphics, perspective, titleObj, identObj, perspective.getTitleString(), identObj2, bl);
        if (rectangle3 != null) {
            perspective.putToLookNoCalc(perspective.getTitle(), Attr.TitleRect, rectangle3, !this.m_reset);
            if (this.m_reset) {
                ((GraphTitle)this.m_graph.getTitle()).setPropertyOverrideFlags(4);
            }
        }
        if ((rectangle2 = this.calculateTitleRect(graphics, perspective, titleObj2, identObj2, perspective.getSubtitleString(), identObj, bl)) != null) {
            if (perspective.getDisplay(identObj)) {
                rectangle2.y = rectangle2.y - rectangle3.height - perspective.getVC().destToVirtHeight(5);
            }
            perspective.putToLookNoCalc(perspective.getSubtitle(), Attr.SubtitleRect, rectangle2, !this.m_reset);
            if (this.m_reset) {
                ((GraphSubtitle)this.m_graph.getSubtitle()).setPropertyOverrideFlags(4);
            }
        }
        if ((rectangle = this.calculateFootnoteRect(graphics, perspective, titleObj3, bl)) != null) {
            perspective.putToLookNoCalc(perspective.getFootnote(), Attr.FootnoteRect, rectangle, !this.m_reset);
            if (this.m_reset) {
                ((GraphFootnote)this.m_graph.getFootnote()).setPropertyOverrideFlags(4);
            }
        }
    }

    private void readjustTitles(Perspective perspective, boolean bl) {
        this.adjustTitle(perspective, perspective.getTitle(), bl);
        this.adjustTitle(perspective, perspective.getSubtitle(), bl);
        this.adjustFootnote(perspective, perspective.getFootnote(), bl);
    }

    private void adjustTitle(Perspective perspective, IdentObj identObj, boolean bl) {
        Serializable serializable;
        if (!perspective.getDisplay(identObj)) {
            return;
        }
        int n = perspective.getTextJustHoriz(identObj);
        if (n != 1) {
            return;
        }
        Rectangle rectangle = perspective.getRect(identObj);
        int n2 = 32000 - 2 * this.m_graphMarginH;
        if (this._isLegendDisplayed()) {
            serializable = perspective.getLegendRect();
            int n3 = this.m_graph.getLegendArea().getAutomaticPosition();
            if (bl) {
                if (n3 == 2 || n3 == 3) {
                    n2 -= serializable.width;
                }
                rectangle.x += (n2 - rectangle.width) / 2;
            } else {
                int n4 = serializable.x;
                int n5 = serializable.y + serializable.height;
                switch (n3) {
                    case 2: {
                        if (rectangle.y < n5 + this.m_graphMarginV) {
                            n2 -= serializable.width + this.m_graphMarginH;
                        }
                        rectangle.x += (n2 - rectangle.width) / 2;
                        break;
                    }
                    case 3: {
                        if (rectangle.y < n5 + this.m_graphMarginV) {
                            n2 -= serializable.width + this.m_graphMarginH;
                        }
                        rectangle.x -= (n2 - rectangle.width) / 2;
                        break;
                    }
                    default: {
                        rectangle.x += (n2 - rectangle.width) / 2;
                    }
                }
            }
        } else {
            rectangle.x += (n2 - rectangle.width) / 2;
        }
        serializable = Attr.TitleRect;
        if (identObj.getObjectID() == 4) {
            serializable = Attr.SubtitleRect;
        }
        perspective.putToLookNoCalc(identObj, (Attr)serializable, rectangle, !this.m_reset);
    }

    private void adjustFootnote(Perspective perspective, IdentObj identObj, boolean bl) {
        if (!perspective.getDisplay(identObj)) {
            return;
        }
        int n = perspective.getTextJustHoriz(identObj);
        if (n != 1) {
            return;
        }
        Rectangle rectangle = perspective.getRect(identObj);
        int n2 = 32000 - 2 * this.m_graphMarginH;
        if (this._isLegendDisplayed()) {
            Rectangle rectangle2 = perspective.getLegendRect();
            int n3 = this.m_graph.getLegendArea().getAutomaticPosition();
            if (bl) {
                if (n3 == 2 || n3 == 3) {
                    n2 -= rectangle2.width;
                }
                rectangle.x += (n2 - rectangle.width) / 2;
            } else {
                int n4 = rectangle2.x;
                int n5 = rectangle2.y;
                switch (n3) {
                    case 2: {
                        if (rectangle.y > n5 - this.m_graphMarginV) {
                            n2 -= rectangle2.width + this.m_graphMarginH;
                        }
                        rectangle.x += (n2 - rectangle.width) / 2;
                        break;
                    }
                    case 3: {
                        if (rectangle.y > n5 - this.m_graphMarginV) {
                            n2 -= rectangle2.width + this.m_graphMarginH;
                        }
                        rectangle.x -= (n2 - rectangle.width) / 2;
                        break;
                    }
                    default: {
                        rectangle.x += (n2 - rectangle.width) / 2;
                    }
                }
            }
        } else {
            rectangle.x += (n2 - rectangle.width) / 2;
        }
        perspective.putToLookNoCalc(identObj, Attr.FootnoteRect, rectangle, !this.m_reset);
    }

    private Rectangle calculateTitleRect(Graphics graphics, Perspective perspective, TitleObj titleObj, IdentObj identObj, String string, IdentObj identObj2, boolean bl) {
        int n;
        if (!perspective.getDisplay(identObj)) {
            return null;
        }
        if (string.equals("")) {
            perspective.putToLookNoCalc(identObj, Attr.NoDisplay, new Boolean(false), !this.m_reset);
            return null;
        }
        perspective.putToLookNoCalc(identObj, Attr.TextRotation, new Integer(0), !this.m_reset);
        if (this.m_reset) {
            ((GraphTitle)this.m_graph.getTitle()).setPropertyOverrideFlags(1);
        }
        int n2 = this.m_graph.getLegendArea().getAutomaticPosition();
        int n3 = 32000 - 2 * this.m_graphMarginH;
        int n4 = -16000 + this.m_graphMarginH;
        int n5 = 16000 - this.m_graphMarginV;
        if (bl && this._isLegendDisplayed()) {
            Rectangle rectangle = perspective.getLegendRect();
            switch (n2) {
                case 2: {
                    n3 -= rectangle.width;
                    break;
                }
                case 3: {
                    n3 -= rectangle.width;
                    n4 += rectangle.width;
                    break;
                }
                case 0: {
                    n5 -= rectangle.height;
                    break;
                }
            }
        }
        int n6 = !perspective.getFontSizeAbsolute(identObj) ? perspective.getVC().virtToDestHeight(perspective.getFontSizeVC(identObj)) : perspective.getFontSize(identObj);
        int n7 = BILabelLayout.getJavaFontStyle(perspective.getFontStyle(identObj));
        String string2 = perspective.getFontName(identObj);
        Font font = new Font(string2, n7, n6);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n8 = perspective.getVC().destToVirtWidth(fontMetrics.stringWidth(string));
        int n9 = perspective.getVC().destToVirtHeight(BILabelLayout.getPFJFontHeight(fontMetrics));
        boolean bl2 = false;
        if (n8 > n3) {
            n8 = n3;
            bl2 = true;
        }
        Vector vector = new Vector();
        TextStyleObj textStyleObj = new TextStyleObj(null, null, 0, false, 0, 0, 0, 0, 0, false, false, false);
        textStyleObj.extractLinesWordWrap(string, vector, perspective.getVC().virtToDestWidth(n8), fontMetrics);
        if (perspective.getDisplay(identObj2)) {
            if (vector.size() >= 2 || bl2) {
                titleObj.setTruncated(true, 1);
                this.m_graph.processAlertEvent(12);
                this.m_graph.getErrorHandler().log("title text truncated", this.getClass().getName(), "adjustProperties");
            }
        } else if (vector.size() > 2) {
            n9 = 2 * n9;
            titleObj.setTruncated(true, 2);
            this.m_graph.processAlertEvent(12);
            this.m_graph.getErrorHandler().log("title text truncated", this.getClass().getName(), "adjustProperties");
        } else {
            n = vector.size();
            n9 = n * n9;
            if (fontMetrics.stringWidth((String)vector.elementAt(n - 1)) > perspective.getVC().virtToDestWidth(n8)) {
                titleObj.setTruncated(true, n);
                this.m_graph.processAlertEvent(12);
                this.m_graph.getErrorHandler().log("title text truncated", this.getClass().getName(), "adjustProperties");
            } else {
                titleObj.setTruncated(false, 2);
            }
        }
        n = perspective.getTextJustHoriz(identObj);
        if (n == 3) {
            n = LocaleUtils.getReadingDirectionForLocale((Locale)perspective.getLocale());
            if (n == 1) {
                n = 0;
            }
            if (n == 2) {
                n = 2;
            }
        }
        if (n == 2 || n == 1 && n2 == 3 && !bl) {
            n4 += n3 - n8;
        }
        return new Rectangle(n4, n5 - n9, ++n8, n9);
    }

    private Rectangle calculateFootnoteRect(Graphics graphics, Perspective perspective, TitleObj titleObj, boolean bl) {
        IdentObj identObj = perspective.getFootnote();
        if (!perspective.getDisplay(identObj)) {
            return null;
        }
        if (perspective.getFootnoteString().equals("")) {
            perspective.putToLookNoCalc(identObj, Attr.NoDisplay, new Boolean(false), !this.m_reset);
            return null;
        }
        perspective.putToLookNoCalc(identObj, Attr.TextRotation, new Integer(0), !this.m_reset);
        if (this.m_reset) {
            ((GraphFootnote)this.m_graph.getFootnote()).setPropertyOverrideFlags(1);
        }
        String string = perspective.getFootnoteString();
        int n = this.m_graph.getLegendArea().getAutomaticPosition();
        int n2 = 32000 - 2 * this.m_graphMarginH;
        int n3 = -16000 + this.m_graphMarginH;
        int n4 = -16000 + this.m_graphMarginV;
        if (bl && this._isLegendDisplayed()) {
            Rectangle rectangle = perspective.getLegendRect();
            switch (n) {
                case 2: {
                    n2 -= rectangle.width;
                    break;
                }
                case 3: {
                    n2 -= rectangle.width;
                    n3 += rectangle.width;
                    break;
                }
                case 1: {
                    n4 += rectangle.height;
                    break;
                }
            }
        }
        int n5 = !perspective.getFontSizeAbsolute(identObj) ? perspective.getVC().virtToDestHeight(perspective.getFontSizeVC(identObj)) : perspective.getFontSize(identObj);
        int n6 = BILabelLayout.getJavaFontStyle(perspective.getFontStyle(identObj));
        String string2 = perspective.getFontName(identObj);
        Font font = new Font(string2, n6, n5);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n7 = perspective.getVC().destToVirtWidth(fontMetrics.stringWidth(string));
        int n8 = perspective.getVC().destToVirtHeight(BILabelLayout.getPFJFontHeight(fontMetrics));
        if (n7 > n2) {
            n7 = n2;
            Vector vector = new Vector();
            TextStyleObj textStyleObj = new TextStyleObj(null, null, 0, false, 0, 0, 0, 0, 0, false, false, false);
            textStyleObj.extractLinesWordWrap(string, vector, perspective.getVC().virtToDestWidth(n7), fontMetrics);
            if (vector.size() <= 2) {
                n8 = vector.size() * n8;
            } else {
                n8 = 2 * n8;
                titleObj.setTruncated(true, 2);
                this.m_graph.processAlertEvent(12);
                this.m_graph.getErrorHandler().log("title text truncated", this.getClass().getName(), "calculateFootnoteRect");
            }
        } else {
            titleObj.setTruncated(false, 1);
        }
        int n9 = perspective.getTextJustHoriz(identObj);
        if (n9 == 3) {
            n9 = LocaleUtils.getReadingDirectionForLocale((Locale)perspective.getLocale());
            if (n9 == 1) {
                n9 = 0;
            }
            if (n9 == 2) {
                n9 = 2;
            }
        }
        if (n9 == 2 || n9 == 1 && n == 3 && !bl) {
            n3 += n2 - n7;
        }
        return new Rectangle(n3, n4, ++n7, n8);
    }

    private boolean _isTitlesLayoutValid(Perspective perspective, Graphics graphics) {
        Rectangle rectangle = perspective.getRect(perspective.getTitle());
        Rectangle rectangle2 = perspective.getRect(perspective.getSubtitle());
        Rectangle rectangle3 = perspective.getRect(perspective.getFootnote());
        IdentObj identObj = perspective.getTitle();
        IdentObj identObj2 = perspective.getSubtitle();
        IdentObj identObj3 = perspective.getFootnote();
        if (perspective.getDisplay(identObj) && perspective.getDisplay(identObj2) && rectangle.intersects(rectangle2)) {
            return false;
        }
        if (perspective.getDisplay(identObj) && perspective.getDisplay(identObj3) && rectangle.intersects(rectangle3)) {
            return false;
        }
        if (perspective.getDisplay(identObj2) && perspective.getDisplay(identObj3) && rectangle2.intersects(rectangle3)) {
            return false;
        }
        return this._isTitleLayoutValid(perspective, graphics, perspective.getTitle(), perspective.getTitleString()) && this._isTitleLayoutValid(perspective, graphics, perspective.getSubtitle(), perspective.getTitleString()) && this._isTitleLayoutValid(perspective, graphics, perspective.getFootnote(), perspective.getTitleString());
    }

    private boolean _isTitleLayoutValid(Perspective perspective, Graphics graphics, IdentObj identObj, String string) {
        Rectangle rectangle;
        Rectangle rectangle2;
        int n;
        if (!perspective.getDisplay(identObj)) {
            return true;
        }
        Rectangle rectangle3 = perspective.getRect(identObj);
        int n2 = perspective.getTextRotation(identObj);
        int n3 = !perspective.getFontSizeAbsolute(identObj) ? perspective.getVC().virtToDestHeight(perspective.getFontSizeVC(identObj)) : perspective.getFontSize(identObj);
        int n4 = BILabelLayout.getJavaFontStyle(perspective.getFontStyle(identObj));
        String string2 = perspective.getFontName(identObj);
        Font font = new Font(string2, n4, n3);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        Vector vector = new Vector();
        TextStyleObj textStyleObj = new TextStyleObj(null, null, 0, false, 0, 0, 0, 0, 0, false, false, false);
        if (n2 == 0) {
            textStyleObj.extractLinesWordWrap(string, vector, perspective.getVC().virtToDestWidth(rectangle3.width), fontMetrics);
            n = 0;
            while (n < vector.size()) {
                if (fontMetrics.stringWidth((String)vector.elementAt(n)) > perspective.getVC().virtToDestWidth(rectangle3.width)) {
                    return false;
                }
                ++n;
            }
            if (rectangle3.height < perspective.getVC().destToVirtHeight(BILabelLayout.getPFJFontHeight(fontMetrics)) * vector.size()) {
                return false;
            }
        } else {
            textStyleObj.extractLinesWordWrap(string, vector, perspective.getVC().virtToDestHeight(rectangle3.height), fontMetrics);
            n = 0;
            while (n < vector.size()) {
                if (fontMetrics.stringWidth((String)vector.elementAt(n)) > perspective.getVC().virtToDestHeight(rectangle3.height)) {
                    return false;
                }
                ++n;
            }
            if (rectangle3.width < perspective.getVC().destToVirtWidth(BILabelLayout.getPFJFontHeight(fontMetrics)) * vector.size()) {
                return false;
            }
        }
        if (this._isLegendDisplayed() && (rectangle2 = perspective.getLegendRect()).intersects(rectangle3)) {
            return false;
        }
        IdentObj identObj2 = null;
        identObj2 = this._isPieFrame(perspective.getGraphType()) ? perspective.getPieFrame() : perspective.getFrame();
        return !perspective.getDisplay(identObj2) || !rectangle3.intersects(rectangle = perspective.getRect(identObj2));
    }

    private boolean _isLegendLayoutValid(Perspective perspective, LegendObj legendObj, Graphics graphics) {
        if (this._isLegendDisplayed() && !this._isThreeDSurfaceGraph(perspective.getGraphType())) {
            Serializable serializable;
            Serializable serializable2;
            boolean bl;
            Cloneable cloneable;
            IdentObj identObj;
            Rectangle rectangle;
            Rectangle rectangle2 = perspective.getLegendRect();
            IdentObj identObj2 = null;
            identObj2 = this._isPieFrame(perspective.getGraphType()) ? perspective.getPieFrame() : perspective.getFrame();
            if (perspective.getDisplay(identObj2) && rectangle2.intersects(rectangle = perspective.getRect(identObj2))) {
                return false;
            }
            boolean bl2 = this.m_graph.getLegendArea().isAlongGraphEdge();
            int n = this.m_graph.getLegendArea().getAutomaticPosition();
            if (!bl2 || n == 0 || n == 1) {
                Serializable serializable3;
                Serializable serializable4;
                identObj = perspective.getTitle();
                if (perspective.getDisplay(identObj) && rectangle2.intersects((Rectangle)(serializable4 = perspective.getRect(identObj)))) {
                    return false;
                }
                serializable4 = perspective.getSubtitle();
                if (perspective.getDisplay((IdentObj)serializable4) && rectangle2.intersects((Rectangle)(serializable3 = perspective.getRect((IdentObj)serializable4)))) {
                    return false;
                }
                serializable3 = perspective.getFootnote();
                if (perspective.getDisplay((IdentObj)serializable3) && rectangle2.intersects((Rectangle)(cloneable = perspective.getRect((IdentObj)serializable3)))) {
                    return false;
                }
            }
            if ((bl = perspective.getFontSizeAbsolute(identObj = perspective.getLegendText())) || !perspective.getLegendTextAutofit()) {
                legendObj.init();
                if (legendObj.getMarkersLabels().getNumLabels() > 0) {
                    legendObj.layoutCells();
                }
                int n2 = perspective.getFontSize(identObj);
                if (!bl) {
                    n2 = perspective.getVC().virtToDestHeight(perspective.getFontSizeVC(identObj));
                }
                int n3 = BILabelLayout.getJavaFontStyle(perspective.getFontStyle(identObj));
                serializable2 = new Font(perspective.getFontName(identObj), n3, n2);
                serializable = graphics.getFontMetrics((Font)serializable2);
                int n4 = TextStyleObj.getFontHeight((FontMetrics)serializable);
                Dimension dimension = legendObj.getDimCell();
                int n5 = perspective.getVC().virtToDestHeight(dimension.height);
                if (n4 > n5) {
                    return false;
                }
            }
            int n6 = perspective.getDetectiv().getVectorList().size();
            legendObj.calc();
            cloneable = legendObj.getMarkersLabels().getDimLabelCell();
            serializable2 = legendObj.getMarkersLabels().getTextStyleObj();
            serializable = serializable2.getDimLargeTextVC(perspective.getVC());
            Vector vector = perspective.getDetectiv().getVectorList();
            int n7 = vector.size() - 1;
            while (n7 > n6 - 1) {
                BlackBoxIF blackBoxIF;
                DetObj detObj = (DetObj)vector.elementAt(n7);
                if (detObj != null && (blackBoxIF = detObj.getBlackBox()) != null) {
                    blackBoxIF.releaseReferences();
                    vector.removeElementAt(n7);
                }
                --n7;
            }
            if (serializable != null && cloneable != null && (serializable.width > ((Dimension)cloneable).width || serializable.height > ((Dimension)cloneable).height)) {
                return false;
            }
        }
        return true;
    }

    private boolean _isThreeDSurfaceGraph(int n) {
        return n == 12 || n == 13 || n == 14;
    }

    private boolean _isPieFrame(int n) {
        return n >= 55 && n <= 60 || n >= 93 && n <= 94;
    }

    private boolean _isLegendDisplayed() {
        return this.m_legendDisplay;
    }

    private void _setLegendDisplayed(LegendObj legendObj) {
        this.m_legendDisplay = legendObj != null;
    }

    private static Point adjustFrameFor3D(Perspective perspective, Rectangle rectangle) {
        Point point = new Point(rectangle.x, rectangle.y);
        int n = perspective.getDepthAngle();
        int n2 = perspective.getDepthRadius();
        if (n2 > 0 && n > 0 && n < 180) {
            int n3 = rectangle.width / 3;
            int n4 = n3 * n2 / 100;
            int n5 = (int)((double)n4 * Math.cos((double)n * Math.PI / (double)180));
            int n6 = (int)((double)n4 * Math.sin((double)n * Math.PI / (double)180));
            if (n5 >= 0 || n5 < 0 && !perspective.isChartOrientHorz()) {
                point.x -= n5;
                point.y -= n6;
            }
        }
        return point;
    }

    private static boolean intersectsComponents(Perspective perspective, Rectangle rectangle) {
        if (!perspective.getVC().getVirtCoords().contains(rectangle)) {
            return true;
        }
        boolean bl = false;
        IdentObj[] identObjArray = new IdentObj[]{perspective.getTitle(), perspective.getSubtitle(), perspective.getFootnote(), perspective.getLegendArea()};
        int n = 0;
        while (n < identObjArray.length && !bl) {
            if (perspective.getDisplay(identObjArray[n])) {
                bl = rectangle.intersects(perspective.getRect(identObjArray[n]));
            }
            ++n;
        }
        return bl;
    }

    private static int getAxisTitleHeight(Graphics graphics, Perspective perspective, IdentObj identObj, boolean bl) {
        int n = 0;
        String string = perspective.getTextString(identObj);
        if (string.length() != 0 && perspective.getDisplay(identObj)) {
            FontMetrics fontMetrics = BILabelLayout.getFontMetrics(graphics, perspective, identObj);
            n = bl ? perspective.getVC().destToVirtWidth(BILabelLayout.getPFJFontHeight(fontMetrics) + 10) : perspective.getVC().destToVirtHeight(BILabelLayout.getPFJFontHeight(fontMetrics) + 10);
        }
        return n;
    }

    private static Rectangle getLabelSpace(Graphics graphics, Perspective perspective, IdentObj identObj, Rectangle rectangle) {
        boolean bl = perspective.isChartOrientHorz();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Point point = BILabelLayout.adjustFrameFor3D(perspective, rectangle);
        Rectangle rectangle2 = new Rectangle(point.x, point.y, rectangle.width, rectangle.height);
        IdentObj identObj2 = perspective.getLegendArea();
        Rectangle rectangle3 = null;
        if (perspective.getDisplay(identObj2)) {
            rectangle3 = perspective.getRect(identObj2);
        }
        IdentObj identObj3 = perspective.getFootnote();
        Rectangle rectangle4 = null;
        if (perspective.getDisplay(identObj3)) {
            rectangle4 = perspective.getRect(identObj3);
        }
        int n5 = BILabelLayout.getAxisTitleHeight(graphics, perspective, identObj, bl);
        Rectangle rectangle5 = perspective.getVC().getVirtCoords();
        if (bl) {
            rectangle2.y -= 100;
            rectangle2.height += 200;
            rectangle2.x -= perspective.getVC().destToVirtWidth(5);
            n4 = rectangle2.y;
            n2 = rectangle2.height;
            int n6 = rectangle5.x;
            if (rectangle3 != null && rectangle3.x + rectangle3.width < rectangle5.x + rectangle5.width / 2 && rectangle3.y + rectangle3.height > rectangle2.y && rectangle3.y < rectangle2.y + rectangle2.height) {
                n6 = rectangle3.x + rectangle3.width;
            }
            n3 = n6 + n5;
            n = rectangle2.x - n3;
        } else {
            int n7;
            rectangle2.x -= 100;
            rectangle2.width += 200;
            rectangle2.y -= perspective.getVC().destToVirtHeight(5);
            n3 = rectangle2.x;
            n = rectangle2.width;
            int n8 = rectangle5.y;
            if (rectangle3 != null && rectangle3.y + rectangle3.height < rectangle5.y + rectangle5.height / 2 && rectangle3.x + rectangle3.width > rectangle2.x && rectangle3.x < rectangle2.x + rectangle2.width) {
                n8 = rectangle3.y + rectangle3.height;
            }
            if (rectangle4 != null && rectangle4.y + rectangle4.height < rectangle5.y + rectangle5.height / 2 && (n7 = rectangle4.y + rectangle4.height) > n8) {
                n8 = n7;
            }
            n4 = n8 + n5;
            n2 = rectangle2.y - n4;
        }
        return new Rectangle(n3, n4, n, n2);
    }

    private static int getJavaFontStyle(int n) {
        int n2 = 0;
        n2 |= (n & 1) != 0 ? 2 : 0;
        return n2 |= (n & 2) != 0 ? 1 : 0;
    }

    private static FontMetrics getFontMetrics(Graphics graphics, Perspective perspective, IdentObj identObj) {
        int n = perspective.getFontSize(identObj);
        if (!perspective.getFontSizeAbsolute(identObj)) {
            n = perspective.getVC().virtToDestHeight(perspective.getFontSizeVC(identObj));
        }
        int n2 = BILabelLayout.getJavaFontStyle(perspective.getFontStyle(identObj));
        Font font = new Font(perspective.getFontName(identObj), n2, n);
        return graphics.getFontMetrics(font);
    }

    private static int getLongestLabelWidth(FontMetrics fontMetrics, String[] stringArray, int n, int n2, int[] nArray) {
        int n3 = 0;
        int n4 = stringArray.length;
        int n5 = 0;
        int n6 = n2;
        while (n6 < n4) {
            String string = stringArray[n6];
            if (string != null) {
                int n7 = fontMetrics.stringWidth(BILabelLayout.limitString(string, false));
                if (nArray != null) {
                    nArray[n5++] = n7;
                }
                if (n7 > n3) {
                    n3 = n7;
                }
            }
            n6 += n + 1;
        }
        return n3;
    }

    private static boolean verifyPairLengths(int[] nArray, int n, int n2) {
        boolean bl = true;
        if (nArray.length > n) {
            bl = false;
            int n3 = 0;
            while (!bl && n3 < nArray.length - n) {
                bl = (nArray[n3] + nArray[n3 + n]) / 2 > n2;
                ++n3;
            }
        }
        return !bl;
    }

    private static int wordWrap(FontMetrics fontMetrics, String[] stringArray, int n, int n2, int n3, int n4) {
        int n5 = -1;
        int n6 = BILabelLayout.getPFJFontHeight(fontMetrics);
        int n7 = n4 / n6;
        if (n7 > 1) {
            int n8 = 1;
            boolean bl = false;
            int n9 = fontMetrics.charWidth(' ');
            int n10 = stringArray.length;
            int n11 = n2;
            while (!bl && n11 < n10) {
                String string = stringArray[n11];
                if (string != null) {
                    string = BILabelLayout.limitString(string, false);
                    int n12 = 0;
                    int n13 = 1;
                    String string2 = " \t\n\r\f";
                    StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
                    while (!bl && stringTokenizer.hasMoreTokens()) {
                        String string3 = stringTokenizer.nextToken();
                        if (string2.indexOf(string3) != -1) {
                            if (!string3.equals("\n")) continue;
                            n12 = 0;
                            if (n8 < ++n13) {
                                n8 = n13;
                            }
                            if (n13 <= n7) continue;
                            bl = true;
                            continue;
                        }
                        int n14 = fontMetrics.stringWidth(string3 = BILabelLayout.limitString(string3, true));
                        if (n14 < n3) {
                            if (n12 != 0) {
                                n12 += n9;
                            }
                            if ((n12 += n14) <= n3) continue;
                            if (++n13 <= n7) {
                                n12 = n14;
                                if (n8 >= n13) continue;
                                n8 = n13;
                                continue;
                            }
                            bl = true;
                            continue;
                        }
                        bl = true;
                    }
                }
                n11 += n + 1;
            }
            if (!bl) {
                n5 = n8 * n6;
            }
        }
        return n5;
    }

    private static int wordWrap(FontMetrics fontMetrics, Vector[] vectorArray, int n, boolean bl, int n2) {
        int n3 = -1;
        int n4 = 1;
        boolean bl2 = false;
        int n5 = fontMetrics.charWidth(' ');
        int n6 = vectorArray.length;
        int n7 = 0;
        while (!bl2 && n7 < n6) {
            int n8 = 0;
            int n9 = 1;
            int n10 = 0;
            while (n10 < vectorArray[n7].size() && !bl2) {
                int n11 = (Integer)vectorArray[n7].elementAt(n10);
                if (n11 == -1) {
                    n8 = 0;
                    if (n4 < ++n9) {
                        n4 = n9;
                    }
                    if (n9 > n2) {
                        bl2 = true;
                    }
                } else if (n11 < n) {
                    if (n8 != 0) {
                        n8 += n5;
                    }
                    if ((n8 += n11) > n) {
                        if (++n9 > n2 || bl && n10 == vectorArray[n7].size() - 1 && n11 < 15) {
                            bl2 = true;
                        } else {
                            n8 = n11;
                            if (n4 < n9) {
                                n4 = n9;
                            }
                        }
                    }
                } else {
                    bl2 = true;
                }
                ++n10;
            }
            ++n7;
        }
        if (!bl2) {
            n3 = n4;
        }
        return n3;
    }

    private static Vector[] getWordLengths(FontMetrics fontMetrics, String[] stringArray, int n, int n2) {
        int n3 = (stringArray.length - n2 + n) / (n + 1);
        Vector[] vectorArray = new Vector[n3];
        int n4 = n2;
        int n5 = 0;
        while (n4 < stringArray.length) {
            vectorArray[n5] = new Vector(10);
            String string = stringArray[n4];
            if (string != null) {
                string = BILabelLayout.limitString(string, false);
                String string2 = " \t\n\r\f";
                StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if (string2.indexOf(string3) != -1) {
                        if (!string3.equals("\n")) continue;
                        vectorArray[n5].add(new Integer(-1));
                        continue;
                    }
                    string3 = BILabelLayout.limitString(string3, true);
                    int n6 = fontMetrics.stringWidth(string3);
                    vectorArray[n5].add(new Integer(n6));
                }
            }
            n4 += n + 1;
            ++n5;
        }
        return vectorArray;
    }

    private static String limitString(String string, boolean bl) {
        return string;
    }

    private static int[] getPlotAreaShifts(int n, int n2, double d, double d2, int n3, int n4) {
        int[] nArray = new int[2];
        if (n > 0 || n2 > 0) {
            if (n4 == 1) {
                if (-n2 - n < 0) {
                    return null;
                }
                if (n > 0) {
                    nArray[0] = (int)((double)n / d);
                } else {
                    nArray[1] = (int)((double)n2 / d2);
                }
                if (nArray[0] + nArray[1] > n3) {
                    return null;
                }
            } else {
                boolean bl = false;
                do {
                    int n5;
                    if (n2 > 0) {
                        n5 = (int)((double)n2 / d2);
                        nArray[1] = nArray[1] + n5;
                        n2 = 0;
                        n += (int)((double)n5 * (1.0 - d));
                    }
                    if (n > 0) {
                        n5 = (int)((double)n / d);
                        nArray[0] = nArray[0] + n5;
                        n = 0;
                        n2 += (int)((double)n5 * (1.0 - d2));
                    }
                    boolean bl2 = bl = nArray[0] + nArray[1] > n3;
                } while (!bl && n2 > 100);
                if (bl) {
                    return null;
                }
            }
        }
        return nArray;
    }

    private void doLegendAutoLayout(Graphics graphics, LegendObj legendObj, Access access, JChart_Base jChart_Base, Perspective perspective, boolean bl) {
        if (legendObj == null || !this._isLegendDisplayed() || this._isThreeDSurfaceGraph(perspective.getGraphType())) {
            return;
        }
        this.setLegendProps(perspective);
        legendObj.init();
        int n = this.m_graph.getLegendArea().getAutomaticPosition();
        if (n == 2 || n == 3) {
            this.doLegendAutoLayoutLR(graphics, legendObj, access, jChart_Base, perspective, n);
        } else {
            this.doLegendAutoLayoutTB(graphics, legendObj, access, jChart_Base, perspective, n);
        }
        if (this.m_reset) {
            this.m_graph.getLegendArea().setPropertyOverrideFlags(12);
        }
    }

    private void doLegendAutoLayoutTB(Graphics graphics, LegendObj legendObj, Access access, JChart_Base jChart_Base, Perspective perspective, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Attr attr;
        IdentObj identObj;
        int n7 = 32000;
        boolean bl = this.m_graph.getLegendArea().isAlongGraphEdge();
        if (!bl) {
            n7 -= 2 * this.m_graphMarginH;
        }
        if (bl) {
            n7 -= perspective.getVC().destToVirtWidth(1);
        }
        perspective.putToLookNoCalc(new IdentObj(2000), Attr.LegendOrient, new Integer(1), !this.m_reset);
        Rectangle rectangle = null;
        Rectangle rectangle2 = null;
        Rectangle rectangle3 = null;
        boolean bl2 = perspective.getTitleDisplay();
        boolean bl3 = perspective.getSubtitleDisplay();
        boolean bl4 = perspective.getFootnoteDisplay();
        int n8 = this.m_graph.getGraphType();
        boolean bl5 = this._isPieFrame(n8);
        if (bl5) {
            identObj = perspective.getPieFrame();
            attr = Attr.PieFrameRect;
        } else {
            identObj = perspective.getFrame();
            attr = Attr.FrameRect;
        }
        Rectangle rectangle4 = (Rectangle)perspective.getRect(identObj).clone();
        Rectangle rectangle5 = (Rectangle)perspective.getRect(perspective.getLegendArea()).clone();
        if (bl2) {
            rectangle = (Rectangle)perspective.getRect(perspective.getTitle()).clone();
        }
        if (bl3) {
            rectangle2 = (Rectangle)perspective.getRect(perspective.getSubtitle()).clone();
        }
        if (bl4) {
            rectangle3 = (Rectangle)perspective.getRect(perspective.getFootnote()).clone();
        }
        VC vC = perspective.getVC();
        int n9 = vC.destToVirtHeight(7);
        int n10 = rectangle4.y + rectangle4.height;
        IdentObj identObj2 = perspective.getLegendText();
        int n11 = !perspective.getFontSizeAbsolute(identObj2) ? perspective.getVC().virtToDestHeight(perspective.getFontSizeVC(identObj2)) : perspective.getFontSize(identObj2);
        int n12 = BILabelLayout.getJavaFontStyle(perspective.getFontStyle(identObj2));
        String string = perspective.getFontName(identObj2);
        Font font = new Font(string, n12, n11);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n13 = TextStyleObj.getFontHeight(fontMetrics);
        int n14 = perspective.getLegendMarkerSize();
        int n15 = vC.destToVirtWidth(n14);
        int n16 = vC.destToVirtHeight(n13);
        int n17 = vC.destToVirtHeight(n14);
        int n18 = Math.max(n16, n17);
        String[] stringArray = this.getReferenceLineLabels(perspective);
        String string2 = this.getDrillText(perspective);
        int n19 = access.getNumTotalSeries();
        int n20 = legendObj.getSeriesRange() - legendObj.getSeriesStart();
        if (jChart_Base.isSingleSeriesOnly()) {
            n19 = 1;
        }
        n19 += stringArray.length;
        if (string2 != null) {
            ++n19;
        }
        n7 -= legendObj.DOUBLE_BOX_MARGIN_W;
        String[] stringArray2 = new String[n19];
        boolean bl6 = false;
        int n21 = 0;
        int n22 = 0;
        int n23 = 0;
        int n24 = 0;
        if (string2 != null) {
            stringArray2[n24] = string2;
            ++n24;
        }
        int n25 = 0;
        while (n25 < n19 - n24) {
            stringArray2[n25 + n24] = n25 >= access.getNumTotalSeries() ? stringArray[n23++] : perspective.getSeriesLabel(n25);
            ++n25;
        }
        n25 = 0;
        while (n25 < n19) {
            if (!bl6) {
                n6 = fontMetrics.stringWidth(stringArray2[n25]);
                if (n6 > n22) {
                    n22 = n6;
                }
                if ((n21 = (vC.destToVirtWidth(n22) + n15 + legendObj.getMarkersLabels().DOUBLE_MKR_MARGIN) * n20) > n7) {
                    bl6 = true;
                }
            }
            ++n25;
        }
        n25 = 0;
        n6 = 0;
        int n26 = 8000 - legendObj.DOUBLE_BOX_MARGIN_HT;
        if (!bl6) {
            n25 = !bl ? n21 : n7;
            n25 += legendObj.DOUBLE_BOX_MARGIN_W;
            n6 = n18 + legendObj.DOUBLE_BOX_MARGIN_HT;
        } else if (n26 < n18 || n7 < n15 + legendObj.getMarkersLabels().MKR_MARGIN) {
            n25 = n7 + legendObj.DOUBLE_BOX_MARGIN_W;
            n6 = n26 + legendObj.DOUBLE_BOX_MARGIN_HT;
        } else {
            n5 = (n26 + n9) / (n18 + n9);
            n4 = n7 / (n15 + legendObj.getMarkersLabels().MKR_MARGIN);
            if (n5 * n4 < stringArray2.length) {
                this.logAllMarkersError();
                perspective.putToLookNoCalc(new IdentObj(2000), Attr.LegendMarkersPerRow, new Integer(n4), !this.m_reset);
                if (this.m_reset) {
                    this.m_graph.getLegendArea().setPropertyOverrideFlags(10);
                }
                perspective.putToLookNoCalc(new IdentObj(2000), Attr.LegendSeriesCount, new Integer(n5 * n4), !this.m_reset);
                legendObj.getMarkersLabels().setDrawLabels(false);
                n6 = n5 * n18 + (n5 - 1) * n9;
                n25 = (n15 + legendObj.getMarkersLabels().MKR_MARGIN) * n4;
            } else {
                n3 = 0;
                int n27 = 0;
                while (n27 < n19) {
                    if (stringArray2[n27] != null && (n2 = fontMetrics.stringWidth(stringArray2[n27])) > n3) {
                        n3 = n2;
                    }
                    ++n27;
                }
                n27 = n15 + legendObj.getMarkersLabels().DOUBLE_MKR_MARGIN + vC.destToVirtWidth(n3);
                n2 = n18 + n9;
                int n28 = n7 / n27;
                int n29 = n26 / n2;
                if (n5 == 0) {
                    n5 = 1;
                }
                if (n28 == 0) {
                    n28 = 1;
                }
                if (n29 == 0) {
                    n29 = 1;
                }
                if (n29 > n5) {
                    n29 = n5;
                    n28 = n20 / n29;
                    if (n20 % n29 != 0) {
                        ++n28;
                    }
                    n25 = n7;
                } else {
                    n25 = n27 * n28;
                    n29 = n20 / n28;
                    if (n20 % n28 != 0) {
                        ++n29;
                    }
                    if (n29 > n5) {
                        n29 = n5;
                        n28 = n20 / n29;
                        if (n20 % n29 != 0) {
                            ++n28;
                        }
                        n25 = n7;
                    }
                }
                perspective.putToLookNoCalc(new IdentObj(2000), Attr.LegendMarkersPerRow, new Integer(n28), !this.m_reset);
                if (this.m_reset) {
                    this.m_graph.getLegendArea().setPropertyOverrideFlags(10);
                }
                n6 = n18 * n29 + (n29 - 1) * n9;
            }
            if (n6 > n26) {
                n6 = n26;
            }
            if (n25 > n7) {
                n25 = n7;
            }
            n6 += legendObj.DOUBLE_BOX_MARGIN_HT;
            n25 += legendObj.DOUBLE_BOX_MARGIN_W;
            if (bl) {
                n25 = 32000;
            }
        }
        n5 = 16000 - this.m_graphMarginV;
        n4 = -16000 + this.m_graphMarginV;
        if (rectangle != null) {
            n5 = rectangle.y - this.m_graphMarginV;
        }
        if (rectangle2 != null) {
            n5 = rectangle2.y - this.m_graphMarginV;
        }
        if (rectangle3 != null) {
            n4 = rectangle3.y + rectangle3.height + this.m_graphMarginV;
        }
        if (n == 0) {
            n3 = rectangle5.height;
            rectangle5.height = n6;
            rectangle5.width = n25;
            rectangle5.x = -(n25 / 2);
            if (!bl) {
                rectangle5.y = n5 - n6;
            } else {
                rectangle5.y = 16000 - n6;
                rectangle5.width -= vC.destToVirtWidth(1);
                Rectangle rectangle6 = this.m_graph.getLegendArea().getDefaultPFJRect(0, true);
                n2 = rectangle5.height - rectangle6.height;
                rectangle4.height -= n2;
            }
        }
        if (n == 1) {
            rectangle5.height = n6;
            rectangle5.width = n25;
            rectangle5.x = -(n25 / 2);
            if (!bl) {
                rectangle5.y = n4;
            } else {
                rectangle5.y = -16000 + vC.destToVirtHeight(1);
                rectangle5.width -= vC.destToVirtWidth(1);
                Rectangle rectangle7 = this.m_graph.getLegendArea().getDefaultPFJRect(1, true);
                int n30 = rectangle5.height - rectangle7.height;
                rectangle4.y += n30;
                rectangle4.height -= n30;
            }
        }
        perspective.putToLookNoCalc(identObj, attr, rectangle4, !this.m_reset);
        perspective.putToLookNoCalc(perspective.getLegendArea(), Attr.LegendAreaRect, rectangle5, !this.m_reset);
    }

    private void doLegendAutoLayoutLR(Graphics graphics, LegendObj legendObj, Access access, JChart_Base jChart_Base, Perspective perspective, int n) {
        int n2;
        int n3;
        int n4 = 10666;
        perspective.putToLookNoCalc(new IdentObj(2000), Attr.LegendOrient, new Integer(0), !this.m_reset);
        Rectangle rectangle = null;
        Rectangle rectangle2 = null;
        Rectangle rectangle3 = null;
        boolean bl = false;
        boolean bl2 = perspective.getTitleDisplay();
        boolean bl3 = perspective.getSubtitleDisplay();
        boolean bl4 = perspective.getFootnoteDisplay();
        int n5 = this.m_graph.getGraphType();
        boolean bl5 = this._isPieFrame(n5);
        IdentObj identObj = bl5 ? perspective.getPieFrame() : perspective.getFrame();
        Rectangle rectangle4 = (Rectangle)perspective.getRect(identObj).clone();
        Rectangle rectangle5 = (Rectangle)perspective.getRect(perspective.getLegendArea()).clone();
        if (bl2) {
            rectangle = perspective.getRect(perspective.getTitle());
        }
        if (bl3) {
            rectangle2 = perspective.getRect(perspective.getSubtitle());
        }
        if (bl4) {
            rectangle3 = perspective.getRect(perspective.getFootnote());
        }
        VC vC = perspective.getVC();
        int n6 = vC.destToVirtHeight(7);
        int n7 = rectangle4.y + rectangle4.height;
        int n8 = 16000;
        int n9 = -16000;
        boolean bl6 = this.m_graph.getLegendArea().isAlongGraphEdge();
        if (!bl6) {
            if (n == 2) {
                if (rectangle != null && rectangle.x + rectangle.width > 16000 - n4 - this.m_graphLegendGapH * 2) {
                    n8 = rectangle.y - this.m_graphMarginV;
                }
                if (rectangle2 != null && rectangle2.x + rectangle2.width > 16000 - n4 - this.m_graphLegendGapH * 2) {
                    n8 = rectangle2.y - this.m_graphMarginV;
                }
                if (rectangle3 != null && rectangle3.x + rectangle3.width > 16000 - n4 - this.m_graphLegendGapH * 2) {
                    n9 = rectangle3.y + rectangle3.height + this.m_graphMarginV;
                }
            } else {
                if (rectangle != null && rectangle.x < -16000 + n4 + this.m_graphLegendGapH * 2) {
                    n8 = rectangle.y - this.m_graphMarginV;
                }
                if (rectangle2 != null && rectangle2.x < -16000 + n4 + this.m_graphLegendGapH * 2) {
                    n8 = rectangle2.y - this.m_graphMarginV;
                }
                if (rectangle3 != null && rectangle3.x < -16000 + n4 + this.m_graphLegendGapH * 2) {
                    n9 = rectangle3.y + rectangle3.height + this.m_graphMarginV;
                }
            }
        }
        this.m_maxBottomY = n9;
        int n10 = n8 - n9;
        n10 -= legendObj.DOUBLE_BOX_MARGIN_HT;
        n4 -= legendObj.DOUBLE_BOX_MARGIN_W;
        String[] stringArray = this.getReferenceLineLabels(perspective);
        int n11 = access.getNumTotalSeries();
        int n12 = legendObj.getSeriesRange() - legendObj.getSeriesStart();
        if (jChart_Base.isSingleSeriesOnly()) {
            n11 = 1;
        }
        n11 += stringArray.length;
        String string = this.getDrillText(perspective);
        if (string != null) {
            ++n11;
        }
        String[] stringArray2 = new String[n11];
        int n13 = 0;
        int n14 = 0;
        if (string != null) {
            stringArray2[n14] = string;
            ++n14;
        }
        int n15 = 0;
        while (n15 < n11 - n14) {
            stringArray2[n15 + n14] = n15 >= access.getNumTotalSeries() ? stringArray[n13++] : perspective.getSeriesLabel(n15);
            ++n15;
        }
        IdentObj identObj2 = perspective.getLegendText();
        n15 = !perspective.getFontSizeAbsolute(identObj2) ? perspective.getVC().virtToDestHeight(perspective.getFontSizeVC(identObj2)) : perspective.getFontSize(identObj2);
        int n16 = BILabelLayout.getJavaFontStyle(perspective.getFontStyle(identObj2));
        String string2 = perspective.getFontName(identObj2);
        Font font = new Font(string2, n16, n15);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n17 = TextStyleObj.getFontHeight(fontMetrics);
        int n18 = perspective.getLegendMarkerSize();
        int n19 = vC.destToVirtWidth(n18);
        int n20 = vC.destToVirtHeight(n17);
        int n21 = vC.destToVirtHeight(n18);
        int n22 = Math.max(n20, n21);
        int n23 = vC.destToVirtHeight(fontMetrics.getDescent());
        int n24 = n3 = n22 * n12 + (n12 - 1) * n6;
        if (n3 < n10) {
            if (n4 <= n19 + legendObj.getMarkersLabels().MKR_MARGIN) {
                legendObj.getMarkersLabels().setDrawLabels(false);
                int n25 = n4 + legendObj.getMarkersLabels().DOUBLE_MKR_MARGIN;
                this.setRectangles(n, rectangle5, rectangle4, n5, bl5, identObj, perspective, n25, n3, bl6);
                return;
            }
            int n26 = n20 * 2 * n12 + (n12 - 1) * n6;
            if (n10 > n26) {
                int n27;
                int n28 = 0;
                int n29 = 0;
                while (n29 < n11) {
                    if (stringArray2[n29] != null && (n27 = fontMetrics.stringWidth(stringArray2[n29])) > n28) {
                        n28 = n27;
                    }
                    ++n29;
                }
                n29 = vC.destToVirtWidth(n28);
                if (n29 < (n27 = 3200)) {
                    n2 = n29;
                } else {
                    int n30;
                    Object object;
                    Object object2;
                    int n31;
                    boolean bl7 = true;
                    int n32 = 0;
                    int n33 = 0;
                    while (n33 < n11) {
                        if (stringArray2[n33] != null) {
                            n31 = 0;
                            object2 = new StringTokenizer(stringArray2[n33], " ");
                            while (((StringTokenizer)object2).hasMoreTokens()) {
                                ++n31;
                                object = ((StringTokenizer)object2).nextToken();
                                n30 = fontMetrics.stringWidth((String)object);
                                if (n30 <= n32) continue;
                                n32 = n30;
                            }
                            if (n31 > 1) {
                                bl7 = false;
                            }
                        }
                        ++n33;
                    }
                    if (bl7) {
                        n2 = n29;
                        if (n2 > n4) {
                            n2 = n4;
                        }
                    } else {
                        Serializable serializable;
                        n27 = Math.max(n27, vC.destToVirtWidth(n32));
                        n33 = 0;
                        n31 = 0;
                        object2 = new Vector();
                        while (n33 == 0) {
                            if (n27 > n4) {
                                n27 = n4;
                                n33 = 1;
                            }
                            bl = true;
                            object = null;
                            n31 = 0;
                            n30 = 0;
                            while (n30 < n11) {
                                if (stringArray2[n30] != null) {
                                    object = new Vector();
                                    serializable = new TextStyleObj(null, null, 0, false, 0, 0, 0, 0, 0, false, false, false);
                                    ((TextStyleObj)serializable).setTextTruncate(true, -1, 2);
                                    ((TextStyleObj)serializable).extractLinesWordWrap(stringArray2[n30], (Vector)object, vC.virtToDestWidth(n27), fontMetrics);
                                    serializable = null;
                                    if (object != null && ((Vector)object).size() > n31) {
                                        n31 = ((Vector)object).size();
                                    }
                                    ((Vector)object2).addElement(object);
                                    if (n20 * n31 * n12 + (n12 - 1) * n6 > n10) break;
                                }
                                ++n30;
                            }
                            n3 = n20 * n31 * n12 + (n12 - 1) * n6;
                            if (n33 == 0 && n3 > n10) {
                                n27 += (int)((double)((float)n3 / (float)n10) * 0.5 * (double)n27);
                            }
                            if (n3 > n10) continue;
                            n33 = 1;
                        }
                        if (n27 < n4 && n3 < n10) {
                            int n34 = 0;
                            Enumeration enumeration = ((Vector)object2).elements();
                            while (enumeration.hasMoreElements()) {
                                serializable = (Vector)enumeration.nextElement();
                                Enumeration enumeration2 = ((Vector)serializable).elements();
                                while (enumeration2.hasMoreElements()) {
                                    String string3 = (String)enumeration2.nextElement();
                                    int n35 = fontMetrics.stringWidth(string3);
                                    if (n35 <= n34) continue;
                                    n34 = n35;
                                }
                            }
                            n27 = vC.destToVirtWidth(n34);
                            if ((double)n27 + (double)n29 * 0.1 >= (double)n29 || n27 + vC.destToVirtWidth(15) >= n29) {
                                bl = false;
                                perspective.putToLookNoCalc(identObj2, Attr.TextWrap, new Boolean(false), !this.m_reset);
                                n3 = n24;
                                n27 = n29;
                            }
                        }
                        if (n3 > n10) {
                            int n36 = 1;
                            while (n36 < n31) {
                                int n37 = n20 * n36 * n12 + (n12 - 1) * n6;
                                if (n37 >= n10) break;
                                n3 = n37;
                                ++n36;
                            }
                        }
                        n2 = n27;
                    }
                }
                n3 += legendObj.DOUBLE_BOX_MARGIN_HT;
                if (bl6) {
                    n3 = n10 + legendObj.DOUBLE_BOX_MARGIN_HT;
                }
                n2 = n2 + legendObj.getMarkersLabels().DOUBLE_MKR_MARGIN + n19 + legendObj.DOUBLE_BOX_MARGIN_W;
                perspective.putToLookNoCalc(identObj2, Attr.TextWrap, new Boolean(bl), !this.m_reset);
                if (this.m_reset) {
                    this.m_graph.getLegendText().setPropertyOverrideFlags(4);
                }
            } else {
                n3 += legendObj.DOUBLE_BOX_MARGIN_HT;
                int n38 = 0;
                int n39 = 0;
                while (n39 < n11) {
                    int n40;
                    if (stringArray2[n39] != null && (n40 = fontMetrics.stringWidth(stringArray2[n39])) > n38) {
                        n38 = n40;
                    }
                    ++n39;
                }
                n2 = vC.destToVirtWidth(n38) + legendObj.getMarkersLabels().DOUBLE_MKR_MARGIN + n19;
                if (n2 > n4) {
                    n2 = n4;
                }
                n2 += legendObj.DOUBLE_BOX_MARGIN_W;
                if (bl6) {
                    n3 = n10 + legendObj.DOUBLE_BOX_MARGIN_HT;
                }
            }
        } else {
            int n41;
            int n42;
            if (n4 <= n19 + legendObj.getMarkersLabels().MKR_MARGIN) {
                legendObj.getMarkersLabels().setDrawLabels(false);
                n3 = n10 + legendObj.DOUBLE_BOX_MARGIN_HT;
                int n43 = n4 + legendObj.DOUBLE_BOX_MARGIN_W;
                this.setRectangles(n, rectangle5, rectangle4, n5, bl5, identObj, perspective, n43, n3, bl6);
                return;
            }
            if (n10 <= 0) {
                n42 = 1;
            } else {
                n42 = n3 / n10;
                if (n3 % n10 != 0) {
                    ++n42;
                }
            }
            int n44 = n12 / n42;
            int n45 = n22 * n44 + (n44 - 1) * n6;
            if (n45 + n22 + n6 < n10) {
                n45 = n45 + n22 + n6;
                ++n44;
            }
            if (n44 == 0) {
                n42 = 1;
            } else {
                n42 = n11 / n44;
                if (n11 % n44 != 0) {
                    ++n42;
                }
            }
            perspective.putToLookNoCalc(new IdentObj(2000), Attr.LegendMarkersPerRow, new Integer(n42), !this.m_reset);
            if (this.m_reset) {
                this.m_graph.getLegendArea().setPropertyOverrideFlags(10);
            }
            if ((n41 = n4 / n42) < n19 + legendObj.getMarkersLabels().MKR_MARGIN) {
                this.logAllMarkersError();
                n42 = n4 / (n19 + legendObj.getMarkersLabels().MKR_MARGIN);
                perspective.putToLookNoCalc(new IdentObj(2000), Attr.LegendMarkersPerRow, new Integer(n42), !this.m_reset);
                perspective.putToLookNoCalc(new IdentObj(2000), Attr.LegendSeriesCount, new Integer(n42 * n44), !this.m_reset);
                legendObj.getMarkersLabels().setDrawLabels(false);
                n2 = n42 * (n19 + legendObj.getMarkersLabels().MKR_MARGIN);
            } else {
                int n46 = 0;
                int n47 = 0;
                while (n47 < n11) {
                    int n48;
                    if (stringArray2[n47] != null && (n48 = fontMetrics.stringWidth(stringArray2[n47])) > n46) {
                        n46 = n48;
                    }
                    ++n47;
                }
                n47 = n19 + legendObj.getMarkersLabels().DOUBLE_MKR_MARGIN + vC.destToVirtWidth(n46);
                n2 = n47 * n42;
                if (n2 > n4) {
                    n2 = n4;
                }
            }
            n2 += legendObj.DOUBLE_BOX_MARGIN_W;
            n3 = n45 + legendObj.DOUBLE_BOX_MARGIN_HT;
            if (bl6) {
                n3 = n10 + legendObj.DOUBLE_BOX_MARGIN_HT;
            }
        }
        this.setRectangles(n, rectangle5, rectangle4, n5, bl5, identObj, perspective, n2, n3, bl6);
    }

    private String getDrillText(Perspective perspective) {
        IdentObj identObj = new IdentObj(235);
        if (!perspective.getDrillCallback().isDrillingEnabled() || perspective.getTextString(identObj) == null || !perspective.getDisplay(identObj)) {
            return null;
        }
        String string = perspective.getTextString(identObj);
        return string;
    }

    private String[] getReferenceLineLabels(Perspective perspective) {
        int n;
        boolean bl = perspective.isX1AxisPresent();
        boolean bl2 = perspective.isY1AxisPresent() && (perspective.isChartBLAType() || perspective.isChartScatter() || perspective.isChartCircular() || perspective.getJGraphType().isBubble());
        boolean bl3 = perspective.isY2AxisPresent();
        boolean bl4 = false;
        Vector<String> vector = new Vector<String>();
        boolean bl5 = false;
        Vector vector2 = perspective.getReferenceLineVector();
        if (vector2 != null && !vector2.isEmpty()) {
            int n2 = vector2.size();
            n = 0;
            while (n < n2) {
                ReferenceLineObj referenceLineObj = (ReferenceLineObj)vector2.elementAt(n);
                if (perspective.getDisplay(perspective.getReferenceLine(referenceLineObj.getIdentObj(), referenceLineObj.getIndex())) && perspective.getDisplay(perspective.getReferenceLineLegendText(referenceLineObj.getIdentObj(), referenceLineObj.getIndex()))) {
                    switch (referenceLineObj.getAxisID()) {
                        case 2004: {
                            if (!bl2) break;
                            bl4 = true;
                            break;
                        }
                        case 2005: {
                            if (!bl3) break;
                            bl4 = true;
                            break;
                        }
                        case 2003: {
                            if (!bl) break;
                            bl4 = true;
                            break;
                        }
                        default: {
                            bl4 = false;
                        }
                    }
                    if (bl4) {
                        vector.addElement(perspective.getTextString(perspective.getReferenceLine(referenceLineObj.getIdentObj(), referenceLineObj.getIndex())));
                    }
                    bl4 = false;
                }
                ++n;
            }
        }
        String[] stringArray = new String[vector.size()];
        n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)vector.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    private void setRectangles(int n, Rectangle rectangle, Rectangle rectangle2, int n2, boolean bl, IdentObj identObj, Perspective perspective, int n3, int n4, boolean bl2) {
        if (n == 2) {
            if (bl2) {
                rectangle.x = 16000 - n3 - perspective.getVC().destToVirtWidth(1);
                rectangle.width = n3;
                rectangle.height = n4 - perspective.getVC().destToVirtHeight(1);
            } else {
                rectangle.x = 16000 - this.m_graphMarginH - n3;
                rectangle.width = n3;
                rectangle.height = n4;
            }
            perspective.putToLookNoCalc(perspective.getLegendArea(), Attr.LegendAreaRect, rectangle, !this.m_reset);
        } else {
            if (bl2) {
                rectangle.x = -16000;
                rectangle.height = n4 - perspective.getVC().destToVirtHeight(1);
            } else {
                rectangle.x = -16000 + this.m_graphMarginH;
                rectangle.height = n4;
            }
            rectangle.width = n3;
            perspective.putToLookNoCalc(perspective.getLegendArea(), Attr.LegendAreaRect, rectangle, !this.m_reset);
        }
    }

    public void maximizePlotArea(LegendObj legendObj, Perspective perspective) {
        int n;
        Attr attr;
        IdentObj identObj;
        boolean bl = this.m_graph.getLegendArea().isAlongGraphEdge();
        int n2 = this.m_graph.getLegendArea().getAutomaticPosition();
        Rectangle rectangle = null;
        Rectangle rectangle2 = null;
        Rectangle rectangle3 = null;
        boolean bl2 = perspective.getTitleDisplay();
        boolean bl3 = perspective.getSubtitleDisplay();
        boolean bl4 = perspective.getFootnoteDisplay();
        int n3 = this.m_graph.getGraphType();
        boolean bl5 = this._isPieFrame(n3);
        if (bl5) {
            identObj = perspective.getPieFrame();
            attr = Attr.PieFrameRect;
        } else {
            identObj = perspective.getFrame();
            attr = Attr.FrameRect;
        }
        Rectangle rectangle4 = (Rectangle)perspective.getRect(identObj).clone();
        Rectangle rectangle5 = (Rectangle)perspective.getRect(perspective.getLegendArea()).clone();
        if (bl2) {
            rectangle = (Rectangle)perspective.getRect(perspective.getTitle()).clone();
        }
        if (bl3) {
            rectangle2 = (Rectangle)perspective.getRect(perspective.getSubtitle()).clone();
        }
        if (bl4) {
            rectangle3 = (Rectangle)perspective.getRect(perspective.getFootnote()).clone();
        }
        int n4 = rectangle4.y + rectangle4.height;
        int n5 = 16000;
        boolean bl6 = this._isLegendDisplayed();
        if (bl6) {
            legendObj.adjustForDataScroller(rectangle5);
            legendObj.adjustForLegendScroller(rectangle5);
        }
        if (bl6 && n2 == 0 && !bl) {
            n5 = rectangle5.y;
            n = this.m_graphLegendGapV;
        } else {
            n = this.m_graphMarginV;
            if (bl6 && n2 == 0 && bl) {
                n5 = rectangle5.y;
            }
            if (rectangle != null) {
                n5 = rectangle.y;
            }
            if (rectangle2 != null) {
                n5 = rectangle2.y;
            }
        }
        int n6 = -16000;
        if (bl6 && n2 == 1 && !bl) {
            n6 = rectangle5.y + rectangle5.height;
            n = this.m_graphLegendGapV;
        } else {
            n = this.m_graphMarginV;
            if (bl6 && n2 == 1 && bl) {
                n6 = rectangle5.y + rectangle5.height;
            }
            if (rectangle3 != null) {
                n6 = rectangle3.y + rectangle3.height;
            }
        }
        rectangle4.y = n6 + n;
        rectangle4.height = n5 - n6 - 2 * n;
        Point point = BILabelLayout.adjustFrameFor3D(perspective, rectangle4);
        int n7 = rectangle4.y;
        rectangle4.y += rectangle4.y - point.y;
        rectangle4.height -= Math.abs(n7 - point.y);
        int n8 = bl6 && n2 == 3 ? rectangle4.x - (rectangle5.x + this.m_graphLegendGapH + (rectangle4.x - point.x) + rectangle5.width) : rectangle4.x - (-16000 + this.m_graphMarginH + (rectangle4.x - point.x));
        rectangle4.width += n8;
        rectangle4.x -= n8;
        int n9 = rectangle4.x + rectangle4.width;
        n8 = bl6 && n2 == 2 ? rectangle5.x - this.m_graphLegendGapH - n9 : 16000 - this.m_graphMarginH - n9;
        rectangle4.width += n8;
        if (bl5 && BILabelLayout.getDrillLabel(perspective) != null) {
            int n10 = BILabelLayout.getAxisTitleHeight(perspective.getGraphicsContext(), perspective, perspective.getO1DrillLabel(), false);
            rectangle4.y += n10;
            rectangle4.height -= n10;
        }
        if ((n3 == 35 || n3 == 23 || n3 == 47) && this.m_graph.getMarkerText().isVisible() && this.m_graph.getMarkerText().getMarkerTextPlace() == 1) {
            Font font = this.m_graph.getMarkerText().getFont();
            FontMetrics fontMetrics = perspective.getGraphicsContext().getFontMetrics(font);
            int n11 = TextStyleObj.getFontHeight(fontMetrics);
            rectangle4.height -= perspective.getVC().destToVirtHeight(n11);
        }
        perspective.putToLookNoCalc(identObj, attr, rectangle4, !this.m_reset);
        if (this.m_reset) {
            if (bl5) {
                this.m_graph.getPieFrame().setPropertyOverrideFlags(4);
            } else {
                this.m_graph.getPlotArea().setPropertyOverrideFlags(4);
            }
        }
        if (bl6 && n2 == 2) {
            rectangle5.y = !bl ? rectangle4.y + (rectangle4.height - rectangle5.height) : -16000 + perspective.getVC().destToVirtHeight(1);
            perspective.putToLookNoCalc(perspective.getLegendArea(), Attr.LegendAreaRect, rectangle5, !this.m_reset);
        } else if (bl6 && n2 == 3) {
            rectangle5.y = !bl ? rectangle4.y + (rectangle4.height - rectangle5.height) : -16000 + perspective.getVC().destToVirtHeight(1);
            perspective.putToLookNoCalc(perspective.getLegendArea(), Attr.LegendAreaRect, rectangle5, !this.m_reset);
        }
    }

    public void centerLegend(Perspective perspective, LegendObj legendObj) {
        if (!this._isLegendDisplayed()) {
            return;
        }
        Rectangle rectangle = null;
        Rectangle rectangle2 = null;
        Rectangle rectangle3 = null;
        boolean bl = perspective.getTitleDisplay();
        boolean bl2 = perspective.getSubtitleDisplay();
        boolean bl3 = perspective.getFootnoteDisplay();
        if (bl) {
            rectangle = (Rectangle)perspective.getRect(perspective.getTitle()).clone();
        }
        if (bl2) {
            rectangle2 = (Rectangle)perspective.getRect(perspective.getSubtitle()).clone();
        }
        if (bl3) {
            rectangle3 = (Rectangle)perspective.getRect(perspective.getFootnote()).clone();
        }
        int n = this.m_graph.getLegendArea().getAutomaticPosition();
        boolean bl4 = this.m_graph.getLegendArea().isAlongGraphEdge();
        IdentObj identObj = this._isPieFrame(perspective.getGraphType()) ? perspective.getPieFrame() : perspective.getFrame();
        Rectangle rectangle4 = (Rectangle)perspective.getRect(identObj).clone();
        Rectangle rectangle5 = (Rectangle)perspective.getRect(perspective.getLegendArea()).clone();
        if (!(bl4 || n != 2 && n != 3)) {
            if (rectangle5.height < rectangle4.height) {
                int n2 = rectangle4.height / 2 + rectangle4.y;
                rectangle5.y = n2 - rectangle5.height / 2;
            } else if (rectangle5.height > rectangle4.height + rectangle4.y - this.m_maxBottomY) {
                rectangle5.y = this.m_maxBottomY == -16000 ? this.m_maxBottomY + perspective.getVC().destToVirtHeight(1) : this.m_maxBottomY;
            }
        }
        if (!(bl4 || n != 0 && n != 1)) {
            rectangle5.x = -(rectangle5.width / 2);
        }
        perspective.putToLookNoCalc(perspective.getLegendArea(), Attr.LegendAreaRect, rectangle5, !this.m_reset);
    }

    private void setLegendProps(Perspective perspective) {
        perspective.putToLookNoCalc(perspective.getLegendText(), Attr.Autofit, new Boolean(false), !this.m_reset);
        IdentObj identObj = new IdentObj(2000);
        perspective.putToLookNoCalc(identObj, Attr.LegendAutomatic, new Boolean(false), !this.m_reset);
        perspective.putToLookNoCalc(identObj, Attr.LegendMarkerPosition, new Integer(0), !this.m_reset);
        perspective.putToLookNoCalc(new IdentObj(2000), Attr.LegendMarkersPerRow, new Integer(0), !this.m_reset);
    }

    private static int getPFJFontHeight(FontMetrics fontMetrics) {
        return TextStyleObj.getFontHeight(fontMetrics);
    }

    private static IdentObj getO1AxisTitle(Perspective perspective) {
        IdentObj identObj = BILabelLayout.getDrillLabel(perspective);
        if (identObj != null) {
            return identObj;
        }
        return perspective.getO1Title();
    }

    private static IdentObj getDrillLabel(Perspective perspective) {
        IdentObj identObj = perspective.getO1DrillLabel();
        if (perspective.getDrillCallback().isDrillingEnabled() && perspective.getTextString(identObj) != null && perspective.getDisplay(identObj)) {
            return identObj;
        }
        return null;
    }

    private static class _PropertyContext {
        String[] m_O1Labels;

        _PropertyContext() {
        }
    }
}

