/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView.datacache;

import java.sql.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.dss.dataView.datacache.Map;
import oracle.dss.util.ColumnOutOfRangeException;
import oracle.dss.util.DataAccess;
import oracle.dss.util.RowOutOfRangeException;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class Data {
    protected Dictionary m_dataDict;
    protected Map m_map;
    protected int m_rows;
    protected int m_cols;
    protected static final String CELL = "Cell";
    protected static final String DATA = "Data";
    protected static final String DATAMAP = "DataMap";
    protected static final String DATATYPE = "dtype";
    protected static final String DATE = "date";
    protected static final String DOUBLE = "double";
    protected static final String LONG = "long";
    protected static final String STRING = "str";

    Data(Map map, int n, int n2) {
        this.m_map = map;
        this.m_rows = n;
        this.m_cols = n2;
        this.m_dataDict = new Hashtable();
        Enumeration enumeration = this.m_map.getSupportedMap().types();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.m_dataDict.put(string, new Object[n][n2]);
        }
    }

    public Map getMap() {
        return this.m_map;
    }

    public Object getValue(int n, int n2, String string) throws ColumnOutOfRangeException, RowOutOfRangeException {
        Object[][] objectArray = this.getData(string);
        if (objectArray == null) {
            return null;
        }
        int n3 = objectArray.length;
        if (n >= n3) {
            throw new RowOutOfRangeException(n, n3 - 1);
        }
        int n4 = objectArray[n].length;
        if (n2 >= n4) {
            throw new ColumnOutOfRangeException(n2, n4 - 1);
        }
        return objectArray[n][n2];
    }

    public void setValue(Object object, int n, int n2, String string) throws ColumnOutOfRangeException, RowOutOfRangeException {
        Object[][] objectArray = this.getData(string);
        if (objectArray == null) {
            return;
        }
        int n3 = objectArray.length;
        if (n >= n3) {
            throw new RowOutOfRangeException(n, n3 - 1);
        }
        int n4 = objectArray[n].length;
        if (n2 >= n4) {
            throw new ColumnOutOfRangeException(n2, n4 - 1);
        }
        objectArray[n][n2] = object;
    }

    public void readDataFromXML(ContainerNode containerNode, int n) {
        String string = DOUBLE;
        PropertyNode propertyNode = containerNode.getProperty(DATATYPE);
        if (propertyNode != null) {
            string = propertyNode.getValueAsString();
        }
        Enumeration enumeration = containerNode.getContainedObject(CELL);
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            String string2 = string;
            ObjectNode objectNode = (ObjectNode)enumeration.nextElement();
            propertyNode = objectNode.getProperty(DATATYPE);
            if (propertyNode != null) {
                string2 = propertyNode.getValueAsString();
            }
            Enumeration enumeration2 = this.m_map.types();
            while (enumeration2.hasMoreElements()) {
                String string3 = (String)enumeration2.nextElement();
                Object[][] objectArray = this.getData(string3);
                Object object = this.m_map.readDataFromXML(objectNode, string3);
                if (object == null || objectArray == null || n2 >= objectArray.length || n >= objectArray[n2].length) continue;
                Object object2 = object;
                if (string3.equals("dataUnformatted")) {
                    String string4 = object.toString();
                    if (string2.equals(DOUBLE)) {
                        object2 = Double.valueOf(string4);
                    } else if (string2.equals(LONG)) {
                        object2 = Long.valueOf(string4);
                    } else if (string2.equals(DATE)) {
                        object2 = Date.valueOf(string4);
                    }
                } else if (string3.equals("dataGroupSort")) {
                    object2 = Integer.valueOf(object.toString());
                } else if (string3.equals("dataIsTotal")) {
                    object2 = Boolean.valueOf(object.toString());
                }
                objectArray[n2][n] = object2;
            }
            ++n2;
        }
    }

    public void addDataToXML(ContainerNode containerNode, int n) {
        int n2;
        String string = null;
        if (this.m_map.getSupportedMap().contains("dataUnformatted")) {
            n2 = 0;
            while (n2 < this.m_rows) {
                try {
                    string = Data.getDataType(this.getValue(n2, n, "dataUnformatted"));
                }
                catch (RowOutOfRangeException rowOutOfRangeException) {
                }
                catch (ColumnOutOfRangeException columnOutOfRangeException) {
                    // empty catch block
                }
                if (string != null) break;
                ++n2;
            }
        }
        if (string != null && string != DOUBLE) {
            containerNode.addProperty(DATATYPE, string);
        }
        n2 = 0;
        while (n2 < this.m_rows) {
            ObjectNode objectNode = new ObjectNode(CELL);
            Enumeration enumeration = this.m_map.types();
            while (enumeration.hasMoreElements()) {
                String string2;
                String string3 = (String)enumeration.nextElement();
                Object object = null;
                try {
                    object = this.getValue(n2, n, string3);
                }
                catch (RowOutOfRangeException rowOutOfRangeException) {
                }
                catch (ColumnOutOfRangeException columnOutOfRangeException) {
                    // empty catch block
                }
                if (object != null && string3.equals("dataUnformatted") && string != (string2 = Data.getDataType(object))) {
                    objectNode.addProperty(DATATYPE, string2);
                }
                this.m_map.addDataToXML(objectNode, string3, object);
            }
            containerNode.addContainedObject(objectNode);
            ++n2;
        }
    }

    public void initializeDataSource(DataAccess dataAccess) {
        Enumeration enumeration = this.m_map.types();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object[][] objectArray = this.getData(string);
            int n = 0;
            while (n < this.m_rows) {
                int n2 = 0;
                while (n2 < this.m_cols) {
                    try {
                        objectArray[n][n2] = dataAccess.getValue(n, n2, string);
                    }
                    catch (RowOutOfRangeException rowOutOfRangeException) {
                    }
                    catch (ColumnOutOfRangeException columnOutOfRangeException) {
                        // empty catch block
                    }
                    ++n2;
                }
                ++n;
            }
        }
    }

    private static String getDataType(Object object) {
        String string = null;
        if (object == null) {
            return null;
        }
        string = object instanceof Double || object instanceof Float ? DOUBLE : (object instanceof Integer || object instanceof Long || object instanceof Short ? LONG : (object instanceof Date ? DATE : STRING));
        return string;
    }

    private Object[][] getData(String string) {
        return (Object[][])this.m_dataDict.get(string);
    }
}

