/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.dataView;

import java.awt.Color;
import java.awt.Font;
import oracle.dss.dataView.BaseTitleAttributes;
import oracle.dss.dataView.DataviewDefaultValues;
import oracle.dss.dataView.DataviewUtils;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class BaseTitleXML {
    public static String a_visible = "visible";
    public static String a_text = "text";
    public static String a_horzAlign = "horzAlign";
    protected boolean d_visible = DataviewDefaultValues.isBaseTitleVisible();
    protected String d_text = DataviewDefaultValues.getBaseTitleText();
    protected boolean d_underline = DataviewDefaultValues.isBaseTitleUnderline();
    protected boolean d_fontBold = DataviewDefaultValues.isBaseTitleFontBold();
    protected boolean d_fontItalic = DataviewDefaultValues.isBaseTitleFontItalic();
    protected String d_fontName = DataviewDefaultValues.getBaseTitleFontName();
    protected int d_fontSize;
    protected int d_horzAlign = DataviewDefaultValues.getBaseTitleHorzAlign();
    protected Color d_background = DataviewDefaultValues.getBaseTitleBackground();
    protected Color d_foreground = DataviewDefaultValues.getBaseTitleForeground();
    protected BaseTitleAttributes _baseTitle;
    protected String _version;

    public BaseTitleXML(BaseTitleAttributes baseTitleAttributes, String string) {
        this._baseTitle = baseTitleAttributes;
        this._version = string;
    }

    public void setXML(ObjectNode objectNode, String string, int n) {
        PropertyNode propertyNode = objectNode.getProperty(a_text);
        if (propertyNode != null) {
            this._baseTitle.setText(propertyNode.getValueAsString());
        }
        if ((propertyNode = objectNode.getProperty(a_visible)) != null) {
            this._baseTitle.setVisible(propertyNode.getValueAsBoolean());
        } else {
            this._baseTitle.setVisible(this.d_visible);
        }
        this.setStyleXML(objectNode);
    }

    public void setStyleXML(ObjectNode objectNode) {
        String string;
        PropertyNode propertyNode = objectNode.getProperty("fontName");
        if (propertyNode != null) {
            string = propertyNode.getValueAsString();
            this._baseTitle.setStyleProperty(0, string);
        }
        if ((propertyNode = objectNode.getProperty("fontSize")) != null) {
            string = propertyNode.getValueAsString();
            this._baseTitle.setStyleProperty(1, string);
        }
        if ((propertyNode = objectNode.getProperty("fontBold")) != null) {
            string = propertyNode.getValueAsString();
            this._baseTitle.setStyleProperty(2, string);
        }
        if ((propertyNode = objectNode.getProperty("fontItalic")) != null) {
            string = propertyNode.getValueAsString();
            this._baseTitle.setStyleProperty(3, string);
        }
        if ((propertyNode = objectNode.getProperty(a_horzAlign)) != null) {
            String string2 = propertyNode.getValueAsString();
            if (string2.equals("LEFT")) {
                this._baseTitle.setHorizontalAlignment(2);
            } else if (string2.equals("CENTER")) {
                this._baseTitle.setHorizontalAlignment(0);
            } else if (string2.equals("RIGHT")) {
                this._baseTitle.setHorizontalAlignment(4);
            } else if (string2.equals("LEADING")) {
                this._baseTitle.setHorizontalAlignment(10);
            }
        }
        if ((propertyNode = objectNode.getProperty("foreground")) != null) {
            this._baseTitle.setForeground(new Color(DataviewUtils.hexStringToInt(propertyNode.getValueAsString())));
        }
        if ((propertyNode = objectNode.getProperty("background")) != null) {
            this._baseTitle.setBackground(new Color(DataviewUtils.hexStringToInt(propertyNode.getValueAsString())));
        }
        if ((propertyNode = objectNode.getProperty("underline")) != null) {
            this._baseTitle.setUnderline(propertyNode.getValueAsBoolean());
        }
    }

    public ObjectNode getXML(boolean bl) {
        ObjectNode objectNode = new ObjectNode(this._baseTitle.getComponentName());
        boolean bl2 = this.getStyleXML(bl, objectNode);
        if (bl || !this.d_text.equals(this._baseTitle.getUnParseText())) {
            objectNode.addProperty(a_text, this._baseTitle.getUnParseText());
            bl2 = true;
        }
        if (bl || this.d_visible != this._baseTitle.isVisible()) {
            objectNode.addProperty(a_visible, this._baseTitle.isVisible());
            bl2 = true;
        }
        if (bl2) {
            return objectNode;
        }
        return null;
    }

    public ObjectNode getStyleXML(boolean bl) {
        ObjectNode objectNode = new ObjectNode(this._baseTitle.getComponentName());
        return this.getStyleXML(bl, objectNode) ? objectNode : null;
    }

    private boolean getStyleXML(boolean bl, ObjectNode objectNode) {
        boolean bl2 = false;
        if (bl || this._baseTitle.isUserOverrideFlag(0)) {
            objectNode.addProperty("fontName", this._baseTitle.getFont().getName());
            bl2 = true;
        }
        if (bl || this._baseTitle.isUserOverrideFlag(1)) {
            objectNode.addProperty("fontSize", this._baseTitle.getFont().getSize());
            bl2 = true;
        }
        if (bl || this._baseTitle.isUserOverrideFlag(2)) {
            objectNode.addProperty("fontBold", this._baseTitle.getFont().isBold());
            bl2 = true;
        }
        if (bl || this._baseTitle.isUserOverrideFlag(3)) {
            objectNode.addProperty("fontItalic", this._baseTitle.getFont().isItalic());
            bl2 = true;
        }
        if (bl || this._baseTitle.isUserOverrideFlag(7)) {
            int n = this._baseTitle.getHorizontalAlignment();
            if (n == 2) {
                objectNode.addProperty(a_horzAlign, "LEFT");
            } else if (n == 0) {
                objectNode.addProperty(a_horzAlign, "CENTER");
            } else if (n == 4) {
                objectNode.addProperty(a_horzAlign, "RIGHT");
            } else if (n == 10) {
                objectNode.addProperty(a_horzAlign, "LEADING");
            }
            bl2 = true;
        }
        if (bl || this._baseTitle.isUserOverrideFlag(4)) {
            objectNode.addProperty("foreground", DataviewUtils.toHexString(this._baseTitle.getForeground().getRGB()));
            bl2 = true;
        }
        if (bl || this._baseTitle.isUserOverrideFlag(5)) {
            objectNode.addProperty("background", DataviewUtils.toHexString(this._baseTitle.getBackground().getRGB()));
            bl2 = true;
        }
        if (bl || this._baseTitle.isUserOverrideFlag(6)) {
            objectNode.addProperty("underline", this._baseTitle.isUnderline());
            bl2 = true;
        }
        return bl2;
    }

    public void resetToDefault(int n) {
        this.resetToDefault(n, this._version);
    }

    protected void resetToDefault(int n, String string) {
        this._baseTitle.setText(this.d_text);
        this.resetStyle();
    }

    public void resetStyle() {
        this._baseTitle.setUnderline(this.d_underline);
        this._baseTitle.setBackground(this.d_background);
        this._baseTitle.setForeground(this.d_foreground);
        this._baseTitle.setFont(new Font(this.d_fontName, DataviewUtils.fontStyle(this.d_fontBold, this.d_fontItalic), this.d_fontSize));
        this._baseTitle.setHorizontalAlignment(this.d_horzAlign);
    }
}

