/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.groupv2;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.groupv2.ConnectionOwner;
import oracle.ias.cache.groupv2.GcommException;
import oracle.ias.cache.groupv2.SSLConfig;

class SSLManager {
    static final String LOGGER_NAME = "oracle.ias.cache.groupv2.SSLManager";
    private SSLConfig sslConf_;
    private SSLContext sslContext_;
    private KeyManagerFactory keyMgrFactory_;
    private TrustManagerFactory trustMgrFactory_;
    private KeyStore keyStore_;
    private ConnectionOwner parent_;
    private Logger logger_ = Logger.getLogger("oracle.ias.cache.groupv2.SSLManager");

    private SSLManager(ConnectionOwner connectionOwner) throws GroupException {
        this.parent_ = connectionOwner;
        this.sslConf_ = this.parent_.getConfig().getSSLConfig();
        String string = this.sslConf_.getProtocol();
        String string2 = this.sslConf_.getAlgorithm();
        String string3 = this.sslConf_.getKeyStoreType();
        String string4 = this.sslConf_.getKeyStorePassword();
        String string5 = this.sslConf_.getProviderName();
        if (this.logger_.isLoggable(Level.FINEST)) {
            this.logger_.log(Level.FINEST, "protocol=" + string + " algorithm=" + string2 + " keyStoreType=" + string3 + " keyStorePassword=" + string4);
        }
        InputStream inputStream = this.sslConf_.getKeyStoreInputStream();
        try {
            Security.addProvider((Provider)Class.forName(string5).newInstance());
        }
        catch (InstantiationException instantiationException) {
            throw new GcommException(GcommException.SSLPROVIDERINSTANTIATION + string5, (Throwable)instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new GcommException(GcommException.SSLPROVIDERINSTANTIATION + string5, (Throwable)illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new GcommException(GcommException.SSLPROVIDERCLASSNOTFOUND + string5, (Throwable)classNotFoundException);
        }
        catch (ClassCastException classCastException) {
            throw new GcommException(GcommException.SSLPROVIDERCLASSCAST, (Throwable)classCastException);
        }
        char[] cArray = string4.toCharArray();
        try {
            this.sslContext_ = SSLContext.getInstance(string);
            this.keyMgrFactory_ = KeyManagerFactory.getInstance(string2);
            this.trustMgrFactory_ = TrustManagerFactory.getInstance(string2);
            this.keyStore_ = KeyStore.getInstance(string3);
            this.keyStore_.load(inputStream, cArray);
            this.keyMgrFactory_.init(this.keyStore_, cArray);
            this.trustMgrFactory_.init(this.keyStore_);
            this.sslContext_.init(this.keyMgrFactory_.getKeyManagers(), this.trustMgrFactory_.getTrustManagers(), null);
            if (this.logger_.isLoggable(Level.FINEST)) {
                this.logger_.log(Level.FINEST, "close keystore stream");
            }
            inputStream.close();
        }
        catch (Exception exception) {
            throw new GcommException(GcommException.SSLINIT, (Throwable)exception);
        }
    }

    static SSLManager getInstance(ConnectionOwner connectionOwner) throws GroupException {
        return new SSLManager(connectionOwner);
    }

    private SSLServerSocketFactory getServerSocketFactory() {
        SSLServerSocketFactory sSLServerSocketFactory;
        if (this.sslContext_ != null) {
            sSLServerSocketFactory = this.sslContext_.getServerSocketFactory();
            if (this.logger_.isLoggable(Level.FINEST)) {
                this.logger_.log(Level.FINEST, "Got secure ServerSocketFactory");
            }
        } else {
            sSLServerSocketFactory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
            if (this.logger_.isLoggable(Level.FINEST)) {
                this.logger_.log(Level.FINEST, "Got default secure ServerSocketFactory");
            }
        }
        return sSLServerSocketFactory;
    }

    ServerSocket createSSLServerSocket(int n, int n2) throws IOException {
        return this.createSSLServerSocket(n, n2, null);
    }

    ServerSocket createSSLServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        if (this.logger_.isLoggable(Level.FINEST)) {
            this.logger_.log(Level.FINEST, "Create Secure Server Socket");
        }
        SSLServerSocketFactory sSLServerSocketFactory = this.getServerSocketFactory();
        ServerSocket serverSocket = null;
        serverSocket = inetAddress == null ? sSLServerSocketFactory.createServerSocket(n, n2) : sSLServerSocketFactory.createServerSocket(n, n2, inetAddress);
        if (serverSocket == null) {
            throw new IOException(GcommException.SSLSOCKET);
        }
        if (this.sslConf_.getClientAuth()) {
            ((SSLServerSocket)serverSocket).setNeedClientAuth(true);
        }
        return serverSocket;
    }

    private SSLSocketFactory getSocketFactory() {
        SSLSocketFactory sSLSocketFactory;
        if (this.sslContext_ != null) {
            sSLSocketFactory = this.sslContext_.getSocketFactory();
            if (this.logger_.isLoggable(Level.FINEST)) {
                this.logger_.log(Level.FINEST, "Got secure SocketFactory");
            }
        } else {
            sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            if (this.logger_.isLoggable(Level.FINEST)) {
                this.logger_.log(Level.FINEST, "Got default secure SocketFactory");
            }
        }
        return sSLSocketFactory;
    }

    Socket createSSLSocket() throws IOException {
        Socket socket = null;
        SSLSocketFactory sSLSocketFactory = this.getSocketFactory();
        if (sSLSocketFactory != null) {
            socket = sSLSocketFactory.createSocket();
            if (this.logger_.isLoggable(Level.FINEST)) {
                this.logger_.log(Level.FINEST, "created secure Socket");
            }
        } else if (this.logger_.isLoggable(Level.FINEST)) {
            this.logger_.log(Level.FINEST, "no SSLSocketFactory!");
        }
        if (socket == null) {
            throw new IOException(GcommException.SSLSOCKET);
        }
        return socket;
    }
}

