/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.groupv2;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.rmi.server.UID;
import java.util.Arrays;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.groupv2.Address;
import oracle.ias.cache.groupv2.GcommException;
import oracle.ias.cache.groupv2.GcommSerializable;
import oracle.ias.cache.groupv2.Packet;

public class MemberID
extends GcommSerializable
implements Comparable,
Serializable {
    public static final char FIELD_SEPARATOR = ':';
    static final int RAW_ID_LENGTH = 8;
    private byte[] rawData_;
    private String strData_;

    public static MemberID generate(int n) throws GroupException {
        return new MemberID(n);
    }

    public static MemberID parse(byte[] byArray) {
        return new MemberID(byArray);
    }

    public static MemberID parse(String string) {
        return new MemberID(string);
    }

    private MemberID(int n) throws GroupException {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(n);
            stringBuffer.append(':');
            stringBuffer.append(Address.getLocalPrimaryHostIP());
            UID uID = new UID();
            stringBuffer.append(':');
            stringBuffer.append(uID.toString());
            this.strData_ = stringBuffer.toString().toUpperCase().trim();
            this.rawData_ = new byte[Packet.FIELD_LENGTH[8]];
            byte[] byArray = this.strData_.getBytes("UTF-8");
            System.arraycopy(byArray, 0, this.rawData_, 0, byArray.length);
        }
        catch (IOException iOException) {
            throw new GcommException(GcommException.IDGENERATION, (Throwable)iOException);
        }
    }

    private MemberID(byte[] byArray) {
        this.rawData_ = byArray;
        try {
            int n = MemberID.search(byArray, (byte)0);
            this.strData_ = n > 0 ? new String(this.rawData_, 0, n, "UTF-8") : null;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private MemberID(String string) {
        this.strData_ = string;
        try {
            this.rawData_ = new byte[Packet.FIELD_LENGTH[8]];
            byte[] byArray = this.strData_.getBytes("UTF-8");
            System.arraycopy(byArray, 0, this.rawData_, 0, byArray.length);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof MemberID) {
            try {
                bl = Arrays.equals(this.rawData_, ((MemberID)object).toBytes());
            }
            catch (GroupException groupException) {
                bl = false;
            }
        } else {
            bl = object instanceof byte[] ? Arrays.equals(this.rawData_, (byte[])object) : super.equals(object);
        }
        return bl;
    }

    public byte[] toBytes() throws GroupException {
        return this.rawData_;
    }

    public String toString() {
        return this.strData_;
    }

    public int compareTo(Object object) {
        MemberID memberID = (MemberID)object;
        int n = this.toString().compareTo(memberID.toString());
        return n;
    }

    static int search(byte[] byArray, byte by) {
        int n = 0;
        for (n = 0; n < byArray.length && byArray[n] != by; ++n) {
        }
        if (n >= byArray.length) {
            n = -1;
        }
        return n;
    }
}

