/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.groupv2;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Vector;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import oracle.ias.cache.commx.GroupCommunication;
import oracle.ias.cache.commx.GroupConfig;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.groupv2.Address;
import oracle.ias.cache.groupv2.SSLConfig;

public class Configuration
implements GroupConfig {
    public static final String GROUP_PROVIDER = "oracle.ias.cache.groupv2.GrpCommunication";
    public static final int DEFAULT_BACKLOG = 50;
    public static final Level DEFAULT_LOG_LEVEL = Level.WARNING;
    public static final String DEFAULT_DISTTRIBUTOR_HOST = "localhost";
    public static final int DEFAULT_CLIENT_PORT = 20030;
    public static final int DEFAULT_DISTRIBUTOR_PORT = 20031;
    public static final boolean DEFAULT_SSL_ENABLE = false;
    public static final boolean USE_MULTICAST_RESOLUTION = false;
    public static final String DEFAULT_MULTICAST_ADDRESS = "228.6.8.9";
    public static final int DEFAULT_MULTICAST_PORT = 20031;
    public static final int DEFAULT_MULTICAST_TTL = 0;
    public static final int DEFAULT_CONNECT_TIMEOUT = 60000;
    public static final long DEFAULT_INIT_TIMEOUT = 240000L;
    public static final int DEFAULT_REGISTRATION_TIMEOUT = 300000;
    public static final long DEFAULT_DISCONNECT_TIMEOUT = 2000L;
    public static final long DEFAULT_ACK_TIMEOUT = 600000L;
    public static final long DEFAULT_VIEW_CHANGE_PAUSE = 1000L;
    public static final long DEFAULT_VIEW_MONITOR_PAUSE = 60000L;
    public static final int DEFAULT_MAX_SEND_RETRY = 3;
    public static final int SENDER_THREADS = 3;
    public static final boolean DEDICATED_COORIDNATOR = false;
    public static final boolean ROUTER = false;
    public static final String DEFAULT_LOG_FILE = "gcomm.log";
    public static final boolean DEFAULT_SELFTUNNING = true;
    public static final int DEFAULT_RESOLUTION_INTERVAL = 300;
    public static final long DEFAULT_RESOLUTION_TIMEOUT = 2000L;
    public static final int DEFAULT_MAX_CONNECT_RETRY = 5;
    public static final int DEFAULT_CONNECT_RETRY_DELAY = 100;
    public static final int MAX_INIT_RETRY = 10;
    public static final int MAX_INIT_RETRY_DELAY = 2000;
    public static final String DEFAULT_VERSION = "10.1.3.0.0";
    private Logger logger_;
    private int maxSystemInitRetry_ = 10;
    private int backlog_ = 50;
    private int maxInitRetyDelay_ = 2000;
    private Vector discoverAddresses_;
    private Vector listenerAddresses_;
    private Address distributorAddress_;
    private String distributorHostName_ = "localhost";
    private int clientPort_ = 20030;
    private int distributorPort_ = 20031;
    private int connectTimeout_ = 60000;
    private long initTimeout_ = 240000L;
    private long disconnectTimeout_ = 2000L;
    private long ackTimeout_ = 600000L;
    private long viewChangePause_ = 1000L;
    private int maxSenderThreads_ = 3;
    private int registrationTimeout_ = 300000;
    private long viewMonitorPause_ = 60000L;
    private boolean useMulticastResolution_ = false;
    private long resolutionInterval_ = 300L;
    private long resolutionTimeout_ = 2000L;
    private String multicastAddress_ = "228.6.8.9";
    private int multicastPort_ = 20031;
    private int multicastTtl_ = 0;
    private int connectRetry_ = 5;
    private int connectRetryDelay_ = 100;
    private boolean selfTunning_ = true;
    private boolean dedicatedCoordinator_ = false;
    private boolean router_ = false;
    private String tmpPath_ = null;
    private boolean useSSL_ = false;
    private String sslConfigFile_ = null;
    private SSLConfig sslConfig_ = null;
    private String version_ = null;
    private Serializable diskUid_;
    private String name_;
    private String localBindingAddressStr_;
    private int maxSendRetry_ = 3;

    public static Configuration getDefaultConfiguration() {
        return Configuration.getDefaultConfiguration(false);
    }

    public static Configuration getDefaultConfiguration(boolean bl) {
        Configuration configuration = new Configuration();
        if (bl) {
            Logger logger = Logger.getLogger(DEFAULT_LOG_FILE);
            try {
                logger.setUseParentHandlers(false);
                FileHandler fileHandler = new FileHandler(DEFAULT_LOG_FILE, true);
                fileHandler.setFormatter(new SimpleFormatter());
                logger.addHandler(fileHandler);
                logger.setLevel(DEFAULT_LOG_LEVEL);
                configuration.setLogger(logger);
            }
            catch (IOException iOException) {
                logger.setUseParentHandlers(true);
            }
        }
        return configuration;
    }

    public void setLogger(Logger logger) {
        this.logger_ = logger;
    }

    public void addADiscoverAddress(Address address) {
        if (this.discoverAddresses_ == null) {
            this.discoverAddresses_ = new Vector();
        }
        this.discoverAddresses_.addElement(address);
    }

    public void addAListenerAddress(Address address) {
        if (this.listenerAddresses_ == null) {
            this.listenerAddresses_ = new Vector();
        }
        this.listenerAddresses_.addElement(address);
    }

    public void setDistributorAddress(Address address) {
        this.distributorAddress_ = address;
    }

    public void setDiscoverList(Vector vector) {
        this.discoverAddresses_ = vector;
    }

    public void setListenerList(Vector vector) {
        this.listenerAddresses_ = vector;
    }

    public void setPortForDistributors(int n) {
        this.distributorPort_ = n;
    }

    public void setPortForClients(int n) {
        this.clientPort_ = n;
    }

    public void setBacklog(int n) {
        this.backlog_ = n;
    }

    public void setDisconnectTimeout(long l) {
        this.disconnectTimeout_ = l;
    }

    public void setAckTimeout(long l) {
        this.ackTimeout_ = l;
    }

    public void setRegistrationTimeout(int n) {
        this.registrationTimeout_ = n;
    }

    public void setViewMonitorPause(int n) {
        this.viewMonitorPause_ = n;
    }

    public void sseMulticastResolution(boolean bl) {
        this.useMulticastResolution_ = bl;
    }

    public void setResolutionInterval(long l) {
        this.resolutionInterval_ = l;
    }

    public void setResolutionTimeout(long l) {
        this.resolutionTimeout_ = l;
    }

    public void setMulticastAddress(String string) {
        this.multicastAddress_ = string;
    }

    public void setMulticastPort(int n) {
        this.multicastPort_ = n;
    }

    public void setMulticastTtl(int n) {
        this.multicastTtl_ = n;
    }

    public void setConnectRetry(int n) {
        this.connectRetry_ = n;
    }

    public void setConnectRetryDelay(int n) {
        this.connectRetryDelay_ = n;
    }

    public void setDedicatedCoordinator(boolean bl) {
        this.dedicatedCoordinator_ = bl;
    }

    public void setRouter(boolean bl) {
        this.router_ = bl;
    }

    public void enableSSL(boolean bl, String string) throws GroupException {
        this.useSSL_ = bl;
        this.sslConfigFile_ = string;
        if (this.useSSL_) {
            this.sslConfig_ = new SSLConfig(this.sslConfigFile_);
        } else {
            this.sslConfig_ = null;
            this.sslConfigFile_ = null;
        }
    }

    public void setMaxSendRetry(int n) {
        this.maxSendRetry_ = n;
    }

    public int getConnectTimeout() {
        return this.connectTimeout_;
    }

    public int getPortForDistributors() {
        return this.distributorPort_;
    }

    public int getPortForClients() {
        return this.clientPort_;
    }

    public String getDistributorHostName() {
        return this.distributorHostName_;
    }

    public Vector getDiscoverAddresses() {
        if (this.discoverAddresses_ != null) {
            return (Vector)this.discoverAddresses_.clone();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Address[] getListenerAddresses() {
        Address[] addressArray = null;
        if (this.listenerAddresses_ == null) {
            return null;
        }
        Vector vector = this.listenerAddresses_;
        synchronized (vector) {
            int n = this.listenerAddresses_.size();
            if (this.listenerAddresses_ != null && n > 0) {
                addressArray = new Address[n];
                this.listenerAddresses_.toArray(addressArray);
            }
        }
        return addressArray;
    }

    public Address getDistributorAddress() {
        return this.distributorAddress_;
    }

    public int getMaxInitRetryDelay() {
        return this.maxInitRetyDelay_;
    }

    public int getBacklog() {
        return this.backlog_;
    }

    public int getMaxSystemInitRetry() {
        return this.maxSystemInitRetry_;
    }

    public Logger getLogger() {
        return this.logger_;
    }

    public long getInitTimeout() {
        return this.initTimeout_;
    }

    public long getDisconnectTimeout() {
        return this.disconnectTimeout_;
    }

    public long getAckTimeout() {
        return this.ackTimeout_;
    }

    public int getMaxSenderThreads() {
        return this.maxSenderThreads_;
    }

    public long getViewChangePause() {
        return this.viewChangePause_;
    }

    public int getRegistrationTimeout() {
        return this.registrationTimeout_;
    }

    public long getViewMonitorPause() {
        return this.viewMonitorPause_;
    }

    public boolean isUseMulticastResolution() {
        return this.useMulticastResolution_;
    }

    public long getResolutionInterval() {
        return this.resolutionInterval_;
    }

    public long getResolutionTimeout() {
        if (this.selfTunning_) {
            int n = 1;
            if (this.discoverAddresses_ != null) {
                n = this.discoverAddresses_.size();
            }
            this.resolutionTimeout_ = 900 * n;
        }
        return this.resolutionTimeout_;
    }

    public String getMulticastAddress() {
        return this.multicastAddress_;
    }

    public int getMulticastPort() {
        return this.multicastPort_;
    }

    public int getMulticastTtl() {
        return this.multicastTtl_;
    }

    public int getConnectRetry() {
        return this.connectRetry_;
    }

    public int getConnectRetryDelay() {
        return this.connectRetryDelay_;
    }

    public boolean isDedicatedCoordinator() {
        return this.dedicatedCoordinator_;
    }

    public boolean isRouter() {
        return this.router_;
    }

    public String getTempPath() {
        return this.tmpPath_;
    }

    public void setTempPath(String string) {
        this.tmpPath_ = string;
    }

    public boolean isSSLEnabled() {
        return this.useSSL_;
    }

    public String getSSLConfigFile() {
        return this.sslConfigFile_;
    }

    public SSLConfig getSSLConfig() {
        return this.sslConfig_;
    }

    public int getMaxSendRetry() {
        return this.maxSendRetry_;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Loggger=");
        stringBuffer.append(this.logger_);
        if (this.useSSL_) {
            stringBuffer.append("\r\nSSL Configuration=");
            stringBuffer.append(this.sslConfig_);
        }
        stringBuffer.append("\r\nmaxSystemInitRetry=");
        stringBuffer.append(this.maxSystemInitRetry_);
        stringBuffer.append("\r\nlocalDistributorPort=");
        stringBuffer.append(this.distributorPort_);
        stringBuffer.append("\r\nlocalDistributorBacklog=");
        stringBuffer.append(this.backlog_);
        stringBuffer.append("\r\nmaxInitRetyDelay=");
        stringBuffer.append(this.maxInitRetyDelay_);
        stringBuffer.append("\r\ndiscoverAddresses=");
        stringBuffer.append(this.discoverAddresses_);
        stringBuffer.append("\r\nlistenerAddresses=");
        stringBuffer.append(this.listenerAddresses_);
        stringBuffer.append("\r\ndistributorHostName=");
        stringBuffer.append(this.distributorHostName_);
        stringBuffer.append("\r\ndistributorPort=");
        stringBuffer.append(this.distributorPort_);
        stringBuffer.append("\r\nclientPort=");
        stringBuffer.append(this.clientPort_);
        stringBuffer.append("\r\nconnectTimeout=");
        stringBuffer.append(this.connectTimeout_);
        stringBuffer.append("\r\ndisconnectTimeout=");
        stringBuffer.append(this.disconnectTimeout_);
        stringBuffer.append("\r\nackTimeout=");
        stringBuffer.append(this.ackTimeout_);
        stringBuffer.append("\r\nmaxSenderThreads");
        stringBuffer.append(this.maxSenderThreads_);
        stringBuffer.append("\r\nviewChangePause");
        stringBuffer.append(this.viewChangePause_);
        stringBuffer.append("\r\nregistrationTimeout");
        stringBuffer.append(this.registrationTimeout_);
        stringBuffer.append("\r\nviewMonitorPause=");
        stringBuffer.append(this.viewMonitorPause_);
        stringBuffer.append("\r\nuseMulticastResolution=");
        stringBuffer.append(this.useMulticastResolution_);
        stringBuffer.append("\r\nresolutionInterval=");
        stringBuffer.append(this.resolutionInterval_);
        stringBuffer.append("\r\nresolutionTimeout=");
        stringBuffer.append(this.resolutionTimeout_);
        stringBuffer.append("\r\nmulticastAddress=");
        stringBuffer.append(this.multicastAddress_);
        stringBuffer.append("\r\nmulticastPort=");
        stringBuffer.append(this.multicastPort_);
        stringBuffer.append("\r\nmulticastTtl=");
        stringBuffer.append(this.multicastTtl_);
        stringBuffer.append("\r\ntmpPath_=");
        stringBuffer.append(this.tmpPath_);
        return stringBuffer.toString();
    }

    Configuration() {
    }

    public void setWorkingDir(String string) {
        this.tmpPath_ = string;
    }

    public String getWorkingDir() {
        return this.tmpPath_;
    }

    public void setVersion(String string) {
        this.version_ = string;
    }

    public String getVersion() {
        return this.version_;
    }

    public void setReceiveBufferSize(int n) {
    }

    public int getReceiveBufferSize() {
        return 0;
    }

    public void setSendBufferSize(int n) {
    }

    public int getSendBufferSize() {
        return 0;
    }

    public void setTag(Serializable serializable) {
        this.diskUid_ = serializable;
    }

    public Serializable getTag() {
        return this.diskUid_;
    }

    public void setCacheName(String string) {
        this.name_ = string;
    }

    public String getCacheName() {
        return this.name_;
    }

    public void setSSLEnabled(boolean bl) {
        this.useSSL_ = bl;
        if (this.useSSL_ && this.sslConfigFile_ != null) {
            try {
                this.enableSSL(bl, this.sslConfigFile_);
            }
            catch (GroupException groupException) {
                // empty catch block
            }
        }
    }

    public void addCacheAddr(InetAddress inetAddress, int n, boolean bl, boolean bl2, int n2) {
        this.addCacheAddr(inetAddress, n, bl, bl2, n2, this.useSSL_, 1);
    }

    public void addCacheAddr(InetAddress inetAddress, int n, boolean bl, boolean bl2, int n2, boolean bl3, int n3) {
        Address address = null;
        Address address2 = null;
        if (this.discoverAddresses_ == null) {
            this.discoverAddresses_ = new Vector();
        }
        address = new Address(inetAddress.getHostAddress(), n, bl3, n3);
        int n4 = this.discoverAddresses_.size();
        for (int i = 0; i < n4; ++i) {
            address2 = (Address)this.discoverAddresses_.elementAt(i);
            if (address2 == null || address2.getIPString() == null || !address2.getIPString().equals(address.getIPString())) continue;
            if (bl) {
                this.discoverAddresses_.setElementAt(address, i);
                return;
            }
            if (n != address2.getPort()) continue;
            return;
        }
        this.discoverAddresses_.addElement(address);
    }

    public void addPrimaryCacheAddr(InetAddress inetAddress, int n) {
        this.addPrimaryCacheAddr(inetAddress, n, this.useSSL_, 1);
    }

    public void addPrimaryCacheAddr(InetAddress inetAddress, int n, boolean bl, int n2) {
        Address address = null;
        Address address2 = null;
        if (this.discoverAddresses_ == null) {
            this.discoverAddresses_ = new Vector();
            address = new Address(inetAddress.getHostAddress(), n, bl, n2);
            this.discoverAddresses_.addElement(address);
            return;
        }
        int n3 = this.discoverAddresses_.size();
        address = new Address(inetAddress.getHostAddress(), n, bl, n2);
        Vector<Address> vector = new Vector<Address>();
        vector.addElement(address);
        for (int i = 0; i < n3; ++i) {
            address2 = (Address)this.discoverAddresses_.elementAt(i);
            if (address2 == null) continue;
            if (address2.getIPString().equals(address.getIPString()) && n == address2.getPort()) {
                if (!address2.isOriginal()) continue;
                int n4 = address2.getPriorityOrder();
                address = new Address(inetAddress.getHostAddress(), n, bl, n2);
                vector.setElementAt(address, 0);
                continue;
            }
            vector.addElement(address2);
        }
        this.discoverAddresses_ = vector;
    }

    public void addListener(InetAddress inetAddress, int n, boolean bl, int n2) {
        Address address = null;
        Address address2 = null;
        if (this.listenerAddresses_ == null) {
            this.listenerAddresses_ = new Vector();
        }
        address = inetAddress != null ? new Address(inetAddress.getHostAddress(), n, bl, n2) : new Address(null, n, bl, n2);
        int n3 = this.listenerAddresses_.size();
        for (int i = 0; i < n3; ++i) {
            address2 = (Address)this.listenerAddresses_.elementAt(i);
            if (address2 == null || address2.getIPString() == null || address.getIPString() == null || !address2.getIPString().equals(address.getIPString()) || n != address2.getPort()) continue;
            return;
        }
        this.listenerAddresses_.addElement(address);
    }

    public boolean addressIsOriginal(InetAddress inetAddress, int n) {
        Address address = null;
        Address address2 = null;
        if (this.discoverAddresses_ == null) {
            this.discoverAddresses_ = new Vector();
        }
        address = new Address(inetAddress.getHostAddress(), n, this.useSSL_, 0);
        int n2 = this.discoverAddresses_.size();
        for (int i = 0; i < n2; ++i) {
            address2 = (Address)this.discoverAddresses_.elementAt(i);
            if (address2 == null || !address2.getString().equals(address.getString())) continue;
            return address2.isOriginal();
        }
        return false;
    }

    public boolean removeCacheAddr(InetAddress inetAddress, int n) {
        if (this.discoverAddresses_ == null || this.discoverAddresses_.isEmpty()) {
            return false;
        }
        Address address = new Address(inetAddress.getHostAddress(), n, this.useSSL_, 0);
        for (int i = 0; i < this.discoverAddresses_.size(); ++i) {
            Address address2 = (Address)this.discoverAddresses_.elementAt(i);
            if (address2 == null || !address2.equals(address)) continue;
            this.discoverAddresses_.remove(i);
            return true;
        }
        return false;
    }

    public void setKeyStore(String string) {
        this.sslConfig_.setKeyStore(string);
    }

    public String getKeyStore() {
        return this.sslConfig_.getKeyStoreType();
    }

    public void setSSLConfigFile(String string) {
        this.sslConfigFile_ = string;
        if (this.useSSL_ && this.sslConfigFile_ != null) {
            try {
                this.enableSSL(this.useSSL_, this.sslConfigFile_);
            }
            catch (GroupException groupException) {
                // empty catch block
            }
        }
    }

    public GroupCommunication createGroupCommunication() throws GroupException {
        GroupCommunication groupCommunication = null;
        try {
            Class<?> clazz = Class.forName(GROUP_PROVIDER);
            groupCommunication = (GroupCommunication)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new GroupException(exception);
        }
        return groupCommunication;
    }

    public Vector getListenerList() {
        return this.discoverAddresses_;
    }

    public void setMode(int n) {
    }

    public int getMode() {
        return 0;
    }

    public void setLocalAddress(String string) {
        this.localBindingAddressStr_ = string;
    }

    public String getLocalAddress() {
        return this.localBindingAddressStr_;
    }

    public void setNLDeathDetected(boolean bl) {
    }

    public boolean isNLDeathDetected() {
        return false;
    }

    public void setOverrideNLPort(int n) {
    }

    public int getOverrideNLPort() {
        return 0;
    }

    public int getMulticastInterval() {
        return 0;
    }

    public int getMulticastTTL() {
        return 0;
    }

    public boolean isMulticast() {
        return false;
    }

    public void enablePriorityOrder(boolean bl) {
    }

    public boolean isPriorityOrderEnabled() {
        return false;
    }

    public void setMulticastInterval(int n) {
    }

    public void setMulticastTTL(int n) {
    }

    public void setMulticast(boolean bl) {
    }

    public int getLowerPortBoundry() {
        return 0;
    }

    public int getUpperPortBoundry() {
        return 0;
    }

    public void setLowerPortBoundry(int n) {
    }

    public void setUpperPortBoundry(int n) {
    }
}

