/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import oracle.ias.cache.SSLConfigurator;
import oracle.ias.cache.commx.GroupConfig;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.group.GrpCommunication;

class SSLManager {
    static final String LOGGER_NAME = "oracle.ias.cache.group.SSLManager";
    private SSLContext m_ctx;
    private KeyManagerFactory m_kmf;
    private TrustManagerFactory m_tmf;
    private KeyStore m_ks;
    private GrpCommunication gcomm_;
    private Logger logger_ = Logger.getLogger("oracle.ias.cache.group.SSLManager");

    SSLManager(GrpCommunication grpCommunication) throws Exception {
        this.gcomm_ = grpCommunication;
        GroupConfig groupConfig = this.gcomm_.getGroupConfig();
        Properties properties = System.getProperties();
        String string = properties.getProperty("oracle.ias.cache.ssl.provider", "com.sun.net.ssl.internal.ssl.Provider");
        String string2 = properties.getProperty("oracle.ias.cache.ssl.protocol", "TLS");
        String string3 = properties.getProperty("oracle.ias.cache.ssl.algorithm", "SunX509");
        String string4 = properties.getProperty("oracle.ias.cache.ssl.keyStore.type", "JKS");
        HashMap hashMap = SSLConfigurator.list(groupConfig.getSSLConfigFile(), true);
        String string5 = (String)hashMap.get(SSLConfigurator.KEYSTORE);
        String string6 = (String)hashMap.get(SSLConfigurator.PASSWORD);
        if (string5 == null || string6 == null) {
            throw new GroupException(GrpCommunication.EXP_GRP_SSL_CONFIG);
        }
        if (this.logger_.isLoggable(Level.FINEST)) {
            this.logger_.log(Level.FINEST, "protocol=" + string2 + " algorithm=" + string3 + " keyStoreType=" + string4 + " keyStorePassword=" + string6);
        }
        FileInputStream fileInputStream = new FileInputStream(string5);
        try {
            Security.addProvider((Provider)Class.forName(string).newInstance());
        }
        catch (InstantiationException instantiationException) {
            throw new GroupException(GrpCommunication.EXP_GRP_SSL_PROVIDER_INSTANTIATION + string, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new GroupException(GrpCommunication.EXP_GRP_SSL_PROVIDER_INSTANTIATION + string, illegalAccessException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new GroupException(GrpCommunication.EXP_GRP_SSL_PROVIDER_CLASSNOTFOUND + string, classNotFoundException);
        }
        catch (ClassCastException classCastException) {
            throw new GroupException(string + GrpCommunication.EXP_GRP_SSL_PROVIDER_CLASSCAST);
        }
        char[] cArray = string6.toCharArray();
        this.m_ctx = SSLContext.getInstance(string2);
        this.m_kmf = KeyManagerFactory.getInstance(string3);
        this.m_tmf = TrustManagerFactory.getInstance(string3);
        this.m_ks = KeyStore.getInstance(string4);
        this.m_ks.load(fileInputStream, cArray);
        this.m_kmf.init(this.m_ks, cArray);
        this.m_tmf.init(this.m_ks);
        this.m_ctx.init(this.m_kmf.getKeyManagers(), this.m_tmf.getTrustManagers(), null);
    }

    SSLServerSocketFactory getServerSocketFactory() {
        SSLServerSocketFactory sSLServerSocketFactory;
        if (this.m_ctx != null) {
            sSLServerSocketFactory = this.m_ctx.getServerSocketFactory();
            if (this.logger_.isLoggable(Level.FINEST)) {
                this.logger_.log(Level.FINEST, "Got secure ServerSocketFactory");
            }
        } else {
            sSLServerSocketFactory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
            if (this.logger_.isLoggable(Level.FINEST)) {
                this.logger_.log(Level.FINEST, "Got default secure ServerSocketFactory");
            }
        }
        return sSLServerSocketFactory;
    }

    ServerSocket createSSLServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        SSLServerSocketFactory sSLServerSocketFactory;
        ServerSocket serverSocket;
        if (this.logger_.isLoggable(Level.FINEST)) {
            this.logger_.log(Level.FINEST, "Create Secure Server Socket");
        }
        if ((serverSocket = (sSLServerSocketFactory = this.getServerSocketFactory()).createServerSocket(n, n2, inetAddress)) == null) {
            throw new IOException(GrpCommunication.EXP_GRP_SSL_SSOCKET);
        }
        return serverSocket;
    }

    SSLSocketFactory getSocketFactory() {
        SSLSocketFactory sSLSocketFactory;
        if (this.m_ctx != null) {
            sSLSocketFactory = this.m_ctx.getSocketFactory();
            if (this.logger_.isLoggable(Level.FINEST)) {
                this.logger_.log(Level.FINEST, "Got secure SocketFactory");
            }
        } else {
            sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            if (this.logger_.isLoggable(Level.FINEST)) {
                this.logger_.log(Level.FINEST, "Got default secure SocketFactory");
            }
        }
        return sSLSocketFactory;
    }

    Socket createSSLSocket(String string, int n) throws IOException {
        Socket socket = null;
        SSLSocketFactory sSLSocketFactory = this.getSocketFactory();
        if (sSLSocketFactory != null) {
            socket = sSLSocketFactory.createSocket(string, n);
            if (this.logger_.isLoggable(Level.FINEST)) {
                this.logger_.log(Level.FINEST, "created secure Socket");
            }
        } else if (this.logger_.isLoggable(Level.FINEST)) {
            this.logger_.log(Level.FINEST, "no SSLSocketFactory!");
        }
        if (socket == null) {
            throw new IOException(GrpCommunication.EXP_GRP_SSL_SOCKET);
        }
        return socket;
    }
}

