/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.group.GrpCommunication;
import oracle.ias.cache.group.Job;
import oracle.ias.cache.group.Packet;

class AsyncQueue {
    static final String LOGGER_NAME = "oracle.ias.cache.group.AsyncQueue";
    List queue;
    private LinkedList sysQueue_;
    GrpCommunication gcomm_;
    private int sysQcnt;
    private boolean enable_;
    private Logger logger_ = Logger.getLogger("oracle.ias.cache.group.AsyncQueue");

    AsyncQueue(GrpCommunication grpCommunication) {
        this.gcomm_ = grpCommunication;
        this.sysQueue_ = new LinkedList();
        this.sysQueue_.clear();
        this.queue = Collections.synchronizedList(new LinkedList());
        this.enable_ = true;
    }

    void disable() {
        this.enable_ = false;
    }

    boolean isEnable() {
        return this.enable_;
    }

    synchronized Job dequeue() {
        Job job = null;
        if (this.enable_) {
            if (this.queue.size() != 0) {
                job = (Job)this.queue.remove(0);
            }
            if (job != null && job.action == 4) {
                job = (Job)this.sysQueue_.removeFirst();
                --this.sysQcnt;
                if (this.logger_.isLoggable(Level.FINEST)) {
                    this.logger_.log(Level.FINEST, "sending sysMsg: " + job.argument);
                }
            }
        } else if (this.sysQueue_.size() != 0) {
            job = (Job)this.sysQueue_.remove(0);
        }
        return job;
    }

    synchronized void enqueue(Job job) {
        Packet packet = null;
        Job job2 = null;
        if (!this.enable_) {
            if (this.logger_.isLoggable(Level.FINEST)) {
                this.logger_.log(Level.FINEST, "discard packet: " + job.argument);
            }
            return;
        }
        if (job != null && job.argument != null && job.argument instanceof Packet) {
            packet = (Packet)job.argument;
        }
        if (packet != null && packet.type != 17 && packet.type != 14 && packet.type != 13) {
            job2 = new Job();
            this.sysQueue_.add(job);
            this.queue.add(0, job2);
            ++this.sysQcnt;
        } else {
            this.queue.add(job);
        }
        this.wakeup();
    }

    synchronized void sleep(int n) {
        try {
            if (this.queue.size() == 0) {
                this.wait(n);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    synchronized void wakeup() {
        this.notifyAll();
    }

    synchronized int getLength() {
        return this.queue.size();
    }

    synchronized void dump() {
        this.logger_.log(Level.SEVERE, "--- AsyncQueue Dump---");
        ListIterator listIterator = this.queue.listIterator();
        while (listIterator.hasNext()) {
            Job job = (Job)listIterator.next();
            this.logger_.log(Level.SEVERE, job.toString());
        }
    }
}

