/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.io.FileInputStream;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.ias.cache.CacheConfigParsingException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class ConfigReader {
    Document m_document;

    ConfigReader(String string) throws SAXParseException, SAXException, Exception {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new DefaultHandler());
            InputStream inputStream = this.getClass().getResourceAsStream("/" + string);
            if (inputStream == null) {
                inputStream = new FileInputStream(string);
            }
            this.m_document = documentBuilder.parse(inputStream);
            this.m_document.getDocumentElement().normalize();
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (SAXParseException sAXParseException) {
            throw sAXParseException;
        }
        catch (SAXException sAXException) {
            throw sAXException;
        }
        catch (Exception exception) {
            throw exception;
        }
    }

    Document getDocument() {
        return this.m_document;
    }

    static ConfigReader getReader(String string) throws CacheConfigParsingException {
        ConfigReader configReader = null;
        try {
            configReader = new ConfigReader(string);
        }
        catch (SAXParseException sAXParseException) {
            throw new CacheConfigParsingException(" file=" + string + ", line=" + sAXParseException.getLineNumber() + ", " + sAXParseException.getMessage(), sAXParseException);
        }
        catch (SAXException sAXException) {
            throw new CacheConfigParsingException(" file=" + string + ", " + sAXException.getMessage(), sAXException);
        }
        catch (Exception exception) {
            throw new CacheConfigParsingException(" file=" + string + ", " + exception, exception);
        }
        return configReader;
    }
}

