/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.util.EventObject;
import oracle.ias.cache.CacheEventListener;
import oracle.ias.cache.NullObj;

public class CacheEvent
extends EventObject {
    public static final int OBJECT_INVALIDATED = 0;
    public static final int OBJECT_UPDATED = 1;
    public static final int OBJECT_UPDATED_SYNC = 2;
    public static final int OBJECT_INV_EXPLICIT = 3;
    public static final int OBJECT_INV_TIMEOUT = 4;
    public static final int OBJECT_INV_REMOVED = 5;
    static final int MAX_EVENTS = 6;
    public static final int REASON_UNSPECIFIED = 0;
    public static final int REASON_INTERNAL = 1;
    public static final int REASON_INV_GLOBAL = 2;
    public static final int REASON_INV_EXPLICIT = 3;
    public static final int REASON_INV_TIMEOUT = 4;
    public static final int REASON_INV_REMOVED = 5;
    int event_id;
    private Object name;
    private String region;
    private int reason;
    CacheEventListener listener;

    protected CacheEvent(int n, Object object, String string, Object object2, CacheEventListener cacheEventListener, int n2) {
        super(object2);
        this.event_id = n;
        this.name = object;
        this.region = string;
        this.reason = n2;
        this.listener = cacheEventListener;
    }

    public int getId() {
        return this.event_id;
    }

    public Object getName() {
        return this.name;
    }

    public Object getSource() {
        Object object = super.getSource();
        if (object instanceof NullObj) {
            object = null;
        }
        return object;
    }

    public String getRegion() {
        return this.region;
    }

    public int getReason() {
        return this.reason;
    }

    static String getEventName(int n) {
        switch (n) {
            case 0: {
                return "INVALIDATE";
            }
            case 1: {
                return "UPDATE";
            }
            case 2: {
                return "UPDATE_SYNC";
            }
            case 3: {
                return "INV_EXPLICIT";
            }
            case 4: {
                return "INV_TIMEOUT";
            }
            case 5: {
                return "INV_REMOVED";
            }
        }
        return "UNKNOWN";
    }
}

