/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.java.util;

import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import oracle.help.common.util.java.StaticLocaleContext;

public class MenuUtils {
    public static final String SEPARATOR = "menu.separator";
    public static final String FILE = "menu.File";
    public static final String DISPLAY = "menu.Display";
    public static final String DISPLAY_NEW = "menu.Display_New";
    public static final String PRINT_TOPIC = "menu.PrintTopic";
    public static final String CLOSE = "menu.Close";
    public static final String EXIT = "menu.Exit";
    public static final String PRINT_TREE = "menu.PrintTree";
    public static final String PRINT_TOPICS = "menu.PrintTopics";
    public static final String VIEW = "menu.View";
    public static final String GO = "menu.Go";
    public static final String BACK = "menu.Back";
    public static final String FORWARD = "menu.Forward";
    public static final String TOOLS = "menu.Tools";
    public static final String FIND = "menu.Find";
    public static final String PREFERENCES = "menu.Preferences";
    public static final String DOCK = "menu.Dock";
    public static final String UNDOCK = "menu.Undock";
    public static final String NAVIGATOR = "menu.Navigator";
    public static final String HELP = "menu.Help";
    public static final String HELP_ON_HELP = "menu.HelpOnHelp";
    public static final String ABOUT = "menu.About";
    private static String MENU_RESOURCE_BUNDLE = "oracle.help.resource.MenuLabels";

    public static JMenu createMenu(String[] stringArray, boolean bl, ActionListener actionListener) {
        JMenu jMenu = null;
        if (stringArray.length > 0) {
            String string = stringArray[0];
            jMenu = new JMenu();
            MenuUtils.setMenuAttributes(jMenu, string, bl);
            int n = 1;
            while (n < stringArray.length) {
                string = stringArray[n];
                JMenuItem jMenuItem = MenuUtils.createItem(string, bl);
                jMenuItem.setActionCommand(string);
                jMenuItem.addActionListener(actionListener);
                jMenu.add(jMenuItem);
                ++n;
            }
        }
        return jMenu;
    }

    public static JMenuItem createItem(String string, boolean bl) {
        JMenuItem jMenuItem;
        if (string.charAt(0) == '+') {
            jMenuItem = new JCheckBoxMenuItem();
            string = string.substring(1);
        } else {
            jMenuItem = new JMenuItem();
        }
        MenuUtils.setMenuAttributes(jMenuItem, string, bl);
        return jMenuItem;
    }

    public static void setMenuAttributes(JMenuItem jMenuItem, String string, boolean bl) {
        if (string.charAt(0) == '&') {
            jMenuItem.setText(string.substring(2));
            if (!bl) {
                if (!(jMenuItem instanceof JMenu)) {
                    if (string.equals(MenuUtils.getDefaultMenuLabel(BACK))) {
                        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(37, 8));
                    } else if (string.equals(MenuUtils.getDefaultMenuLabel(FORWARD))) {
                        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(39, 8));
                    } else {
                        KeyStroke keyStroke = KeyStroke.getKeyStroke((int)string.charAt(1), 2);
                        if (KeyEvent.getKeyText(keyStroke.getKeyCode()).indexOf("known") == -1) {
                            jMenuItem.setAccelerator(keyStroke);
                        }
                    }
                }
                jMenuItem.setMnemonic(string.charAt(1));
            }
        } else {
            jMenuItem.setText(string);
        }
    }

    public static String getDefaultMenuLabel(String string) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(MENU_RESOURCE_BUNDLE, StaticLocaleContext.getLocale());
        String string2 = resourceBundle.getString(string);
        return string2;
    }

    public static String removeSpecialMenuChars(String string) {
        String string2 = string;
        if (string2 != null) {
            if (string2.charAt(0) == '+') {
                string2 = string2.substring(1);
            }
            if (string2.charAt(0) == '&') {
                string2 = string2.substring(2);
            }
        }
        return string2;
    }
}

