/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.sql.xa;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import oracle.j2ee.transaction.TransactionMessages;
import oracle.oc4j.sql.xa.GenericRecoverableCommitStrategy;

public class OracleRecoverableCommitStrategy
extends GenericRecoverableCommitStrategy {
    public OracleRecoverableCommitStrategy(String oc4jCommitRecordTableName) {
        super(oc4jCommitRecordTableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean purgeCommitRecords(Xid[] xids, Connection connection) {
        try {
            String purge = "delete from " + this.m_oc4jCommitRecordTableName + " where id = ?";
            PreparedStatement statement = connection.prepareStatement(purge);
            try {
                for (int i = 0; i < xids.length; ++i) {
                    this.setValueOnPrepareStatement(statement, xids[i]);
                    statement.addBatch();
                }
                statement.executeBatch();
            }
            finally {
                statement.close();
            }
        }
        catch (SQLException e) {
            TransactionMessages.finer("SQLException encountered in purgeCommitRecords: " + e);
            return false;
        }
        return true;
    }

    public byte[][] recoverCommitted(Connection connection) throws XAException {
        HashSet<byte[]> set = new HashSet<byte[]>();
        try {
            ResultSet resultSet = connection.createStatement().executeQuery("select * from " + this.m_oc4jCommitRecordTableName);
            while (resultSet.next()) {
                set.add(resultSet.getBytes(1));
            }
        }
        catch (SQLException e) {
            XAException xaException = new XAException("SQLException thrown while gathering commit records from from Recoverable");
            xaException.errorCode = -7;
            xaException.initCause(e);
            throw xaException;
        }
        byte[][] tids = new byte[set.size()][];
        Iterator iterator = set.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            tids[i++] = (byte[])iterator.next();
        }
        return tids;
    }

    void setValueOnPrepareStatement(PreparedStatement ps, Xid xid) throws SQLException {
        ps.setBytes(1, xid.getGlobalTransactionId());
    }
}

